/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura_neb.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.ability.skill.unique.CookSkill;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.DynamicMeleeAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.controller.FlightMoveController;
import com.github.manasmods.tensura.api.entity.navigator.StraightFlightNavigator;
import com.github.manasmods.tensura.api.entity.subclass.DynamicMeleeAttackAction;
import com.github.manasmods.tensura.api.entity.subclass.IElementalSpirit;
import com.github.manasmods.tensura.api.entity.subclass.IFollower;
import com.github.manasmods.tensura.api.entity.subclass.ITeleportation;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.entity.human.OtherworlderEntity;
import com.github.manasmods.tensura.entity.magic.barrier.DisintegrationEntity;
import com.github.manasmods.tensura.entity.magic.beam.BloodRayProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura_neb.registry.NebItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PacketDistributor;

public class LuminousValentineEntity
extends OtherworlderEntity
implements ITeleportation,
FlyingAnimal,
IFollower {
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(LuminousValentineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK = SynchedEntityData.m_135353_(LuminousValentineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(LuminousValentineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float prevFlyProgress;
    public float flyProgress;
    protected boolean wasFlying;
    public int timeFlying = 0;
    public int miscAnimationTicks = 0;
    public int disintegrationCooldown = 0;
    public int embraceDrainCooldown = 0;
    public int deathBlessCooldown = 0;
    private UUID disintegrationUUID = null;
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20).m_7005_(true);

    public LuminousValentineEntity(EntityType<? extends LuminousValentineEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19793_ = 2.0f;
        this.f_21364_ = 20000;
        this.f_21365_ = new LuminousLookControl();
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.switchNavigator(false);
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand || this.m_5803_()) {
            this.f_21342_ = new LuminousMoveControl();
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
            this.wasFlying = false;
        } else {
            this.f_21342_ = new LuminousFlightMoveControl();
            this.f_21344_ = new StraightFlightNavigator((Mob)this, this.f_19853_);
            this.wasFlying = true;
        }
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 32.0).m_22268_(Attributes.f_22281_, 100.0).m_22268_(Attributes.f_22276_, 30000.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, (double)0.8f).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal((HumanoidNPCEntity)this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 15.0f, 1.2, 2.0){

            public boolean m_8036_() {
                if (LuminousValentineEntity.this.getAttack() != 7) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new CrossbowAttackGoal((Mob)this, 1.2, 20.0f));
        this.f_21345_.m_25352_(4, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(4, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal((HumanoidNPCEntity)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(4, (Goal)new LuminousAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FlyingFollowOwnerGoal((TamableAnimal)this, 0.7, 10.0f, 4.0f, true, false));
        this.f_21345_.m_25352_(6, (Goal)new WalkGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this, new Class[]{LuminousValentineEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, entity -> true));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE, (Object)0);
        this.f_19804_.m_135372_(ATTACK, (Object)0);
        this.f_19804_.m_135372_(FLYING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Phase", this.getPhase());
        compound.m_128405_("Attack", this.getAttack());
        if (this.disintegrationUUID != null) {
            compound.m_128362_("Disintegration", this.disintegrationUUID);
        }
        compound.m_128379_("Flying", this.m_29443_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setPhase(compound.m_128451_("Phase"));
        this.setAttack(compound.m_128451_("Attack"));
        if (compound.m_128441_("Disintegration")) {
            this.disintegrationUUID = compound.m_128342_("Disintegration");
        }
        this.setFlying(compound.m_128471_("Flying"));
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public int getAttack() {
        return (Integer)this.f_19804_.m_135370_(ATTACK);
    }

    public void setAttack(int attack) {
        this.f_19804_.m_135381_(ATTACK, (Object)attack);
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public ResourceLocation getTextureLocation() {
        return new ResourceLocation("tensura_neb", "textures/entity/luminous_valentine.png");
    }

    public List<ManasSkill> getUniqueSkills() {
        return List.of((ManasSkill)UniqueSkills.LUST.get());
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean canSleep() {
        return false;
    }

    public boolean m_7243_(ItemStack pStack) {
        return false;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean shouldCountMotionBlock() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (pSource.m_7639_() instanceof IElementalSpirit) {
            return false;
        }
        if (this.shouldDodge(pSource)) {
            return false;
        }
        boolean hurt = super.m_6469_(pSource, pAmount *= RaceHelper.spiritualReducePhysicalDamage((DamageSource)pSource));
        if (hurt) {
            Entity entity2;
            if (this.getAttack() == 7 && pAmount >= 50.0f && this.miscAnimationTicks <= 250 && this.disintegrationUUID != null) {
                Entity entity3 = ((ServerLevel)this.f_19853_).m_8791_(this.disintegrationUUID);
                if (entity3 instanceof DisintegrationEntity) {
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity3, (ParticleOptions)ParticleTypes.f_123812_, (double)3.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity3, (ParticleOptions)ParticleTypes.f_123813_, (double)3.0);
                    entity3.m_146870_();
                    this.disintegrationCooldown = 1000;
                    this.setAttack(0);
                    this.miscAnimationTicks = 0;
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 5.0f, 1.0f);
                } else {
                    this.disintegrationUUID = null;
                }
            }
            if ((entity2 = pSource.m_7639_()) instanceof LivingEntity) {
                Player player;
                LivingEntity damageSource = (LivingEntity)entity2;
                if (!damageSource.m_6084_()) {
                    return true;
                }
                if (damageSource instanceof Player && ((player = (Player)damageSource).m_7500_() || player.m_5833_())) {
                    return true;
                }
                List list = this.f_19853_.m_6443_(Mob.class, this.m_20191_().m_82400_(16.0), entity -> SkillHelper.getSubordinateOwner((LivingEntity)entity) == null);
                if (!list.isEmpty()) {
                    list.forEach(spirit -> spirit.m_6710_(damageSource));
                }
            }
        }
        return hurt;
    }

    private boolean shouldDodge(DamageSource source) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        if (this.shouldStopMoving()) {
            return false;
        }
        if (SkillUtils.canNegateDodge((LivingEntity)this, (DamageSource)source)) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (source.m_19378_()) {
                return false;
            }
            if ((double)entity2.m_217043_().m_188501_() >= 0.25) {
                return false;
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 2.0f, 1.0f);
            if (!this.m_9236_().m_5776_() && this.m_5448_() != null) {
                this.teleportTowards((LivingEntity)this, (Entity)this.m_5448_(), 5.0);
            }
            this.f_19802_ = 60;
            return true;
        }
        return false;
    }

    public boolean m_7307_(Entity entity) {
        Mob mob;
        if (super.m_7307_(entity)) {
            return true;
        }
        return entity instanceof Mob && (mob = (Mob)entity).m_5448_() != this;
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.getPhase() == 2) {
            this.bossEvent.m_5648_(BossEvent.BossBarOverlay.NOTCHED_10);
        }
    }

    private boolean shouldStopMoving() {
        int attack = this.getAttack();
        return attack == 3 || attack == 7;
    }

    protected void handleFlying() {
        this.prevFlyProgress = this.flyProgress;
        if (this.m_29443_()) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (!this.f_19853_.m_5776_()) {
            boolean isFlying = this.m_29443_();
            if (isFlying != this.wasFlying) {
                this.switchNavigator(!isFlying);
            }
            if (isFlying) {
                ++this.timeFlying;
                this.m_20242_(true);
                if (this.m_21827_() || this.m_20159_() || this.m_27593_() || this.m_5803_()) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
                this.m_20242_(false);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.miscAnimationHandler();
        this.phaseHandler();
        if (this.m_20202_() instanceof Boat || this.m_20202_() instanceof AbstractMinecart) {
            this.m_20202_().m_6469_(DamageSource.m_19370_((LivingEntity)this), 40.0f);
        }
        this.handleFlying();
        if (this.disintegrationCooldown > 0) {
            --this.disintegrationCooldown;
        }
        if (this.embraceDrainCooldown > 0) {
            --this.embraceDrainCooldown;
        }
        if (this.deathBlessCooldown > 0) {
            --this.deathBlessCooldown;
        }
        if (this.f_19797_ % 20 == 0) {
            if (!this.m_6084_()) {
                return;
            }
            if (this.f_19797_ % 200 == 0) {
                this.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HAKI_COAT.get(), 240, 1, false, false, false));
            }
            if (this.shouldStopMoving()) {
                return;
            }
            if (this.m_21223_() >= this.m_21233_() && TensuraEPCapability.getSpiritualHealth((LivingEntity)this) >= this.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())) {
                return;
            }
            if (this.f_19797_ % 200 == 0) {
                if (this.getAttack() == 0) {
                    this.setAttack(8);
                }
                this.m_5634_(500.0f);
                TensuraEPCapability.healSpiritualHealth((LivingEntity)this, (double)1000.0);
                SkillHelper.removePredicateEffect((LivingEntity)this, effect -> true);
                TensuraEffectsCapability.resetEverything((LivingEntity)this, (boolean)false, (boolean)false);
                CookSkill.removeCookedHP((LivingEntity)this, null);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 30, 0, false, false, false));
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123810_, (double)2.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123749_, (double)2.0);
            } else if (this.getPhase() != 2) {
                this.m_5634_(10.0f);
                TensuraEPCapability.healSpiritualHealth((LivingEntity)this, (double)100.0);
            } else {
                this.m_5634_(20.0f);
                TensuraEPCapability.healSpiritualHealth((LivingEntity)this, (double)200.0);
            }
        }
    }

    protected void phaseHandler() {
        switch (this.getPhase()) {
            case 0: {
                this.setPhase(1);
                break;
            }
            case 1: {
                LivingEntity target = this.m_5448_();
                if (target != null) {
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                }
                if (!((double)this.m_21223_() <= (double)this.m_21233_() * 0.5)) break;
                this.enterLastPhase();
            }
        }
    }

    private void enterLastPhase() {
        this.f_19802_ = 100;
        CookSkill.removeCookedHP((LivingEntity)this, null);
        AttributeInstance HP = this.m_21051_(Attributes.f_22276_);
        if (HP != null) {
            HP.m_22100_(HP.m_22115_() * 0.5);
            this.m_21153_((float)HP.m_22135_());
        }
        TensuraEPCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
            if (cap.getEP() <= 0.0) {
                cap.setEP((LivingEntity)this, 1000000.0, false);
            }
            if (cap.getCurrentEP() <= 0.0) {
                cap.setCurrentEP((LivingEntity)this, cap.getEP() * 0.5);
            }
            double SHP = this.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
            if (cap.getSpiritualHealth() < SHP * 0.5) {
                cap.setSpiritualHealth(SHP * 0.5);
            }
            TensuraEPCapability.sync((LivingEntity)this);
        });
        TensuraEffectsCapability.resetEverything((LivingEntity)this, (boolean)false, (boolean)false);
        this.f_20890_ = false;
        this.f_20919_ = 0;
        this.m_146912_();
        this.disintegrationCooldown = 200;
        this.setPhase(4);
        ItemStack stack = new ItemStack((ItemLike)NebItems.NIGHT_ROSE.get());
        this.m_8061_(EquipmentSlot.MAINHAND, stack.m_41777_());
        this.inventory.m_6836_(4, stack.m_41777_());
        this.inventory.m_6596_();
        AABB aabb = this.m_20191_().m_82400_(this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()) + 6.0);
        List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, entity -> !entity.m_7307_((Entity)this) && entity != this.m_21826_() && entity != this);
        for (LivingEntity target : list) {
            target.m_6469_(TensuraDamageSources.holyDamage((Entity)this), (float)this.m_21133_(Attributes.f_22281_) * 2.0f);
            target.m_20334_(0.0, 0.2, 0.0);
            SkillHelper.knockBack((LivingEntity)this, (LivingEntity)target, (float)3.0f);
        }
        TensuraParticleHelper.spawnServerParticles((Level)this.f_19853_, (ParticleOptions)ParticleTypes.f_123812_, (double)this.m_20185_(), (double)(this.m_20186_() + (double)(this.m_20206_() / 2.0f)), (double)this.m_20189_(), (int)30, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 0.5f, 0.4f + (this.f_19796_.m_188501_() * 0.4f + 0.8f));
    }

    protected void miscAnimationHandler() {
        if (this.getAttack() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            LivingEntity target = this.m_5448_();
            switch (this.getAttack()) {
                case 2: {
                    if (this.miscAnimationTicks != 29 && this.miscAnimationTicks % 2 == 0) {
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123750_, (double)2.0);
                        break;
                    }
                    this.mindControlSurrounding();
                    break;
                }
                case 3: {
                    this.m_21573_().m_26573_();
                    if (target == null) break;
                    if (this.miscAnimationTicks == 0) {
                        this.teleportTowards((LivingEntity)this, (Entity)target, 3.0);
                        this.embraceDrainCooldown = 600;
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)this, (MobEffect)((MobEffect)TensuraMobEffects.LUST_EMBRACEMENT.get()), (int)30, (int)1);
                        SkillHelper.checkThenAddEffectSource((LivingEntity)this, (Entity)this, (MobEffect)((MobEffect)TensuraMobEffects.LUST_EMBRACEMENT.get()), (int)30, (int)1);
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12053_, SoundSource.HOSTILE, 2.0f, 1.0f);
                        break;
                    }
                    if (this.miscAnimationTicks % 20 != 0 || !SkillHelper.drainEnergy((LivingEntity)target, (LivingEntity)this, (double)100000.0, (boolean)false)) break;
                    target.m_6469_(TensuraDamageSources.OUT_OF_ENERGY, 50.0f);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case 4: {
                    if (this.miscAnimationTicks == 0 && target != null) {
                        this.teleportTowards((LivingEntity)this, (Entity)target, 3.0);
                    }
                    this.deathBless(this.miscAnimationTicks);
                    break;
                }
                case 5: {
                    if (target == null || !(target.m_20270_((Entity)this) <= 40.0f)) break;
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12054_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123765_);
                    if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.DARKNESS_ATTACK_NULLIFICATION.get()))) {
                        return;
                    }
                    int bindLevel = 3;
                    if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.DARKNESS_ATTACK_RESISTANCE.get()))) {
                        --bindLevel;
                    }
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)this, (MobEffectInstance)new MobEffectInstance((MobEffect)TensuraMobEffects.SHADOW_BIND.get(), 200, bindLevel, true, true, false));
                    break;
                }
                case 6: {
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    if (this.miscAnimationTicks == 10) {
                        this.bloodRay();
                    }
                    if (this.miscAnimationTicks < 10 || this.miscAnimationTicks > 55) break;
                    this.m_5496_(SoundEvents.f_215771_, 3.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    break;
                }
                case 7: {
                    if (target != null && this.disintegrationUUID == null) {
                        if (this.disintegrationCooldown <= 0) {
                            this.disintegration(target);
                        }
                    } else if (this.disintegrationUUID != null) {
                        Entity entity = ((ServerLevel)this.f_19853_).m_8791_(this.disintegrationUUID);
                        if (entity instanceof DisintegrationEntity) {
                            DisintegrationEntity disintegration = (DisintegrationEntity)entity;
                            if (target != null) {
                                if (disintegration.getAffectedEntities().isEmpty()) {
                                    disintegration.m_146870_();
                                    this.setAttack(0);
                                    this.miscAnimationTicks = 0;
                                    this.disintegrationUUID = null;
                                } else if (this.m_20270_((Entity)disintegration) <= 10.0f) {
                                    this.teleportTowards((LivingEntity)this, (Entity)disintegration, 15.0);
                                }
                            } else {
                                this.setAttack(0);
                                this.miscAnimationTicks = 0;
                                this.disintegrationUUID = null;
                            }
                        } else {
                            this.setAttack(0);
                            this.miscAnimationTicks = 0;
                            this.disintegrationUUID = null;
                        }
                    }
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123809_, (double)2.0);
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 30, 0, false, false, false));
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getAttack())) {
                this.setAttack(0);
                this.miscAnimationTicks = 0;
                this.disintegrationUUID = null;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case 2 -> 30;
            case 3, 6 -> 60;
            case 4 -> 101;
            case 5 -> 15;
            case 7 -> 260;
            default -> 5;
        };
    }

    private void mindControlSurrounding() {
        LivingEntity livingTarget = this.m_5448_();
        if (livingTarget == null) {
            return;
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 3.0f, 1.0f);
        List list = this.f_19853_.m_6443_(Mob.class, this.m_20191_().m_82400_(20.0), mob -> !mob.m_7306_((Entity)this) && mob.m_6084_());
        if (list.isEmpty()) {
            return;
        }
        for (Mob target : list) {
            if (!CharmSkill.canMindControl((LivingEntity)target, (Level)this.f_19853_, (boolean)true) || target.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get()) || RaceHelper.isSpiritualLifeForm((LivingEntity)target) || SkillUtils.isSkillToggled((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get()))) continue;
            target.m_21561_(true);
            target.m_6710_(livingTarget);
            if (target instanceof NeutralMob) {
                NeutralMob neutralMob = (NeutralMob)target;
                neutralMob.m_6710_(livingTarget);
            }
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123798_);
        }
    }

    private void disintegration(LivingEntity target) {
        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
        if (this.disintegrationUUID == null || ((ServerLevel)this.f_19853_).m_8791_(this.disintegrationUUID) == null) {
            DisintegrationEntity disintegration = new DisintegrationEntity(this.f_19853_, (LivingEntity)this);
            disintegration.setRadius(3.0f);
            disintegration.setHeight(50.0f);
            disintegration.setLife(300);
            double y = this.f_19853_.m_6924_(Heightmap.Types.WORLD_SURFACE, (int)target.m_20185_(), (int)target.m_20189_());
            Vec3 pos = new Vec3(target.m_20185_(), y, target.m_20189_());
            disintegration.m_146884_(pos);
            this.f_19853_.m_7967_((Entity)disintegration);
            this.disintegrationUUID = disintegration.m_20148_();
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MOVEMENT_INTERFERENCE.get(), 40, 9, false, false, false));
            target.m_20219_(disintegration.m_20182_());
            target.m_20256_(Vec3.f_82478_);
            target.f_19864_ = true;
            if (this.m_20186_() < y - 1.0) {
                double yNew = this.f_19853_.m_6924_(Heightmap.Types.WORLD_SURFACE, (int)this.m_20185_(), (int)this.m_20189_());
                this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_6027_(this.m_20185_(), yNew, this.m_20189_());
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
        this.disintegrationCooldown = 1000;
    }

    private void deathBless(int ticks) {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215771_, SoundSource.HOSTILE, 1.0f, 1.0f);
        if (ticks % 10 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:death_blessing"), this.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (ticks <= 0 || ticks % 100 != 0) {
            return;
        }
        List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(5.0), living -> !living.m_7306_((Entity)this) && living.m_6084_() && !this.m_7307_((Entity)living));
        if (!list.isEmpty()) {
            this.deathBlessCooldown = 1200;
            for (LivingEntity target : list) {
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                if (!target.m_6469_(TensuraDamageSources.deathBless((Entity)this), 1000.0f)) continue;
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123810_);
            }
        }
    }

    private void bloodRay() {
        BloodRayProjectile beam = new BloodRayProjectile(this.f_19853_, (LivingEntity)this);
        beam.setFollowingOwner(true);
        beam.setSize(0.2f);
        beam.setLife(60);
        float damage = (float)(this.m_21133_(Attributes.f_22281_) * 1.5);
        beam.setDamage(damage);
        beam.setRange(40.0f);
        beam.m_146884_(this.m_146892_());
        beam.setSkill(SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)((ManasSkill)IntrinsicSkills.BLOOD_MIST.get())));
        beam.setMpCost(2000.0);
        this.f_19853_.m_7967_((Entity)beam);
    }

    public boolean randomTeleport(LivingEntity entity, double pX, double pY, double pZ, boolean pBroadcastTeleport) {
        boolean randomTeleport = super.randomTeleport(entity, pX, pY, pZ, pBroadcastTeleport);
        if (randomTeleport && !this.m_20096_()) {
            this.setFlying(true);
            this.switchNavigator(false);
        }
        return randomTeleport;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public double getFluidMotionScale(FluidType type) {
        return 1.0;
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.m_20069_() && this.m_20184_().f_82480_ > 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.5, 1.0));
        }
        super.m_7023_(vec3d);
    }

    public boolean shouldFollow() {
        return !this.m_21827_() && !this.isWandering() && (this.m_5448_() == null || !this.m_5448_().m_6084_());
    }

    public void followEntity(TamableAnimal animal, LivingEntity owner, double followSpeed) {
        if (this.m_20270_((Entity)owner) > 5.0f) {
            this.setFlying(true);
            this.m_21566_().m_6849_(owner.m_20185_(), owner.m_20186_() + (double)owner.m_20206_(), owner.m_20189_(), followSpeed);
        } else {
            if (this.f_19861_ && !this.m_20072_()) {
                this.setFlying(false);
            }
            if (this.m_29443_() && !this.isOverWater((LivingEntity)this)) {
                BlockPos vec = this.getGround((LivingEntity)this, this.m_20183_());
                this.m_21566_().m_6849_((double)vec.m_123341_(), (double)vec.m_123342_(), (double)vec.m_123343_(), followSpeed);
            } else {
                this.m_21573_().m_5624_((Entity)owner, followSpeed);
            }
        }
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    protected float m_21519_(EquipmentSlot pSlot) {
        return 0.0f;
    }

    public void m_6667_(DamageSource source) {
        if (source == DamageSource.f_19317_) {
            super.m_6667_(source);
            return;
        }
        if (this.getPhase() < 2) {
            this.enterLastPhase();
            return;
        }
        super.m_6667_(source);
    }

    public class LuminousLookControl
    extends TensuraTamableEntity.SleepLookControl {
        public LuminousLookControl() {
            super((TensuraTamableEntity)LuminousValentineEntity.this);
        }

        public void m_8128_() {
            LuminousValentineEntity entity = LuminousValentineEntity.this;
            if (entity.shouldStopMoving()) {
                return;
            }
            super.m_8128_();
        }
    }

    public class LuminousMoveControl
    extends TensuraTamableEntity.SleepMoveControl {
        public LuminousMoveControl() {
            super((TensuraTamableEntity)LuminousValentineEntity.this);
        }

        public void m_8126_() {
            LuminousValentineEntity entity = LuminousValentineEntity.this;
            if (entity.shouldStopMoving()) {
                return;
            }
            super.m_8126_();
        }
    }

    public class LuminousFlightMoveControl
    extends FlightMoveController {
        public LuminousFlightMoveControl() {
            super((Mob)LuminousValentineEntity.this, 1.0f, true);
        }

        public void m_8126_() {
            LuminousValentineEntity entity = LuminousValentineEntity.this;
            if (entity.shouldStopMoving()) {
                return;
            }
            super.m_8126_();
        }
    }

    static class LuminousAttackGoal
    extends DynamicMeleeAttackGoal {
        public final LuminousValentineEntity luminous;

        public LuminousAttackGoal(LuminousValentineEntity serpent) {
            super((PathfinderMob)serpent, List.of((self, target, goal) -> 1.0f));
            this.luminous = serpent;
        }

        public boolean m_8036_() {
            if (this.luminous.m_21827_()) {
                return false;
            }
            return super.m_8036_();
        }

        protected boolean shouldMoveToTarget() {
            if (this.luminous.shouldStopMoving()) {
                return false;
            }
            return this.shouldMoveToTarget;
        }

        protected List<DynamicMeleeAttackAction> getActions() {
            ArrayList<DynamicMeleeAttackAction> list = new ArrayList<DynamicMeleeAttackAction>();
            list.add((self, target, goal) -> {
                float speed = 2.0f;
                double distanceSqr = self.m_20280_((Entity)target);
                if (distanceSqr > 400.0) {
                    speed = 2.5f;
                    if (this.shouldMoveToTarget()) {
                        this.luminous.teleportTowards((LivingEntity)this.luminous, (Entity)target, 5.0);
                    }
                } else {
                    if (this.shouldMoveToTarget()) {
                        if (distanceSqr <= this.getAttackReachSqr(target)) {
                            this.luminous.m_7327_((Entity)target);
                            this.luminous.m_21011_(InteractionHand.MAIN_HAND, true);
                        } else if (this.luminous.m_217043_().m_188503_(5) == 1) {
                            this.luminous.teleportTowards((LivingEntity)this.luminous, (Entity)target, 10.0);
                        }
                        this.luminous.f_21342_.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), this.luminous.f_21342_.m_24999_());
                    }
                    this.checkAndPerformAttack(target, distanceSqr);
                    self.m_21391_((Entity)target, 70.0f, 70.0f);
                }
                return speed;
            });
            return list;
        }

        protected void checkAndPerformAttack(LivingEntity pEnemy, double pDistToEnemySqr) {
            double attackRange;
            double d0 = this.getAttackReachSqr(pEnemy);
            int randomAttack = this.randomAttack(pEnemy, pDistToEnemySqr);
            if (randomAttack == 0) {
                return;
            }
            switch (randomAttack) {
                case 1: 
                case 3: {
                    double d = d0;
                    break;
                }
                case 2: {
                    double d = d0 + 225.0;
                    break;
                }
                case 4: 
                case 5: {
                    double d = d0 + 400.0;
                    break;
                }
                case 6: {
                    double d = d0 + 1600.0;
                    break;
                }
                default: {
                    double d = attackRange = d0 + 900.0;
                }
            }
            if (pDistToEnemySqr <= attackRange) {
                if (randomAttack == 1) {
                    this.luminous.m_7327_((Entity)pEnemy);
                    this.luminous.m_21011_(InteractionHand.MAIN_HAND, true);
                } else if (this.luminous.getAttack() == 0 || this.luminous.getAttack() == 1) {
                    this.luminous.setAttack(randomAttack);
                }
            }
        }

        protected int randomAttack(LivingEntity target, double distSqr) {
            if (distSqr <= 400.0 && (double)this.luminous.f_19796_.m_188501_() <= 0.5) {
                List list;
                if (distSqr <= 25.0 && this.luminous.embraceDrainCooldown <= 0 && (double)this.luminous.f_19796_.m_188501_() <= 0.3) {
                    return 3;
                }
                if (this.luminous.deathBlessCooldown <= 0 && (double)this.luminous.f_19796_.m_188501_() <= 0.3) {
                    return 4;
                }
                if ((double)this.luminous.f_19796_.m_188501_() <= 0.2 && !(list = this.luminous.m_9236_().m_6443_(LivingEntity.class, this.luminous.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)this.luminous) && living.m_6084_() && !(living instanceof Player))).isEmpty()) {
                    return 2;
                }
            } else if ((double)this.luminous.f_19796_.m_188501_() <= 0.3) {
                return 6;
            }
            if (this.luminous.disintegrationCooldown <= 0 && (this.luminous.f_19796_.m_188501_() <= 0.3f || this.luminous.getPhase() == 2) && (double)this.luminous.f_19796_.m_188501_() <= 0.2) {
                return 7;
            }
            if (distSqr >= 400.0 && (double)this.luminous.f_19796_.m_188501_() <= 0.2) {
                return 5;
            }
            return 1;
        }

        protected double getAttackReachSqr(LivingEntity target) {
            double attackRange = this.luminous.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get());
            return (double)(this.luminous.m_20205_() * 2.0f * this.luminous.m_20205_() * 2.0f + target.m_20205_()) + attackRange * attackRange;
        }
    }

    public class WalkGoal
    extends Goal {
        protected final LuminousValentineEntity entity;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public WalkGoal(LuminousValentineEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.entity = entity;
        }

        public boolean m_8036_() {
            if (this.entity.m_20160_() || this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_() || this.entity.m_20159_() || this.entity.m_21827_()) {
                return false;
            }
            if (this.entity.m_217043_().m_188503_(30) != 0 && !this.entity.m_29443_()) {
                return false;
            }
            this.flightTarget = this.entity.m_20096_() ? LuminousValentineEntity.this.f_19796_.m_188499_() : LuminousValentineEntity.this.f_19796_.m_188503_(5) > 0 && this.entity.timeFlying < 200;
            Vec3 position = this.getPosition();
            if (position == null) {
                return false;
            }
            this.x = position.f_82479_;
            this.y = position.f_82480_;
            this.z = position.f_82481_;
            return true;
        }

        public void m_8037_() {
            if (this.flightTarget) {
                this.entity.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
            } else {
                this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
                if (LuminousValentineEntity.this.m_29443_() && this.entity.f_19861_) {
                    this.entity.setFlying(false);
                }
            }
            if (LuminousValentineEntity.this.m_29443_() && this.entity.f_19861_ && this.entity.timeFlying > 10) {
                this.entity.setFlying(false);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.entity.m_20182_();
            if (LuminousValentineEntity.this.isOverWater((LivingEntity)this.entity) || this.entity.m_20072_()) {
                this.flightTarget = true;
            }
            Vec3 pos = Vec3.m_82512_((Vec3i)this.entity.getWanderPos());
            double distance = (Double)TensuraConfig.INSTANCE.entitiesConfig.tamedWanderRadius.get();
            if (this.entity.isWandering() && this.entity.m_20238_(pos) >= distance * distance) {
                return pos;
            }
            if (this.flightTarget) {
                if (this.entity.timeFlying < 50 || LuminousValentineEntity.this.isOverWater((LivingEntity)this.entity)) {
                    return LuminousValentineEntity.this.getBlockInViewAway((LivingEntity)this.entity, vector3d, 0.0f);
                }
                return LuminousValentineEntity.this.getBlockGrounding((LivingEntity)this.entity, vector3d);
            }
            return LandRandomPos.m_148488_((PathfinderMob)this.entity, (int)10, (int)7);
        }

        public boolean m_8045_() {
            if (this.entity.m_21827_()) {
                return false;
            }
            if (this.flightTarget) {
                return this.entity.m_29443_() && this.entity.m_20275_(this.x, this.y, this.z) > 2.0;
            }
            return !this.entity.m_21573_().m_26571_() && !this.entity.m_20160_();
        }

        public void m_8056_() {
            if (this.flightTarget) {
                this.entity.setFlying(true);
                this.entity.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
            } else {
                this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
            }
        }

        public void m_8041_() {
            this.entity.m_21573_().m_26573_();
            super.m_8041_();
        }
    }
}

