/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura_neb.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.resist.AbnormalConditionNullification;
import com.github.manasmods.tensura.ability.skill.unique.CookSkill;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.DynamicMeleeAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.controller.FlightMoveController;
import com.github.manasmods.tensura.api.entity.navigator.StraightFlightNavigator;
import com.github.manasmods.tensura.api.entity.subclass.DynamicMeleeAttackAction;
import com.github.manasmods.tensura.api.entity.subclass.IFollower;
import com.github.manasmods.tensura.api.entity.subclass.ITeleportation;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.entity.human.OtherworlderEntity;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.AuraBulletProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.AuraSlashProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.battlewill.MeleeArts;
import com.github.manasmods.tensura.registry.battlewill.ProjectileArts;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class CarrionEntity
extends OtherworlderEntity
implements ITeleportation,
FlyingAnimal,
IFollower,
IAnimatable {
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(CarrionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK = SynchedEntityData.m_135353_(CarrionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(CarrionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float prevFlyProgress;
    public float flyProgress;
    protected boolean wasFlying;
    public int timeFlying = 0;
    public int miscAnimationTicks = 0;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.NOTCHED_10).m_7005_(true);

    public CarrionEntity(EntityType<? extends CarrionEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19793_ = 2.0f;
        this.f_21364_ = 6000;
        this.f_21365_ = new TensuraTamableEntity.SleepLookControl((TensuraTamableEntity)this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.switchNavigator(false);
    }

    protected void switchNavigator(boolean onLand) {
        if (!this.canFly()) {
            return;
        }
        if (onLand || this.m_5803_()) {
            this.f_21342_ = new TensuraTamableEntity.SleepMoveControl((TensuraTamableEntity)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
            this.wasFlying = false;
        } else {
            this.f_21342_ = new FlightMoveController((Mob)this, 1.0f, true);
            this.f_21344_ = new StraightFlightNavigator((Mob)this, this.f_19853_);
            this.wasFlying = true;
        }
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 30.0).m_22268_(Attributes.f_22281_, 80.0).m_22268_(Attributes.f_22276_, 8000.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal((HumanoidNPCEntity)this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(4, (Goal)new CrossbowAttackGoal((Mob)this, 1.2, 20.0f));
        this.f_21345_.m_25352_(4, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(4, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal((HumanoidNPCEntity)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(4, (Goal)new CarrionAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FlyingFollowOwnerGoal((TamableAnimal)this, 0.7, 10.0f, 4.0f, true, false){

            public boolean m_8036_() {
                if (!CarrionEntity.this.canFly()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WanderingFollowOwnerGoal((TensuraTamableEntity)this, 1.5, 10.0f, 5.0f, false){

            public boolean m_8036_() {
                if (CarrionEntity.this.canFly()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new WalkGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2){

            public boolean m_8036_() {
                if (CarrionEntity.this.canFly()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.2){

            public boolean m_8036_() {
                if (!CarrionEntity.this.canFly()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this, new Class[]{CarrionEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, entity -> true));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE, (Object)1);
        this.f_19804_.m_135372_(ATTACK, (Object)0);
        this.f_19804_.m_135372_(FLYING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Phase", this.getPhase());
        compound.m_128405_("Attack", this.getAttack());
        compound.m_128379_("Flying", this.m_29443_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setPhase(compound.m_128451_("Phase"));
        this.setAttack(compound.m_128451_("Attack"));
        this.setFlying(compound.m_128471_("Flying"));
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public int getAttack() {
        return (Integer)this.f_19804_.m_135370_(ATTACK);
    }

    public void setAttack(int attack) {
        this.f_19804_.m_135381_(ATTACK, (Object)attack);
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public boolean canFly() {
        return this.getPhase() == 2 || this.m_20072_();
    }

    public List<ManasSkill> getUniqueSkills() {
        return List.of((ManasSkill)UniqueSkills.ROYAL_BEAST.get());
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean canSleep() {
        return false;
    }

    public boolean shouldSwim() {
        return false;
    }

    public boolean m_7243_(ItemStack pStack) {
        return false;
    }

    public boolean shouldCountMotionBlock() {
        if (this.getPhase() != 2) {
            return true;
        }
        return this.m_5448_() != null && this.m_5448_().m_20096_();
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean m_7301_(MobEffectInstance instance) {
        if (AbnormalConditionNullification.getAbnormalEffects().contains(instance.m_19544_())) {
            return false;
        }
        return super.m_7301_(instance);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (this.shouldDodge(pSource)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    private boolean shouldDodge(DamageSource source) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (source.m_19378_()) {
                return false;
            }
            if ((double)entity2.m_217043_().m_188501_() >= 0.15 * (double)this.getPhase()) {
                return false;
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 2.0f, 1.0f);
            if (!this.m_9236_().m_5776_() && this.m_5448_() != null) {
                this.m_20225_(true);
                this.teleportTowards((LivingEntity)this, (Entity)this.m_5448_(), 2.0);
                this.m_20225_(false);
            }
            this.f_19802_ = 60;
            return true;
        }
        return false;
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.getPhase() == 2) {
            this.bossEvent.m_5648_(BossEvent.BossBarOverlay.NOTCHED_20);
        }
    }

    protected void handleFlying() {
        this.prevFlyProgress = this.flyProgress;
        if (this.m_29443_()) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (!this.f_19853_.m_5776_()) {
            boolean isFlying;
            boolean bl = isFlying = this.m_29443_() && this.canFly();
            if (isFlying != this.wasFlying) {
                this.switchNavigator(!isFlying);
            }
            if (isFlying) {
                ++this.timeFlying;
                this.m_20242_(true);
                if (this.m_21827_() || this.m_20159_() || this.m_27593_() || this.m_5803_()) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
                this.m_20242_(false);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.miscAnimationHandler();
        this.phaseHandler();
        if (this.m_20202_() instanceof Boat || this.m_20202_() instanceof AbstractMinecart) {
            this.m_20202_().m_6469_(DamageSource.m_19370_((LivingEntity)this), 40.0f);
        }
        this.handleFlying();
        if (this.f_19797_ % 20 == 0) {
            if (!this.m_6084_()) {
                return;
            }
            if (this.f_19797_ % 200 == 0) {
                this.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HAKI_COAT.get(), 240, 1, false, false, false));
            }
            if (this.m_21223_() >= this.m_21233_() && TensuraEPCapability.getSpiritualHealth((LivingEntity)this) >= this.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())) {
                return;
            }
            if (this.getPhase() == 1) {
                this.m_5634_(4.0f);
                TensuraEPCapability.healSpiritualHealth((LivingEntity)this, (double)20.0);
            } else {
                this.m_5634_(12.0f);
                TensuraEPCapability.healSpiritualHealth((LivingEntity)this, (double)60.0);
            }
        }
    }

    protected void phaseHandler() {
        switch (this.getPhase()) {
            case 0: {
                this.setPhase(1);
                break;
            }
            case 1: {
                LivingEntity target = this.m_5448_();
                if (target != null) {
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                }
                if (!((double)this.m_21223_() <= (double)this.m_21233_() * 0.5)) break;
                this.enterLastPhase();
            }
        }
    }

    private void enterLastPhase() {
        AttributeInstance knock;
        AttributeInstance attack;
        this.f_19802_ = 100;
        CookSkill.removeCookedHP((LivingEntity)this, null);
        AttributeInstance HP = this.m_21051_(Attributes.f_22276_);
        if (HP != null) {
            HP.m_22100_(HP.m_22115_() * 0.5);
            this.m_21153_((float)HP.m_22135_());
        }
        TensuraEPCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
            if (cap.getEP() <= 0.0) {
                cap.setEP((LivingEntity)this, 850000.0, false);
            } else {
                cap.setEP((LivingEntity)this, cap.getEP() + 200000.0, false);
            }
            if (cap.getCurrentEP() <= 0.0) {
                cap.setCurrentEP((LivingEntity)this, cap.getEP() * 0.5);
            }
            double SHP = this.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
            if (cap.getSpiritualHealth() < SHP * 0.5) {
                cap.setSpiritualHealth(SHP * 0.5);
            }
            TensuraEPCapability.sync((LivingEntity)this);
        });
        AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
        if (armor != null) {
            armor.m_22100_(armor.m_22115_() + 20.0);
        }
        if ((attack = this.m_21051_(Attributes.f_22281_)) != null) {
            attack.m_22100_(attack.m_22115_() + 20.0);
        }
        if ((knock = this.m_21051_(Attributes.f_22278_)) != null) {
            knock.m_22100_(knock.m_22115_() + 0.2);
        }
        TensuraEffectsCapability.resetEverything((LivingEntity)this, (boolean)false, (boolean)false);
        this.f_20890_ = false;
        this.f_20919_ = 0;
        this.m_146912_();
        this.setPhase(2);
        this.switchNavigator(false);
        AABB aabb = this.m_20191_().m_82400_(this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()) + 6.0);
        List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, entity -> !entity.m_7307_((Entity)this) && entity != this.m_21826_() && entity != this);
        for (LivingEntity target : list) {
            target.m_6469_(DamageSource.m_19373_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_) * 2.0f);
            target.m_20334_(0.0, 0.2, 0.0);
            SkillHelper.knockBack((LivingEntity)this, (LivingEntity)target, (float)3.0f);
        }
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123812_);
        TensuraParticleHelper.spawnServerParticles((Level)this.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.LIGHTNING_SPARK.get()), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)60, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
        TensuraParticleHelper.spawnServerParticles((Level)this.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get()), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)80, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 0.5f, 0.4f + (this.f_19796_.m_188501_() * 0.4f + 0.8f));
    }

    protected void miscAnimationHandler() {
        if (this.getAttack() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            switch (this.getAttack()) {
                case 2: {
                    LivingEntity target;
                    if (this.miscAnimationTicks != 10 || (target = this.m_5448_()) == null) break;
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    if ((double)target.m_20270_((Entity)this) <= this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()) + 3.0) {
                        this.m_7327_((Entity)target);
                    } else {
                        this.auraSlashAttack(0.0, false);
                    }
                    this.m_21011_(InteractionHand.MAIN_HAND, true);
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.f_21344_.m_26573_();
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    if (this.miscAnimationTicks >= 10 && this.miscAnimationTicks % 10 == 0) {
                        this.m_21011_(InteractionHand.MAIN_HAND, true);
                        this.spawnElephantAuraBullets((LivingEntity)this, this.m_146892_().m_82520_(0.0, 6.0, 0.0));
                        break;
                    }
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_175830_, (double)1.0);
                    break;
                }
                case 4: {
                    this.f_21344_.m_26573_();
                    LivingEntity target = this.m_5448_();
                    if (target == null) break;
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)((ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get()), (double)1.0);
                    if (target.m_20270_((Entity)this) >= 5.0f && this.miscAnimationTicks % 5 == 0) {
                        this.teleportTowards((LivingEntity)this, (Entity)target, 3.0);
                        break;
                    }
                    if (!(target.m_20270_((Entity)this) <= 7.0f) || this.miscAnimationTicks < 10 || !this.doMelee((Entity)target, 10.0f)) break;
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123812_, (double)1.0);
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 5.0f, 1.0f);
                    break;
                }
                case 5: {
                    if (this.miscAnimationTicks != 10) break;
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        if ((double)target.m_20270_((Entity)this) <= this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()) + 2.0) {
                            this.doMelee((Entity)target, 3.0f);
                        }
                    }
                    this.auraSlashAttack(0.1, false);
                    this.auraSlashAttack(0.6, false);
                    this.auraSlashAttack(0.6, true);
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    break;
                }
                case 6: {
                    this.f_21344_.m_26573_();
                    if (this.miscAnimationTicks < 5) break;
                    if (this.miscAnimationTicks % 3 == 0) {
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)((ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get()), (double)1.0);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)((ParticleOptions)TensuraParticles.LIGHTNING_SPARK.get()), (double)1.0);
                    }
                    if (this.miscAnimationTicks < 20) break;
                    BeamProjectile.spawnLastingBeam((EntityType)((EntityType)TensuraEntityTypes.SOLAR_BEAM.get()), (float)((float)this.m_21133_(Attributes.f_22281_) * 10.0f), (float)3.0f, (int)21, (float)50.0f, (float)3.0f, (Vec3)this.m_146892_(), (LivingEntity)this, (ManasSkillInstance)SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)((ManasSkill)MeleeArts.ROARING_LION_PUNCH.get())), (double)0.0, (double)0.0, (int)this.miscAnimationTicks);
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11862_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getAttack())) {
                this.setAttack(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case 3 -> 40;
            case 4, 6 -> 30;
            case 5 -> 15;
            default -> 10;
        };
    }

    public void auraSlashAttack(double multishot, boolean negativeAngle) {
        AuraSlashProjectile slash = new AuraSlashProjectile(this.f_19853_, (LivingEntity)this);
        slash.setSkill(SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)((ManasSkill)MeleeArts.AURA_SLASH.get())));
        float radius = 2.0f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        slash.m_6034_(this.m_20185_() + extraX, this.m_20188_() - 0.5, this.m_20189_() + extraZ);
        if (multishot > 0.0) {
            int rot = negativeAngle ? -145 : 145;
            float yaw = this.m_146908_() * ((float)Math.PI / 180);
            float f3 = Mth.m_14031_((float)((float)((double)yaw + Math.toRadians(rot))));
            float f = -Mth.m_14089_((float)((float)((double)yaw + Math.toRadians(rot))));
            slash.m_6034_(slash.m_20185_() + (double)f3 * multishot, slash.m_20186_(), slash.m_20189_() + (double)f * multishot);
        }
        slash.setDamage((float)this.m_21133_(Attributes.f_22281_));
        slash.m_20242_(true);
        Vector3f vector3f = new Vector3f(this.m_146895_() != null ? this.m_146895_().m_20252_(2.0f) : this.m_20252_(2.0f));
        slash.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), 1.0f, 0.0f);
        this.f_19853_.m_7967_((Entity)slash);
    }

    private void spawnElephantAuraBullets(LivingEntity entity, Vec3 pos) {
        for (int i = 0; i < 8; ++i) {
            Vec3 arrowPos = entity.m_146892_().m_82549_(new Vec3(0.0, 1.0, 0.0).m_82535_(((float)(45 * i) - 22.5f) * ((float)Math.PI / 180)).m_82496_(1.5707964f));
            AuraBulletProjectile bullet = new AuraBulletProjectile(entity.m_9236_(), entity);
            bullet.setSpeed(0.75f);
            bullet.m_146884_(arrowPos);
            bullet.shootFromRot(pos.m_82546_(arrowPos).m_82541_());
            bullet.setDamage((float)this.m_21133_(Attributes.f_22281_) / 2.0f);
            bullet.setExplosionRadius(4.0f);
            bullet.setSize(0.5f);
            bullet.setColor(AuraBulletProjectile.AuraColor.PURPLE);
            bullet.setSkill(SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)((ManasSkill)ProjectileArts.ELEPHANT_STAMPEDE.get())));
            bullet.setApCost(100.0);
            entity.m_9236_().m_7967_((Entity)bullet);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public boolean doMelee(Entity pEntity, float multiplier) {
        float f = (float)this.m_21133_(Attributes.f_22281_) * multiplier;
        float f1 = (float)this.m_21133_(Attributes.f_22282_) * 10.0f;
        boolean flag = pEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), f);
        if (flag) {
            if (f1 > 0.0f && pEntity instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)pEntity;
                entity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_21335_(pEntity);
        }
        return flag;
    }

    public boolean randomTeleport(LivingEntity entity, double pX, double pY, double pZ, boolean pBroadcastTeleport) {
        boolean randomTeleport = super.randomTeleport(entity, pX, pY, pZ, pBroadcastTeleport);
        if (randomTeleport && !this.m_20096_() && this.getPhase() == 2) {
            this.setFlying(true);
            this.switchNavigator(false);
        }
        return randomTeleport;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return type != ForgeMod.WATER_TYPE.get();
    }

    public boolean isPushedByFluid(FluidType type) {
        return type != ForgeMod.WATER_TYPE.get();
    }

    public double getFluidMotionScale(FluidType type) {
        return 1.0;
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.canFly() && this.m_20069_() && this.m_20184_().f_82480_ > 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.5, 1.0));
        }
        super.m_7023_(vec3d);
    }

    public boolean shouldFollow() {
        return !this.m_21827_() && !this.isWandering() && (this.m_5448_() == null || !this.m_5448_().m_6084_());
    }

    public void followEntity(TamableAnimal animal, LivingEntity owner, double followSpeed) {
        if (this.m_20270_((Entity)owner) > 5.0f) {
            this.setFlying(true);
            this.m_21566_().m_6849_(owner.m_20185_(), owner.m_20186_() + (double)owner.m_20206_(), owner.m_20189_(), followSpeed);
        } else {
            if (this.f_19861_ && !this.m_20072_()) {
                this.setFlying(false);
            }
            if (this.m_29443_() && !this.isOverWater((LivingEntity)this)) {
                BlockPos vec = this.getGround((LivingEntity)this, this.m_20183_());
                this.m_21566_().m_6849_((double)vec.m_123341_(), (double)vec.m_123342_(), (double)vec.m_123343_(), followSpeed);
            } else {
                this.m_21573_().m_5624_((Entity)owner, followSpeed);
            }
        }
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    protected float m_21519_(EquipmentSlot pSlot) {
        return 0.0f;
    }

    public void m_6667_(DamageSource source) {
        if (source == DamageSource.f_19317_) {
            super.m_6667_(source);
            return;
        }
        if (this.getPhase() < 2) {
            this.enterLastPhase();
            return;
        }
        super.m_6667_(source);
    }

    public boolean isInFlyingPose() {
        if (this.m_20096_() || this.m_21525_()) {
            return false;
        }
        if (!this.m_9236_().m_8055_(this.m_20097_().m_7495_()).m_60767_().m_76336_()) {
            return false;
        }
        return !this.m_21825_() && !this.m_21827_();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isInFlyingPose()) {
            if (event.isMoving()) {
                if (this.m_21660_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.fly_slow", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.fly_fast", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.idle_fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (event.isMoving() && !this.m_21525_()) {
            if (this.m_21660_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getAttack() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.halberd_poke", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getAttack() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.halberd_swing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getAttack() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.elephant_stampede", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getAttack() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.lion_punch", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getAttack() == 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.tiger_talon", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getAttack() == 6) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.royal_beast_carrion.beast_roar", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class CarrionAttackGoal
    extends DynamicMeleeAttackGoal {
        public final CarrionEntity carrion;

        public CarrionAttackGoal(CarrionEntity carrion) {
            super((PathfinderMob)carrion, List.of((self, target, goal) -> 1.0f));
            this.carrion = carrion;
        }

        public boolean m_8036_() {
            if (this.carrion.m_21827_()) {
                return false;
            }
            return super.m_8036_();
        }

        protected List<DynamicMeleeAttackAction> getActions() {
            ArrayList<DynamicMeleeAttackAction> list = new ArrayList<DynamicMeleeAttackAction>();
            list.add((self, target, goal) -> {
                float speed = 2.0f;
                double distanceSqr = self.m_20280_((Entity)target);
                if (distanceSqr > 400.0) {
                    speed = 2.5f;
                    if (this.shouldMoveToTarget()) {
                        this.carrion.teleportTowards((LivingEntity)this.carrion, (Entity)target, 5.0);
                    }
                } else {
                    if (this.shouldMoveToTarget()) {
                        if (distanceSqr <= this.getAttackReachSqr(target)) {
                            this.carrion.m_7327_((Entity)target);
                            this.carrion.m_21011_(InteractionHand.MAIN_HAND, true);
                        } else if (this.carrion.m_217043_().m_188503_(5) == 1) {
                            this.carrion.teleportTowards((LivingEntity)this.carrion, (Entity)target, 10.0);
                        }
                        this.carrion.f_21342_.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), this.carrion.f_21342_.m_24999_());
                    }
                    this.checkAndPerformAttack(target, distanceSqr);
                    self.m_21391_((Entity)target, 70.0f, 70.0f);
                }
                return speed;
            });
            return list;
        }

        protected void checkAndPerformAttack(LivingEntity pEnemy, double pDistToEnemySqr) {
            double attackRange;
            double d0 = this.getAttackReachSqr(pEnemy);
            int randomAttack = this.randomAttack(pDistToEnemySqr, pEnemy);
            if (randomAttack == 0) {
                return;
            }
            switch (randomAttack) {
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    double d = d0 + 1000.0;
                    break;
                }
                case 3: {
                    double d = d0 + 36.0;
                    break;
                }
                default: {
                    double d = attackRange = d0;
                }
            }
            if (pDistToEnemySqr <= attackRange) {
                if (randomAttack == 1) {
                    this.carrion.m_7327_((Entity)pEnemy);
                    this.carrion.m_21011_(InteractionHand.MAIN_HAND, true);
                } else if (this.carrion.getAttack() == 0 || this.carrion.getAttack() == 1) {
                    this.carrion.setAttack(randomAttack);
                }
            }
        }

        protected int randomAttack(double distSqr, LivingEntity target) {
            if (distSqr >= 100.0 || (double)this.carrion.f_19796_.m_188501_() <= 0.1) {
                if ((double)this.carrion.f_19796_.m_188501_() <= 0.3) {
                    return 5;
                }
                return 2;
            }
            if (distSqr <= 64.0 && target.m_20096_() && (double)this.carrion.f_19796_.m_188501_() <= 0.2) {
                return 3;
            }
            if (this.carrion.f_19796_.m_188501_() <= 0.1f) {
                return 4;
            }
            if (this.carrion.getPhase() == 2 && distSqr <= 600.0 && this.carrion.f_19796_.m_188501_() <= 0.1f) {
                return 6;
            }
            return 1;
        }

        protected double getAttackReachSqr(LivingEntity target) {
            double attackRange = this.carrion.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get());
            return (double)(this.carrion.m_20205_() * 2.0f * this.carrion.m_20205_() * 2.0f + target.m_20205_()) + attackRange * attackRange;
        }
    }

    public class WalkGoal
    extends Goal {
        protected final CarrionEntity entity;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public WalkGoal(CarrionEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.entity = entity;
        }

        public boolean m_8036_() {
            if (!CarrionEntity.this.canFly()) {
                return false;
            }
            if (this.entity.m_20160_() || this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_() || this.entity.m_20159_() || this.entity.m_21827_()) {
                return false;
            }
            if (this.entity.m_217043_().m_188503_(30) != 0 && !this.entity.m_29443_()) {
                return false;
            }
            this.flightTarget = this.entity.m_20096_() ? CarrionEntity.this.f_19796_.m_188499_() : CarrionEntity.this.f_19796_.m_188503_(5) > 0 && this.entity.timeFlying < 200;
            Vec3 position = this.getPosition();
            if (position == null) {
                return false;
            }
            this.x = position.f_82479_;
            this.y = position.f_82480_;
            this.z = position.f_82481_;
            return true;
        }

        public void m_8037_() {
            if (this.flightTarget) {
                this.entity.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
            } else {
                this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
                if (CarrionEntity.this.m_29443_() && this.entity.f_19861_) {
                    this.entity.setFlying(false);
                }
            }
            if (CarrionEntity.this.m_29443_() && this.entity.f_19861_ && this.entity.timeFlying > 10) {
                this.entity.setFlying(false);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.entity.m_20182_();
            if (CarrionEntity.this.isOverWater((LivingEntity)this.entity) || this.entity.m_20072_()) {
                this.flightTarget = true;
            }
            Vec3 pos = Vec3.m_82512_((Vec3i)this.entity.getWanderPos());
            double distance = (Double)TensuraConfig.INSTANCE.entitiesConfig.tamedWanderRadius.get();
            if (this.entity.isWandering() && this.entity.m_20238_(pos) >= distance * distance) {
                return pos;
            }
            if (this.flightTarget) {
                if (this.entity.timeFlying < 50 || CarrionEntity.this.isOverWater((LivingEntity)this.entity)) {
                    return CarrionEntity.this.getBlockInViewAway((LivingEntity)this.entity, vector3d, 0.0f);
                }
                return CarrionEntity.this.getBlockGrounding((LivingEntity)this.entity, vector3d);
            }
            return LandRandomPos.m_148488_((PathfinderMob)this.entity, (int)10, (int)7);
        }

        public boolean m_8045_() {
            if (this.entity.m_21827_()) {
                return false;
            }
            if (this.flightTarget) {
                return this.entity.m_29443_() && this.entity.m_20275_(this.x, this.y, this.z) > 2.0;
            }
            return !this.entity.m_21573_().m_26571_() && !this.entity.m_20160_();
        }

        public void m_8056_() {
            if (this.flightTarget) {
                this.entity.setFlying(true);
                this.entity.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
            } else {
                this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
            }
        }

        public void m_8041_() {
            this.entity.m_21573_().m_26573_();
            super.m_8041_();
        }
    }
}

