/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura_neb.data.gen;

import com.github.manasmods.manascore.api.data.gen.LanguageProvider;
import com.github.manasmods.tensura_neb.data.gen.NebAdvancementsProvider;
import com.github.manasmods.tensura_neb.registry.NebEntityTypes;
import com.github.manasmods.tensura_neb.registry.NebItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;

public class NebLanguageProvider
extends LanguageProvider {
    public NebLanguageProvider(GatherDataEvent gatherDataEvent) {
        super(gatherDataEvent, "tensura_neb");
    }

    protected void generate() {
        this.addItem(NebItems.WHITE_TIGER_AZURE_DRAGON_HALBERD, "White Tiger-Azure Dragon Halberd");
        this.addItem(NebItems.NIGHT_ROSE, "Night Rose");
        this.addEntityAndSpawnEgg(NebEntityTypes.RIMURU_OGRE_FIGHT, "Rimuru");
        this.addEntityAndSpawnEgg(NebEntityTypes.CARRION, "Carrion");
        this.addEntityAndSpawnEgg(NebEntityTypes.LUMINOUS_VALENTINE, "Luminous Valentine");
        this.addAdvancement(NebAdvancementsProvider.MONSTER_RULER, "The Monster Ruler", "Defeat Rimuru.");
        this.addAdvancement(NebAdvancementsProvider.LION_KING, "The Lion King", "Defeat Carrion.");
        this.addAdvancement(NebAdvancementsProvider.QUEEN_OF_NIGHTMARES, "The Queen of Nightmares", "Defeat Luminous Valentine.");
    }

    protected void addEntity(RegistryObject<? extends EntityType<?>> entity, String name) {
        this.add(String.format("entity.%s.%s", entity.getId().m_135827_(), entity.getId().m_135815_().replace('/', '.')), name);
    }

    protected void addEntityAndSpawnEgg(RegistryObject<? extends EntityType<?>> entity, String name) {
        String path = entity.getId().m_135815_().replace('/', '.');
        this.add(String.format("entity.%s.%s", entity.getId().m_135827_(), path), name);
        this.add(String.format("item.%s.%s_spawn_egg", entity.getId().m_135827_(), path), name + " Spawn Egg");
    }

    protected void addAdvancement(ResourceLocation location, String name, String description) {
        this.add("tensura_neb.advancements." + location.m_135815_() + ".title", name);
        this.add("tensura_neb.advancements." + location.m_135815_() + ".description", description);
    }
}

