/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura_neb.data.gen;

import com.github.manasmods.tensura.registry.items.TensuraConsumableItems;
import com.github.manasmods.tensura_neb.registry.NebEntityTypes;
import com.github.manasmods.tensura_neb.registry.NebItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;

public class NebAdvancementsProvider
extends AdvancementProvider {
    private ExistingFileHelper fileHelper;
    private Consumer<Advancement> consumer;
    public static final ResourceLocation MONSTER_RULER = new ResourceLocation("tensura_neb", "monster_ruler");
    public static final ResourceLocation LION_KING = new ResourceLocation("tensura_neb", "lion_king");
    public static final ResourceLocation QUEEN_OF_NIGHTMARES = new ResourceLocation("tensura_neb", "queen_of_nightmares");

    public NebAdvancementsProvider(GatherDataEvent gatherDataEvent) {
        this(gatherDataEvent.getGenerator(), gatherDataEvent.getExistingFileHelper());
    }

    public NebAdvancementsProvider(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, fileHelper);
    }

    protected void registerAdvancements(Consumer<Advancement> consumer, ExistingFileHelper fileHelper) {
        this.consumer = consumer;
        this.fileHelper = fileHelper;
        Advancement MONSTER_RULER = Advancement.Builder.m_138353_().m_138371_((ItemLike)TensuraConsumableItems.CHILLED_SLIME.get(), (Component)Component.m_237115_((String)"tensura_neb.advancements.monster_ruler.title"), (Component)Component.m_237115_((String)"tensura_neb.advancements.monster_ruler.description"), new ResourceLocation("tensura", "textures/block/cream_labyrinth_stone.png"), FrameType.CHALLENGE, true, true, false).m_138386_("rimuru", (CriterionTriggerInstance)this.playerKilledEntityTrigger((EntityType)NebEntityTypes.RIMURU_OGRE_FIGHT.get())).m_138389_(consumer, String.format("%s:monster_ruler", "tensura_neb"));
        Advancement LION_KING = this.add(NebAdvancementsProvider.LION_KING, (ItemLike)NebItems.WHITE_TIGER_AZURE_DRAGON_HALBERD.get(), MONSTER_RULER, null, FrameType.CHALLENGE, true, true, true, null, this.createList(new ArrayList<String>(List.of("entities")), new ArrayList<KilledTrigger.TriggerInstance>(List.of(this.playerKilledEntityTrigger((EntityType)NebEntityTypes.CARRION.get())))));
        Advancement QUEEN_OF_NIGHTMARES = this.add(NebAdvancementsProvider.QUEEN_OF_NIGHTMARES, (ItemLike)NebItems.NIGHT_ROSE.get(), LION_KING, null, FrameType.CHALLENGE, true, true, true, null, this.createList(new ArrayList<String>(List.of("entities")), new ArrayList<KilledTrigger.TriggerInstance>(List.of(this.playerKilledEntityTrigger((EntityType)NebEntityTypes.LUMINOUS_VALENTINE.get())))));
    }

    private Advancement.Builder addBuilder(ResourceLocation resourceLocation, ItemLike displayItem, @Nullable Advancement parent, Component title, Component description, @Nullable ResourceLocation background, @Nullable FrameType frameType, boolean showToast, boolean announceInChat, boolean hidden, @Nullable RequirementsStrategy requirements, @Nullable List<Map<String, CriterionTriggerInstance>> criterion) {
        Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
        if (parent != null) {
            advancementBuilder.m_138398_(parent);
        }
        advancementBuilder.m_138371_(displayItem, title, description, (ResourceLocation)(parent == null ? background : null), frameType == null ? FrameType.GOAL : frameType, showToast, announceInChat, hidden);
        if (requirements != null) {
            advancementBuilder.m_138360_(requirements);
        }
        if (criterion != null && !criterion.isEmpty()) {
            for (Map<String, CriterionTriggerInstance> map : criterion) {
                map.forEach((key, value) -> advancementBuilder.m_138383_(key, new Criterion(value)));
            }
        } else {
            advancementBuilder.m_138386_("custom", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
        }
        advancementBuilder.save(this.consumer, new ResourceLocation(String.format("%s:%s", resourceLocation.m_135827_(), resourceLocation.m_135815_())), this.fileHelper);
        return advancementBuilder;
    }

    private Advancement add(ResourceLocation location, ItemLike displayItem, @Nullable Advancement parent, @Nullable ResourceLocation background, @Nullable FrameType frameType, boolean showToast, boolean announceInChat, boolean hidden, @Nullable RequirementsStrategy requirements, @Nullable List<Map<String, CriterionTriggerInstance>> criterion) {
        MutableComponent title = Component.m_237115_((String)("tensura_neb.advancements." + location.m_135815_() + ".title"));
        MutableComponent description = Component.m_237115_((String)("tensura_neb.advancements." + location.m_135815_() + ".description"));
        return this.addBuilder(location, displayItem, parent, (Component)title, (Component)description, background, frameType, showToast, announceInChat, hidden, requirements, criterion).m_138403_(location);
    }

    private Advancement add(ResourceLocation location, ItemLike displayItem, @Nullable ResourceLocation parent, @Nullable ResourceLocation background, @Nullable FrameType frameType, boolean showToast, boolean announceInChat, boolean hidden, @Nullable RequirementsStrategy requirements, @Nullable List<Map<String, CriterionTriggerInstance>> criterion) {
        MutableComponent title = Component.m_237115_((String)("tensura_neb.advancements." + location.m_135815_() + ".title"));
        MutableComponent description = Component.m_237115_((String)("tensura_neb.advancements." + location.m_135815_() + ".description"));
        return this.add(location, displayItem, parent, (Component)title, (Component)description, background, frameType, showToast, announceInChat, hidden, requirements, criterion);
    }

    private Advancement add(ResourceLocation resourceLocation, ItemLike displayItem, @Nullable ResourceLocation parent, Component title, Component description, @Nullable ResourceLocation background, @Nullable FrameType frameType, boolean showToast, boolean announceInChat, boolean hidden, @Nullable RequirementsStrategy requirements, @Nullable List<Map<String, CriterionTriggerInstance>> criterion) {
        Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
        if (parent != null) {
            advancementBuilder.m_138396_(parent);
        }
        advancementBuilder.m_138371_(displayItem, title, description, (ResourceLocation)(parent == null ? background : null), frameType == null ? FrameType.GOAL : frameType, showToast, announceInChat, hidden);
        if (requirements != null) {
            advancementBuilder.m_138360_(requirements);
        }
        if (criterion != null && !criterion.isEmpty()) {
            for (Map<String, CriterionTriggerInstance> map : criterion) {
                map.forEach((key, value) -> advancementBuilder.m_138383_(key, new Criterion(value)));
            }
        } else {
            advancementBuilder.m_138386_("custom", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
        }
        advancementBuilder.save(this.consumer, new ResourceLocation(String.format("%s:%s", resourceLocation.m_135827_(), resourceLocation.m_135815_())), this.fileHelper);
        return advancementBuilder.m_138403_(resourceLocation);
    }

    private List<Map<String, CriterionTriggerInstance>> createList(List<String> keys, List<CriterionTriggerInstance> values) {
        if (keys.size() != values.size()) {
            throw new ArrayIndexOutOfBoundsException(String.format("Array sizes do not match: 'keys' is %s, 'values' is %s", keys.size(), values.size()));
        }
        ArrayList<Map<String, CriterionTriggerInstance>> list = new ArrayList<Map<String, CriterionTriggerInstance>>();
        for (int i = 0; i < keys.size(); ++i) {
            HashMap<String, CriterionTriggerInstance> map = new HashMap<String, CriterionTriggerInstance>();
            map.put(keys.get(i), values.get(i));
            list.add(map);
        }
        return list;
    }

    private KilledTrigger.TriggerInstance playerKilledEntityTrigger(EntityType<?> entity) {
        EntityPredicate predicate = EntityPredicate.Builder.m_36633_().m_36636_(entity).m_36662_();
        return KilledTrigger.TriggerInstance.m_152108_((EntityPredicate)predicate);
    }
}

