/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura_neb;

import com.github.manasmods.tensura_neb.TensuraNebConfig;
import com.github.manasmods.tensura_neb.data.NebLootTable;
import com.github.manasmods.tensura_neb.data.gen.NebAdvancementsProvider;
import com.github.manasmods.tensura_neb.data.gen.NebBlockTagProvider;
import com.github.manasmods.tensura_neb.data.gen.NebEntityEPProvider;
import com.github.manasmods.tensura_neb.data.gen.NebEntityTypeTagProvider;
import com.github.manasmods.tensura_neb.data.gen.NebGearEpProvider;
import com.github.manasmods.tensura_neb.data.gen.NebItemModelProvider;
import com.github.manasmods.tensura_neb.data.gen.NebItemTagProvider;
import com.github.manasmods.tensura_neb.data.gen.NebLanguageProvider;
import com.github.manasmods.tensura_neb.handler.NebEntitiesHandler;
import com.github.manasmods.tensura_neb.registry.NebRegistry;
import java.nio.file.Path;
import net.minecraft.data.DataProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tensura_neb")
public class TensuraNeb {
    public static final String MOD_ID = "tensura_neb";
    public static final String CONFIG_DIR = "tensura-reincarnated";
    private static final Logger LOGGER = LogManager.getLogger();

    public TensuraNeb() {
        FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve(CONFIG_DIR), (String)CONFIG_DIR);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TensuraNebConfig.SPEC, this.getConfigFileName("neb_common"));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        NebRegistry.register(modEventBus);
        modEventBus.addListener(NebEntitiesHandler::entityAttributeEvent);
        modEventBus.addListener(this::generateData);
    }

    private void generateData(GatherDataEvent event) {
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new NebEntityEPProvider(event));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new NebEntityTypeTagProvider(event));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new NebLanguageProvider(event));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new NebGearEpProvider(event));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new NebAdvancementsProvider(event));
        NebBlockTagProvider provider = new NebBlockTagProvider(event);
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)provider);
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new NebItemTagProvider(event, provider));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new NebItemModelProvider(event));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new NebLootTable(event));
    }

    private String getConfigFileName(String name) {
        return String.format("%s/%s.toml", CONFIG_DIR, name);
    }

    public static Logger getLOGGER() {
        return LOGGER;
    }
}

