/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client;

import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import dev.kir.cubeswithoutborders.client.util.FramebufferUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ResizableGameRenderer {
    private static final ResizableGameRenderer INSTANCE = new ResizableGameRenderer(Minecraft.m_91087_());
    private final Minecraft client;
    private RenderTarget framebuffer;
    private RenderTarget clientFramebuffer;
    private int framebufferWidth;
    private int framebufferHeight;
    private int windowFramebufferWidth;
    private int windowFramebufferHeight;

    private ResizableGameRenderer(Minecraft client) {
        this.client = client;
        this.framebuffer = null;
        this.clientFramebuffer = null;
        this.framebufferWidth = -1;
        this.framebufferHeight = -1;
    }

    public static ResizableGameRenderer getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return this.framebufferWidth > 0 && this.framebufferHeight > 0;
    }

    public void resize(int width, int height) {
        this.framebufferWidth = width;
        this.framebufferHeight = height;
        this.reload();
    }

    public void reload() {
        if (!this.isEnabled()) {
            return;
        }
        FramebufferUtil.resize(this.framebuffer, this.framebufferWidth, this.framebufferHeight);
        this.resizeWorldRendererFramebuffers();
    }

    public void disable() {
        this.framebufferWidth = -1;
        this.framebufferHeight = -1;
        Window window = this.client.m_91268_();
        if (window != null && this.windowFramebufferWidth > 0 && this.windowFramebufferHeight > 0) {
            window.f_85361_ = this.windowFramebufferWidth;
            window.f_85362_ = this.windowFramebufferHeight;
        }
        this.windowFramebufferWidth = -1;
        this.windowFramebufferHeight = -1;
        if (this.clientFramebuffer != null) {
            this.client.f_91042_ = this.clientFramebuffer;
            this.client.m_91385_().m_83947_(true);
        }
        this.clientFramebuffer = null;
        if (this.framebuffer != null) {
            this.framebuffer.m_83930_();
            this.framebuffer = null;
        }
    }

    public void beginRender() {
        int width = this.framebufferWidth;
        int height = this.framebufferHeight;
        Window window = this.client.m_91268_();
        if (!this.isEnabled() || window == null) {
            return;
        }
        if (this.framebuffer == null) {
            this.framebuffer = new MainTarget(width, height);
            this.resizeWorldRendererFramebuffers();
        }
        this.windowFramebufferWidth = window.f_85361_;
        this.windowFramebufferHeight = window.f_85362_;
        window.f_85361_ = width;
        window.f_85362_ = height;
        this.clientFramebuffer = this.client.m_91385_();
        this.client.f_91042_ = this.framebuffer;
        this.framebuffer.m_83947_(true);
    }

    public void endRender() {
        Window window = this.client.m_91268_();
        if (!this.isEnabled() || window == null) {
            return;
        }
        if (this.framebuffer == null || this.clientFramebuffer == null) {
            return;
        }
        window.f_85361_ = this.windowFramebufferWidth;
        window.f_85362_ = this.windowFramebufferHeight;
        this.windowFramebufferWidth = -1;
        this.windowFramebufferHeight = -1;
        this.client.f_91042_ = this.clientFramebuffer;
        this.clientFramebuffer = null;
        this.client.m_91385_().m_83947_(true);
        this.framebuffer.m_83938_(window.m_85441_(), window.m_85442_());
    }

    private void resizeWorldRendererFramebuffers() {
        int width = this.framebufferWidth;
        int height = this.framebufferHeight;
        Window window = this.client.m_91268_();
        LevelRenderer worldRenderer = this.client.f_91060_;
        if (window == null) {
            return;
        }
        FramebufferUtil.resize(worldRenderer.m_109832_(), width, height);
        FramebufferUtil.resize(worldRenderer.m_109829_(), width, height);
        FramebufferUtil.resize(worldRenderer.m_109827_(), width, height);
        FramebufferUtil.resize(worldRenderer.m_109830_(), width, height);
        FramebufferUtil.resize(worldRenderer.m_109828_(), width, height);
        FramebufferUtil.resize(worldRenderer.m_109831_(), width, height);
    }
}

