/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client;

import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.VideoMode;
import dev.kir.cubeswithoutborders.client.MonitorInfo;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class MonitorLookup {
    public static Optional<Monitor> findMonitor(ScreenManager monitorTracker, MonitorInfo monitorInfo) {
        return MonitorLookup.findMonitor(monitorTracker, monitorInfo.getViewportX(), monitorInfo.getViewportY(), monitorInfo.getWidth(), monitorInfo.getHeight());
    }

    public static Optional<Monitor> findMonitor(ScreenManager monitorTracker, int x, int y, int width, int height) {
        for (Monitor monitor : monitorTracker.f_85262_.values()) {
            if (monitor.m_84951_() != x || monitor.m_84952_() != y || !MonitorLookup.matchesDimensions(monitor, width, height)) continue;
            return Optional.of(monitor);
        }
        return Optional.empty();
    }

    private static boolean matchesDimensions(Monitor monitor, int width, int height) {
        int modeCount = monitor.m_84953_();
        for (int i = 0; i < modeCount; ++i) {
            VideoMode mode = monitor.m_84944_(i);
            if (width >= 0 && mode.m_85332_() != width || height >= 0 && mode.m_85335_() != height) continue;
            return true;
        }
        return false;
    }

    private MonitorLookup() {
    }
}

