/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.create_jetpack.item;

import com.possible_triangle.create_jetpack.config.Configs;
import com.possible_triangle.flightlib.api.ControlType;
import com.possible_triangle.flightlib.api.IJetpack;
import com.possible_triangle.flightlib.api.ISource;
import com.possible_triangle.flightlib.api.sources.CuriosSource;
import com.possible_triangle.flightlib.api.sources.EquipmentSource;
import com.possible_triangle.flightlib.forge.api.ForgeFlightLib;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.LayeredArmorItem;
import com.simibubi.create.foundation.particle.AirParticleData;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u00018B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J2\u0010*\u001a\b\u0012\u0004\u0012\u0002H+0\u0010\"\n\b\u0000\u0010+*\u0004\u0018\u00010,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0018\u00101\u001a\u00020(2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0016R4\u0010\u000f\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00020\u0002 \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/possible_triangle/create_jetpack/item/JetpackItem;", "Lcom/simibubi/create/content/equipment/armor/BacktankItem;", "Lcom/possible_triangle/flightlib/api/IJetpack;", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "material", "Lnet/minecraft/world/item/ArmorMaterial;", "texture", "Lnet/minecraft/resources/ResourceLocation;", "blockItem", "Lcom/tterrag/registrate/util/entry/ItemEntry;", "Lcom/simibubi/create/content/equipment/armor/BacktankItem$BacktankBlockItem;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;Lnet/minecraft/world/item/ArmorMaterial;Lnet/minecraft/resources/ResourceLocation;Lcom/tterrag/registrate/util/entry/ItemEntry;)V", "capability", "Lnet/minecraftforge/common/util/LazyOptional;", "kotlin.jvm.PlatformType", "Lnet/minecraftforge/common/util/LazyOptional;", "hoverSpeed", "", "context", "Lcom/possible_triangle/flightlib/api/IJetpack$Context;", "verticalSpeed", "activeType", "Lcom/possible_triangle/flightlib/api/ControlType;", "hoverType", "horizontalSpeed", "acceleration", "swimModifier", "elytraBoost", "thrusters", "", "Lnet/minecraft/world/phys/Vec3;", "getThrusters", "onUse", "", "secondsPerTank", "", "isValid", "", "isUsable", "getCapability", "T", "", "cap", "Lnet/minecraftforge/common/capabilities/Capability;", "side", "Lnet/minecraft/core/Direction;", "canApplyAtEnchantingTable", "stack", "Lnet/minecraft/world/item/ItemStack;", "enchantment", "Lnet/minecraft/world/item/enchantment/Enchantment;", "createParticles", "Lnet/minecraft/core/particles/ParticleOptions;", "Layered", "create_jetpack-forge-4.4.5"})
@SourceDebugExtension(value={"SMAP\nJetpackItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetpackItem.kt\ncom/possible_triangle/create_jetpack/item/JetpackItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1557#2:144\n1628#2,3:145\n*S KotlinDebug\n*F\n+ 1 JetpackItem.kt\ncom/possible_triangle/create_jetpack/item/JetpackItem\n*L\n76#1:144\n76#1:145,3\n*E\n"})
public class JetpackItem
extends BacktankItem
implements IJetpack,
ICapabilityProvider {
    private final LazyOptional<IJetpack> capability;
    @NotNull
    private final List<Vec3> thrusters;

    /*
     * WARNING - void declaration
     */
    public JetpackItem(@NotNull Item.Properties properties, @NotNull ArmorMaterial material, @NotNull ResourceLocation texture, @NotNull ItemEntry<BacktankItem.BacktankBlockItem> blockItem) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter(blockItem, (String)"blockItem");
        super(material, properties, texture, (Supplier)blockItem);
        this.capability = LazyOptional.of(() -> JetpackItem.capability$lambda$0(this));
        Object object = new Double[]{-0.35, 0.35};
        object = CollectionsKt.listOf((Object[])object);
        JetpackItem jetpackItem = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void offset;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Vec3((double)offset, 0.7, -0.5));
        }
        jetpackItem.thrusters = (List)destination$iv$iv;
    }

    public double hoverSpeed(@NotNull IJetpack.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Configs.INSTANCE.getSERVER().getHoverSpeed();
    }

    public double verticalSpeed(@NotNull IJetpack.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Configs.INSTANCE.getSERVER().getVerticalSpeed();
    }

    @NotNull
    public ControlType activeType(@NotNull IJetpack.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ControlType.TOGGLE;
    }

    @NotNull
    public ControlType hoverType(@NotNull IJetpack.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ControlType.TOGGLE;
    }

    public double horizontalSpeed(@NotNull IJetpack.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Configs.INSTANCE.getSERVER().getHorizontalSpeed();
    }

    public double acceleration(@NotNull IJetpack.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Configs.INSTANCE.getSERVER().getAcceleration();
    }

    public double swimModifier(@NotNull IJetpack.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Configs.INSTANCE.getSERVER().getSwimModifier();
    }

    public double elytraBoost() {
        return Configs.INSTANCE.getSERVER().getElytraBoost();
    }

    @NotNull
    public List<Vec3> getThrusters(@NotNull IJetpack.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.thrusters;
    }

    public void onUse(@NotNull IJetpack.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getWorld().m_46467_() % (long)20 != 0L) {
            return;
        }
        BacktankUtil.canAbsorbDamage((LivingEntity)context.getEntity(), (int)this.secondsPerTank(context));
    }

    private final int secondsPerTank(IJetpack.Context context) {
        return this.isHovering(context) ? Configs.INSTANCE.getSERVER().getSecondsPerTankHover() : Configs.INSTANCE.getSERVER().getSecondsPerTank();
    }

    public boolean isValid(@NotNull IJetpack.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ISource source = context.getSource();
        return source instanceof EquipmentSource ? ((EquipmentSource)source).getSlot() == EquipmentSlot.CHEST : source instanceof CuriosSource;
    }

    public boolean isUsable(@NotNull IJetpack.Context context) {
        float cost;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List list = BacktankUtil.getAllWithAir((LivingEntity)context.getEntity());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllWithAir(...)");
        ItemStack itemStack = (ItemStack)CollectionsKt.firstOrNull((List)list);
        if (itemStack == null) {
            return false;
        }
        ItemStack tank = itemStack;
        float air = BacktankUtil.getAir((ItemStack)tank);
        return air >= (cost = (float)BacktankUtil.maxAirWithoutEnchants() / (float)this.secondsPerTank(context));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Intrinsics.checkNotNullParameter(cap, (String)"cap");
        if (Intrinsics.areEqual(cap, (Object)ForgeFlightLib.JETPACK_CAPABILITY)) {
            LazyOptional lazyOptional = this.capability.cast();
            Intrinsics.checkNotNullExpressionValue((Object)lazyOptional, (String)"cast(...)");
            return lazyOptional;
        }
        LazyOptional lazyOptional = LazyOptional.empty();
        Intrinsics.checkNotNullExpressionValue((Object)lazyOptional, (String)"empty(...)");
        return lazyOptional;
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack stack, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        return super.canApplyAtEnchantingTable(stack, enchantment) && Configs.INSTANCE.getSERVER().isAllowed(enchantment);
    }

    @NotNull
    public ParticleOptions createParticles() {
        ParticleOptions particleOptions;
        if (Configs.INSTANCE.getCLIENT().getSpawnSnowParticles()) {
            SimpleParticleType simpleParticleType = ParticleTypes.f_175821_;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"SNOWFLAKE");
            particleOptions = (ParticleOptions)simpleParticleType;
        } else {
            particleOptions = (ParticleOptions)new AirParticleData(0.0f, 0.01f);
        }
        return particleOptions;
    }

    public double hoverVerticalSpeed(@NotNull IJetpack.Context context) {
        return IJetpack.DefaultImpls.hoverVerticalSpeed((IJetpack)this, (IJetpack.Context)context);
    }

    public double hoverHorizontalSpeed(@NotNull IJetpack.Context context) {
        return IJetpack.DefaultImpls.hoverHorizontalSpeed((IJetpack)this, (IJetpack.Context)context);
    }

    @Deprecated(message="exact boost amount is now configurable")
    public boolean boostsElytra() {
        return IJetpack.DefaultImpls.boostsElytra((IJetpack)this);
    }

    public boolean isHovering(@NotNull IJetpack.Context context) {
        return IJetpack.DefaultImpls.isHovering((IJetpack)this, (IJetpack.Context)context);
    }

    public boolean isThrusting(@NotNull IJetpack.Context context) {
        return IJetpack.DefaultImpls.isThrusting((IJetpack)this, (IJetpack.Context)context);
    }

    private static final IJetpack capability$lambda$0(JetpackItem this$0) {
        return this$0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ.\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/possible_triangle/create_jetpack/item/JetpackItem$Layered;", "Lcom/possible_triangle/create_jetpack/item/JetpackItem;", "Lcom/simibubi/create/foundation/item/LayeredArmorItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "material", "Lnet/minecraft/world/item/ArmorMaterial;", "texture", "Lnet/minecraft/resources/ResourceLocation;", "blockItem", "Lcom/tterrag/registrate/util/entry/ItemEntry;", "Lcom/simibubi/create/content/equipment/armor/BacktankItem$BacktankBlockItem;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;Lnet/minecraft/world/item/ArmorMaterial;Lnet/minecraft/resources/ResourceLocation;Lcom/tterrag/registrate/util/entry/ItemEntry;)V", "getArmorTextureLocation", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "slot", "Lnet/minecraft/world/entity/EquipmentSlot;", "stack", "Lnet/minecraft/world/item/ItemStack;", "layer", "", "create_jetpack-forge-4.4.5"})
    public static final class Layered
    extends JetpackItem
    implements LayeredArmorItem {
        public Layered(@NotNull Item.Properties properties, @NotNull ArmorMaterial material, @NotNull ResourceLocation texture, @NotNull ItemEntry<BacktankItem.BacktankBlockItem> blockItem) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)material, (String)"material");
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            Intrinsics.checkNotNullParameter(blockItem, (String)"blockItem");
            super(properties, material, texture, blockItem);
        }

        @NotNull
        public String getArmorTextureLocation(@Nullable LivingEntity entity, @Nullable EquipmentSlot slot, @Nullable ItemStack stack, int layer) {
            Locale locale = Locale.ROOT;
            String string = "%s:textures/models/armor/%s_layer_%d.png";
            Object[] objectArray = new Object[]{this.textureLoc.m_135827_(), this.textureLoc.m_135815_(), layer};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
    }
}

