/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.SingleXZInputStream;
import org.tukaani.xz.XZFormatException;
import org.tukaani.xz.XZIOException;

public class XZInputStream
extends InputStream {
    private final ArrayCache arrayCache;
    private final int memoryLimit;
    private InputStream in;
    private SingleXZInputStream xzIn;
    private final boolean verifyCheck;
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    public XZInputStream(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    public XZInputStream(InputStream inputStream, ArrayCache arrayCache) throws IOException {
        this(inputStream, -1, arrayCache);
    }

    public XZInputStream(InputStream inputStream, int i) throws IOException {
        this(inputStream, i, true);
    }

    public XZInputStream(InputStream inputStream, int i, ArrayCache arrayCache) throws IOException {
        this(inputStream, i, true, arrayCache);
    }

    public XZInputStream(InputStream inputStream, int i, boolean bl) throws IOException {
        this(inputStream, i, bl, ArrayCache.getDefaultCache());
    }

    public XZInputStream(InputStream inputStream, int i, boolean bl, ArrayCache arrayCache) throws IOException {
        this.arrayCache = arrayCache;
        this.in = inputStream;
        this.memoryLimit = i;
        this.verifyCheck = bl;
        this.xzIn = new SingleXZInputStream(inputStream, i, bl, arrayCache);
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] bs, int i, int j) throws IOException {
        int n;
        block11: {
            if (i < 0 || j < 0 || i + j < 0 || i + j > bs.length) {
                throw new IndexOutOfBoundsException();
            }
            if (j == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.endReached) {
                return -1;
            }
            n = 0;
            try {
                while (j > 0) {
                    int n2;
                    if (this.xzIn == null) {
                        this.prepareNextStream();
                        if (this.endReached) {
                            return n == 0 ? -1 : n;
                        }
                    }
                    if ((n2 = this.xzIn.read(bs, i, j)) > 0) {
                        n += n2;
                        i += n2;
                        j -= n2;
                        continue;
                    }
                    if (n2 != -1) continue;
                    this.xzIn = null;
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
                if (n != 0) break block11;
                throw iOException;
            }
        }
        return n;
    }

    private void prepareNextStream() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.in);
        byte[] byArray = new byte[12];
        do {
            int n;
            if ((n = dataInputStream.read(byArray, 0, 1)) == -1) {
                this.endReached = true;
                return;
            }
            dataInputStream.readFully(byArray, 1, 3);
        } while (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0);
        dataInputStream.readFully(byArray, 4, 8);
        try {
            this.xzIn = new SingleXZInputStream(this.in, this.memoryLimit, this.verifyCheck, byArray, this.arrayCache);
        }
        catch (XZFormatException xZFormatException) {
            throw new CorruptedInputException("Garbage after a valid XZ Stream");
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.xzIn == null ? 0 : this.xzIn.available();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean bl) throws IOException {
        if (this.in != null) {
            if (this.xzIn != null) {
                this.xzIn.close(false);
                this.xzIn = null;
            }
            try {
                if (bl) {
                    this.in.close();
                }
            }
            finally {
                this.in = null;
            }
        }
    }
}

