/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class WorldGenStructFeatManager
extends StructureManager {
    final WorldGenLevel genLevel;
    WorldOptions worldOptions;
    StructureCheck structureCheck;

    public WorldGenStructFeatManager(WorldOptions worldOptions, WorldGenLevel genLevel, StructureCheck structureCheck) {
        super((LevelAccessor)genLevel, worldOptions, structureCheck);
        this.genLevel = genLevel;
        this.worldOptions = worldOptions;
    }

    public WorldGenStructFeatManager forWorldGenRegion(WorldGenRegion worldGenRegion) {
        if (worldGenRegion == this.genLevel) {
            return this;
        }
        return new WorldGenStructFeatManager(this.worldOptions, (WorldGenLevel)worldGenRegion, this.structureCheck);
    }

    private ChunkAccess _getChunk(int x, int z, ChunkStatus status) {
        if (this.genLevel == null) {
            return null;
        }
        return this.genLevel.m_6522_(x, z, status, false);
    }

    public boolean m_220486_(BlockPos blockPos) {
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)blockPos);
        ChunkAccess chunk = this._getChunk(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62316_);
        if (chunk == null) {
            return false;
        }
        return chunk.m_187678_();
    }

    public List<StructureStart> m_220477_(ChunkPos sectionPos, Predicate<Structure> predicate) {
        ChunkAccess chunk = this._getChunk(sectionPos.f_45578_, sectionPos.f_45579_, ChunkStatus.f_62316_);
        if (chunk == null) {
            return List.of();
        }
        Map map = chunk.m_62769_();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : map.entrySet()) {
            Structure configuredStructureFeature = (Structure)entry.getKey();
            if (!predicate.test(configuredStructureFeature)) continue;
            LongSet var10002 = (LongSet)entry.getValue();
            Objects.requireNonNull(builder);
            this.m_220480_(configuredStructureFeature, var10002, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public List<StructureStart> m_220504_(SectionPos sectionPos, Structure structure) {
        ChunkAccess chunk = this._getChunk(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62316_);
        if (chunk == null) {
            return (List)((Object)Stream.empty());
        }
        LongSet longSet = chunk.m_213649_(structure);
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(builder);
        this.m_220480_(structure, longSet, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public Map<Structure, LongSet> m_220522_(BlockPos blockPos) {
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)blockPos);
        ChunkAccess chunk = this._getChunk(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62316_);
        if (chunk == null) {
            return (Map)((Object)Stream.empty());
        }
        return chunk.m_62769_();
    }
}

