/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.processor;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterstrongholds.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.banner.Banner;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BannerProcessor
extends StructureProcessor {
    public static final BannerProcessor INSTANCE = new BannerProcessor();
    public static final Codec<BannerProcessor> CODEC = Codec.unit(() -> INSTANCE);
    public static final Banner ENDERMAN_WALL_BANNER = new Banner.Builder().blockState(Blocks.f_50432_.m_49966_()).pattern("ss", 0).pattern("ts", 15).pattern("hhb", 15).pattern("bo", 15).pattern("ms", 15).pattern("cs", 15).build();
    public static final Banner WITHER_WALL_BANNER = new Banner.Builder().blockState(Blocks.f_50393_.m_49966_()).pattern("bs", 7).pattern("cs", 15).pattern("hh", 7).pattern("cre", 15).pattern("sku", 15).build();
    public static final Banner PORTAL_WALL_BANNER = new Banner.Builder().blockState(Blocks.f_50388_.m_49966_()).pattern("ss", 2).pattern("bri", 10).pattern("cbo", 2).pattern("bo", 15).build();
    public static final List<Banner> WALL_BANNERS = Lists.newArrayList((Object[])new Banner[]{ENDERMAN_WALL_BANNER, WITHER_WALL_BANNER, PORTAL_WALL_BANNER});

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.f_74676_().m_60734_() instanceof AbstractBannerBlock && blockInfoGlobal.f_74676_().m_60734_() == Blocks.f_50437_ && (blockInfoGlobal.f_74677_().m_128423_("Patterns") == null || blockInfoGlobal.f_74677_().m_128437_("Patterns", 10).size() == 0)) {
            Banner banner = this.getRandomBanner(structurePlacementData.m_230326_(blockInfoGlobal.f_74675_()));
            Direction facing = (Direction)blockInfoGlobal.f_74676_().m_61143_((Property)BlockStateProperties.f_61374_);
            BlockState newState = (BlockState)banner.getState().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
            CompoundTag newNBT = this.copyNBT(banner.getNbt());
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_(), newState, newNBT);
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorTypeModule.BANNER_PROCESSOR;
    }

    private Banner getRandomBanner(RandomSource randomSource) {
        return WALL_BANNERS.get(randomSource.m_188503_(WALL_BANNERS.size()));
    }

    private CompoundTag copyNBT(CompoundTag other) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128391_(other);
        return nbt;
    }
}

