/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.almanac.command;

import com.frikinjay.almanac.Almanac;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class ReloadCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"almanac").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").then(Commands.m_82129_((String)"config", (ArgumentType)StringArgumentType.string()).suggests(ReloadCommand::suggestConfigs).executes(ReloadCommand::reloadConfig))).executes(ReloadCommand::listConfigs)));
    }

    private static CompletableFuture<Suggestions> suggestConfigs(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase();
        Almanac.getConfigEntryNames().stream().filter(config -> config.toLowerCase().startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int listConfigs(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Available configs:"), false);
        Almanac.getConfigEntryNames().forEach(configName -> ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("- " + configName)), false));
        return 1;
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        String configName = StringArgumentType.getString(context, (String)"config");
        try {
            Almanac.reloadConfig(configName);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Reloaded and repopulated config: " + configName)), true);
        }
        catch (Exception e) {
            Almanac.LOGGER.error("Error reloading config: " + configName, (Throwable)e);
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error reloading config: " + configName + ". Check the server logs for details.")));
        }
        return 1;
    }
}

