/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools.render;

import com.mna.ManaAndArtifice;
import com.mna.api.blocks.tile.IMultiblockDefinition;
import com.mna.tools.DidYouKnowHelper;
import com.mna.tools.RotationUtils;
import com.mna.tools.math.MathUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.awt.Color;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.mutable.MutableInt;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MultiblockRenderer {
    public static boolean hasMultiblock;
    private static IMultiblockDefinition multiblock;
    private static Component name;
    private static BlockPos renderPos;
    private static boolean posLocked;
    private static Rotation facingRotation;
    private static int blocks;
    private static int blocksDone;
    private static boolean syncWait;
    private static int timeComplete;
    private static BlockState lookingState;
    private static BlockPos lookingPos;
    private static MultiBufferSource.BufferSource buffers;
    private static boolean lowestLayerMode;

    public static void setMultiblock(IMultiblockDefinition multiblock, Component name, boolean flip) {
        if (flip && hasMultiblock) {
            hasMultiblock = false;
        } else {
            MultiblockRenderer.multiblock = multiblock;
            MultiblockRenderer.name = name;
            renderPos = null;
            hasMultiblock = multiblock != null;
            posLocked = false;
        }
    }

    public static void toggleLowestLayerMode() {
        lowestLayerMode = !lowestLayerMode;
    }

    @SubscribeEvent
    public static void onRenderHUD(RenderGuiOverlayEvent.Post event) {
        if (hasMultiblock) {
            int fullAnimTime;
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Minecraft mc = Minecraft.m_91087_();
            int waitTime = 40;
            int fadeOutSpeed = 4;
            float animTime = (float)timeComplete + (timeComplete == 0 ? 0.0f : event.getPartialTick());
            if (animTime > (float)(fullAnimTime = waitTime + 10)) {
                hasMultiblock = false;
                return;
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, -Math.max(0.0f, animTime - (float)waitTime) * (float)fadeOutSpeed, 0.0f);
            int x = event.getWindow().m_85445_() / 2;
            int y = 16;
            int width = 180;
            int height = 9;
            int left = x - width / 2;
            int top = y + 10;
            if (timeComplete > 0) {
                String s = I18n.m_118938_((String)"gui.mna:structure_complete", (Object[])new Object[0]);
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, Math.min((float)(height + 5), animTime), 0.0f);
                guiGraphics.m_280056_(mc.f_91062_, s, x - mc.f_91062_.m_92895_(s) / 2, top + height - 10, 65280, true);
                guiGraphics.m_280168_().m_85849_();
            }
            guiGraphics.m_280509_(left - 1, top - 1, left + width + 1, top + height + 1, -16777216);
            guiGraphics.m_280024_(left, top, left + width, top + height, -10066330, -11184811);
            float pct = MathUtils.clamp01((float)blocksDone / (float)Math.max(1, blocks));
            int progressWidth = (int)((float)width * pct);
            int color = Mth.m_14169_((float)(pct / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
            int color2 = new Color(color).darker().getRGB();
            guiGraphics.m_280024_(left, top, left + progressWidth, top + height, color, color2);
            if (((Boolean)mc.f_91066_.f_92043_.m_231551_()).booleanValue()) {
                guiGraphics.m_280649_(mc.f_91062_, name.m_7532_(), x - mc.f_91062_.m_92852_((FormattedText)name) / 2, y + 10, 0xFFFFFF, true);
            } else {
                guiGraphics.m_280649_(mc.f_91062_, name.m_7532_(), x - mc.f_91062_.m_92852_((FormattedText)name) / 2, y + 11, 0xFFFFFF, true);
            }
            if (!posLocked) {
                String s = I18n.m_118938_((String)"gui.mna:not_anchored", (Object[])new Object[0]);
                guiGraphics.m_280056_(mc.f_91062_, s, x - mc.f_91062_.m_92895_(s) / 2, top + height + 8, 0xFFFFFF, true);
            } else {
                if (lookingState != null) {
                    try {
                        Block block = lookingState.m_60734_();
                        ItemStack stack = block.getCloneItemStack(lookingState, mc.f_91077_, (BlockGetter)mc.f_91073_, lookingPos, (Player)mc.f_91074_);
                        if (!stack.m_41619_()) {
                            guiGraphics.m_280649_(mc.f_91062_, stack.m_41786_().m_7532_(), left + 20, top + height + 8, 0xFFFFFF, true);
                            guiGraphics.m_280480_(stack, left, top + height + 2);
                        }
                    }
                    catch (Exception block) {
                        // empty catch block
                    }
                }
                if (timeComplete == 0) {
                    color = 0xFFFFFF;
                    int posx = left + width;
                    int posy = top + height + 2;
                    int mult = 1;
                    String progress = blocksDone + "/" + blocks;
                    guiGraphics.m_280056_(mc.f_91062_, progress, posx - mc.f_91062_.m_92895_(progress) / mult, posy, color, true);
                }
            }
            guiGraphics.m_280168_().m_85849_();
        }
    }

    @SubscribeEvent
    public static void onWorldRenderLast(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && hasMultiblock && multiblock != null) {
            MultiblockRenderer.renderMultiblock(ManaAndArtifice.instance.proxy.getClientWorld(), event.getPoseStack());
        }
    }

    public static void anchorTo(BlockPos target, Rotation rot) {
        renderPos = target;
        facingRotation = rot;
        posLocked = true;
        DidYouKnowHelper.CheckAndShowDidYouKnow(ManaAndArtifice.instance.proxy.getClientPlayer(), "helptip.mna.visualized_multiblock");
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (hasMultiblock && !posLocked && event.getEntity() == Minecraft.m_91087_().f_91074_) {
            MultiblockRenderer.anchorTo(event.getPos().m_121945_(event.getFace()), MultiblockRenderer.getRotation((Entity)event.getEntity()));
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (ManaAndArtifice.instance.proxy.getClientWorld() == null) {
            hasMultiblock = false;
        } else if (posLocked && !syncWait && blocks == blocksDone) {
            if (++timeComplete == 16) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11871_, (float)1.0f));
            }
            if (timeComplete == 60) {
                MultiblockRenderer.setMultiblock(null, null, false);
            }
        } else {
            timeComplete = 0;
        }
    }

    public static void renderMultiblock(Level world, PoseStack ms) {
        Minecraft mc = Minecraft.m_91087_();
        if (!posLocked) {
            facingRotation = MultiblockRenderer.getRotation((Entity)mc.f_91074_);
            if (mc.f_91077_ instanceof BlockHitResult) {
                renderPos = ((BlockHitResult)mc.f_91077_).m_82425_().m_121945_(((BlockHitResult)mc.f_91077_).m_82434_());
            }
        } else if (renderPos.m_203193_((Position)mc.f_91074_.m_20182_()) > 4096.0) {
            return;
        }
        if (renderPos == null) {
            return;
        }
        if (multiblock.isSymmetrical()) {
            facingRotation = Rotation.NONE;
        }
        EntityRenderDispatcher erm = mc.m_91290_();
        double renderPosX = erm.f_114358_.m_90583_().m_7096_();
        double renderPosY = erm.f_114358_.m_90583_().m_7098_();
        double renderPosZ = erm.f_114358_.m_90583_().m_7094_();
        ms.m_85837_(-renderPosX, -renderPosY, -renderPosZ);
        if (buffers == null) {
            buffers = MultiblockRenderer.initBuffers(mc.m_91269_().m_110104_());
        }
        BlockPos checkPos = null;
        if (mc.f_91077_ instanceof BlockHitResult) {
            BlockHitResult blockRes = (BlockHitResult)mc.f_91077_;
            checkPos = blockRes.m_82425_().m_121945_(blockRes.m_82434_());
        }
        blocks = 0;
        blocksDone = 0;
        lookingState = null;
        lookingPos = checkPos;
        MutableInt lowestY = new MutableInt(Integer.MAX_VALUE);
        HashMap<BlockPos, BlockState> missingBlocks = multiblock.getMissingBlocks(world, MultiblockRenderer.getStartPos(), MultiblockRenderer.getFacingRotation(), true);
        if (missingBlocks != null) {
            blocksDone = multiblock.getBlockCount() - missingBlocks.size();
            blocks = multiblock.getBlockCount();
            float alpha = 0.2f;
            if (lowestLayerMode) {
                missingBlocks.entrySet().stream().forEach(e -> {
                    if (lowestY.getValue() > ((BlockPos)e.getKey()).m_123342_()) {
                        lowestY.setValue(((BlockPos)e.getKey()).m_123342_());
                    }
                });
            }
            missingBlocks.entrySet().forEach(e -> {
                if (!MultiblockRenderer.posLocked() || !lowestLayerMode || ((BlockPos)e.getKey()).m_123342_() == lowestY.getValue().intValue()) {
                    MultiblockRenderer.renderBlock(world, (BlockState)e.getValue(), (BlockPos)e.getKey(), alpha, ms);
                }
            });
            syncWait = false;
        } else {
            syncWait = true;
        }
        buffers.m_109911_();
        if (!posLocked) {
            blocksDone = 0;
            blocks = 0;
        }
    }

    public static void renderBlock(Level world, BlockState state, BlockPos pos, float alpha, PoseStack ms) {
        if (pos != null) {
            ms.m_85836_();
            ms.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            if (state.m_60734_() == Blocks.f_50016_) {
                float scale = 0.3f;
                float off = (1.0f - scale) / 2.0f;
                ms.m_252880_(off, off, -off);
                ms.m_85841_(scale, scale, scale);
                state = Blocks.f_50504_.m_49966_();
            }
            Minecraft.m_91087_().m_91289_().renderSingleBlock(state, ms, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, null);
            ms.m_85849_();
        }
    }

    public static IMultiblockDefinition getMultiblock() {
        return multiblock;
    }

    public static boolean posLocked() {
        return posLocked;
    }

    public static Rotation getFacingRotation() {
        return multiblock.isSymmetrical() ? Rotation.NONE : facingRotation;
    }

    public static BlockPos getStartPos() {
        return renderPos;
    }

    private static Rotation getRotation(Entity entity) {
        return RotationUtils.rotationFromFacing(entity.m_6350_());
    }

    private static MultiBufferSource.BufferSource initBuffers(MultiBufferSource.BufferSource original) {
        BufferBuilder fallback = (BufferBuilder)ObfuscationReflectionHelper.getPrivateValue(MultiBufferSource.BufferSource.class, (Object)original, (String)"f_109904_");
        Map layerBuffers = (Map)ObfuscationReflectionHelper.getPrivateValue(MultiBufferSource.BufferSource.class, (Object)original, (String)"f_109905_");
        Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry e : layerBuffers.entrySet()) {
            remapped.put(GhostRenderType.remap((RenderType)e.getKey()), (BufferBuilder)e.getValue());
        }
        return new GhostBuffers(fallback, (Map<RenderType, BufferBuilder>)remapped);
    }

    static {
        syncWait = true;
        buffers = null;
        lowestLayerMode = true;
    }

    private static class GhostRenderType
    extends RenderType {
        private static Map<RenderType, RenderType> remappedTypes = new IdentityHashMap<RenderType, RenderType>();

        private GhostRenderType(RenderType original) {
            super(String.format("%s_%s_ghost", original.toString(), "mna"), original.m_110508_(), original.m_173186_(), original.m_110507_(), original.m_110405_(), true, () -> {
                original.m_110185_();
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.blendEquation((int)32774);
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
            }, () -> {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                original.m_110188_();
            });
        }

        public boolean equals(@Nullable Object other) {
            return this == other;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof GhostRenderType) {
                return in;
            }
            return remappedTypes.computeIfAbsent(in, GhostRenderType::new);
        }
    }

    private static class GhostBuffers
    extends MultiBufferSource.BufferSource {
        protected GhostBuffers(BufferBuilder fallback, Map<RenderType, BufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public VertexConsumer m_6299_(RenderType type) {
            return super.m_6299_(GhostRenderType.remap(type));
        }
    }
}

