/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools;

import com.mna.ManaAndArtifice;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.tools.MATags;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockUtils {
    private static final int blockBreakLimit = 25;

    public static Pair<Boolean, List<ItemStack>> breakTreeRecursive(Player player, Level world, BlockPos origin, boolean captureDrops) {
        return BlockUtils.breakTreeRecursive(player, world, origin, new ArrayList<Long>(), 0, captureDrops);
    }

    private static Pair<Boolean, List<ItemStack>> breakTreeRecursive(Player player, Level world, BlockPos origin, ArrayList<Long> checkedBlocks, int blockBreakCount, boolean captureDrops) {
        int radius = 1;
        int leafRadius = 2;
        boolean success = true;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = 0; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = origin.m_121955_((Vec3i)new BlockPos(x, y, z));
                    if (checkedBlocks.contains(pos.m_121878_())) continue;
                    checkedBlocks.add(pos.m_121878_());
                    TreeBlockTypes block = BlockUtils.isLogOrLeaf(world.m_8055_(pos));
                    if (block != TreeBlockTypes.LOG) continue;
                    ++blockBreakCount;
                    if (captureDrops) {
                        drops.addAll(BlockUtils.destroyBlockCaptureDrops((LivingEntity)player, world, pos, false, 0, (Tier)TierSortingRegistry.getSortedTiers().get(TierSortingRegistry.getSortedTiers().size() - 1)));
                    } else if (!BlockUtils.destroyBlock((LivingEntity)player, world, pos, !captureDrops, (Tier)TierSortingRegistry.getSortedTiers().get(TierSortingRegistry.getSortedTiers().size() - 1))) {
                        return new Pair((Object)false, drops);
                    }
                    for (int lx = -leafRadius; lx <= leafRadius; ++lx) {
                        for (int ly = 0; ly <= leafRadius; ++ly) {
                            for (int lz = -leafRadius; lz <= leafRadius; ++lz) {
                                BlockPos leafPos = pos.m_121955_((Vec3i)new BlockPos(lx, ly, lz));
                                block = BlockUtils.isLogOrLeaf(world.m_8055_(leafPos));
                                if (block != TreeBlockTypes.LEAF) continue;
                                if (captureDrops) {
                                    drops.addAll(BlockUtils.destroyBlockCaptureDrops((LivingEntity)player, world, leafPos, false, 0, (Tier)TierSortingRegistry.getSortedTiers().get(TierSortingRegistry.getSortedTiers().size() - 1)));
                                    continue;
                                }
                                BlockUtils.destroyBlock((LivingEntity)player, world, leafPos, !captureDrops, (Tier)TierSortingRegistry.getSortedTiers().get(TierSortingRegistry.getSortedTiers().size() - 1));
                            }
                        }
                    }
                    if (blockBreakCount > 25) continue;
                    Pair<Boolean, List<ItemStack>> sub = BlockUtils.breakTreeRecursive(player, world, pos, checkedBlocks, blockBreakCount, captureDrops);
                    drops.addAll((Collection)sub.getSecond());
                    success &= ((Boolean)sub.getFirst()).booleanValue();
                }
            }
        }
        return new Pair((Object)success, drops);
    }

    public static TreeBlockTypes isLogOrLeaf(BlockState state) {
        if (MATags.isBlockIn(state.m_60734_(), MATags.Blocks.LOGS)) {
            return TreeBlockTypes.LOG;
        }
        if (MATags.isBlockIn(state.m_60734_(), MATags.Blocks.LEAVES) || state.m_204336_(BlockTags.f_13078_)) {
            return TreeBlockTypes.LEAF;
        }
        return TreeBlockTypes.INVALID;
    }

    public static boolean placeBlock(ServerLevel world, BlockPos pos, Direction face, BlockState state, @Nullable Player player) {
        if (world.m_46749_(pos) && !ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos), (Direction)face)) {
            world.m_46597_(pos, state);
            return true;
        }
        return false;
    }

    public static BlockPos[] getBlocksInFrontOfCharacter(LivingEntity entity, int numBlocks, BlockPos firstBlock) {
        float speed = 0.1f;
        float factor = (float)Math.PI / 180;
        float sinYawRadians = Mth.m_14031_((float)(entity.m_146908_() * factor));
        float cosYawRadians = Mth.m_14089_((float)(entity.m_146908_() * factor));
        float sinPitchRadians = Mth.m_14031_((float)(entity.m_146909_() * factor));
        float cosPitchRadians = Mth.m_14089_((float)(entity.m_146909_() * factor));
        double motionZ = cosYawRadians * cosPitchRadians * speed;
        double motionX = -sinYawRadians * cosPitchRadians * speed;
        double motionY = -sinPitchRadians * speed;
        double curX = firstBlock.m_123341_();
        double curY = firstBlock.m_123342_();
        double curZ = firstBlock.m_123343_();
        float minimum = 0.01f;
        if (Math.abs(motionX) < (double)minimum) {
            motionX = 0.0;
        }
        if (Math.abs(motionY) < (double)minimum) {
            motionY = 0.0;
        }
        if (Math.abs(motionZ) < (double)minimum) {
            motionZ = 0.0;
        }
        int lastX = firstBlock.m_123341_();
        int lastY = firstBlock.m_123342_();
        int lastZ = firstBlock.m_123343_();
        BlockPos[] list = new BlockPos[numBlocks];
        list[0] = new BlockPos((Vec3i)firstBlock);
        int count = 1;
        while (count < numBlocks) {
            if ((int)Math.round(curX += motionX) == lastX && (int)Math.round(curY += motionY) == lastY && (int)Math.round(curZ += motionZ) == lastZ) continue;
            lastX = (int)Math.round(curX);
            lastY = (int)Math.round(curY);
            lastZ = (int)Math.round(curZ);
            list[count++] = new BlockPos(lastX, lastY, lastZ);
        }
        return list;
    }

    public static void stepThroughBlocksLinear(BlockPos a, BlockPos b, Consumer<BlockPos> action) {
        float stepDist = 0.2f;
        Vec3 curPos = Vec3.m_82512_((Vec3i)a);
        Vec3 endPos = Vec3.m_82512_((Vec3i)b);
        Vec3 step = endPos.m_82546_(curPos).m_82541_().m_82490_((double)stepDist);
        action.accept(BlockPos.m_274561_((double)curPos.m_7096_(), (double)curPos.m_7098_(), (double)curPos.m_7094_()));
        while (!curPos.m_82509_((Position)endPos, (double)stepDist)) {
            curPos = curPos.m_82549_(step);
            BlockPos cbp = BlockPos.m_274561_((double)curPos.m_7096_(), (double)curPos.m_7098_(), (double)curPos.m_7094_());
            action.accept(cbp);
        }
    }

    public static BlockPos Vector3dToBlockPosRound(Vec3 vec) {
        return BlockPos.m_274561_((double)Math.floor(vec.f_82479_), (double)Math.floor(vec.f_82480_), (double)Math.floor(vec.f_82481_));
    }

    public static void IterateBlocksInCube(int radius, BlockPos center, Consumer<BlockPos> callable) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockPos pos = new BlockPos(i, j, k).m_121955_((Vec3i)center);
                    callable.accept(pos);
                }
            }
        }
    }

    public static void stepThroughBlocksInCube(Vec3 a, Vec3 b, Consumer<BlockPos> action) {
        Vec3 dimensions = b.m_82546_(a);
        Vec3 step = dimensions.m_82541_();
        ArrayList<BlockPos> processed = new ArrayList<BlockPos>();
        double x = a.f_82479_;
        while (b.f_82479_ - x > step.f_82479_) {
            double y = a.f_82480_;
            while (b.f_82480_ - y > step.f_82480_) {
                double z = a.f_82481_;
                while (b.f_82481_ - z > step.f_82481_) {
                    BlockPos cur = BlockUtils.Vector3dToBlockPosRound(new Vec3(x, y, z));
                    if (!processed.contains(cur)) {
                        action.accept(cur);
                        processed.add(cur);
                    }
                    z += step.f_82481_;
                }
                y += step.f_82480_;
            }
            x += step.f_82479_;
        }
    }

    public static boolean destroyBlock(LivingEntity caster, Level world, BlockPos pos, boolean doDrops, Tier harvestLevel) {
        return BlockUtils.destroyBlock(caster, world, pos, doDrops, false, -1, harvestLevel);
    }

    public static boolean destroyBlock(LivingEntity caster, Level world, BlockPos pos, boolean doDrops, boolean silkTouch, int fortuneLevel, Tier harvestLevel) {
        int xp;
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        Player playerEntity = caster instanceof Player ? (Player)caster : FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world));
        BlockState state = world.m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)world, pos);
        if (hardness < 0.0f) {
            return false;
        }
        if (state.m_60834_() && !TierSortingRegistry.isCorrectTierForDrops((Tier)harvestLevel, (BlockState)state)) {
            return false;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, playerEntity);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (fortuneLevel > 0) {
            stack = new ItemStack((ItemLike)Items.f_42390_);
            stack.m_41663_(Enchantments.f_44987_, fortuneLevel);
            Block.m_49881_((BlockState)world.m_8055_(pos), (Level)world, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)playerEntity, (ItemStack)stack);
            doDrops = false;
        } else if (silkTouch) {
            stack = new ItemStack((ItemLike)Items.f_42390_);
            stack.m_41663_(Enchantments.f_44985_, 1);
            Block.m_49881_((BlockState)world.m_8055_(pos), (Level)world, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)playerEntity, (ItemStack)stack);
            doDrops = false;
        }
        if (!silkTouch && (xp = state.getExpDrop((LevelReader)world, world.m_213780_(), pos, 0, 0)) > 0) {
            state.m_60734_().m_49805_((ServerLevel)world, pos, xp);
        }
        if (doDrops) {
            if (world.m_46953_(pos, true, (Entity)playerEntity)) {
                int xp2;
                if (!silkTouch && (xp2 = state.getExpDrop((LevelReader)world, world.m_213780_(), pos, 0, 0)) > 0) {
                    state.m_60734_().m_49805_((ServerLevel)world, pos, xp2);
                }
                return true;
            }
            return false;
        }
        return world.m_46961_(pos, false);
    }

    public static List<ItemStack> destroyBlockCaptureDrops(LivingEntity caster, Level world, BlockPos pos, boolean silkTouch, int fortuneLevel, Tier harvestLevel) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!(world instanceof ServerLevel)) {
            return drops;
        }
        Player playerEntity = caster instanceof Player ? (Player)caster : FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world));
        BlockState state = world.m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)world, pos);
        if (hardness < 0.0f) {
            return drops;
        }
        if (state.m_60834_() && !TierSortingRegistry.isCorrectTierForDrops((Tier)harvestLevel, (BlockState)state)) {
            return drops;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, playerEntity);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return drops;
        }
        ItemStack stack = new ItemStack((ItemLike)Items.f_42390_);
        if (fortuneLevel > 0) {
            stack.m_41663_(Enchantments.f_44987_, fortuneLevel);
            drops.addAll(Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)playerEntity, (ItemStack)stack));
        } else if (silkTouch) {
            stack.m_41663_(Enchantments.f_44985_, 1);
            drops.addAll(Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)playerEntity, (ItemStack)stack));
        } else {
            drops.addAll(Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)playerEntity, (ItemStack)stack));
        }
        if (world.m_46953_(pos, false, (Entity)playerEntity)) {
            int xp;
            state.m_60734_().m_5707_(world, pos, state, playerEntity);
            if (!silkTouch && (xp = state.getExpDrop((LevelReader)world, world.m_213780_(), pos, 0, 0)) > 0) {
                state.m_60734_().m_49805_((ServerLevel)world, pos, xp);
            }
            BlockUtils.updateBlockState(world, pos);
        } else {
            drops.clear();
        }
        return drops;
    }

    public static boolean canDestroyBlock(LivingEntity caster, Level world, BlockPos pos, Tier harvestLevel) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        Player playerEntity = caster instanceof Player ? (Player)caster : FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world));
        BlockState state = world.m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)world, pos);
        if (hardness < 0.0f) {
            return false;
        }
        if (state.m_60834_() && !TierSortingRegistry.isCorrectTierForDrops((Tier)harvestLevel, (BlockState)state)) {
            return false;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, playerEntity);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void updateBlockState(Level world, BlockPos pos, BlockState state) {
        if (!world.m_151570_(pos)) {
            world.m_7260_(pos, state, state, 3);
        }
    }

    public static void updateBlockState(Level world, BlockPos pos) {
        BlockUtils.updateBlockState(world, pos, world.m_8055_(pos));
    }

    public static boolean tryDestroyBlockSilent(Level world, BlockPos pos, boolean dropBlock) {
        return BlockUtils.destroyBlockSilent(world, pos, dropBlock, null);
    }

    public static boolean tryDestroyBlockSilent(Level world, BlockPos pos, boolean dropBlock, @Nullable LivingEntity caster) {
        Player playerEntity;
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        Object object = playerEntity = caster instanceof Player ? (Player)caster : FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world));
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.m_8055_(pos), playerEntity))) {
            return false;
        }
        return BlockUtils.destroyBlockSilent(world, pos, dropBlock);
    }

    private static boolean destroyBlockSilent(Level world, BlockPos pos, boolean dropBlock) {
        return BlockUtils.destroyBlockSilent(world, pos, dropBlock, null);
    }

    private static boolean destroyBlockSilent(Level world, BlockPos pos, boolean isMoving, @Nullable Entity entityIn) {
        BlockState blockstate = world.m_8055_(pos);
        if (world.m_46859_(pos)) {
            return false;
        }
        FluidState ifluidstate = world.m_6425_(pos);
        if (isMoving) {
            BlockEntity tileentity = blockstate.m_155947_() ? world.m_7702_(pos) : null;
            Block.m_49881_((BlockState)blockstate, (Level)world, (BlockPos)pos, (BlockEntity)tileentity, (Entity)entityIn, (ItemStack)ItemStack.f_41583_);
        }
        return world.m_7731_(pos, ifluidstate.m_76188_(), 3);
    }

    public static Tier tierFromHarvestLevel(int harvestLevel) {
        ArrayList<? extends String> configuredTiers = new ArrayList<String>(GeneralConfigValues.BreakMagnitudeMapping);
        if (configuredTiers.size() == 0) {
            configuredTiers.add("minecraft:stone");
        }
        if (harvestLevel < 0) {
            harvestLevel = 0;
        }
        if (harvestLevel >= configuredTiers.size()) {
            harvestLevel = configuredTiers.size() - 1;
        }
        ResourceLocation rLoc = null;
        try {
            rLoc = new ResourceLocation(configuredTiers.get(harvestLevel));
        }
        catch (Throwable t) {
            rLoc = new ResourceLocation("minecraft:stone");
        }
        Tier resolved = TierSortingRegistry.byName((ResourceLocation)rLoc);
        if (resolved == null) {
            resolved = (Tier)TierSortingRegistry.getSortedTiers().get(0);
        }
        return resolved;
    }

    public static BlockState readBlockState(CompoundTag pTag) {
        if (!pTag.m_128425_("Name", 8)) {
            return Blocks.f_50016_.m_49966_();
        }
        ResourceLocation resourcelocation = new ResourceLocation(pTag.m_128461_("Name"));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourcelocation);
        if (block == null) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockState blockstate = block.m_49966_();
        if (pTag.m_128425_("Properties", 10)) {
            CompoundTag compoundtag = pTag.m_128469_("Properties");
            StateDefinition statedefinition = block.m_49965_();
            for (String s : compoundtag.m_128431_()) {
                Property property = statedefinition.m_61081_(s);
                if (property == null) continue;
                blockstate = BlockUtils.setValueHelper(blockstate, property, s, compoundtag, pTag);
            }
        }
        return blockstate;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S pStateHolder, Property<T> pProperty, String pPropertyName, CompoundTag pPropertiesTag, CompoundTag pBlockStateTag) {
        Optional optional = pProperty.m_6215_(pPropertiesTag.m_128461_(pPropertyName));
        if (optional.isPresent()) {
            return (S)((StateHolder)pStateHolder.m_61124_(pProperty, (Comparable)optional.get()));
        }
        ManaAndArtifice.LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)pPropertyName, (Object)pPropertiesTag.m_128461_(pPropertyName), (Object)pBlockStateTag.toString());
        return pStateHolder;
    }

    public static enum TreeBlockTypes {
        LOG,
        LEAF,
        INVALID;

    }
}

