/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.shapes;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.spells.targeting.SpellTargetHelper;
import com.mna.blocks.BlockInit;
import com.mna.blocks.ritual.ChalkRuneBlock;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.sorcery.targeting.SpellSigil;
import com.mna.factions.Factions;
import com.mna.items.sorcery.MagicStaff;
import com.mna.spells.shapes.ShapeRaytrace;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public class ShapeSigil
extends ShapeRaytrace {
    public ShapeSigil(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.RADIUS, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f), new AttributeValuePair(Attribute.WIDTH, 1.0f, 1.0f, 5.0f, 1.0f, 15.0f), new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f), new AttributeValuePair(Attribute.RANGE, 3.0f, 3.0f, 16.0f, 1.0f, 3.0f));
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, Level world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        Vec3 sigilPos;
        BlockPos pos;
        ItemStack heldItem;
        LazyOptional progression;
        SpellSigil sigil;
        EntityHitResult ehr;
        if (!source.isPlayerCaster()) {
            return Arrays.asList(SpellTarget.NONE);
        }
        float range = modificationData.getValue(Attribute.RANGE);
        HitResult targetResult = SpellTargetHelper.rayTrace((Entity)source.getCaster(), world, source.getOrigin(), source.getForward(), true, false, ClipContext.Block.OUTLINE, entity -> entity.m_6087_() && entity.m_6084_() && entity != source.getCaster(), source.getBoundingBox().m_82377_((double)range, (double)range, (double)range), range);
        HitResult.Type targetType = targetResult.m_6662_();
        if (targetType == HitResult.Type.MISS) {
            return Arrays.asList(SpellTarget.NONE);
        }
        if (targetType == HitResult.Type.ENTITY && (ehr = (EntityHitResult)targetResult).m_82443_() instanceof SpellSigil && (sigil = (SpellSigil)ehr.m_82443_()).isPermanent()) {
            sigil.addCharge();
            return Arrays.asList(new SpellTarget((Entity)source.getPlayer()));
        }
        boolean permanent = false;
        byte bonus = 0;
        if (source.isPlayerCaster() && (progression = source.getPlayer().getCapability(PlayerProgressionProvider.PROGRESSION)).isPresent() && ((IPlayerProgression)progression.resolve().get()).getAlliedFaction() == Factions.COUNCIL && (heldItem = source.getCaster().m_21120_(source.getHand())).m_41720_() instanceof MagicStaff) {
            bonus = (byte)heldItem.getEnchantmentLevel(Enchantments.f_44988_);
        }
        if (world.m_45976_(Entity.class, new AABB(pos = BlockPos.m_274446_((Position)(sigilPos = targetResult.m_82450_())))).size() != 0) {
            return Arrays.asList(SpellTarget.NONE);
        }
        if (targetType == HitResult.Type.BLOCK) {
            BlockHitResult brtr = (BlockHitResult)targetResult;
            BlockState state = world.m_8055_(brtr.m_82425_());
            if (state.m_60734_() == BlockInit.CHALK_RUNE.get() && ((Boolean)state.m_61143_((Property)ChalkRuneBlock.METAL)).booleanValue()) {
                permanent = true;
                world.m_7731_(brtr.m_82425_(), Blocks.f_50016_.m_49966_(), 3);
            } else if (brtr.m_82434_() != Direction.UP) {
                sigilPos.m_82520_((double)brtr.m_82434_().m_122429_(), (double)brtr.m_82434_().m_122430_(), (double)brtr.m_82434_().m_122431_());
            }
        }
        if (!world.f_46443_) {
            SpellSigil sigil2 = new SpellSigil(source.getPlayer(), recipe);
            sigil2.m_6034_((float)pos.m_123341_() + 0.5f, sigilPos.m_7098_() + 0.01, (float)pos.m_123343_() + 0.5f);
            if (permanent) {
                sigil2.setPermanent();
            }
            sigil2.setSize((byte)modificationData.getValue(Attribute.WIDTH));
            sigil2.setCastWithBonus(bonus);
            world.m_7967_((Entity)sigil2);
        }
        return Arrays.asList(new SpellTarget((Entity)source.getPlayer()));
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 250;
    }
}

