/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.crafting;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.events.SpellReagentsEvent;
import com.mna.api.faction.IFaction;
import com.mna.api.items.IFactionSpecific;
import com.mna.api.particles.MAParticleType;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellCastingResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.SpellReagent;
import com.mna.api.spells.SpellValidityResult;
import com.mna.api.spells.adjusters.SpellCastStage;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Modifier;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.MagicStaff;
import com.mna.recipes.ItemAndPatternRecipeHelper;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.spells.ComponentRecipe;
import com.mna.recipes.spells.ModifierRecipe;
import com.mna.recipes.spells.ShapeRecipe;
import com.mna.spells.NameProcessors;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;

public class SpellRecipe
implements ISpellDefinition,
IFactionSpecific {
    public static final int MAX_COMPONENTS = 5;
    public static final int MAX_MODIFIERS = 3;
    public static final String SPELL_COMPOUND_TAG = "spell";
    public static final String SPELL_COLOR_TAG = "spellColor";
    private ModifiedSpellPart<Shape> shape;
    private ArrayList<ModifiedSpellPart<SpellEffect>> components;
    private Modifier[] modifiers;
    private Affinity overrideAffinity = Affinity.UNKNOWN;
    private float complexity;
    private int particleColorOverride = -1;
    private float calculatedManaCost;
    private float overrideManaCost = -1.0f;
    private boolean isMysterious = true;

    public SpellRecipe() {
        this.modifiers = new Modifier[3];
        this.components = new ArrayList(5);
    }

    public SpellRecipe(Shape shape, SpellEffect component) {
        this.modifiers = new Modifier[3];
        this.components = new ArrayList(5);
        this.setShape(shape);
        this.addComponent(component);
    }

    public SpellRecipe setShape(Shape shape) {
        this.shape = shape != null ? new ModifiedSpellPart<Shape>(shape) : null;
        this.recalculateSpellNumbers();
        return this;
    }

    public SpellRecipe addComponent(SpellEffect component) {
        if (this.components.size() < 5 && !this.components.stream().anyMatch(c -> c.getPart() == component)) {
            this.components.add(new ModifiedSpellPart<SpellEffect>(component));
            this.recalculateSpellNumbers();
        }
        return this;
    }

    public SpellRecipe setShapeModifier(Attribute modifier, float value) {
        IModifiedSpellPart shape = this.getShape();
        if (shape != null) {
            ((ModifiedSpellPart)shape).setValue(modifier, value);
        }
        return this;
    }

    public SpellRecipe setComponentModifier(int componentIndex, Attribute modifier, float value) {
        IModifiedSpellPart component = this.getComponent(componentIndex);
        if (component != null) {
            ((ModifiedSpellPart)component).setValue(modifier, value);
        }
        return this;
    }

    public void removeComponent(int index) {
        if (index < 0 || index >= this.components.size()) {
            return;
        }
        this.components.remove(index);
        this.recalculateSpellNumbers();
    }

    public void setModifier(Modifier modifier, int index) {
        if (index < 0 || index >= 3) {
            return;
        }
        if (modifier == null && this.modifiers[index] != null) {
            for (Attribute attribute : this.modifiers[index].getModifiedAttributes()) {
                if (this.shape != null) {
                    this.shape.resetValueToDefault(attribute);
                }
                for (ModifiedSpellPart<SpellEffect> component : this.components) {
                    if (component == null) continue;
                    component.resetValueToDefault(attribute);
                }
            }
        }
        this.modifiers[index] = modifier;
        this.recalculateSpellNumbers();
    }

    public boolean addModifier(Modifier modifier) {
        for (int i = 0; i < 3; ++i) {
            if (this.modifiers[i] != null) continue;
            this.modifiers[i] = modifier;
            return true;
        }
        return false;
    }

    private void recalculateSpellNumbers() {
        this.calculateComplexity();
        this.calculateManaCost();
    }

    public ModifiedSpellPart<Shape> getShape() {
        return this.shape;
    }

    @Nullable
    public ModifiedSpellPart<SpellEffect> getComponent(int index) {
        if (index < 0 || index >= this.components.size()) {
            return null;
        }
        return this.components.get(index);
    }

    @Override
    public int countComponents() {
        return this.components.size();
    }

    @Override
    public void clearComponents() {
        this.components.clear();
        this.recalculateSpellNumbers();
    }

    @Override
    public int findComponent(SpellEffect component) {
        OptionalInt index = IntStream.range(0, this.components.size()).filter(idx -> this.components.get(idx).getPart() == component).findFirst();
        return index.isPresent() ? index.getAsInt() : -1;
    }

    @Override
    public List<IModifiedSpellPart<SpellEffect>> getComponents() {
        return this.components.stream().map(c -> c).collect(Collectors.toList());
    }

    @Override
    public void iterateComponents(Consumer<IModifiedSpellPart<SpellEffect>> consumer) {
        for (ModifiedSpellPart<SpellEffect> component : this.components) {
            consumer.accept(component);
        }
    }

    @Override
    public Modifier getModifier(int index) {
        if (index < 0 || index >= 3) {
            return null;
        }
        return this.modifiers[index];
    }

    @Override
    public List<Modifier> getModifiers() {
        return Arrays.asList(this.modifiers).stream().filter(m -> m != null).collect(Collectors.toList());
    }

    public boolean isAttributeModifiable(Attribute attr) {
        for (Modifier m : this.modifiers) {
            if (m == null || !m.modifiesType(attr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int countModifiers() {
        int c = 0;
        for (Modifier m : this.modifiers) {
            if (m == null) continue;
            ++c;
        }
        return c;
    }

    @Override
    public int getCooldown(@Nullable LivingEntity caster) {
        if (!this.isValid()) {
            return 0;
        }
        IPlayerRoteSpells roteCap = caster != null && caster instanceof Player ? (IPlayerRoteSpells)caster.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null) : null;
        float complexityCooldown = this.getComplexity() / 4.0f;
        MutableFloat baseline = new MutableFloat((float)this.shape.getPart().baselineCooldown());
        MutableFloat componentMastery = new MutableFloat(0.0f);
        this.iterateComponents(c -> {
            float componentCD = ((SpellEffect)c.getPart()).baselineCooldown();
            baseline.add(componentCD);
            if (roteCap != null) {
                float mastery = roteCap.getMastery((ISpellComponent)c.getPart());
                componentMastery.add(mastery);
            }
        });
        float totalBaseline = baseline.getValue().floatValue() + complexityCooldown;
        float componentMasteryFactor = componentMastery.getValue().floatValue() * 0.625f / (float)this.getComponents().size();
        float shapeMasteryFactor = (roteCap != null ? roteCap.getMastery((ISpellComponent)((ModifiedSpellPart)this.getShape()).getPart()) : 0.0f) * 0.375f;
        float contribution = MathUtils.lerpf(1.0f, 0.5f, componentMasteryFactor + shapeMasteryFactor);
        return (int)Math.ceil(totalBaseline * contribution);
    }

    @Override
    public float getComplexity() {
        return this.complexity;
    }

    @Override
    public float getManaCost() {
        return this.overrideManaCost == -1.0f ? this.calculatedManaCost : this.overrideManaCost;
    }

    @Override
    public void setManaCost(float manaCost) {
        this.overrideManaCost = manaCost;
    }

    @Override
    public int getParticleColorOverride() {
        return this.particleColorOverride;
    }

    @Override
    public void setParticleColorOverride(int color) {
        this.particleColorOverride = color;
    }

    @Override
    public MAParticleType colorParticle(MAParticleType particle, Entity living) {
        float minAlpha = 0.1f;
        if (living != null && living instanceof Player) {
            ((Player)living).getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                if (m.getParticleColorOverride() != -1) {
                    float pct = MathUtils.clamp((float)FastColor.ARGB32.m_13655_((int)m.getParticleColorOverride()) / 255.0f, minAlpha, 1.0f);
                    particle.setColor((float)FastColor.ARGB32.m_13665_((int)m.getParticleColorOverride()) * pct, (float)FastColor.ARGB32.m_13667_((int)m.getParticleColorOverride()) * pct, (float)FastColor.ARGB32.m_13669_((int)m.getParticleColorOverride()) * pct);
                }
            });
        }
        if (this.particleColorOverride != -1) {
            float pct = MathUtils.clamp((float)FastColor.ARGB32.m_13655_((int)this.particleColorOverride) / 255.0f, minAlpha, 1.0f);
            particle.setColor((float)FastColor.ARGB32.m_13665_((int)this.particleColorOverride) * pct, (float)FastColor.ARGB32.m_13667_((int)this.particleColorOverride) * pct, (float)FastColor.ARGB32.m_13669_((int)this.particleColorOverride) * pct);
        }
        return particle;
    }

    @Override
    public boolean isValid() {
        if (this.shape == null || this.shape.getPart() == null || this.components.stream().allMatch(c -> c == null)) {
            return false;
        }
        return !this.shape.getPart().isChanneled() && this.shape.getPart().allowChanneledComponents() || !this.components.stream().anyMatch(c -> !((SpellEffect)c.getPart()).canBeChanneled());
    }

    @Override
    public boolean isHarmful() {
        return this.components.stream().anyMatch(c -> c != null && c.getPart() != null && ((SpellEffect)c.getPart()).getUseTag() == SpellPartTags.HARMFUL);
    }

    public boolean isRote(Player player) {
        MutableBoolean valid = new MutableBoolean(true);
        player.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> {
            ArrayList<Attribute> modified_attrs = new ArrayList<Attribute>();
            if (!r.isRote(this.shape.getPart())) {
                valid.setFalse();
                return;
            }
            modified_attrs.addAll(this.shape.getContainedAttributes().stream().filter(a -> this.shape.getValueWithoutMultipliers((Attribute)((Object)((Object)a))) != this.shape.getDefaultValue((Attribute)((Object)((Object)a)))).collect(Collectors.toList()));
            this.components.forEach((Consumer<ModifiedSpellPart<SpellEffect>>)((Consumer<ModifiedSpellPart>)c -> {
                if (!r.isRote((ISpellComponent)c.getPart())) {
                    valid.setFalse();
                    return;
                }
                modified_attrs.addAll(c.getContainedAttributes().stream().filter(a -> this.shape.getValueWithoutMultipliers((Attribute)((Object)((Object)((Object)a)))) != this.shape.getDefaultValue((Attribute)((Object)((Object)((Object)a))))).collect(Collectors.toList()));
            }));
            modified_attrs.forEach(a -> {
                boolean modifier_attr_rote = false;
                for (int i = 0; i < this.modifiers.length; ++i) {
                    Modifier m = this.modifiers[i];
                    if (m == null) {
                        return;
                    }
                    if (!m.modifiesType((Attribute)((Object)((Object)a)))) continue;
                    modifier_attr_rote = true;
                    break;
                }
                if (!modifier_attr_rote) {
                    valid.setFalse();
                }
            });
        });
        return valid.getValue();
    }

    public int getMaxChannelTime() {
        if (!this.isValid()) {
            return 0;
        }
        Shape s = (Shape)((ModifiedSpellPart)this.getShape()).getPart();
        return s.isChanneled() ? s.maxChannelTime(this.getShape()) : 0;
    }

    @Override
    public boolean isChanneled() {
        if (!this.isValid()) {
            return false;
        }
        return ((Shape)((ModifiedSpellPart)this.getShape()).getPart()).isChanneled();
    }

    @Override
    public boolean isMysterious() {
        return this.isMysterious;
    }

    public static boolean isMysterious(ItemStack stack) {
        CompoundTag spellTag;
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt.m_128441_(SPELL_COMPOUND_TAG) && (spellTag = nbt.m_128469_(SPELL_COMPOUND_TAG)).m_128441_("mysterious")) {
            return spellTag.m_128471_("mysterious");
        }
        return false;
    }

    public void setMysterious(boolean mysterious) {
        this.isMysterious = mysterious;
    }

    @Override
    public void setOverrideAffinity(Affinity affinity) {
        this.overrideAffinity = affinity;
    }

    public boolean hasOverrideAffinity() {
        return this.overrideAffinity != Affinity.UNKNOWN;
    }

    public boolean hasOverrideManaCost() {
        return this.overrideManaCost >= 0.0f;
    }

    @Override
    public boolean canFactionCraft(IPlayerProgression progression) {
        int i;
        if (((Shape)((ModifiedSpellPart)this.getShape()).getPart()).getFactionRequirement() != null && ((Shape)((ModifiedSpellPart)this.getShape()).getPart()).getFactionRequirement() != progression.getAlliedFaction()) {
            return false;
        }
        for (i = 0; i < 5; ++i) {
            IModifiedSpellPart c = this.getComponent(i);
            if (c == null || ((SpellEffect)((ModifiedSpellPart)c).getPart()).getFactionRequirement() == null || ((SpellEffect)((ModifiedSpellPart)c).getPart()).getFactionRequirement() == progression.getAlliedFaction()) continue;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            Modifier m = this.getModifier(i);
            if (m == null || m.getFactionRequirement() == null || m.getFactionRequirement() == progression.getAlliedFaction()) continue;
            return false;
        }
        return true;
    }

    public boolean changeShapeAttributeValue(Attribute attribute, float newValue) {
        if (this.shape == null) {
            return false;
        }
        this.shape.setValue(attribute, newValue);
        this.recalculateSpellNumbers();
        return true;
    }

    public boolean changeComponentAttributeValue(int index, Attribute attribute, float newValue) {
        if (index < 0 || index >= this.components.size() || this.components.get(index) == null) {
            return false;
        }
        this.components.get(index).setValue(attribute, newValue);
        this.recalculateSpellNumbers();
        return true;
    }

    @Override
    public void writeToNBT(CompoundTag nbt) {
        CompoundTag spell = new CompoundTag();
        if (this.getShape() != null) {
            spell.m_128365_("shape", (Tag)((ModifiedSpellPart)this.getShape()).toNBT());
        }
        ListTag componentData = new ListTag();
        for (ModifiedSpellPart<SpellEffect> component : this.components) {
            if (component == null) continue;
            componentData.add((Object)component.toNBT());
        }
        spell.m_128365_("components", (Tag)componentData);
        CompoundTag modifierNBT = new CompoundTag();
        for (int i = 0; i < 3; ++i) {
            if (this.getModifier(i) == null) {
                modifierNBT.m_128359_("modifier_" + i, ManaAndArtifice.EMPTY.toString());
                continue;
            }
            modifierNBT.m_128359_("modifier_" + i, this.getModifier(i).getRegistryName().toString());
        }
        spell.m_128365_("modifiers", (Tag)modifierNBT);
        spell.m_128379_("mysterious", this.isMysterious());
        spell.m_128359_("overrideAffinity", this.overrideAffinity.toString());
        if (this.hasOverrideManaCost()) {
            spell.m_128350_("overrideManaCost", this.overrideManaCost);
        }
        nbt.m_128365_(SPELL_COMPOUND_TAG, (Tag)spell);
        nbt.m_128405_(SPELL_COLOR_TAG, this.particleColorOverride);
    }

    public static void removeSpellFromTag(CompoundTag nbt) {
        nbt.m_128473_(SPELL_COMPOUND_TAG);
    }

    public static SpellRecipe fromNBT(CompoundTag nbt) {
        SpellRecipe recipe = new SpellRecipe();
        if (nbt == null) {
            return recipe;
        }
        CompoundTag spellNBT = new CompoundTag();
        if (nbt.m_128441_(SPELL_COMPOUND_TAG)) {
            spellNBT = nbt.m_128469_(SPELL_COMPOUND_TAG);
        }
        if (spellNBT.m_128441_("shape")) {
            recipe.shape = ModifiedSpellPart.fromNBT(spellNBT.m_128469_("shape"), Registries.Shape.get());
        }
        if (spellNBT.m_128441_("component")) {
            recipe.components.clear();
            recipe.components.add(ModifiedSpellPart.fromNBT(spellNBT.m_128469_("component"), Registries.SpellEffect.get()));
        } else if (spellNBT.m_128441_("components")) {
            ListTag ComponentData = spellNBT.m_128437_("components", 10);
            for (Tag cINBT : ComponentData) {
                ModifiedSpellPart<SpellEffect> comp;
                if (!(cINBT instanceof CompoundTag) || (comp = ModifiedSpellPart.fromNBT((CompoundTag)cINBT, Registries.SpellEffect.get())) == null) continue;
                recipe.components.add(comp);
            }
        }
        if (spellNBT.m_128441_("modifiers")) {
            CompoundTag modifierNBT = spellNBT.m_128469_("modifiers");
            for (int i = 0; i < 3; ++i) {
                ResourceLocation rLoc = new ResourceLocation(modifierNBT.m_128461_("modifier_" + i));
                recipe.modifiers[i] = (Modifier)Registries.Modifier.get().getValue(rLoc);
            }
        }
        if (spellNBT.m_128441_("mysterious")) {
            recipe.isMysterious = spellNBT.m_128471_("mysterious");
        }
        if (spellNBT.m_128441_("overrideAffinity")) {
            recipe.overrideAffinity = Affinity.valueOf(spellNBT.m_128461_("overrideAffinity"));
        }
        if (spellNBT.m_128441_("overrideManaCost")) {
            recipe.overrideManaCost = spellNBT.m_128457_("overrideManaCost");
        }
        recipe.particleColorOverride = SpellRecipe.getParticleColorOverride(nbt);
        recipe.recalculateSpellNumbers();
        return recipe;
    }

    public static boolean stackContainsSpell(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128441_(SPELL_COMPOUND_TAG)) {
            CompoundTag subTag = tag.m_128469_(SPELL_COMPOUND_TAG);
            return subTag.m_128441_("shape") && (subTag.m_128441_("component") || subTag.m_128441_("components"));
        }
        return false;
    }

    public void calculateComplexity() {
        this.complexity = 0.0f;
        if (this.shape != null) {
            this.complexity += this.shape.getPart().initialComplexity();
            for (Attribute attr : this.shape.getContainedAttributes()) {
                float modifiedValue = this.shape.getValueWithoutMultipliers(attr);
                float modificationTotal = Math.abs(modifiedValue - this.shape.getDefaultValue(attr));
                if (modificationTotal == 0.0f) continue;
                this.complexity += (float)((int)Math.ceil(modificationTotal / this.shape.getStep(attr))) * this.shape.getStepComplexity(attr);
            }
        }
        for (ModifiedSpellPart<SpellEffect> component : this.components) {
            if (component == null) continue;
            this.complexity += component.getPart().initialComplexity();
            for (Attribute attr : component.getContainedAttributes()) {
                float modifiedValue = component.getValueWithoutMultipliers(attr);
                float modificationTotal = Math.abs(modifiedValue - component.getDefaultValue(attr));
                if (modificationTotal == 0.0f) continue;
                this.complexity += (float)((int)Math.ceil(modificationTotal / component.getStep(attr))) * component.getStepComplexity(attr);
            }
        }
    }

    public void calculateManaCost() {
        this.overrideManaCost = -1.0f;
        this.calculatedManaCost = this.complexity * 1.5f;
    }

    @Override
    public int getTier(@Nonnull Level world) {
        int tier = 1;
        if (this.shape != null) {
            tier = Math.max(tier, this.shape.getPart().getTier(world));
        }
        for (ModifiedSpellPart<SpellEffect> component : this.components) {
            if (component == null) continue;
            tier = Math.max(tier, component.getPart().getTier(world));
        }
        for (Modifier modifier : this.modifiers) {
            if (modifier == null) continue;
            tier = Math.max(tier, modifier.getTier(world));
        }
        return tier;
    }

    @Override
    public HashMap<Affinity, Float> getAffinity() {
        HashMap<Affinity, Float> affinityMap = new HashMap<Affinity, Float>();
        if (this.hasOverrideAffinity()) {
            affinityMap.put(this.overrideAffinity, Float.valueOf(1.0f));
            return affinityMap;
        }
        float total = 0.0f;
        HashMap<Affinity, Integer> affinityCount = new HashMap<Affinity, Integer>();
        for (ModifiedSpellPart<SpellEffect> component : this.components) {
            if (component == null) continue;
            total += 1.0f;
            Affinity aff = component.getPart().getAffinity();
            if (!affinityCount.containsKey((Object)aff)) {
                affinityCount.put(aff, 1);
                continue;
            }
            affinityCount.put(aff, (Integer)affinityCount.get((Object)aff) + 1);
        }
        for (Affinity aff : affinityCount.keySet()) {
            affinityMap.put(aff, Float.valueOf((float)((Integer)affinityCount.get((Object)aff)).intValue() / total));
        }
        if (affinityMap.size() == 0) {
            affinityMap.put(Affinity.UNKNOWN, Float.valueOf(1.0f));
        }
        return affinityMap;
    }

    @Override
    public Affinity getHighestAffinity() {
        return (Affinity)((Object)Collections.max(this.getAffinity().entrySet(), Comparator.comparingDouble(Map.Entry::getValue)).getKey());
    }

    public void maximize() {
        if (this.shape != null) {
            this.shape.getContainedAttributes().forEach(a -> this.shape.setValue((Attribute)((Object)a), this.shape.getMaximumValue((Attribute)((Object)a))));
        }
        this.components.forEach((Consumer<ModifiedSpellPart<SpellEffect>>)((Consumer<ModifiedSpellPart>)c -> c.getContainedAttributes().forEach(a -> c.setValue((Attribute)((Object)((Object)a)), this.shape.getMaximumValue((Attribute)((Object)((Object)a)))))));
        this.recalculateSpellNumbers();
    }

    @Override
    public void addItemTooltip(ItemStack stack, Level worldIn, List<Component> tooltip, Player player) {
        String displayName = stack.m_41786_().getString();
        if (this.isValid() && !this.isMysterious()) {
            SpellCaster.applyAdjusters(stack, (LivingEntity)player, InteractionHand.MAIN_HAND, false, this, SpellCastStage.SPELL_TOOLTIP);
            NameProcessors.checkAndAddDisplay(this, displayName, tooltip);
            if (Screen.m_96638_()) {
                IModifiedSpellPart shape = this.getShape();
                if (shape != null) {
                    tooltip.add((Component)Component.m_237115_((String)"item.mna.spell.shape_attributes").m_130940_(ChatFormatting.GREEN));
                    for (AttributeValuePair attr : ((Shape)((ModifiedSpellPart)shape).getPart()).getModifiableAttributes()) {
                        tooltip.add((Component)Component.m_237110_((String)"item.mna.spell.attribute_display", (Object[])new Object[]{attr.getAttribute().name(), Float.valueOf(((ModifiedSpellPart)shape).getValue(attr.getAttribute()))}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                    }
                }
                tooltip.add((Component)Component.m_237113_((String)" "));
                this.iterateComponents(component -> {
                    String componentName = Component.m_237115_((String)((SpellEffect)component.getPart()).getRegistryName().toString()).getString();
                    tooltip.add((Component)Component.m_237110_((String)"item.mna.spell.component_attributes", (Object[])new Object[]{componentName}).m_130940_(ChatFormatting.GREEN));
                    for (AttributeValuePair attr : ((SpellEffect)component.getPart()).getModifiableAttributes()) {
                        tooltip.add((Component)Component.m_237110_((String)"item.mna.spell.attribute_display", (Object[])new Object[]{attr.getAttribute().name(), Float.valueOf(component.getValue(attr.getAttribute()))}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                    }
                });
                tooltip.add((Component)Component.m_237113_((String)" "));
                if (this.isChanneled()) {
                    tooltip.add((Component)Component.m_237110_((String)"item.mna.spell.channeled_mana_cost_display", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getManaCost() * 20.0f))}).m_130940_(ChatFormatting.GOLD));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"item.mna.spell.mana_cost_display", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getManaCost()))}).m_130940_(ChatFormatting.GOLD));
                }
                tooltip.add((Component)Component.m_237110_((String)"item.mna.spell.complexity_display", (Object[])new Object[]{Float.valueOf(this.getComplexity())}).m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237113_((String)" "));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.mna.spell.shift_prompt").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
            if (this.getReagents(ManaAndArtifice.instance.proxy.getClientPlayer(), null, null).size() > 0) {
                if (Screen.m_96639_()) {
                    tooltip.add((Component)Component.m_237115_((String)"item.mna.spell.required_reagents").m_130940_(ChatFormatting.GOLD));
                    for (SpellReagent reagent : this.getReagents(ManaAndArtifice.instance.proxy.getClientPlayer(), null, null)) {
                        reagent.getAddedBy().addReagentTooltip(ManaAndArtifice.instance.proxy.getClientPlayer(), null, tooltip, reagent);
                    }
                    tooltip.add((Component)Component.m_237113_((String)" "));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"item.mna.spell.alt_prompt").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                }
            }
        }
    }

    @Override
    public List<SpellReagent> getReagents(@Nullable Player caster, @Nullable InteractionHand hand, @Nullable SpellCastingResult spellResult) {
        ArrayList<SpellReagent> reagents = new ArrayList<SpellReagent>();
        List<SpellReagent> shape_reagents = ((Shape)((ModifiedSpellPart)this.getShape()).getPart()).getRequiredReagents(caster);
        if (shape_reagents != null) {
            reagents.addAll(shape_reagents);
        }
        for (int i = 0; i < this.components.size(); ++i) {
            List<SpellReagent> component_reagents;
            SpellEffect c = (SpellEffect)((ModifiedSpellPart)this.getComponent(i)).getPart();
            if (spellResult != null && spellResult.getResultFor(c) != ComponentApplicationResult.SUCCESS && spellResult.getResultFor(c) != ComponentApplicationResult.DELAYED && spellResult.getResultFor(c) != ComponentApplicationResult.TARGET_ENTITY_SPAWNED || (component_reagents = c.getRequiredReagents(caster, hand)) == null) continue;
            reagents.addAll(component_reagents);
        }
        SpellReagentsEvent event = new SpellReagentsEvent(this, caster, reagents);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getRequiredReagents();
    }

    @Override
    public boolean containsPart(ResourceLocation partID) {
        if (this.getShape() != null && ((Shape)((ModifiedSpellPart)this.getShape()).getPart()).getRegistryName().equals((Object)partID)) {
            return true;
        }
        for (IModifiedSpellPart<SpellEffect> effect : this.getComponents()) {
            if (!effect.getPart().getRegistryName().equals((Object)partID)) continue;
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            Modifier m = this.getModifier(i);
            if (m == null || !m.getRegistryName().equals((Object)partID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFactionSpell(IFaction faction) {
        IFaction partReq;
        Object partReq2;
        if (this.getShape() != null && (partReq2 = ((Shape)((ModifiedSpellPart)this.getShape()).getPart()).getFactionRequirement()) != null && partReq2 == faction) {
            return true;
        }
        for (IModifiedSpellPart iModifiedSpellPart : this.getComponents()) {
            partReq = ((SpellEffect)iModifiedSpellPart.getPart()).getFactionRequirement();
            if (partReq == null || partReq != faction) continue;
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            Modifier modifier = this.getModifier(i);
            if (modifier == null || (partReq = modifier.getFactionRequirement()) == null || partReq != faction) continue;
            return true;
        }
        return false;
    }

    public HashMap<IFaction, Float> getCastFactionIre() {
        IFaction partReq;
        Object partReq2;
        HashMap<IFaction, Float> factionIre = new HashMap<IFaction, Float>();
        if (this.getShape() != null && (partReq2 = ((Shape)((ModifiedSpellPart)this.getShape()).getPart()).getFactionRequirement()) != null) {
            factionIre.put((IFaction)partReq2, Float.valueOf(factionIre.getOrDefault(partReq2, Float.valueOf(0.0f)).floatValue() + ((Shape)((ModifiedSpellPart)this.getShape()).getPart()).ire()));
        }
        for (IModifiedSpellPart iModifiedSpellPart : this.getComponents()) {
            partReq = ((SpellEffect)iModifiedSpellPart.getPart()).getFactionRequirement();
            if (partReq == null) continue;
            factionIre.put(partReq, Float.valueOf(factionIre.getOrDefault(partReq, Float.valueOf(0.0f)).floatValue() + ((SpellEffect)iModifiedSpellPart.getPart()).ire()));
        }
        for (int i = 0; i < 3; ++i) {
            Modifier modifier = this.getModifier(i);
            if (modifier == null || (partReq = modifier.getFactionRequirement()) == null) continue;
            factionIre.put(partReq, Float.valueOf(factionIre.getOrDefault(partReq, Float.valueOf(0.0f)).floatValue() + modifier.ire()));
        }
        return factionIre;
    }

    public void writeRecipeForRitual(Level world, CompoundTag nbt) {
        ComponentRecipe componentRecipe;
        ModifiedSpellPart<SpellEffect> component;
        ShapeRecipe shapeRecipe;
        if (this.components.size() != 1) {
            return;
        }
        CompoundTag ritualReagentData = new CompoundTag();
        NonNullList patterns = NonNullList.m_122779_();
        if (this.shape != null && (shapeRecipe = (ShapeRecipe)ItemAndPatternRecipeHelper.GetRecipe(world, this.shape.getPart().getRegistryName(), (RecipeType)RecipeInit.SHAPE_TYPE.get())) != null) {
            this.WriteRLocList(ritualReagentData, Arrays.asList(shapeRecipe.getRequiredItems()), "shape_items");
            for (ResourceLocation rLoc : shapeRecipe.getRequiredPatterns()) {
                patterns.add((Object)rLoc);
            }
        }
        if ((component = this.components.get(0)) != null && (componentRecipe = (ComponentRecipe)ItemAndPatternRecipeHelper.GetRecipe(world, component.getPart().getRegistryName(), (RecipeType)RecipeInit.COMPONENT_TYPE.get())) != null) {
            this.WriteRLocList(ritualReagentData, Arrays.asList(componentRecipe.getRequiredItems()), "component_items");
            for (ResourceLocation rLoc : componentRecipe.getRequiredPatterns()) {
                patterns.add((Object)rLoc);
            }
        }
        for (int i = 0; i < this.modifiers.length; ++i) {
            ModifierRecipe modifierRecipe;
            if (this.modifiers[i] == null || (modifierRecipe = (ModifierRecipe)ItemAndPatternRecipeHelper.GetRecipe(world, this.modifiers[i].getRegistryName(), (RecipeType)RecipeInit.MODIFIER_TYPE.get())) == null) continue;
            this.WriteRLocList(ritualReagentData, Arrays.asList(modifierRecipe.getRequiredItems()), "modifier_" + i + "_items");
            for (ResourceLocation rLoc : modifierRecipe.getRequiredPatterns()) {
                patterns.add((Object)rLoc);
            }
        }
        this.WriteRLocList(ritualReagentData, (Collection<ResourceLocation>)patterns, "pattern");
        nbt.m_128365_("ritual_reagent_data", (Tag)ritualReagentData);
    }

    private void WriteRLocList(CompoundTag nbt, Collection<ResourceLocation> list, String prefix) {
        if (list.size() == 0) {
            return;
        }
        int count = 0;
        nbt.m_128405_(prefix + "_count", list.size());
        for (ResourceLocation rLoc : list) {
            nbt.m_128359_(prefix + "_" + count++, rLoc.toString());
        }
    }

    private static NonNullList<ResourceLocation> ReadRLocList(CompoundTag nbt, String prefix) {
        NonNullList rLocs = NonNullList.m_122779_();
        if (!nbt.m_128441_(prefix + "_count")) {
            return rLocs;
        }
        int count = nbt.m_128451_(prefix + "_count");
        for (int i = 0; i < count; ++i) {
            String key = prefix + "_" + i;
            if (nbt.m_128441_(key)) {
                rLocs.add((Object)new ResourceLocation(nbt.m_128461_(key)));
                continue;
            }
            ManaAndArtifice.LOGGER.error("Failed to read key '" + key + "' from dynamic ritual spell recipe NBT (not found).");
        }
        return rLocs;
    }

    public static boolean isReagentContainer(ItemStack recipeStack) {
        CompoundTag nbt = recipeStack.m_41783_();
        return nbt != null && nbt.m_128441_("ritual_reagent_data");
    }

    public static NonNullList<ResourceLocation> getShapeReagents(ItemStack recipeStack) {
        CompoundTag ritualReagentData = recipeStack.m_41698_("ritual_reagent_data");
        return SpellRecipe.ReadRLocList(ritualReagentData, "shape_items");
    }

    public static NonNullList<ResourceLocation> getComponentReagents(ItemStack recipeStack) {
        CompoundTag ritualReagentData = recipeStack.m_41698_("ritual_reagent_data");
        return SpellRecipe.ReadRLocList(ritualReagentData, "component_items");
    }

    public static NonNullList<ResourceLocation> getModifierReagents(ItemStack recipeStack, int modifierIndex) {
        CompoundTag ritualReagentData = recipeStack.m_41698_("ritual_reagent_data");
        return SpellRecipe.ReadRLocList(ritualReagentData, "modifier_" + modifierIndex + "_items");
    }

    public static NonNullList<ResourceLocation> getPatterns(ItemStack recipeStack) {
        CompoundTag ritualReagentData = recipeStack.m_41698_("ritual_reagent_data");
        return SpellRecipe.ReadRLocList(ritualReagentData, "pattern");
    }

    public static int getParticleColorOverride(CompoundTag nbt) {
        if (nbt.m_128441_(SPELL_COLOR_TAG)) {
            return nbt.m_128451_(SPELL_COLOR_TAG);
        }
        return -1;
    }

    public ItemStack createAsSpell() {
        ItemStack newSpell = new ItemStack((ItemLike)ItemInit.SPELL.get());
        this.writeToNBT(newSpell.m_41784_());
        return newSpell;
    }

    @Override
    public boolean isChargedSpell(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof MagicStaff) {
            MagicStaff staff = (MagicStaff)item;
            return staff.isChargeSpell(stack);
        }
        return false;
    }

    @Override
    public void consumeCharges(ItemStack stack, Player caster) {
        Item item = stack.m_41720_();
        if (item instanceof MagicStaff) {
            MagicStaff staff = (MagicStaff)item;
            staff.consumeCharge(stack, caster, null);
        }
    }

    public SpellValidityResult isCraftable(Level level, IPlayerProgression progression, boolean creative, boolean allowChanneled, boolean checkFaction) {
        if (progression == null) {
            return SpellValidityResult.LOW_TIER;
        }
        if (this.getShape() == null) {
            return SpellValidityResult.NO_SHAPE;
        }
        if (this.getComponent(0) == null) {
            return SpellValidityResult.NO_COMPONENT;
        }
        if (!allowChanneled && (((Shape)((ModifiedSpellPart)this.getShape()).getPart()).isChanneled() || !((Shape)((ModifiedSpellPart)this.getShape()).getPart()).allowChanneledComponents()) && this.components.stream().anyMatch(c -> !((SpellEffect)c.getPart()).canBeChanneled())) {
            return SpellValidityResult.CANNOT_CHANNEL;
        }
        if (creative) {
            return SpellValidityResult.READY;
        }
        if (progression.getTier() < this.getTier(level)) {
            return SpellValidityResult.LOW_TIER;
        }
        if (this.getComplexity() > (float)progression.getTierMaxComplexity()) {
            return SpellValidityResult.TOO_COMPLEX;
        }
        if (checkFaction && !this.canFactionCraft(progression)) {
            return SpellValidityResult.WRONG_FACTION;
        }
        return SpellValidityResult.READY;
    }
}

