/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.effects.EffectInit;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import com.mna.spells.components.PotionEffectComponent;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ComponentTrueInvisibility
extends PotionEffectComponent {
    public static final String KEY_NBT_DISABLETIME = "ginvis_disabled_until";

    public ComponentTrueInvisibility(ResourceLocation guiIcon) {
        super(guiIcon, EffectInit.GREATER_INVISIBILITY, new AttributeValuePair(Attribute.DURATION, 120.0f, 30.0f, 600.0f, 30.0f, 4.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        Entity entity;
        if (target.isEntity() && (entity = target.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            ComponentTrueInvisibility.DisableForSeconds((LivingEntity)player, 0);
        }
        return super.ApplyEffect(source, target, modificationData, context);
    }

    @Override
    public void SpawnParticles(Level world, Vec3 impact_position, Vec3 normal, int age, LivingEntity caster, ISpellDefinition recipe) {
        if (age > 10) {
            return;
        }
        float particle_spread = 1.0f;
        float v = 0.4f;
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            Vec3 velocity = new Vec3(0.0, Math.random() * (double)v, 0.0);
            world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), (Entity)caster), impact_position.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    @Override
    public float initialComplexity() {
        return 30.0f;
    }

    @Override
    public IFaction getFactionRequirement() {
        return Factions.FEY;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }

    @Override
    public List<Affinity> getValidTinkerAffinities() {
        return Arrays.asList(Affinity.ARCANE, Affinity.ENDER, Affinity.WATER, Affinity.WIND, Affinity.ICE);
    }

    public static void DisableForSeconds(LivingEntity sourceLiving, int durationInSeconds) {
        if (sourceLiving == null) {
            return;
        }
        if (sourceLiving.m_142038_()) {
            durationInSeconds *= 2;
        }
        long gameTime = sourceLiving.m_9236_().m_46467_();
        sourceLiving.getPersistentData().m_128356_(KEY_NBT_DISABLETIME, gameTime + (long)(durationInSeconds * 20));
        if (sourceLiving instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)sourceLiving;
            ServerMessageDispatcher.sendGreaterInvisibilityDisabled(serverPlayer, durationInSeconds);
        }
    }

    public static boolean IsDisabledFor(LivingEntity sourceLiving) {
        if (sourceLiving == null) {
            return false;
        }
        return sourceLiving.getPersistentData().m_128454_(KEY_NBT_DISABLETIME) > sourceLiving.m_9236_().m_46467_();
    }
}

