/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.ConstructMaterial;
import com.mna.api.entities.construct.IConstructConstruction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.tools.MATags;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.constructs.animated.Construct;
import com.mna.recipes.manaweaving.TransmutationRecipe;
import com.mna.recipes.manaweaving.TransmutationRecipeSerializer;
import com.mna.tools.BlockUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ComponentTransmute
extends SpellEffect {
    public ComponentTransmute(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[0]);
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        if (source.getCaster() == null) {
            return ComponentApplicationResult.FAIL;
        }
        if (target.isBlock() && context.getServerLevel().m_46749_(target.getBlock())) {
            BlockState state = context.getServerLevel().m_8055_(target.getBlock());
            Block block = state.m_60734_();
            List recipes = TransmutationRecipeSerializer.ALL_RECIPES.values().stream().filter(r -> MATags.isBlockIn(block, r.getTargetBlock()) || r.getTargetBlock().equals((Object)ForgeRegistries.BLOCKS.getKey((Object)block))).collect(Collectors.toList());
            if (recipes.size() == 0) {
                return ComponentApplicationResult.SUCCESS;
            }
            TransmutationRecipe recipe = (TransmutationRecipe)recipes.get(0);
            if (!source.isPlayerCaster()) {
                Construct construct;
                IConstructConstruction data;
                ConstructMaterial bestMat;
                if (recipe.getFactionRequirement() != null) {
                    return ComponentApplicationResult.FAIL;
                }
                int armTier = 0;
                LivingEntity livingEntity = source.getCaster();
                if (livingEntity instanceof Construct && (bestMat = (data = (construct = (Construct)livingEntity).getConstructData()).getHighestMatieralForCapability(ConstructCapability.CAST_SPELL)) != ConstructMaterial.UNKNOWN) {
                    armTier = bestMat.getCastingTierEquivalent();
                }
                if (recipe.getTier() > armTier) {
                    return ComponentApplicationResult.FAIL;
                }
            }
            if (source.isPlayerCaster()) {
                IPlayerProgression progression = (IPlayerProgression)source.getPlayer().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                if (progression != null) {
                    if (progression.getTier() < recipe.getTier()) {
                        source.getPlayer().m_213846_((Component)Component.m_237115_((String)"mna:components/transmute.low_tier"));
                        return ComponentApplicationResult.FAIL;
                    }
                    if (recipe.getFactionRequirement() != null && progression.getAlliedFaction() != recipe.getFactionRequirement()) {
                        source.getPlayer().m_213846_((Component)Component.m_237115_((String)"mna:components/transmute.wrong_faction"));
                        return ComponentApplicationResult.FAIL;
                    }
                } else if (recipe.getTier() > 0 || recipe.getFactionRequirement() != null) {
                    return ComponentApplicationResult.FAIL;
                }
            }
            if (recipe != null && BlockUtils.destroyBlock(source.getCaster(), (Level)context.getServerLevel(), target.getBlock(), false, (Tier)Tiers.IRON)) {
                LootTable lootTable;
                Block replace;
                if (recipe.hasReplaceBlock() && (replace = (Block)ForgeRegistries.BLOCKS.getValue(recipe.getReplaceBlock())) != null) {
                    context.getServerLevel().m_7731_(target.getBlock(), replace.m_49966_(), 3);
                }
                if (recipe.hasLootTable() && (lootTable = context.getServerLevel().m_7654_().m_278653_().m_278676_(recipe.getLootTable())) != null) {
                    LootParams lootparams = new LootParams.Builder(context.getServerLevel()).m_287286_(LootContextParams.f_81455_, (Object)source.getCaster()).m_287286_(LootContextParams.f_81457_, (Object)source.getCaster().m_269291_().m_269425_()).m_287289_(LootContextParams.f_81463_, (Object)source.getCaster().m_21120_(source.getHand())).m_287286_(LootContextParams.f_81460_, (Object)target.getPosition()).m_287235_(LootContextParamSets.f_81415_);
                    Vec3 isPos = Vec3.m_82512_((Vec3i)target.getBlock());
                    lootTable.m_287195_(lootparams).forEach(is -> {
                        ItemEntity item = new ItemEntity((Level)context.getServerLevel(), isPos.f_82479_, isPos.f_82480_, isPos.f_82481_, is);
                        context.getServerLevel().m_7967_((Entity)item);
                    });
                }
                return ComponentApplicationResult.SUCCESS;
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.ARCANE;
    }

    @Override
    public void SpawnParticles(Level world, Vec3 impact_position, Vec3 normal, int age, LivingEntity caster, ISpellDefinition recipe) {
        if (age < 5) {
            Vec3 rotationOffset = new Vec3(1.5, 0.0, 0.0);
            BlockPos bp = BlockPos.m_274446_((Position)impact_position).m_7918_(0, -1, 0);
            for (int angle = 0; angle < 360; angle += 30) {
                Vec3 point = rotationOffset.m_82524_((float)((double)angle * Math.PI / 180.0));
                world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get())), (Entity)caster), (double)((float)bp.m_123341_() + 0.5f) + point.f_82479_, (double)bp.m_123342_(), (double)((float)bp.m_123343_() + 0.5f) + point.f_82481_, (double)((float)bp.m_123341_() + 0.5f), (double)(bp.m_123342_() + 2), (double)((float)bp.m_123343_() + 0.5f));
            }
        }
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return true;
    }

    @Override
    public boolean targetsEntities() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

