/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.tools.MATags;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.interop.CuriosInterop;
import com.mna.items.ItemInit;
import com.mna.tools.BlockUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import top.theillusivec4.curios.api.SlotTypePreset;

public class ComponentGust
extends SpellEffect {
    public ComponentGust(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.PRECISION, 0.0f, 0.0f, 1.0f, 1.0f, 2.0f), new AttributeValuePair(Attribute.SPEED, 1.0f, 0.0f, 4.0f, 1.0f, 2.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        float speed = modificationData.getValue(Attribute.SPEED);
        float precision = modificationData.getValue(Attribute.PRECISION);
        if (target.isBlock() && precision == 0.0f) {
            if (!context.getServerLevel().m_46749_(target.getBlock())) {
                return ComponentApplicationResult.FAIL;
            }
            BlockState state = context.getServerLevel().m_8055_(target.getBlock());
            if (speed == 0.0f) {
                Block block = state.m_60734_();
                if (block instanceof BrushableBlock) {
                    BrushableBlockEntity brushable;
                    BlockEntity blockentity;
                    BrushableBlock brushableBlock = (BrushableBlock)block;
                    if (source.isPlayerCaster() && (blockentity = context.getLevel().m_7702_(target.getBlock())) instanceof BrushableBlockEntity && (brushable = (BrushableBlockEntity)blockentity).m_276923_(context.getLevel().m_46467_(), source.getPlayer(), target.getBlockFace(this))) {
                        context.getLevel().m_247517_(source.getPlayer(), target.getBlock(), brushableBlock.m_276856_(), SoundSource.BLOCKS);
                    }
                }
            } else if (ComponentGust.BlockStateIsGustable(state) && BlockUtils.destroyBlock(source.getCaster(), (Level)context.getServerLevel(), target.getBlock(), true, (Tier)Tiers.WOOD)) {
                BlockUtils.updateBlockState((Level)context.getServerLevel(), target.getBlock());
                return ComponentApplicationResult.SUCCESS;
            }
        } else if (target.isEntity() && speed > 1.0f) {
            speed -= 1.0f;
            if (target.getEntity() instanceof ItemEntity) {
                Vec3 tPos = target.getEntity().m_20182_();
                Vec3 cPos = source.getOrigin();
                Vec3 delta = cPos.m_82546_(tPos).m_82541_();
                target.getEntity().m_20256_(delta);
                return ComponentApplicationResult.SUCCESS;
            }
            if (target.getEntity() instanceof LivingEntity) {
                if (context.hasEntityBeenAffected(this, target.getEntity())) {
                    return ComponentApplicationResult.FAIL;
                }
                context.addAffectedEntity(this, target.getEntity());
                LivingEntity le = target.getLivingEntity();
                float max_velocity = 1.5f;
                if (CuriosInterop.IsItemInCurioSlot((Item)ItemInit.AIR_CAST_RING.get(), source.getCaster(), SlotTypePreset.RING)) {
                    max_velocity += 0.5f;
                }
                Vec3 motion = new Vec3(0.0, 0.25, 0.0);
                motion = motion.m_82490_((double)(speed * 2.0f));
                if (le instanceof Player) {
                    Player targetPlayer = (Player)le;
                    if (targetPlayer == source.getCaster()) {
                        IPlayerMagic magic = (IPlayerMagic)source.getPlayer().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
                        if (magic == null || magic.getAirCasts() >= magic.getAirCastLimit(source.getPlayer(), context.getSpell())) {
                            return ComponentApplicationResult.FAIL;
                        }
                        if (!source.getPlayer().m_20096_()) {
                            magic.incrementAirCasts(source.getPlayer(), context.getSpell());
                        }
                    }
                    targetPlayer.m_5997_(0.0, motion.f_82480_, 0.0);
                    motion = targetPlayer.m_20184_();
                    if (motion.m_7098_() > (double)max_velocity) {
                        motion = new Vec3(motion.f_82479_, (double)max_velocity, motion.f_82481_);
                    }
                    targetPlayer.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
                    targetPlayer.f_19864_ = true;
                    ((ServerPlayer)targetPlayer).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)targetPlayer));
                    if (!CuriosInterop.IsItemInCurioSlot((Item)ItemInit.AIR_CAST_RING.get(), (LivingEntity)targetPlayer, SlotTypePreset.RING)) {
                        this.setFlags((LivingEntity)targetPlayer, speed);
                    }
                    return ComponentApplicationResult.SUCCESS;
                }
                le.m_5997_(0.0, motion.f_82480_, 0.0);
                motion = le.m_20184_();
                if (motion.m_7098_() > (double)max_velocity) {
                    motion = new Vec3(motion.f_82479_, (double)max_velocity, motion.f_82481_);
                    le.m_20256_(motion);
                }
                if (le instanceof PathfinderMob) {
                    ((PathfinderMob)le).m_21573_().m_26573_();
                }
                this.setFlags(le, speed);
                return ComponentApplicationResult.SUCCESS;
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    private void setFlags(LivingEntity le, float strength) {
        le.getPersistentData().m_128350_("mna:flung", strength);
        le.getPersistentData().m_128356_("mna:fling_time", le.m_9236_().m_46467_());
    }

    public static boolean BlockStateIsGustable(BlockState state) {
        return MATags.isBlockIn(state.m_60734_(), MATags.Blocks.GUST_DESTRUCTIBLE_BLOCKS) || state.m_60734_() instanceof IPlantable;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.WIND;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.AoE.WIND;
    }

    @Override
    public void SpawnParticles(Level world, Vec3 impact_position, Vec3 normal, int age, LivingEntity caster, ISpellDefinition recipe) {
        if (age < 10) {
            float particle_spread = 1.0f;
            int particleCount = 5;
            for (int i = 0; i < particleCount; ++i) {
                world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.2f).setColor(10, 10, 10), (Entity)caster), impact_position.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), Math.random() * (double)0.2f, (double)0.3f, 2.5);
            }
        }
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 50;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }

    @Override
    public List<Affinity> getValidTinkerAffinities() {
        return Arrays.asList(Affinity.WIND, Affinity.LIGHTNING, Affinity.WATER);
    }
}

