/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.tools.BlockUtils;
import com.mna.tools.EnchantmentUtils;
import com.mna.tools.InventoryUtilities;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class ComponentExchange
extends SpellEffect {
    public ComponentExchange(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        if (!source.isPlayerCaster() || target.isEntity()) {
            return ComponentApplicationResult.FAIL;
        }
        if (context.getServerLevel().m_46859_(target.getBlock())) {
            return ComponentApplicationResult.FAIL;
        }
        int harvestLevel = (int)modificationData.getValue(Attribute.MAGNITUDE);
        Tier harvestTier = BlockUtils.tierFromHarvestLevel(harvestLevel - 1);
        if (!BlockUtils.canDestroyBlock(source.getCaster(), (Level)context.getServerLevel(), target.getBlock(), harvestTier)) {
            return ComponentApplicationResult.FAIL;
        }
        CompoundTag nbt = context.getMeta();
        Block searchBlock = null;
        Item searchItem = null;
        if (!nbt.m_128441_("blockType")) {
            ItemStack offhandStack = source.getPlayer().m_21120_(source.getHand() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
            if (!(offhandStack.m_41720_() instanceof BlockItem)) {
                return ComponentApplicationResult.FAIL;
            }
            if (!(offhandStack.m_41720_() instanceof BlockItem)) {
                return ComponentApplicationResult.FAIL;
            }
            searchBlock = ((BlockItem)offhandStack.m_41720_()).m_40614_();
            searchItem = offhandStack.m_41720_();
            nbt.m_128359_("blockType", ForgeRegistries.ITEMS.getKey((Object)offhandStack.m_41720_()).toString());
        } else {
            ResourceLocation rLoc = new ResourceLocation(nbt.m_128461_("blockType"));
            searchItem = (Item)ForgeRegistries.ITEMS.getValue(rLoc);
            if (searchItem != null && searchItem instanceof BlockItem) {
                searchBlock = ((BlockItem)searchItem).m_40614_();
            }
        }
        if (searchBlock == null || searchItem == null) {
            return ComponentApplicationResult.FAIL;
        }
        if (!searchBlock.m_49966_().m_60710_((LevelReader)context.getServerLevel(), target.getBlock())) {
            return ComponentApplicationResult.FAIL;
        }
        if (!source.getPlayer().m_7500_() && InventoryUtilities.removeSingleItemFromInventory(ForgeRegistries.ITEMS.getKey((Object)searchItem), (Container)source.getPlayer().m_150109_()).m_41619_()) {
            return ComponentApplicationResult.FAIL;
        }
        boolean silkTouch = EnchantmentUtils.getSilkTouch(source.getPlayer());
        int fortune_level = 0;
        if (!silkTouch) {
            fortune_level = EnchantmentUtils.getFortuneLevel(source.getPlayer());
        }
        BlockState sourceState = context.getServerLevel().m_8055_(target.getBlock());
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Pair<Boolean, Boolean> captureRedirect = InventoryUtilities.getCaptureAndRedirect(source.getPlayer());
        drops.addAll(BlockUtils.destroyBlockCaptureDrops(source.getCaster(), (Level)context.getServerLevel(), target.getBlock(), silkTouch, fortune_level, harvestTier));
        if (source.isPlayerCaster()) {
            InventoryUtilities.redirectCaptureOrDrop(source.getPlayer(), (Level)context.getServerLevel(), drops, (Boolean)captureRedirect.getSecond());
        }
        BlockState destState = searchBlock.m_152465_(sourceState);
        context.getServerLevel().m_7731_(target.getBlock(), destState, 3);
        return ComponentApplicationResult.SUCCESS;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    @Override
    public float initialComplexity() {
        return 2.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }

    @Override
    public boolean targetsEntities() {
        return false;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }

    public class PlaceBlockInfo {
        public final Block block;
        public final BlockPos position;
        public final Level world;

        public PlaceBlockInfo(Block block, BlockPos position, Level world) {
            this.block = block;
            this.position = position;
            this.world = world;
        }
    }
}

