/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.api.tools.MATags;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.boss.FaerieQueen;
import com.mna.entities.rituals.FeyLight;
import com.mna.factions.Factions;
import com.mna.tools.StructureUtils;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.phys.Vec3;

public class RitualEffectFaerieCourts
extends RitualEffect {
    public RitualEffectFaerieCourts(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    public Component canRitualStart(IRitualContext context) {
        IPlayerProgression progression = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return Component.m_237113_((String)"Progression could not be found...this is a problem.");
        }
        FaerieQueen tempBoss = new FaerieQueen(context.getLevel(), Vec3.m_82539_((Vec3i)context.getCenter()), true);
        if (!StructureUtils.isPointInStructure((ServerLevel)context.getLevel(), context.getCenter(), tempBoss.getArenaStructureID(), tempBoss.getArenaStructureSegment())) {
            if (progression.getTierProgress(context.getLevel()) < 1.0f) {
                return Component.m_237115_((String)"ritual.mna.progression.not_ready");
            }
            if (progression != null && progression.hasAlliedFaction() && progression.getAlliedFaction() != Factions.FEY) {
                return Component.m_237115_((String)"event.mna.faction_ritual_failed");
            }
        }
        return null;
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        boolean winter;
        if (context.getCaster() == null || context.getCaster().m_20148_() == null) {
            return false;
        }
        FaerieQueen summerQueen = new FaerieQueen(context.getLevel(), Vec3.m_82539_((Vec3i)context.getCenter()).m_82520_(3.0, 0.0, 0.0), false);
        if (StructureUtils.isPointInStructure((ServerLevel)context.getLevel(), context.getCenter(), summerQueen.getArenaStructureID(), summerQueen.getArenaStructureSegment())) {
            FaerieQueen winterQueen = new FaerieQueen(context.getLevel(), Vec3.m_82539_((Vec3i)context.getCenter()).m_82520_(-3.0, 0.0, 0.0), true);
            summerQueen.setupSpawn();
            winterQueen.setupSpawn();
            context.getLevel().m_7967_((Entity)summerQueen);
            context.getLevel().m_7967_((Entity)winterQueen);
            return true;
        }
        boolean summer = context.getCollectedReagents(i -> MATags.isItemIn(i.m_41720_(), MATags.Items.Ritual.SUMMER_FLOWERS)).size() > 0;
        boolean bl = winter = context.getCollectedReagents(i -> MATags.isItemIn(i.m_41720_(), MATags.Items.Ritual.WINTER_FLOWERS)).size() > 0;
        if (!summer && !winter) {
            context.getCaster().m_213846_((Component)Component.m_237115_((String)"event.mna.fey_ritual_no_decider"));
            return false;
        }
        if (summer && winter) {
            context.getCaster().m_213846_((Component)Component.m_237115_((String)"event.mna.fey_ritual_conflicting_decider"));
            return false;
        }
        if (summer && !winter) {
            context.getCaster().getPersistentData().m_128405_("faction_casting_resource_idx", 0);
        } else {
            context.getCaster().getPersistentData().m_128405_("faction_casting_resource_idx", 1);
        }
        FeyLight e = (FeyLight)((EntityType)EntityInit.FEY_LIGHT.get()).m_20592_((ServerLevel)context.getLevel(), null, context.getCaster(), context.getCenter().m_6630_(12), MobSpawnType.EVENT, false, false);
        e.setTargetPos(context.getCenter().m_6630_(3));
        e.setCasterUUID(context.getCaster().m_20148_());
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 140;
    }
}

