/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.api.spells.ICanContainSpell;
import com.mna.api.spells.parts.Modifier;
import com.mna.blocks.tileentities.ChalkRuneTile;
import com.mna.entities.utility.PresentItem;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.ItemModifierBook;
import com.mna.items.sorcery.ItemSpell;
import com.mna.items.sorcery.SpellBook;
import com.mna.spells.crafting.SpellRecipe;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class RitualEffectAlteration
extends RitualEffect {
    public RitualEffectAlteration(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    public boolean applyStartCheckInCreative() {
        return true;
    }

    @Override
    public Component canRitualStart(IRitualContext context) {
        MutableObject output = new MutableObject();
        context.getAllPositions().stream().forEach(pos -> {
            BlockEntity te = context.getLevel().m_7702_(pos.getBlockPos());
            if (te != null && te instanceof ChalkRuneTile) {
                Optional<Modifier> selectedModifier;
                ChalkRuneTile tecr = (ChalkRuneTile)te;
                ItemStack reagentStack = tecr.m_8020_(0);
                if (reagentStack.m_41720_() instanceof ItemSpell && !(reagentStack.m_41720_() instanceof SpellBook)) {
                    if (((ItemSpell)reagentStack.m_41720_()).isTranscribedSpell(reagentStack)) {
                        output.setValue((Object)Component.m_237115_((String)"ritual.mna.spell_modification.transcribed"));
                    } else {
                        SpellRecipe recipe = SpellRecipe.fromNBT(reagentStack.m_41783_());
                        if (recipe.countModifiers() >= 3) {
                            output.setValue((Object)Component.m_237115_((String)"ritual.mna.spell_modification.at-maximum"));
                        }
                    }
                } else if (reagentStack.m_41720_() == ItemInit.MODIFIER_BOOK.get() && !(selectedModifier = ItemModifierBook.getModifier(reagentStack)).isPresent()) {
                    output.setValue((Object)Component.m_237115_((String)"ritual.mna.spell_modification.not-selected"));
                }
            }
        });
        return (Component)output.getValue();
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        ItemStack book = context.getCollectedReagents().get(9);
        ItemStack spell = context.getCollectedReagents().get(8);
        if (book.m_41619_() || spell.m_41619_() || book.m_41720_() != ItemInit.MODIFIER_BOOK.get() || !(spell.m_41720_() instanceof ICanContainSpell)) {
            return false;
        }
        Optional<Modifier> m = ItemModifierBook.getModifier(book);
        SpellRecipe recipe = SpellRecipe.fromNBT(spell.m_41784_());
        boolean didAdd = false;
        if (m.isPresent()) {
            didAdd = recipe.addModifier(m.get());
        }
        ItemStack outputStack = spell.m_41777_();
        recipe.writeToNBT(outputStack.m_41784_());
        PresentItem epi = new PresentItem(context.getLevel(), (double)context.getCenter().m_123341_() + 0.5, context.getCenter().m_123342_() + 1, (double)context.getCenter().m_123343_() + 0.5, outputStack);
        context.getLevel().m_7967_((Entity)epi);
        return didAdd;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 0;
    }

    @Override
    protected boolean modifyRitualReagentsAndPatterns(ItemStack dataStack, IRitualContext context) {
        if (dataStack.m_41720_() != ItemInit.MODIFIER_BOOK.get()) {
            return false;
        }
        MutableBoolean successfullyReplaced = new MutableBoolean(false);
        ItemModifierBook.getModifier(dataStack).ifPresent(m -> ItemModifierBook.getRecipe(m, context.getLevel()).ifPresent(r -> {
            context.replaceReagents(new ResourceLocation("mna:dynamic-modifier-1"), (NonNullList<ResourceLocation>)NonNullList.m_122783_((Object)new ResourceLocation(""), (Object[])r.getRequiredItems()));
            context.replacePatterns((NonNullList<ResourceLocation>)NonNullList.m_122783_((Object)new ResourceLocation(""), (Object[])r.getRequiredPatterns()));
            successfullyReplaced.setTrue();
        }));
        return successfullyReplaced.booleanValue();
    }

    @Override
    public SoundEvent getLoopSound(IRitualContext context) {
        return super.getLoopSound(context);
    }

    @Override
    public boolean spawnRitualParticles(IRitualContext context) {
        return super.spawnRitualParticles(context);
    }
}

