/*
 * Decompiled with CFR 0.152.
 */
package com.mna.particles.trail;

import com.mna.api.particles.MAParticleType;
import com.mna.particles.FXMovementType;
import com.mna.particles.base.MAParticleBase;
import com.mna.particles.bolt.Segment;
import com.mna.particles.trail.ParticleTrail;
import com.mna.particles.types.render.ParticleRenderTypes;
import com.mna.tools.math.Vector3;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FXTrail
extends MAParticleBase {
    private ParticleTrail data;
    private Entity followEntity;
    private Vector3 origin;

    public FXTrail(ClientLevel worldIn, double startX, double startY, double startZ, double entityID, double randSeed, double maxAge, SpriteSet sprite) {
        super(worldIn, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.f_108321_ = sprite.m_213979_(this.f_107223_);
        this.data = new ParticleTrail(worldIn.f_46441_.m_188505_());
        this.m_107264_(startX, startY, startZ);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.origin = new Vector3(startX, startY, startZ);
        this.f_107663_ = 0.04f;
        this.m_107250_(3.0f, 3.0f);
        this.f_107227_ = 0.2f;
        this.f_107228_ = 0.2f;
        this.f_107229_ = 0.8f;
    }

    private void setMoveFollowEntity(Level world, int entityID, long seed, int maxAge) {
        this.followEntity = world.m_6815_(entityID);
        this.f_107225_ = maxAge;
        this.movementType = FXMovementType.STATIONARY;
        this.origin = null;
    }

    @Override
    public void m_5989_() {
        if (this.followEntity == null) {
            super.m_5989_();
        } else {
            if (!this.followEntity.m_6084_()) {
                this.m_107274_();
                return;
            }
            this.moveFollowEntity();
        }
        double time = (float)this.f_107224_ / 4.0f;
        Vector3 prevPos = new Vector3(this.f_107209_, this.f_107210_, this.f_107211_);
        Vector3 curPos = new Vector3(this.f_107212_, this.f_107213_, this.f_107214_);
        if (this.f_107224_ > 5) {
            this.data.tick(prevPos, curPos);
        }
    }

    private void moveFollowEntity() {
        if (this.f_107225_ == -1) {
            if (this.followEntity == null || !this.followEntity.m_6084_()) {
                this.m_107274_();
            } else {
                this.f_107220_ = false;
            }
        } else {
            ++this.f_107224_;
            if (this.f_107224_ > this.f_107225_) {
                this.m_107274_();
            }
        }
        if (!this.f_107220_) {
            this.f_107209_ = this.followEntity.f_19854_;
            this.f_107210_ = this.followEntity.f_19855_;
            this.f_107211_ = this.followEntity.f_19856_;
            this.m_107264_(this.followEntity.m_20185_(), this.followEntity.m_20186_(), this.followEntity.m_20189_());
        }
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vector3 particleOrigin;
        Vec3 vec3d = renderInfo.m_90583_();
        double lerpX = Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_);
        double lerpY = Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_);
        double lerpZ = Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_);
        float f = (float)(lerpX - vec3d.m_7096_());
        float f1 = (float)(lerpY - vec3d.m_7098_());
        float f2 = (float)(lerpZ - vec3d.m_7094_());
        Vector3 renderViewOffset = new Vector3(f, f1, f2);
        Vector3 vector3 = particleOrigin = this.origin != null ? this.origin : new Vector3(this.f_107212_, this.f_107213_, this.f_107214_);
        if (this.origin != null) {
            Vector3 originDelta = new Vector3(lerpX, lerpY, lerpZ).sub(particleOrigin);
            particleOrigin = particleOrigin.add(originDelta);
        }
        int count = 0;
        Vector3 lastEnd1 = null;
        Vector3 lastEnd2 = null;
        for (Segment s : this.data.getSegments()) {
            float width = this.f_107663_;
            Vector3 start = s.getStart().sub(particleOrigin);
            Vector3 end = s.getEnd().sub(particleOrigin);
            Vector3 dir = end.sub(start).normalize().scale(5.0E-4f);
            Vector3[] avector3f = new Vector3[]{lastEnd1 == null ? start.add(new Vector3(-width, 0.0, -width)) : lastEnd1.sub(dir), lastEnd2 == null ? start.add(new Vector3(-width, 0.0, width)) : lastEnd2.sub(dir), end.add(new Vector3(width, 0.0, width)), end.add(new Vector3(width, 0.0, -width))};
            lastEnd1 = avector3f[2];
            lastEnd2 = avector3f[3];
            for (int i = 0; i < 4; ++i) {
                avector3f[i] = avector3f[i].add(renderViewOffset);
            }
            float startAlpha = this.f_107230_;
            if (count > this.data.getSegments().size() - 10) {
                startAlpha = 0.1f * (float)(this.data.getSegments().size() - count);
            }
            float minU = this.m_5970_();
            float maxU = this.m_5952_();
            float minV = this.m_5951_();
            float maxV = this.m_5950_();
            int j = 0xF000F0;
            buffer.m_5483_((double)avector3f[3].x, (double)avector3f[3].y, (double)avector3f[3].z).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[2].x, (double)avector3f[2].y, (double)avector3f[2].z).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[0].x, (double)avector3f[0].y, (double)avector3f[0].z).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[1].x, (double)avector3f[1].y, (double)avector3f[1].z).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, startAlpha).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[1].x, (double)avector3f[1].y, (double)avector3f[1].z).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[0].x, (double)avector3f[0].y, (double)avector3f[0].z).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[2].x, (double)avector3f[2].y, (double)avector3f[2].z).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[3].x, (double)avector3f[3].y, (double)avector3f[3].z).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, startAlpha).m_85969_(j).m_5752_();
            ++count;
        }
    }

    @Override
    public ParticleRenderType m_7556_() {
        return ParticleRenderTypes.ADDITIVE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXTrailBezierFactory
    extends MAParticleBase.FXParticleFactoryBase {
        public FXTrailBezierFactory(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXTrail particle = new FXTrail(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.setMoveBezier(x, y, z, xSpeed, ySpeed, zSpeed);
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXTrailSphereOrbitFactory
    extends MAParticleBase.FXParticleFactoryBase {
        public FXTrailSphereOrbitFactory(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXTrail particle = new FXTrail(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.setMoveSphereOrbit(x, y, z, xSpeed, ySpeed, zSpeed);
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXTrailOrbitFactory
    extends MAParticleBase.FXParticleFactoryBase {
        public FXTrailOrbitFactory(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXTrail particle = new FXTrail(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.setMoveOrbit(x, y, z, xSpeed, ySpeed, zSpeed);
            particle.f_107225_ = 50;
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXTrailVelocityFactory
    extends MAParticleBase.FXParticleFactoryBase {
        public FXTrailVelocityFactory(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXTrail particle = new FXTrail(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.setMoveVelocity(xSpeed, ySpeed, zSpeed, false);
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXTrailFollowEntityFactory
    extends MAParticleBase.FXParticleFactoryBase {
        public FXTrailFollowEntityFactory(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXTrail particle = new FXTrail(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.setMoveFollowEntity((Level)worldIn, (int)xSpeed, (long)ySpeed, (int)zSpeed);
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }
}

