/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.network.messages.BaseServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class SendCodexEntryReadMessage
extends BaseServerMessage {
    long hash;

    public SendCodexEntryReadMessage(long hash) {
        this.hash = hash;
        this.messageIsValid = true;
    }

    public SendCodexEntryReadMessage() {
        this.messageIsValid = false;
    }

    public static SendCodexEntryReadMessage decode(FriendlyByteBuf buf) {
        SendCodexEntryReadMessage msg = new SendCodexEntryReadMessage();
        try {
            msg.hash = buf.readLong();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading SendCodexEntryReadMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SendCodexEntryReadMessage msg, FriendlyByteBuf buf) {
        buf.writeLong(msg.hash);
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> p.setCodexEntryRead(this.hash));
    }
}

