/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.network.ServerMessageDispatcher;
import com.mna.network.messages.BaseServerMessage;
import com.mna.tools.loot.LootDrop;
import com.mna.tools.loot.LootTableCache;
import com.mna.tools.loot.LootTableHelper;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class RequestLootTableItems
extends BaseServerMessage {
    ResourceLocation lootTableID;

    public RequestLootTableItems(ResourceLocation lootTableID) {
        this.lootTableID = lootTableID;
        this.messageIsValid = true;
    }

    public RequestLootTableItems() {
        this.messageIsValid = false;
    }

    public ResourceLocation getLootTableID() {
        return this.lootTableID;
    }

    public static RequestLootTableItems decode(FriendlyByteBuf buf) {
        RequestLootTableItems msg = new RequestLootTableItems();
        try {
            msg.lootTableID = buf.m_130281_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading RequestLootTableItems: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(RequestLootTableItems msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.getLootTableID());
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        List<LootDrop> lootItems = LootTableCache.getLoot(this.getLootTableID());
        if (lootItems == null) {
            lootItems = LootTableHelper.toDrops(player.m_284548_(), this.getLootTableID());
        }
        if (lootItems != null) {
            ServerMessageDispatcher.sendRespondLootTableItems(player, this.getLootTableID(), lootItems);
        }
    }
}

