/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.entities.constructs.animated.Construct;
import com.mna.network.messages.BaseServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AnimatedConstructDropItemMessage
extends BaseServerMessage {
    private int entityID;
    private int slot;

    private AnimatedConstructDropItemMessage() {
        this.messageIsValid = false;
    }

    public AnimatedConstructDropItemMessage(int entityID, int slot) {
        this();
        this.entityID = entityID;
        this.slot = slot;
        this.messageIsValid = true;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public int getSlot() {
        return this.slot;
    }

    public static AnimatedConstructDropItemMessage decode(FriendlyByteBuf buf) {
        AnimatedConstructDropItemMessage msg = new AnimatedConstructDropItemMessage();
        try {
            msg.entityID = buf.readInt();
            msg.slot = buf.readInt();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading AnimatedConstructDropItemMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(AnimatedConstructDropItemMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.getEntityID());
        buf.writeInt(msg.slot);
    }

    public static AnimatedConstructDropItemMessage fromConstruct(Construct construct, int slot) {
        AnimatedConstructDropItemMessage msg = new AnimatedConstructDropItemMessage(construct.m_19879_(), slot);
        return msg;
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        Construct eac = (Construct)player.m_9236_().m_6815_(this.getEntityID());
        if (eac != null && eac.playerCanCommand((Player)player)) {
            ItemStack stack = ItemStack.f_41583_;
            switch (this.getSlot()) {
                case 0: {
                    stack = eac.m_21205_();
                    break;
                }
                case 1: {
                    stack = eac.m_21206_();
                    break;
                }
                case 2: {
                    stack = eac.getConstructData().getHat();
                    break;
                }
                case 3: {
                    stack = eac.getConstructData().getBanner();
                    break;
                }
                default: {
                    stack = eac.getStackInSlot(this.getSlot() - 4);
                }
            }
            if (!stack.m_41619_()) {
                switch (this.getSlot()) {
                    case 0: {
                        eac.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                        break;
                    }
                    case 1: {
                        eac.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                        break;
                    }
                    case 2: {
                        eac.setHat(ItemStack.f_41583_);
                        return;
                    }
                    case 3: {
                        eac.setBanner(ItemStack.f_41583_);
                        return;
                    }
                    default: {
                        eac.setStackInSlot(this.getSlot() - 4, ItemStack.f_41583_);
                    }
                }
                ItemEntity ie = new ItemEntity(eac.m_9236_(), eac.m_20185_(), eac.m_20186_(), eac.m_20189_(), stack);
                ie.m_32060_();
                eac.m_9236_().m_7967_((Entity)ie);
            }
        }
    }
}

