/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.network.messages.BaseClientMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class WellspringSyncMessage
extends BaseClientMessage {
    CompoundTag wellspringData;

    public WellspringSyncMessage(CompoundTag nbt) {
        this.wellspringData = nbt;
        this.messageIsValid = true;
    }

    private WellspringSyncMessage() {
        this.messageIsValid = false;
    }

    public static WellspringSyncMessage decode(FriendlyByteBuf buf) {
        WellspringSyncMessage msg = new WellspringSyncMessage();
        try {
            msg.wellspringData = buf.m_130260_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading WellspringSyncMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(WellspringSyncMessage msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.wellspringData);
    }

    @Override
    public void Handle(Level world, Player player) {
        world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().readFromNBT(this.wellspringData));
    }
}

