/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.network.messages.BaseClientMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class WellspringPowerNetworkSyncMessage
extends BaseClientMessage {
    CompoundTag wellspringData;

    public WellspringPowerNetworkSyncMessage(CompoundTag nbt) {
        this.wellspringData = nbt;
        this.messageIsValid = true;
    }

    private WellspringPowerNetworkSyncMessage() {
        this.messageIsValid = false;
    }

    public static WellspringPowerNetworkSyncMessage decode(FriendlyByteBuf buf) {
        WellspringPowerNetworkSyncMessage msg = new WellspringPowerNetworkSyncMessage();
        try {
            msg.wellspringData = buf.m_130260_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading WellspringPowerNetworkSyncMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(WellspringPowerNetworkSyncMessage msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.wellspringData);
    }

    public static WellspringPowerNetworkSyncMessage from(ServerLevel world, ServerPlayer player, boolean fullSync) {
        CompoundTag nbt = new CompoundTag();
        world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().serializeNetworkStrength((Player)player, nbt, fullSync));
        return new WellspringPowerNetworkSyncMessage(nbt);
    }

    @Override
    public void Handle(Level world, Player player) {
        world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().deserializeNetworkStrength(ManaAndArtifice.instance.proxy.getClientPlayer(), this.wellspringData));
    }
}

