/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.gui.containers.entity.ContainerWanderingWizard;
import com.mna.network.messages.BaseClientMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;

public class WanderingWizardInventoryMessage
extends BaseClientMessage {
    private int containerId;
    private MerchantOffers offers;
    private int level;
    private int xp;
    private boolean hasXPBar;
    private boolean canRestock;
    private boolean isFinalized;

    public WanderingWizardInventoryMessage() {
        this.messageIsValid = false;
    }

    public WanderingWizardInventoryMessage(int id, MerchantOffers offersIn, int levelIn, int xpIn, boolean hasXPBar, boolean canRestock, boolean isFinal) {
        this.containerId = id;
        this.offers = offersIn;
        this.level = levelIn;
        this.xp = xpIn;
        this.hasXPBar = hasXPBar;
        this.canRestock = canRestock;
        this.isFinalized = isFinal;
        this.messageIsValid = true;
    }

    public static WanderingWizardInventoryMessage decode(FriendlyByteBuf buf) {
        WanderingWizardInventoryMessage msg = new WanderingWizardInventoryMessage();
        try {
            msg.containerId = buf.m_130242_();
            msg.offers = MerchantOffers.m_45395_((FriendlyByteBuf)buf);
            msg.level = buf.m_130242_();
            msg.xp = buf.m_130242_();
            msg.hasXPBar = buf.readBoolean();
            msg.canRestock = buf.readBoolean();
            msg.isFinalized = buf.readBoolean();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading WanderingWizardInventoryMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(WanderingWizardInventoryMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.containerId);
        message.offers.m_45393_(buf);
        buf.m_130130_(message.level);
        buf.m_130130_(message.xp);
        buf.writeBoolean(message.hasXPBar);
        buf.writeBoolean(message.canRestock);
        buf.writeBoolean(message.isFinalized);
    }

    @Override
    public void Handle(Level world, Player player) {
        AbstractContainerMenu container = player.f_36096_;
        if (this.containerId == container.f_38840_ && container instanceof ContainerWanderingWizard) {
            ContainerWanderingWizard wwContainer = (ContainerWanderingWizard)container;
            wwContainer.setClientSideOffers(new MerchantOffers(this.offers.m_45388_()));
            wwContainer.setXp(this.xp);
            wwContainer.setFinalized(this.isFinalized);
        }
    }
}

