/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.effects.harmful.EffectIcarianFlight;
import com.mna.network.messages.BaseClientMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SetIcarianDataMessage
extends BaseClientMessage {
    private int entityID;
    private Vec3 vel;

    public SetIcarianDataMessage(int entityID, Vec3 vel) {
        this.entityID = entityID;
        this.vel = vel;
        this.messageIsValid = true;
    }

    public SetIcarianDataMessage() {
        this.messageIsValid = false;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public static SetIcarianDataMessage decode(FriendlyByteBuf buf) {
        SetIcarianDataMessage msg = new SetIcarianDataMessage();
        try {
            msg.entityID = buf.readInt();
            msg.vel = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading CloudstepJumpMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SetIcarianDataMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.getEntityID());
        buf.writeDouble(msg.vel.f_82479_);
        buf.writeDouble(msg.vel.f_82480_);
        buf.writeDouble(msg.vel.f_82481_);
    }

    @Override
    public void Handle(Level world, Player player) {
        Entity entity = world.m_6815_(this.entityID);
        if (entity != null && entity instanceof LivingEntity) {
            if (this.vel.f_82479_ == 0.0 && this.vel.f_82480_ == 0.0 && this.vel.f_82481_ == 0.0) {
                EffectIcarianFlight.clearIcarianData((LivingEntity)entity);
            } else {
                EffectIcarianFlight.writeIcarianData((LivingEntity)entity, this.vel);
            }
        }
    }
}

