/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.network.messages.BaseClientMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MindVisionMessage
extends BaseClientMessage {
    int entityID;

    public MindVisionMessage(int entityID) {
        this.entityID = entityID;
        this.messageIsValid = true;
    }

    public MindVisionMessage() {
        this.messageIsValid = false;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public static MindVisionMessage decode(FriendlyByteBuf buf) {
        MindVisionMessage msg = new MindVisionMessage();
        try {
            msg.entityID = buf.readInt();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading getEntityID: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(MindVisionMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.getEntityID());
    }

    @Override
    public void Handle(Level world, Player player) {
        if (this.getEntityID() == -1) {
            ManaAndArtifice.instance.proxy.resetRenderViewEntity();
        } else {
            Entity e = world.m_6815_(this.getEntityID());
            if (e != null) {
                ManaAndArtifice.instance.proxy.setRenderViewEntity(e);
            }
        }
    }
}

