/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.handlers;

import com.mna.ManaAndArtifice;
import com.mna.network.messages.BaseServerMessage;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ServerMessageHandler {
    public static void HandleServerMessage(BaseServerMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " received on wrong side: " + sideReceived);
            return;
        }
        if (!message.isMessageValid()) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " was invalid: " + message);
            return;
        }
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when LodestarLogicSetMessage was received");
            return;
        }
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ctx.enqueueWork(() -> message.Handle(serverLevel, player));
        } else {
            ManaAndArtifice.LOGGER.error("Player was a ServerPlayer but their level was not a ServerLevel.  M&A packet unable to handle.  Skipping.");
        }
    }
}

