/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.renderers;

import com.mna.items.ItemInit;
import com.mna.items.SpellIconList;
import com.mna.items.sorcery.ItemSpell;
import com.mna.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ItemSpellRenderer
extends BlockEntityWithoutLevelRenderer {
    private static HashMap<Integer, BakedModel> bakedSpellModels;
    private BakedModel defaultSpellModel;
    private BakedModel defaultBangleModel;
    public static final ResourceLocation location_spell;
    public static final ResourceLocation location_bangle;

    public ItemSpellRenderer(BlockEntityRenderDispatcher berd, EntityModelSet ems) {
        super(berd, ems);
        if (bakedSpellModels == null) {
            bakedSpellModels = new HashMap();
        }
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (itemDisplayContext != ItemDisplayContext.THIRD_PERSON_LEFT_HAND && itemDisplayContext != ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                this.renderArm(matrixStack, buffer, combinedLight, HumanoidArm.RIGHT);
                WorldRenderUtils.spawnFirstPersonParticlesForStack(stack, HumanoidArm.RIGHT);
            } else if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                this.renderArm(matrixStack, buffer, combinedLight, HumanoidArm.LEFT);
                WorldRenderUtils.spawnFirstPersonParticlesForStack(stack, HumanoidArm.LEFT);
            } else {
                this.renderDefaultSpellItem(stack, itemDisplayContext, matrixStack, buffer, combinedLight, combinedOverlay);
            }
        }
    }

    private void renderDefaultSpellItem(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!stack.m_41619_()) {
            BakedModel spellModel = itemDisplayContext == ItemDisplayContext.GUI ? this.getSpellModel(stack) : this.getDefaultSpellModel(stack.m_41720_() == ItemInit.BANGLE.get());
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            if (itemDisplayContext != ItemDisplayContext.GUI) {
                Minecraft.m_91087_().m_91291_().m_115143_(stack, itemDisplayContext, itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND, matrixStack, buffer, combinedLight, combinedOverlay, spellModel);
            } else {
                boolean flag;
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
                boolean bl = flag = !spellModel.m_7547_();
                if (flag) {
                    Lighting.m_84930_();
                }
                Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, spellModel);
                bufferSource.m_109911_();
                RenderSystem.enableDepthTest();
                if (flag) {
                    Lighting.m_84931_();
                }
            }
        }
    }

    private BakedModel getSpellModel(ItemStack stack) {
        BakedModel customModel;
        if (stack.m_41720_() == ItemInit.BANGLE.get()) {
            return this.getDefaultSpellModel(true);
        }
        int customIconIndex = ItemSpell.getCustomIcon(stack);
        if (customIconIndex < 0 || customIconIndex >= SpellIconList.ALL.length) {
            return this.getDefaultSpellModel(false);
        }
        if (!bakedSpellModels.containsKey(customIconIndex)) {
            bakedSpellModels.put(customIconIndex, Minecraft.m_91087_().m_91304_().getModel(SpellIconList.ALL[customIconIndex]));
        }
        return (customModel = bakedSpellModels.get(customIconIndex)) != null ? customModel : this.getDefaultSpellModel(false);
    }

    private BakedModel getDefaultSpellModel(boolean bangle) {
        if (this.defaultSpellModel == null) {
            this.defaultSpellModel = Minecraft.m_91087_().m_91304_().getModel(location_spell);
            this.defaultBangleModel = Minecraft.m_91087_().m_91304_().getModel(location_bangle);
        }
        return bangle ? this.defaultBangleModel : this.defaultSpellModel;
    }

    private void renderArm(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, HumanoidArm side) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderer entityRenderer = mc.m_91290_().m_114382_((Entity)mc.f_91074_);
        if (entityRenderer instanceof PlayerRenderer) {
            PlayerRenderer playerRenderer = (PlayerRenderer)entityRenderer;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)mc.f_91074_.m_108560_());
            matrixStackIn.m_85836_();
            if (side == HumanoidArm.RIGHT) {
                matrixStackIn.m_85837_(0.75, -0.25, 0.0);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(95.0f));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-30.0f));
                playerRenderer.m_117770_(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayer)mc.f_91074_);
            } else {
                matrixStackIn.m_85837_(0.25, -0.25, 0.0);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(260.0f));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(30.0f));
                playerRenderer.m_117813_(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayer)mc.f_91074_);
            }
            matrixStackIn.m_85849_();
        }
    }

    static {
        location_spell = new ResourceLocation("mna", "item/spell_texture");
        location_bangle = new ResourceLocation("mna", "item/bangle_texture");
    }
}

