/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.manaweaving;

import com.mna.api.items.TieredItem;
import com.mna.api.recipes.IManaweavePattern;
import com.mna.entities.manaweaving.ThrownManaweaveBottle;
import com.mna.items.renderers.ManaweaveBottleRenderer;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.recipes.manaweaving.ManaweavingPatternSerializer;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;

public class ItemManaweaveBottle
extends TieredItem {
    private static final String KEY_PATTERN_ID = "pattern";

    public ItemManaweaveBottle() {
        super(new Item.Properties());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new ManaweaveBottleRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public static boolean hasPattern(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(KEY_PATTERN_ID);
    }

    @Nullable
    public static ManaweavingPattern getPattern(ItemStack stack) {
        if (!ItemManaweaveBottle.hasPattern(stack)) {
            return null;
        }
        String patternID = stack.m_41783_().m_128461_(KEY_PATTERN_ID);
        Optional<ManaweavingPattern> pattern = ManaweavingPatternSerializer.ALL_RECIPES.values().stream().filter(p -> p.m_6423_().toString().equals(patternID)).findFirst();
        return pattern.orElse(null);
    }

    public static void setPattern(IManaweavePattern pattern, ItemStack stack) {
        stack.m_41784_().m_128359_(KEY_PATTERN_ID, pattern.getRegistryId().toString());
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent baseline = Component.m_237115_((String)this.m_5671_(stack));
        if (ItemManaweaveBottle.hasPattern(stack)) {
            String patternName = Component.m_237115_((String)stack.m_41783_().m_128461_(KEY_PATTERN_ID)).getString();
            baseline.m_7220_((Component)Component.m_237110_((String)"item.mna.manaweave_bottle.suffix", (Object[])new Object[]{patternName}));
        }
        return baseline;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_) {
            ThrownManaweaveBottle potionentity = new ThrownManaweaveBottle(worldIn, (LivingEntity)playerIn);
            potionentity.m_37446_(itemstack);
            potionentity.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), -20.0f, 0.5f, 1.0f);
            worldIn.m_7967_((Entity)potionentity);
        }
        if (!playerIn.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)worldIn.m_5776_());
    }

    public static void setRandomPattern(ItemStack is) {
        List patterns = ManaweavingPatternSerializer.ALL_RECIPES.values().stream().collect(Collectors.toList());
        if (patterns.size() == 0) {
            return;
        }
        ItemManaweaveBottle.setPattern((IManaweavePattern)patterns.get((int)((double)patterns.size() * Math.random())), is);
    }
}

