/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifice;

import com.mna.ManaAndArtifice;
import com.mna.rituals.effects.WorldUtils;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Logger;

public class ThaumaturgicCompass
extends CompassItem {
    public static final String trackingKey = "tracking_key";
    public static final String trackingType = "tracking_type";
    public static final String trackingId = "tracking_id";
    public static final String trackingMode = "tracking_mode";

    private static Optional<ResourceKey<Level>> m_40727_(CompoundTag pCompoundTag) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)pCompoundTag.m_128423_("LodestoneDimension")).result();
    }

    public ThaumaturgicCompass() {
        super(new Item.Properties());
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return InteractionResult.SUCCESS;
    }

    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    @Nullable
    public BlockPos getTrackedPosition(ItemStack stack, ResourceKey<Level> dimension) {
        if (!ThaumaturgicCompass.m_40736_((ItemStack)stack)) {
            return null;
        }
        Optional<ResourceKey<Level>> world = ThaumaturgicCompass.m_40727_(stack.m_41783_());
        if (!world.isPresent() || !world.get().equals(dimension)) {
            return null;
        }
        return NbtUtils.m_129239_((CompoundTag)stack.m_41783_().m_128469_("LodestonePos"));
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            if (tag.m_128441_(trackingKey)) {
                tooltip.add((Component)Component.m_237110_((String)"item.mna.thaumaturgic_compass.locating", (Object[])new Object[]{Component.m_237115_((String)tag.m_128461_(trackingKey))}));
            }
            if (ThaumaturgicCompass.getTrackMode(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.mode_new"));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.mode_existing"));
            }
            if (ThaumaturgicCompass.getTrackType(stack) == TrackType.Structure) {
                tooltip.add((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.mode_hint_structure"));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.mode_hint_biome"));
            }
        }
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public static String getLocalizedStructureName(@Nonnull String resource) {
        if (resource.equals("")) {
            return "";
        }
        int split = resource.indexOf(":");
        if (split == -1) {
            return resource;
        }
        String source = resource.substring(0, split);
        String name = resource.substring(split + 1);
        return I18n.m_118938_((String)String.format("structure.%s.%s", source, name), (Object[])new Object[0]);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            if (player.m_6047_()) {
                switch (ThaumaturgicCompass.getTrackType(stack)) {
                    case Biome: {
                        ThaumaturgicCompass.search_biome((ServerPlayer)player, stack);
                        break;
                    }
                    case Structure: {
                        ThaumaturgicCompass.search_structure((ServerPlayer)player, stack, ThaumaturgicCompass.getTrackMode(stack));
                        break;
                    }
                }
            } else if (ThaumaturgicCompass.getTrackType(stack) == TrackType.Structure) {
                boolean newmode = !ThaumaturgicCompass.getTrackMode(stack);
                stack.m_41783_().m_128379_(trackingMode, newmode);
                player.m_213846_((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.mode_changed"));
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
    }

    public static void setTrackedPosition(ItemStack stack, ResourceKey<Level> dimension, BlockPos position, ResourceLocation trackedID, TrackType trackType) {
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128379_(trackingMode, false);
        stackTag.m_128405_(trackingType, trackType.ordinal());
        stackTag.m_128359_(trackingKey, trackedID.toString());
        stackTag.m_128365_("LodestonePos", (Tag)NbtUtils.m_129224_((BlockPos)position));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, dimension).resultOrPartial(arg_0 -> ((Logger)ManaAndArtifice.LOGGER).error(arg_0)).ifPresent(inbt -> stackTag.m_128365_("LodestoneDimension", inbt));
        stackTag.m_128379_("LodestoneTracked", true);
    }

    @Nullable
    public static ResourceLocation getTrackedID(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(trackingKey)) {
            return new ResourceLocation(stack.m_41783_().m_128461_(trackingKey));
        }
        return null;
    }

    public static TrackType getTrackType(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(trackingType)) {
            return TrackType.values()[stack.m_41783_().m_128451_(trackingType) % TrackType.values().length];
        }
        return TrackType.Unset;
    }

    public static boolean getTrackMode(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(trackingMode)) {
            return stack.m_41783_().m_128471_(trackingMode);
        }
        return false;
    }

    public static void search_structure(ServerPlayer player, ItemStack stack, boolean skipGeneratedChunks) {
        if (ThaumaturgicCompass.getTrackType(stack) != TrackType.Structure) {
            return;
        }
        ResourceLocation structureRegistryName = ThaumaturgicCompass.getTrackedID(stack);
        ServerLevel world = (ServerLevel)player.m_9236_();
        player.m_213846_((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.searching"));
        try {
            BlockPos blockpos = BlockPos.m_274446_((Position)player.m_20182_());
            BlockPos locatedPos = WorldUtils.locateStructure(world, blockpos, structureRegistryName, skipGeneratedChunks);
            if (locatedPos == null) {
                player.m_213846_((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.search_fail"));
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.search_success"));
                ThaumaturgicCompass.setTrackedPosition(stack, (ResourceKey<Level>)world.m_46472_(), locatedPos, structureRegistryName, TrackType.Structure);
            }
        }
        catch (Throwable t) {
            player.m_213846_((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.search_fail"));
        }
    }

    public static void search_biome(ServerPlayer player, ItemStack stack) {
        if (ThaumaturgicCompass.getTrackType(stack) != TrackType.Biome) {
            return;
        }
        ResourceLocation biomeLoc = ThaumaturgicCompass.getTrackedID(stack);
        ServerLevel world = (ServerLevel)player.m_9236_();
        player.m_213846_((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.searching"));
        BlockPos locatedPos = WorldUtils.locateBiome(world, player.m_20183_(), biomeLoc);
        if (locatedPos == null) {
            player.m_213846_((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.search_fail"));
            return;
        }
        player.m_213846_((Component)Component.m_237115_((String)"item.mna.thaumaturgic_compass.search_success"));
        ThaumaturgicCompass.setTrackedPosition(stack, (ResourceKey<Level>)world.m_46472_(), locatedPos, biomeLoc, TrackType.Structure);
    }

    public static enum TrackType {
        Unset,
        Structure,
        Biome;

    }
}

