/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifice;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mna.api.faction.IFaction;
import com.mna.api.items.IFactionSpecific;
import com.mna.api.sound.SFX;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.enchantments.framework.EnchantmentInit;
import com.mna.factions.Factions;
import com.mna.items.ItemInit;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class HellfireTrident
extends Item
implements IFactionSpecific {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 10.0f;
    public static final float SHOOT_POWER = 2.5f;
    private final int enchantability = 25;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private final ArrayList<Enchantment> allowedEnchantments = new ArrayList();

    public HellfireTrident() {
        super(new Item.Properties().m_41486_().m_41487_(1).m_41497_(Rarity.EPIC).m_41503_(500));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 10.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-1.9f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    protected ArrayList<Enchantment> getAllowedEnchantments() {
        this.allowedEnchantments.clear();
        if (this.allowedEnchantments.size() == 0) {
            this.allowedEnchantments.add(Enchantments.f_44977_);
            this.allowedEnchantments.add(Enchantments.f_44980_);
            this.allowedEnchantments.add(Enchantments.f_44982_);
            this.allowedEnchantments.add(Enchantments.f_44978_);
            this.allowedEnchantments.add(Enchantments.f_44956_);
            this.allowedEnchantments.add(Enchantments.f_44981_);
            this.allowedEnchantments.add(Enchantments.f_44962_);
            this.allowedEnchantments.add(Enchantments.f_44986_);
            this.allowedEnchantments.add((Enchantment)EnchantmentInit.MANA_REPAIR.get());
            this.allowedEnchantments.add((Enchantment)EnchantmentInit.BEHEADING.get());
        }
        return this.allowedEnchantments;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 25;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)book);
        for (Enchantment ench : enchantments.keySet()) {
            if (this.getAllowedEnchantments().contains(ench)) continue;
            return false;
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.getAllowedEnchantments().contains(enchantment);
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return !pPlayer.m_7500_();
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
                int manaCost;
                int n = manaCost = player.m_20096_() ? 100 : 200;
                if (magic.getCastingResource().hasEnough((LivingEntity)player, manaCost)) {
                    int j = 3;
                    magic.getCastingResource().consume((LivingEntity)player, manaCost);
                    this.usedByPlayer(player);
                    float f7 = player.m_146908_();
                    float f = player.m_146909_();
                    float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
                    player.m_5997_((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    pLevel.m_6269_((Player)null, (Entity)player, SFX.Spell.Impact.Single.FIRE, SoundSource.PLAYERS, 1.0f, 1.0f);
                    pLevel.m_6269_((Player)null, (Entity)player, SoundEvents.f_12519_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_36335_().m_41524_((Item)this, 20);
                    player.getPersistentData().m_128379_("hellfiretrident", true);
                }
            });
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    @Override
    public IFaction getFaction() {
        return Factions.DEMONS;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, p_43414_ -> p_43414_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if ((double)pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0) {
            pStack.m_41622_(2, pEntityLiving, p_43385_ -> p_43385_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_6832_(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.m_41720_() == ItemInit.LIVING_FLAME.get();
    }
}

