/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifice;

import com.mna.api.items.IShowHud;
import com.mna.api.items.TieredItem;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.items.ItemInit;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class CrystalOfMemories
extends TieredItem
implements IShowHud {
    private static final String KEY_MODE = "memory_crystal_fragment_mode";
    private static final int MODE_INFUSE = 0;
    private static final int MODE_SUPPLEMENT = 1;
    private static final String KEY_STORED_XP = "stored_xp";
    private static final int MAX_XP = 20000;

    public CrystalOfMemories() {
        super(new Item.Properties().m_41503_(100).setNoRepair());
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 100;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    private int getContainedXP(ItemStack stack) {
        if (!stack.m_41782_() || stack.m_41720_() != ItemInit.CRYSTAL_OF_MEMORIES.get()) {
            return 0;
        }
        return stack.m_41783_().m_128451_(KEY_STORED_XP);
    }

    private void storeContainedXP(ItemStack stack, int amount) {
        if (stack.m_41720_() != ItemInit.CRYSTAL_OF_MEMORIES.get()) {
            return;
        }
        stack.m_41784_().m_128405_(KEY_STORED_XP, amount);
    }

    public void m_5929_(Level pLevel, LivingEntity living, ItemStack stack, int count) {
        if (living instanceof Player) {
            Player p = (Player)living;
            int contained_xp = this.getContainedXP(stack);
            if (!living.m_9236_().m_5776_()) {
                switch (this.getMode(stack)) {
                    case 1: {
                        if (contained_xp == 0) {
                            return;
                        }
                        int xp_to_give = Math.max(p.f_36078_, 1);
                        if (contained_xp < xp_to_give) {
                            xp_to_give = contained_xp;
                        }
                        p.m_6756_(xp_to_give);
                        this.storeContainedXP(stack, contained_xp - xp_to_give);
                        break;
                    }
                    default: {
                        int xp_to_store;
                        if (contained_xp == 20000 || p.f_36079_ == 0) {
                            return;
                        }
                        int n = xp_to_store = p.f_36078_ == 0 ? 1 : p.f_36078_;
                        if (contained_xp + xp_to_store > 20000) {
                            xp_to_store = 20000 - contained_xp;
                        }
                        p.m_6756_(-xp_to_store);
                        this.storeContainedXP(stack, Math.min(contained_xp + xp_to_store, 20000));
                    }
                }
            }
        }
        if (living.m_9236_().m_5776_()) {
            for (int i = 0; i < 5; ++i) {
                living.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), living.m_20185_() - 0.5 + Math.random(), living.m_20186_() + Math.random(), living.m_20189_() - 0.5 + Math.random(), 0.0, (double)0.1f, 0.0);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            if (!worldIn.f_46443_) {
                if (this.getMode(stack) == 0) {
                    this.setMode(stack, 1);
                } else {
                    this.setMode(stack, 0);
                }
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public int getMode(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(KEY_MODE)) {
            return 0;
        }
        return stack.m_41783_().m_128451_(KEY_MODE);
    }

    private void setMode(ItemStack stack, int mode) {
        stack.m_41784_().m_128405_(KEY_MODE, mode);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        int contained_xp = this.getContainedXP(stack);
        tooltip.add((Component)Component.m_237110_((String)"item.mna.crystal_of_memories.contains", (Object[])new Object[]{contained_xp, 20000}).m_130940_(ChatFormatting.ITALIC));
        switch (this.getMode(stack)) {
            case 1: {
                tooltip.add((Component)Component.m_237115_((String)"item.mna.crystal_of_memories.supplement"));
                break;
            }
            default: {
                tooltip.add((Component)Component.m_237115_((String)"item.mna.crystal_of_memories.infusion"));
            }
        }
    }

    public int m_142159_(ItemStack stack) {
        return FastColor.ARGB32.m_13660_((int)255, (int)128, (int)64, (int)255);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        float xp = this.getContainedXP(stack);
        return (int)(13.0f * (xp / 20000.0f));
    }
}

