/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.armor;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.faction.IFaction;
import com.mna.api.items.IFactionSpecific;
import com.mna.api.items.ITieredItem;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.tools.RLoc;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.utility.MAExplosion;
import com.mna.factions.Factions;
import com.mna.items.ItemInit;
import com.mna.items.armor.IBrokenArmorReplaceable;
import com.mna.items.armor.ISetItem;
import com.mna.items.renderers.DemonArmorRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DemonArmorItem
extends ArmorItem
implements GeoItem,
ISetItem,
ITieredItem<DemonArmorItem>,
IFactionSpecific,
IBrokenArmorReplaceable<DemonArmorItem> {
    private AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final ResourceLocation demon_armor_set_bonus = RLoc.create("demon_armor_set_bonus");
    public static final String demon_armor_set_bonus_key = "demon_armor_set_bonus";
    public static final String demon_armor_meteor_jumping_key = "demon_armor_meteor_jumping";
    public static final String demon_armor_sprint_time_key = "demon_armor_sprint_time";
    public static final String demon_armor_run_speed_1 = "demon_armor_set_bonus_1";
    public static final String demon_armor_run_speed_2 = "demon_armor_set_bonus_2";
    public static final String demon_armor_run_speed_3 = "demon_armor_set_bonus_3";
    public static final AttributeModifier runSpeed_1 = new AttributeModifier("demon_armor_set_bonus_1", (double)0.05f, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier runSpeed_2 = new AttributeModifier("demon_armor_set_bonus_2", (double)0.1f, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier runSpeed_3 = new AttributeModifier("demon_armor_set_bonus_3", (double)0.1f, AttributeModifier.Operation.ADDITION);
    private static final float MANA_COST_PER_TICK = 0.25f;
    private static final float METEOR_JUMP_MANA_COST = 40.0f;
    private int _tier = -1;

    public DemonArmorItem(ArmorMaterial materialIn, ArmorItem.Type slot, Item.Properties builder) {
        super(materialIn, slot, builder.m_41497_(Rarity.EPIC));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new DemonArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> PlayState.STOP)});
    }

    @Override
    public ResourceLocation getSetIdentifier() {
        return demon_armor_set_bonus;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        this.usedByPlayer(player);
        if (stack.m_41768_() && player.m_6060_() && player.m_9236_().m_46467_() % 10L == 0L) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
        if (this.isSetEquipped((LivingEntity)player)) {
            MobEffectInstance eff;
            if (stack.m_41720_() != ItemInit.DEMON_ARMOR_CHEST.get()) {
                return;
            }
            IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            if (magic == null) {
                return;
            }
            boolean showParticles = false;
            boolean removeModifier = true;
            if (player.m_20142_() && magic.getCastingResource().hasEnoughAbsolute((LivingEntity)player, 0.25f)) {
                int sprint_time = player.getPersistentData().m_128451_(demon_armor_sprint_time_key);
                AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
                if (sprint_time == 0) {
                    if (!attr.m_22109_(runSpeed_1)) {
                        attr.m_22118_(runSpeed_1);
                        player.m_5496_(SFX.Event.Artifact.DEMON_ARMOR_SPRINT_START, 1.0f, 0.8f);
                    }
                } else if (sprint_time == 30) {
                    if (!attr.m_22109_(runSpeed_2)) {
                        attr.m_22118_(runSpeed_2);
                        player.m_5496_(SFX.Event.Artifact.DEMON_ARMOR_SPRINT_START, 1.0f, 1.0f);
                    }
                } else if (sprint_time == 60 && !attr.m_22109_(runSpeed_3)) {
                    attr.m_22118_(runSpeed_3);
                    player.m_5496_(SFX.Event.Artifact.DEMON_ARMOR_SPRINT_START, 1.0f, 1.2f);
                }
                player.getPersistentData().m_128405_(demon_armor_sprint_time_key, ++sprint_time);
                magic.getCastingResource().consume((LivingEntity)player, 0.25f);
                removeModifier = false;
                showParticles = true;
            }
            if (removeModifier) {
                player.m_21051_(Attributes.f_22279_).m_22130_(runSpeed_1);
                player.m_21051_(Attributes.f_22279_).m_22130_(runSpeed_2);
                player.m_21051_(Attributes.f_22279_).m_22130_(runSpeed_3);
                player.getPersistentData().m_128473_(demon_armor_sprint_time_key);
            }
            if (!player.m_20096_() && player.m_20184_().f_82480_ < 0.0 && player.m_6047_() && magic.getCastingResource().hasEnough((LivingEntity)player, 40.0f) && !player.getPersistentData().m_128441_(demon_armor_meteor_jumping_key)) {
                int heightAboveGround;
                int reqHeight = 5;
                BlockPos pos = player.m_20183_();
                for (heightAboveGround = 0; player.m_9236_().m_46859_(pos) && heightAboveGround < reqHeight; ++heightAboveGround) {
                    pos = pos.m_7495_();
                }
                if (heightAboveGround >= reqHeight) {
                    player.getPersistentData().m_128379_(demon_armor_meteor_jumping_key, true);
                    player.m_5496_(SFX.Event.Artifact.METEOR_JUMP, 0.25f, 0.8f);
                    magic.getCastingResource().consume((LivingEntity)player, 40.0f);
                    showParticles = true;
                }
            }
            if (player.getPersistentData().m_128441_(demon_armor_meteor_jumping_key)) {
                this.handlePlayerMeteorJump(player);
                showParticles = true;
            }
            if (player.m_6060_()) {
                MobEffectInstance strength;
                if (!(player.m_9236_().m_5776_() || (strength = player.m_21124_((MobEffect)EffectInit.BURNING_RAGE.get())) != null && strength.m_19557_() >= 105)) {
                    player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.BURNING_RAGE.get(), 600, 1, true, true));
                }
            } else if (!player.m_9236_().m_5776_() && (eff = player.m_21124_((MobEffect)EffectInit.BURNING_RAGE.get())) != null && eff.m_19571_()) {
                player.m_21195_((MobEffect)EffectInit.BURNING_RAGE.get());
            }
            if (world.f_46443_ && showParticles) {
                Vec3 motion = player.m_20184_();
                Vec3 look = player.m_20156_().m_82537_(new Vec3(0.0, 1.0, 0.0));
                float offset = (float)(Math.random() * 0.2);
                float yOffset = 0.2f;
                look = look.m_82490_((double)offset);
                for (int i = 0; i < 5; ++i) {
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), player.m_20185_() + look.f_82479_ + Math.random() * motion.f_82479_ * 2.0, player.m_20186_() + (double)yOffset + Math.random() * motion.f_82480_ * 2.0, player.m_20189_() + look.f_82481_ + Math.random() * motion.f_82481_ * 2.0, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), player.m_20185_() - look.f_82479_ + Math.random() * motion.f_82479_ * 2.0, player.m_20186_() + (double)yOffset + Math.random() * motion.f_82480_ * 2.0, player.m_20189_() - look.f_82481_ + Math.random() * motion.f_82481_ * 2.0, 0.0, 0.0, 0.0);
                }
            }
        } else {
            player.m_21051_(Attributes.f_22279_).m_22130_(runSpeed_1);
            player.m_21051_(Attributes.f_22279_).m_22130_(runSpeed_2);
            player.m_21051_(Attributes.f_22279_).m_22130_(runSpeed_3);
        }
    }

    public boolean handlePlayerJump(Player player) {
        if (this.isSetEquipped((LivingEntity)player) && player.m_20142_() && player.m_20096_()) {
            float multiplier = 3.0f;
            player.m_5997_((double)((float)(player.m_20184_().f_82479_ * (double)multiplier)), 0.75, (double)((float)(player.m_20184_().f_82481_ * (double)multiplier)));
            return true;
        }
        return false;
    }

    private void handlePlayerMeteorJump(Player player) {
        if (player.m_20096_()) {
            this.handlePlayerMeteorJumpImpact(player, 0.0f);
        }
        if (this.isSetEquipped((LivingEntity)player)) {
            player.m_5997_(0.0, -0.05, 0.0);
            if (player.m_9236_().m_5776_()) {
                for (int i = 0; i < 25; ++i) {
                    player.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), player.m_20185_() - 0.5 + Math.random() * 0.5, player.m_20186_() + Math.random(), player.m_20189_() - 0.5 + Math.random() * 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean handlePlayerMeteorJumpImpact(Player player, float fallDistance) {
        if (!this.isSetEquipped((LivingEntity)player)) {
            return false;
        }
        if (player.getPersistentData().m_128441_(demon_armor_meteor_jumping_key)) {
            player.getPersistentData().m_128473_(demon_armor_meteor_jumping_key);
            if (!player.m_9236_().m_5776_() && fallDistance > 5.0f) {
                MAExplosion.make((LivingEntity)player, (ServerLevel)player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), Math.min(5.0f, fallDistance / 6.0f), Math.min(20.0f, fallDistance / 1.5f), true, GeneralConfigValues.MeteorJumpEnabled && ((ServerLevel)player.m_9236_()).m_7654_().m_129900_().m_46207_(GameRules.f_46132_) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, player.m_269291_().m_269036_((Entity)player, null));
            }
        }
        return true;
    }

    @Override
    public void applySetBonus(LivingEntity living, EquipmentSlot ... setSlots) {
        if (living instanceof Player) {
            living.getPersistentData().m_128379_(demon_armor_set_bonus_key, true);
        }
    }

    @Override
    public void removeSetBonus(LivingEntity living, EquipmentSlot ... setSlots) {
        if (living instanceof Player) {
            living.getPersistentData().m_128379_(demon_armor_set_bonus_key, false);
        }
    }

    @Override
    public int itemsForSetBonus() {
        return 4;
    }

    @Override
    public int getCachedTier() {
        return this._tier;
    }

    @Override
    public void setCachedTier(int tier) {
        this._tier = tier;
    }

    @Override
    public IFaction getFaction() {
        return Factions.DEMONS;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ISetItem.super.addSetTooltip(tooltip);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return IBrokenArmorReplaceable.super.damageItem(stack, amount * 3, entity, onBroken);
    }
}

