/*
 * Decompiled with CFR 0.152.
 */
package com.mna.guide.recipe;

import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.GuiTextures;
import com.mna.recipes.runeforging.RuneforgingRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeRunesmith
extends RecipeRendererBase {
    private RuneforgingRecipe pattern;
    static final int POINT_RENDER_SIZE = 13;
    private ItemStack _metal;
    private ItemStack _pattern;
    private ItemStack _output;

    public RecipeRunesmith(int x, int y) {
        super(x, y);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.f_91073_.m_7465_().m_44043_(recipeLocation);
        if (pattern.isPresent() && pattern.get() instanceof RuneforgingRecipe) {
            this.pattern = (RuneforgingRecipe)pattern.get();
            this._metal = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(this.pattern.getMaterial()));
            this._pattern = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(this.pattern.getPatternResource()));
            this._output = this.pattern.getResultItem();
        } else {
            this.pattern = null;
        }
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.Recipe.RUNESMITHING;
    }

    @Override
    protected void drawForeground(GuiGraphics pGuiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.pattern == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GuiTextures.Widgets.GUIDE_WIDGETS);
        this.renderItemStack(pGuiGraphics, this._pattern, (int)((float)this.m_252754_() / this.scale + 51.0f), (int)((float)this.m_252907_() / this.scale + 108.0f), 1.0f);
        this.renderItemStack(pGuiGraphics, this._metal, (int)((float)this.m_252754_() / this.scale + 51.0f), (int)((float)this.m_252907_() / this.scale + 64.0f), 1.0f);
        this.renderItemStack(pGuiGraphics, this._output, (int)((float)this.m_252754_() / this.scale) + 180, (int)((float)this.m_252907_() / this.scale + 90.0f), 1.0f);
        String hits = String.format("x %d", this.pattern.getHits());
        pGuiGraphics.m_280056_(this.minecraft.f_91062_, hits, x + 123 - this.minecraft.f_91062_.m_92895_(hits) / 2, y + 100, -12105913, false);
        if (this._output.m_41613_() > 1) {
            String count = String.format("x %d", this._output.m_41613_());
            pGuiGraphics.m_280056_(this.minecraft.f_91062_, count, x + 186 - this.minecraft.f_91062_.m_92895_(count) / 2, y + 110, -12105913, false);
        }
        this.renderByproducts(pGuiGraphics, this.m_5711_() - 55, this.m_93694_() / 2 - 5, this.pattern);
        int tier = this.pattern.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)128, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
        MutableComponent name = Component.m_237115_((String)this.pattern.getResultItem().m_41778_().toString());
        MutableComponent tierPrompt = Component.m_237110_((String)"gui.mna.item-tier", (Object[])new Object[]{tier});
        int stringWidth = this.minecraft.f_91062_.m_92852_((FormattedText)name);
        int textX = x + this.f_93618_ / 2 - stringWidth / 2;
        int textY = y + 5;
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)name, textX, textY, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), false);
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)tierPrompt, x + this.f_93618_ / 2 - this.minecraft.f_91062_.m_92852_((FormattedText)tierPrompt) / 2, y + 15, color, false);
        if (this.pattern.getFactionRequirement() != null) {
            int xPadding = 3;
            this.renderFactionIcon(pGuiGraphics, this.pattern.getFactionRequirement(), textX + stringWidth + xPadding, textY);
        }
    }

    @Override
    public int getTier() {
        return this.pattern != null ? this.pattern.getTier() : 1;
    }
}

