/*
 * Decompiled with CFR 0.152.
 */
package com.mna.guide.recipe;

import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.GuiTextures;
import com.mna.recipes.runeforging.RunescribingRecipe;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeRunescribing
extends RecipeRendererBase {
    private RunescribingRecipe pattern;
    static final int POINT_RENDER_SIZE = 13;
    private boolean disableLabels = false;
    private boolean disableOutputRender = false;

    public RecipeRunescribing(int x, int y) {
        super(x, y);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.f_91073_.m_7465_().m_44043_(recipeLocation);
        this.pattern = pattern.isPresent() && pattern.get() instanceof RunescribingRecipe ? (RunescribingRecipe)pattern.get() : null;
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.Recipe.RUNESCRIBING;
    }

    @Override
    protected void drawForeground(GuiGraphics pGuiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.pattern == null) {
            return;
        }
        float scaleX = 1.5f;
        float scaleY = 1.5f;
        int startX = (int)((float)(x + 37) / scaleX);
        int startY = (int)((float)(y + 110) / scaleY);
        int grid = 12;
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85841_(scaleX, scaleY, 1.0f);
        int count = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((this.pattern.getHMutex() & 1L << count) != 0L) {
                    pGuiGraphics.m_280218_(GuiTextures.Widgets.GUIDE_WIDGETS, startX + j * grid, startY + i * grid, 26, 0, grid, 1);
                }
                if ((this.pattern.getVMutex() & 1L << count) != 0L) {
                    pGuiGraphics.m_280218_(GuiTextures.Widgets.GUIDE_WIDGETS, startX + (i + 1) * grid, startY + (j - 1) * grid, 26, 0, 1, grid);
                }
                ++count;
            }
        }
        pGuiGraphics.m_280168_().m_85849_();
        if (!this.disableOutputRender) {
            ItemStack output = this.pattern.getResultItem();
            this.renderItemStack(pGuiGraphics, output, (int)((float)this.m_252754_() / this.scale + (float)(this.f_93618_ / 2 - 8)), (int)((float)this.m_252907_() / this.scale + 57.0f), 1.0f);
        }
        if (!this.disableLabels) {
            int tier = this.pattern.getTier();
            MutableInt playerTier = new MutableInt(0);
            this.minecraft.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
            int color = tier <= playerTier.getValue() ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)128, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
            MutableComponent name = Component.m_237115_((String)this.pattern.getResultItem().m_41778_().toString());
            MutableComponent tierPrompt = Component.m_237110_((String)"gui.mna.item-tier", (Object[])new Object[]{tier});
            int stringWidth = this.minecraft.f_91062_.m_92852_((FormattedText)name);
            int textX = x + this.f_93618_ / 2 - stringWidth / 2;
            int textY = y + 5;
            pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)name, textX, textY, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), false);
            pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)tierPrompt, x + this.f_93618_ / 2 - this.minecraft.f_91062_.m_92852_((FormattedText)tierPrompt) / 2, y + 15, color, false);
            if (this.pattern.getFactionRequirement() != null) {
                int xPadding = 3;
                this.renderFactionIcon(pGuiGraphics, this.pattern.getFactionRequirement(), textX + stringWidth + xPadding, textY);
            }
        }
    }

    @Override
    public int getTier() {
        return this.pattern != null ? this.pattern.getTier() : 1;
    }

    public String getOutputTranslationKey() {
        if (this.pattern == null) {
            return "";
        }
        return this.pattern.getResultItem().m_41778_().toString();
    }

    public void disableLabels() {
        this.disableLabels = true;
    }

    public void disableOutputRender() {
        this.disableOutputRender = true;
    }
}

