/*
 * Decompiled with CFR 0.152.
 */
package com.mna.guide.recipe;

import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.api.tools.MATags;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.GuiTextures;
import com.mna.guide.recipe.ICyclingRecipeRenderer;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.recipes.manaweaving.ManaweavingPatternHelper;
import com.mna.recipes.manaweaving.ManaweavingRecipe;
import com.mna.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeManaweaving
extends RecipeRendererBase
implements ICyclingRecipeRenderer<RecipeManaweaving> {
    private ManaweavingRecipe[] patterns;

    public RecipeManaweaving(int x, int y) {
        super(x, y);
    }

    @Override
    public void init_cycling(ResourceLocation[] rLocs) {
        ArrayList<ManaweavingRecipe> patternList = new ArrayList<ManaweavingRecipe>();
        for (ResourceLocation rLoc : rLocs) {
            Optional<Recipe<?>> pattern = this.resolveRecipe(rLoc);
            if (!pattern.isPresent() || !(pattern.get() instanceof ManaweavingRecipe)) continue;
            patternList.add((ManaweavingRecipe)pattern.get());
        }
        this.patterns = patternList.toArray(new ManaweavingRecipe[0]);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional<Recipe<?>> pattern = this.resolveRecipe(recipeLocation);
        this.patterns = pattern.isPresent() && pattern.get() instanceof ManaweavingRecipe ? new ManaweavingRecipe[]{(ManaweavingRecipe)pattern.get()} : null;
    }

    private Optional<? extends Recipe<?>> resolveRecipe(ResourceLocation recipeLocation) {
        Optional resolved = this.minecraft.f_91073_.m_7465_().m_44043_(recipeLocation);
        if (!resolved.isPresent()) {
            if (recipeLocation.m_135827_().equals("mna") && !recipeLocation.m_135815_().startsWith("manaweaving/")) {
                recipeLocation = new ResourceLocation(recipeLocation.m_135827_(), "manaweaving/" + recipeLocation.m_135815_());
            }
            resolved = this.minecraft.f_91073_.m_7465_().m_44043_(recipeLocation);
        }
        return resolved;
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.Recipe.MANAWEAVING_ALTAR;
    }

    @Override
    protected void drawForeground(GuiGraphics pGuiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int i;
        if (this.patterns.length == 0) {
            return;
        }
        int index = this.getIndex();
        ManaweavingRecipe pattern = this.patterns[index];
        if (pattern == null) {
            return;
        }
        float patternScale = 0.1f;
        int startX = (int)((float)(x + 31) / patternScale);
        int startY = (int)((float)(y + 225) / patternScale);
        RenderSystem.setShaderColor((float)0.5f, (float)0.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i < pattern.getRequiredPatterns().length; ++i) {
            ManaweavingPattern p2 = ManaweavingPatternHelper.GetManaweavingRecipe((Level)this.minecraft.f_91073_, pattern.getRequiredPatterns()[i]);
            if (p2 == null) continue;
            GuiRenderUtils.renderManaweavePattern(pGuiGraphics, startX, startY, patternScale, p2);
            startX += (int)Math.floor(33.6f / patternScale);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        startX = (int)((float)this.m_252754_() / this.scale + 8.0f);
        startY = (int)((float)this.m_252907_() / this.scale + 44.0f);
        for (i = 0; i < pattern.getRequiredItems().length; ++i) {
            List<ItemStack> items = MATags.smartLookupItem(pattern.getRequiredItems()[i]).stream().map(item -> new ItemStack((ItemLike)item)).collect(Collectors.toList());
            if (items == null || items.size() == 0) continue;
            if (i == 0) {
                this.renderItemStack(pGuiGraphics, items, startX + 68, startY + 33, 1.0f);
            } else {
                this.renderItemStack(pGuiGraphics, items, startX, startY, 1.0f);
            }
            startX += 34;
            if (i == 4) {
                startX += 33;
            }
            if (!((float)startX > (float)this.m_252754_() / this.scale + 112.0f)) continue;
            startY += 33;
            startX = (int)((float)this.m_252754_() / this.scale + 42.0f);
        }
        ItemStack output = pattern.getResultItem();
        this.renderItemStack(pGuiGraphics, output, (int)((float)this.m_252754_() / this.scale + 162.0f), (int)((float)this.m_252907_() / this.scale + 77.0f), 1.0f);
        this.renderByproducts(pGuiGraphics, this.m_5711_() - 73, this.m_93694_() / 2 - 18, pattern);
        Font fr = this.minecraft.f_91062_;
        String lineFormatted = I18n.m_118938_((String)"gui.mna.shapeless", (Object[])new Object[0]);
        pGuiGraphics.m_280056_(fr, lineFormatted, x + 171 - fr.m_92895_(lineFormatted) / 2, y + 62, 0x404040, false);
        int tier = pattern.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)128, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
        MutableComponent name = Component.m_237115_((String)pattern.getResultItem().m_41778_().toString());
        MutableComponent tierPrompt = Component.m_237110_((String)"gui.mna.item-tier", (Object[])new Object[]{tier});
        int stringWidth = this.minecraft.f_91062_.m_92852_((FormattedText)name);
        int textX = x + this.f_93618_ / 2 - stringWidth / 2;
        int textY = y + 5;
        pGuiGraphics.m_280614_(fr, (Component)name, textX, textY, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), false);
        pGuiGraphics.m_280614_(fr, (Component)tierPrompt, x + this.f_93618_ / 2 - this.minecraft.f_91062_.m_92852_((FormattedText)tierPrompt) / 2, y + 15, color, false);
        if (pattern.getFactionRequirement() != null) {
            int xPadding = 3;
            this.renderFactionIcon(pGuiGraphics, pattern.getFactionRequirement(), textX + stringWidth + xPadding, textY);
        }
        RenderSystem.enableBlend();
    }

    @Override
    public int getTier() {
        if (this.patterns == null) {
            return 1;
        }
        int minTier = 5;
        for (ManaweavingRecipe pattern : this.patterns) {
            if (pattern.getTier() >= minTier) continue;
            minTier = pattern.getTier();
        }
        return minTier;
    }

    @Override
    public int countRecipes() {
        return this.patterns.length;
    }
}

