/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.item;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiable;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.api.spells.parts.Modifier;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.mna.gui.GuiTextures;
import com.mna.gui.base.GuiJEIDisable;
import com.mna.gui.block.GuiInscriptionTable;
import com.mna.gui.containers.item.ContainerSpellAdjustments;
import com.mna.gui.widgets.AttributeButton;
import com.mna.gui.widgets.ImageButtonWithAlphaBlend;
import com.mna.gui.widgets.RGBPicker;
import com.mna.network.ClientMessageDispatcher;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GuiSpellAdjust
extends GuiJEIDisable<ContainerSpellAdjustments> {
    ArrayList<ImageButton> shapeAttributeButtons;
    ArrayList<ImageButton> componentAttributeButtons;
    final float textScaleFactor;
    static final int textColor = FastColor.ARGB32.m_13660_((int)255, (int)49, (int)49, (int)49);
    static final int textColorLight = FastColor.ARGB32.m_13660_((int)255, (int)200, (int)200, (int)200);
    final int colWidth = 38;
    final int rowHeight = 13;
    final int texSize = 32;
    int spellNameWidth;
    String spellName;
    final List<Component> currentTooltip;
    IPlayerRoteSpells playerRote;
    IPlayerProgression playerProgression;
    RGBPicker color;

    public GuiSpellAdjust(ContainerSpellAdjustments screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.textScaleFactor = (Boolean)Minecraft.m_91087_().f_91066_.f_92043_.m_231551_() != false ? 1.0f : 0.7f;
        this.colWidth = 38;
        this.rowHeight = 13;
        this.texSize = 32;
        this.spellNameWidth = 1;
        this.spellName = "";
        this.playerRote = null;
        this.playerProgression = null;
        this.f_97726_ = 256;
        this.f_97727_ = 256;
        this.currentTooltip = new ArrayList<Component>();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.playerRote = (IPlayerRoteSpells)this.f_96541_.f_91074_.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
        this.playerProgression = (IPlayerProgression)this.f_96541_.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        this.shapeAttributeButtons = new ArrayList();
        this.componentAttributeButtons = new ArrayList();
        this.spellName = ((ContainerSpellAdjustments)this.f_97732_).getSpellName();
        this.spellNameWidth = this.f_96547_.m_92895_(this.spellName);
        this.m_142416_((GuiEventListener)new ImageButtonWithAlphaBlend(this.f_97735_ + 223, this.f_97736_ + 7, 16, 16, 223, 152, 0, GuiTextures.Items.SPELL_VALUES, 256, 256, button -> {
            this.m_7379_();
            ClientMessageDispatcher.sendRequestOpenSpellNameAndIconGUI();
        }));
        int overrideColor = ((ContainerSpellAdjustments)this.f_97732_).getRecipe().getParticleColorOverride();
        this.color = new RGBPicker(this.f_97735_ + 80, this.f_97736_ + 202, this::adjustSpellColors);
        this.color.setValue(FastColor.ARGB32.m_13665_((int)overrideColor), FastColor.ARGB32.m_13667_((int)overrideColor), FastColor.ARGB32.m_13669_((int)overrideColor), FastColor.ARGB32.m_13655_((int)overrideColor));
        this.m_142416_((GuiEventListener)this.color);
        this.setupShapeAttributeButtons(((ContainerSpellAdjustments)this.f_97732_).getShape().getPart());
        this.setupComponentAttributeButtons(((ContainerSpellAdjustments)this.f_97732_).getComponent().getPart());
    }

    private void setupShapeAttributeButtons(Shape shape) {
        this.clearAttributeButtons(this.shapeAttributeButtons);
        if (shape == null || ((ContainerSpellAdjustments)this.f_97732_).isTranscribed()) {
            return;
        }
        this.setupAttributeButtons(122, 45, this.shapeAttributeButtons, shape);
    }

    private void setupAttributeButtons(int xStart, int yStart, ArrayList<ImageButton> addTo, IModifiable<? extends ISpellComponent> modifiable) {
        int count = 0;
        for (AttributeValuePair attribute : modifiable.getModifiableAttributes()) {
            boolean attributeModifiable = false;
            for (int i = 0; i < 3; ++i) {
                Modifier modifier = ((ContainerSpellAdjustments)this.f_97732_).getModifier(i);
                if (modifier == null || !modifier.modifiesType(attribute.getAttribute())) continue;
                attributeModifiable = true;
                break;
            }
            int row = (int)Math.floor(count / 2);
            int col = count % 2;
            int xOffset = xStart + 38 * col;
            int yOffset = yStart + 13 * row;
            if (attributeModifiable) {
                ImageButtonWithAlphaBlend upButton = (ImageButtonWithAlphaBlend)this.m_142416_((GuiEventListener)new ImageButtonWithAlphaBlend(this.f_97735_ + xOffset + 2, this.f_97736_ + yOffset - 2, 6, 3, 1, 49, 0, GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerSpellAdjustments)this.f_97732_).increaseAttribute((Player)this.f_96541_.f_91074_, modifiable, attribute.getAttribute(), (Level)this.f_96541_.f_91073_, Screen.m_96638_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                ImageButtonWithAlphaBlend downButton = (ImageButtonWithAlphaBlend)this.m_142416_((GuiEventListener)new ImageButtonWithAlphaBlend(this.f_97735_ + xOffset + 2, this.f_97736_ + yOffset + 3, 6, 3, 1, 54, 0, GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerSpellAdjustments)this.f_97732_).decreaseAttribute((Player)this.f_96541_.f_91074_, modifiable, attribute.getAttribute(), (Level)this.f_96541_.f_91073_, Screen.m_96638_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                addTo.add(upButton);
                addTo.add(downButton);
            }
            Point texCoord = GuiTextures.Attribute_Icon_Mappings.get((Object)attribute.getAttribute());
            int blitSize = 8;
            float scaleFactor = (float)blitSize / 52.0f;
            ImageButton iconButton = (ImageButton)this.m_142416_((GuiEventListener)new AttributeButton(this.f_97735_ + xOffset - 8, this.f_97736_ + yOffset - 2, blitSize, blitSize, (int)((float)texCoord.x * scaleFactor), (int)((float)texCoord.y * scaleFactor), 0, GuiTextures.Widgets.ATTRIBUTE_ICONS, (int)(208.0f * scaleFactor), (int)(208.0f * scaleFactor), button -> {}, new String[]{attribute.getAttribute().getLocaleKey(), ((ISpellComponent)((Object)modifiable)).getDescriptionTooltip(attribute.getAttribute())}, this::addTooltipLine));
            addTo.add(iconButton);
            ++count;
        }
    }

    private void clearAttributeButtons(ArrayList<ImageButton> attributeButtons) {
        for (ImageButton button : attributeButtons) {
            this.m_169411_((GuiEventListener)button);
        }
        attributeButtons.clear();
    }

    private void setupComponentAttributeButtons(SpellEffect component) {
        this.clearAttributeButtons(this.componentAttributeButtons);
        if (component == null || ((ContainerSpellAdjustments)this.f_97732_).isTranscribed()) {
            return;
        }
        this.setupAttributeButtons(122, 92, this.componentAttributeButtons, component);
    }

    private void adjustSpellColors(Integer[] colors) {
        ((ContainerSpellAdjustments)this.f_97732_).getRecipe().setParticleColorOverride(FastColor.ARGB32.m_13660_((int)colors[3], (int)colors[0], (int)colors[1], (int)colors[2]));
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.color.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void m_7861_() {
        super.m_7861_();
        if (((ContainerSpellAdjustments)this.f_97732_).getRecipe().isValid()) {
            ClientMessageDispatcher.sendSpellAdjustmentMessage(((ContainerSpellAdjustments)this.f_97732_).getRecipe(), ((ContainerSpellAdjustments)this.f_97732_).getHand());
        }
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.currentTooltip.clear();
        RenderSystem.enableBlend();
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.currentTooltip != null) {
            pGuiGraphics.m_280677_(this.f_96547_, this.currentTooltip, Optional.empty(), mouseX, mouseY);
        }
        this.m_280072_(pGuiGraphics, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        int col;
        int row;
        int xPos = 133;
        int yPos = 45;
        int count = 0;
        int text_y = 12;
        List split_lines = this.f_96547_.m_92865_().m_92432_(this.spellName, 150, Style.f_131099_);
        for (FormattedText line : split_lines) {
            String textLine = line.getString();
            int snw = this.f_96547_.m_92895_(textLine);
            pGuiGraphics.m_280056_(this.f_96547_, textLine, this.f_97726_ / 2 - snw / 2, text_y, textColor, false);
            Objects.requireNonNull(this.f_96547_);
            text_y += 9;
        }
        ItemStack stack = ((ContainerSpellAdjustments)this.f_97732_).getSpellStack();
        pGuiGraphics.m_280480_(stack, 7, 7);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        if (((ContainerSpellAdjustments)this.f_97732_).getShape() != null) {
            pGuiGraphics.m_280163_(((ContainerSpellAdjustments)this.f_97732_).getShape().getPart().getGuiIcon(), 150, 88, 0.0f, 0.0f, 64, 64, 64, 64);
            for (Attribute attribute : ((ContainerSpellAdjustments)this.f_97732_).getShape().getContainedAttributes()) {
                row = (int)Math.floor(count / 2);
                col = count % 2;
                this.drawAttributeValue(pGuiGraphics, xPos + col * 38, yPos + row * 13, ((ContainerSpellAdjustments)this.f_97732_).getShape().getValueWithoutMultipliers(attribute));
                ++count;
            }
        }
        yPos += 47;
        count = 0;
        if (((ContainerSpellAdjustments)this.f_97732_).getComponent() != null) {
            pGuiGraphics.m_280163_(((ContainerSpellAdjustments)this.f_97732_).getComponent().getPart().getGuiIcon(), 150, 182, 0.0f, 0.0f, 64, 64, 64, 64);
            for (Attribute attribute : ((ContainerSpellAdjustments)this.f_97732_).getComponent().getContainedAttributes()) {
                row = (int)Math.floor(count / 2);
                col = count % 2;
                this.drawAttributeValue(pGuiGraphics, xPos + col * 38, yPos + row * 13, ((ContainerSpellAdjustments)this.f_97732_).getComponent().getValueWithoutMultipliers(attribute));
                ++count;
            }
        }
        for (int i = 0; i < 3; ++i) {
            Modifier m = ((ContainerSpellAdjustments)this.f_97732_).getModifier(i);
            if (m == null) continue;
            pGuiGraphics.m_280163_(m.getGuiIcon(), 150 + 74 * i, 276, 0.0f, 0.0f, 64, 64, 64, 64);
        }
        pGuiGraphics.m_280168_().m_85849_();
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85841_(this.textScaleFactor, this.textScaleFactor, this.textScaleFactor);
        String header = I18n.m_118938_((String)"gui.mna.mana_cost", (Object[])new Object[0]) + ":";
        String manaCost = String.format("%.1f", Float.valueOf(((ContainerSpellAdjustments)this.f_97732_).getManaCost((Player)this.f_96541_.f_91074_)));
        String complexityHeader = I18n.m_118938_((String)"gui.mna.complexity", (Object[])new Object[0]) + ":";
        String complexity = String.format("%.1f / %d", Float.valueOf(((ContainerSpellAdjustments)this.f_97732_).getComplexity((Player)this.f_96541_.f_91074_)), this.playerProgression.getTierMaxComplexity());
        float manaCostWidth = (float)this.f_96547_.m_92895_(manaCost) * this.textScaleFactor;
        float headerWidth = (float)this.f_96547_.m_92895_(header) * this.textScaleFactor;
        float complexityHeaderWidth = (float)this.f_96547_.m_92895_(complexityHeader) * this.textScaleFactor;
        float complexityWidth = (float)this.f_96547_.m_92895_(complexity) * this.textScaleFactor;
        float padding = 2.0f;
        float summaryXPos = (float)(this.f_97726_ / 2) - (complexityHeaderWidth + complexityWidth + padding) / 2.0f;
        float summaryYPos = (Boolean)this.f_96541_.f_91066_.f_92043_.m_231551_() != false ? 180.0f : 182.0f;
        pGuiGraphics.m_280056_(this.f_96547_, complexityHeader, (int)(summaryXPos / this.textScaleFactor), (int)(summaryYPos / this.textScaleFactor), textColor, false);
        summaryXPos += complexityHeaderWidth + padding;
        if (((ContainerSpellAdjustments)this.f_97732_).getComplexity((Player)this.f_96541_.f_91074_) <= (float)this.playerProgression.getTierMaxComplexity()) {
            pGuiGraphics.m_280056_(this.f_96547_, complexity, (int)(summaryXPos / this.textScaleFactor), (int)(summaryYPos / this.textScaleFactor), textColor, false);
        } else {
            pGuiGraphics.m_280056_(this.f_96547_, complexity, (int)(summaryXPos / this.textScaleFactor), (int)(summaryYPos / this.textScaleFactor), ChatFormatting.RED.m_126665_().intValue(), false);
        }
        summaryXPos = (float)(this.f_97726_ / 2) - (headerWidth + manaCostWidth + padding) / 2.0f;
        float f = (Boolean)this.f_96541_.f_91066_.f_92043_.m_231551_() != false ? 180 : 184;
        Objects.requireNonNull(this.f_96547_);
        summaryYPos = f + 9.0f * this.textScaleFactor;
        pGuiGraphics.m_280056_(this.f_96547_, header, (int)(summaryXPos / this.textScaleFactor), (int)(summaryYPos / this.textScaleFactor), textColor, false);
        pGuiGraphics.m_280056_(this.f_96547_, manaCost, (int)((summaryXPos += headerWidth + padding) / this.textScaleFactor), (int)(summaryYPos / this.textScaleFactor), textColor, false);
        pGuiGraphics.m_280168_().m_85849_();
    }

    private void drawAttributeValue(GuiGraphics pGuiGraphics, int x, int y, float value) {
        String valueString = String.format("%.1f", Float.valueOf(value));
        pGuiGraphics.m_280056_(this.f_96547_, valueString, (int)((float)x / 0.5f), (int)((float)y / 0.5f), textColor, false);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(pGuiGraphics);
        int i = this.f_97735_;
        int j = this.f_97736_;
        pGuiGraphics.m_280163_(GuiTextures.Items.SPELL_VALUES, i, j, 0.0f, 145.0f, 247, 30, this.f_97726_, this.f_97727_);
        pGuiGraphics.m_280163_(GuiTextures.Items.SPELL_VALUES, i + this.f_97726_ / 2 - 50, j + 170, 0.0f, 176.0f, 100, 30, this.f_97726_, this.f_97727_);
        pGuiGraphics.m_280163_(GuiTextures.Items.SPELL_VALUES, i + this.f_97726_ / 2 - 60, j + 35, 0.0f, 0.0f, 120, 144, this.f_97726_, this.f_97727_);
    }

    public void addTooltipLine(Component comp) {
        this.currentTooltip.add(comp);
    }
}

