/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.item;

import com.google.common.collect.Lists;
import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.capabilities.CodexBreadcrumb;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.config.ClientConfigValues;
import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.api.sound.SFX;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.config.ClientConfig;
import com.mna.gui.GuiTextures;
import com.mna.gui.HUDOverlayRenderer;
import com.mna.gui.base.GuiJEIDisable;
import com.mna.gui.containers.item.ContainerGuideBook;
import com.mna.gui.widgets.ImageItemStackButton;
import com.mna.guide.EntryCategory;
import com.mna.guide.GuideBookEntries;
import com.mna.guide.GuidebookEntry;
import com.mna.guide.RelatedRecipe;
import com.mna.guide.interfaces.IEntrySection;
import com.mna.guide.recipe.RecipeBlank;
import com.mna.recipes.AMRecipeBase;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;

@OnlyIn(value=Dist.CLIENT)
public class GuiGuideBook
extends GuiJEIDisable<ContainerGuideBook> {
    private static final int X_PAGE_LEFT = 15;
    private static final int X_PAGE_RIGHT = 133;
    public static final int X_MAX = 108;
    public static final int Y_PAGE_START = 10;
    public static final int Y_MAX = 168;
    GuidebookEntry currentEntry = null;
    ImageButton prevPage = null;
    ImageButton nextPage = null;
    ImageButton back = null;
    ImageButton switchConfig_HUD = null;
    ImageButton switchConfig_HUDPOS = null;
    ImageButton switchConfig_BACK = null;
    ImageButton switchConfig_PINSIZE = null;
    ImageButton search = null;
    Component searchTerm;
    EditBox searchBox;
    RecipeBlank searchBackground;
    RecipeRendererBase currentRecipe = null;
    ImageButton closeRecipe = null;
    ImageButton pinRecipe = null;
    int page = 0;
    int max_pages = 1;
    boolean isSearching = false;
    IPlayerProgression progression = null;
    static List<Component> currentTooltip = new ArrayList<Component>();
    private ArrayList<ImageButton> relatedTabs;
    private ArrayList<CategoryItemButton> categoryButtons;
    private ArrayList<CodexSearchResult> searchResults;
    private HashMap<Integer, Collection<AbstractWidget>> pageWidgets;
    private EntryCategory currentCategory = EntryCategory.BASICS;

    public GuiGuideBook(ContainerGuideBook container, Inventory playerInventory, Component textComponent) {
        super(container, playerInventory, textComponent);
        this.f_97726_ = 256;
        this.f_97727_ = 178;
        this.relatedTabs = new ArrayList();
        this.categoryButtons = new ArrayList();
        this.searchResults = new ArrayList();
        this.pageWidgets = new HashMap();
        if (this.f_96541_ == null) {
            this.f_96541_ = Minecraft.m_91087_();
        }
        this.progression = (IPlayerProgression)this.f_96541_.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
    }

    protected void m_7856_() {
        super.m_7856_();
        GuideBookEntries.INSTANCE.reload();
        GuideBookEntries.INSTANCE.updateUnlockedEntries(null);
        this.categoryButtons.clear();
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.prevPage = new PaperImageButton(i + 10, j + 158, 14, 14, 0, 0, 14, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> this.decrementPage());
        this.nextPage = new PaperImageButton(i + 233, j + 158, 14, 14, 14, 0, 14, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> this.incrementPage());
        this.prevPage.f_93623_ = false;
        this.prevPage.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.prevPage);
        this.m_142416_((GuiEventListener)this.nextPage);
        this.search = new PaperImageButton(i + 15, j + this.f_97727_ - 6, 18, 28, 118, 0, 28, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> this.toggleSearch()).setTooltip((Component)Component.m_237115_((String)"gui.mna.codex_search"));
        this.searchTerm = Component.m_237115_((String)"gui.mna.codex_search");
        this.searchBox = new EditBox(this.f_96541_.f_91062_, i + this.f_97726_ / 2 - 80, j - 33, 160, 20, this.searchTerm);
        this.searchBox.m_94199_(60);
        this.searchBox.m_94151_(this::runSearch);
        this.searchBackground = new RecipeBlank(this.f_97735_ + (this.f_97726_ - 218) / 2, this.f_97736_ + (this.f_97727_ - 256) / 2);
        this.m_142416_((GuiEventListener)this.search);
        this.back = new PaperImageButton(i - 20, j + this.f_97727_ / 2 - 14, 20, 38, 84, 0, 38, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> this.displayBreadcrumb(false));
        this.m_142416_((GuiEventListener)this.back);
        this.switchConfig_HUD = new PaperImageButton(i + 35, j + this.f_97727_ - 6, 18, 28, 136, 0, 28, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> {
            int cur = ClientConfigValues.CodexBackMode.ordinal();
            ClientConfig.setCodexBackStyle((cur + 1) % ClientConfigValues.CodexMode.values().length);
            ClientConfig.bakeConfig();
            ((PaperImageButton)button).setTooltip((Component)Component.m_237115_((String)ClientConfigValues.CodexBackMode.getLocalizationKey()));
        }).setTooltip((Component)Component.m_237115_((String)ClientConfigValues.CodexBackMode.getLocalizationKey()));
        this.switchConfig_HUDPOS = new PaperImageButton(i + 55, j + this.f_97727_ - 6, 18, 28, 172, 0, 28, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> {
            int cur = ClientConfigValues.HudPosition.ordinal();
            ClientConfig.setHudPosition((cur + 1) % ClientConfigValues.HudPos.values().length);
            ClientConfig.bakeConfig();
            ((PaperImageButton)button).setTooltip((Component)Component.m_237115_((String)ClientConfigValues.HudPosition.getLocalizationKey()));
        }).setTooltip((Component)Component.m_237115_((String)ClientConfigValues.HudPosition.getLocalizationKey()));
        this.switchConfig_PINSIZE = new PaperImageButton(i + 75, j + this.f_97727_ - 6, 18, 28, 190, 0, 28, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> {
            int cur = ClientConfigValues.PinnedRecipeScale.ordinal();
            ClientConfig.setPinnedRecipeScale((cur + 1) % ClientConfigValues.HudMode.values().length);
            ClientConfig.bakeConfig();
            ((PaperImageButton)button).setTooltip((Component)Component.m_237115_((String)ClientConfigValues.PinnedRecipeScale.getLocalizationKey()));
        }).setTooltip((Component)Component.m_237115_((String)ClientConfigValues.PinnedRecipeScale.getLocalizationKey()));
        this.switchConfig_BACK = new PaperImageButton(i + 95, j + this.f_97727_ - 6, 18, 28, 154, 0, 28, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> {
            int cur = ClientConfigValues.ShowHudMode.ordinal();
            ClientConfig.setHudMode((cur + 1) % ClientConfigValues.HudMode.values().length);
            ClientConfig.bakeConfig();
            ((PaperImageButton)button).setTooltip((Component)Component.m_237115_((String)ClientConfigValues.ShowHudMode.getLocalizationKey()));
        }).setTooltip((Component)Component.m_237115_((String)ClientConfigValues.ShowHudMode.getLocalizationKey()));
        this.m_142416_((GuiEventListener)this.switchConfig_HUD);
        this.m_142416_((GuiEventListener)this.switchConfig_HUDPOS);
        this.m_142416_((GuiEventListener)this.switchConfig_PINSIZE);
        this.m_142416_((GuiEventListener)this.switchConfig_BACK);
        this.closeRecipe = new PaperImageButton(i + 210, j - 30, 14, 14, 104, 0, 14, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> this.displayBreadcrumb(false));
        this.pinRecipe = new ImageButton(i + 30, j - 30, 14, 14, 104, 43, 14, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> {
            if (HUDOverlayRenderer.instance.getPinnedrecipe() != null && HUDOverlayRenderer.instance.getPinnedrecipe().equals((Object)this.currentRecipe)) {
                HUDOverlayRenderer.instance.setPinnedRecipe(null);
            } else {
                HUDOverlayRenderer.instance.setPinnedRecipe(this.currentRecipe.clone(0, 0, true));
            }
        });
        this.displayBreadcrumb(false);
        ManaAndArtifice.instance.proxy.playSingleSound(SFX.Gui.BOOK_OPEN);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if ((ClientConfigValues.CodexBackMode == ClientConfigValues.CodexMode.EscUIBack || ClientConfigValues.CodexBackMode == ClientConfigValues.CodexMode.RMouseUIEscBack) && keyCode == 256) {
            if (this.isSearching) {
                this.clearSearch(false);
            } else if (this.currentRecipe != null) {
                this.clearDisplayedRecipe(false);
            } else if (this.progression.peekCodexBreadcrumb() == null) {
                this.m_7379_();
                return true;
            }
            this.displayBreadcrumb(false);
            return true;
        }
        if (this.isSearching && keyCode != 256 && this.m_7222_() != null) {
            this.m_7222_().m_7933_(keyCode, scanCode, modifiers);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if ((ClientConfigValues.CodexBackMode == ClientConfigValues.CodexMode.RMouseUIBackEscOut || ClientConfigValues.CodexBackMode == ClientConfigValues.CodexMode.RMouseUIEscBack) && button == 1) {
            if (this.isSearching) {
                if (this.searchBox.m_5953_(mouseX, mouseY)) {
                    this.searchBox.m_94144_("");
                    for (CodexSearchResult r : this.searchResults) {
                        this.m_169411_((GuiEventListener)r);
                    }
                    this.searchResults.clear();
                    return true;
                }
                this.clearSearch(false);
            } else if (this.currentRecipe != null) {
                this.clearDisplayedRecipe(false);
            }
            this.displayBreadcrumb(false);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.currentRecipe == null && !this.isSearching) {
            if (delta > 0.0) {
                this.decrementPage();
            } else {
                this.incrementPage();
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void toggleSearch() {
        if (this.isSearching) {
            this.clearSearch(true);
        } else {
            this.showSearch(true);
        }
    }

    private void showSearch(boolean pushBreadcrumb) {
        if (pushBreadcrumb) {
            this.pushCategoryBreadcrumb();
            this.clearDisplayedRecipe(true);
        }
        for (Renderable widget : this.f_169369_) {
            if (!(widget instanceof AbstractWidget)) continue;
            ((AbstractWidget)widget).f_93623_ = false;
        }
        for (Renderable widget : (Collection)this.pageWidgets.getOrDefault(this.page, new ArrayList())) {
            if (!(widget instanceof AbstractWidget) || this.relatedTabs.contains(widget)) continue;
            widget.f_93623_ = false;
            widget.f_93624_ = false;
        }
        for (Renderable widget : (Collection)this.pageWidgets.getOrDefault(this.page + 1, new ArrayList())) {
            if (!(widget instanceof AbstractWidget) || this.relatedTabs.contains(widget)) continue;
            widget.f_93623_ = false;
            widget.f_93624_ = false;
        }
        this.m_142416_((GuiEventListener)this.searchBackground);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)this.closeRecipe);
        DelayedEventQueue.pushEvent((Level)this.f_96541_.f_91073_, new TimedDelayedEvent<String>("focus", 10, "focus", this::fixFocus));
        this.isSearching = true;
    }

    private void clearSearch(boolean pushBreadcrumb) {
        if (pushBreadcrumb) {
            this.pushBreadcrumb(CodexBreadcrumb.Type.SEARCH, this.searchBox.m_94155_(), new String[0]);
        }
        this.m_169411_((GuiEventListener)this.searchBox);
        this.m_169411_((GuiEventListener)this.searchBackground);
        this.m_169411_((GuiEventListener)this.closeRecipe);
        for (CodexSearchResult r : this.searchResults) {
            this.m_169411_((GuiEventListener)r);
        }
        this.searchResults.clear();
        this.searchBox.m_94144_("");
        for (Renderable widget : this.f_169369_) {
            if (!(widget instanceof AbstractWidget)) continue;
            ((AbstractWidget)widget).f_93623_ = true;
        }
        for (Renderable widget : (Collection)this.pageWidgets.getOrDefault(this.page, new ArrayList())) {
            if (!(widget instanceof AbstractWidget) || this.relatedTabs.contains(widget)) continue;
            widget.f_93623_ = true;
            widget.f_93624_ = true;
        }
        for (Renderable widget : (Collection)this.pageWidgets.getOrDefault(this.page + 1, new ArrayList())) {
            if (!(widget instanceof AbstractWidget) || this.relatedTabs.contains(widget)) continue;
            widget.f_93623_ = true;
            widget.f_93624_ = true;
        }
        this.isSearching = false;
    }

    private void runSearch(String term) {
        if (term.length() < 3) {
            return;
        }
        for (CodexSearchResult r : this.searchResults) {
            this.m_169411_((GuiEventListener)r);
        }
        this.searchResults.clear();
        MutableInt yCoord = new MutableInt(this.f_97736_ - 10);
        List<GuideBookEntries.GuidebookSearchResult> results = GuideBookEntries.INSTANCE.searchEntries(term, this.progression.getTier(), 24);
        for (GuideBookEntries.GuidebookSearchResult e : results) {
            if (e.isEntry()) {
                csr = new CodexSearchResult(this.f_97735_ + 35, yCoord.getValue(), e.getEntry().getCategory().getDisplayStack().m_41786_().getString() + " > " + e.getEntry().getFirstTitle(), button -> {
                    this.clearSearch(true);
                    this.setCurrentEntry(e.getEntry().getName(), false);
                });
                this.m_142416_((GuiEventListener)csr);
                this.searchResults.add(csr);
                yCoord.add(csr.m_93694_() + 2);
            } else if (e.isRecipe()) {
                MutableComponent ttc = Component.m_237115_((String)("gui.mna.codex_search.recipe." + e.getRecipe().getType()));
                if (e.getOutputStack().m_41793_()) {
                    Map enchs = EnchantmentHelper.m_44831_((ItemStack)e.getOutputStack());
                    for (Map.Entry enchantment : enchs.entrySet()) {
                        ttc.m_7220_(((Enchantment)enchantment.getKey()).m_44700_(((Integer)enchantment.getValue()).intValue()));
                    }
                    csr = new CodexSearchResult(this.f_97735_ + 35, yCoord.getValue(), ttc.getString(), button -> {
                        this.clearSearch(true);
                        this.displayRecipe(e.getRecipe(), false);
                    });
                } else {
                    csr = new CodexSearchResult(this.f_97735_ + 35, yCoord.getValue(), ttc.m_7220_(e.getOutputStack().m_41786_()).getString(), button -> {
                        this.clearSearch(true);
                        this.displayRecipe(e.getRecipe(), false);
                    });
                }
                this.m_142416_((GuiEventListener)csr);
                this.searchResults.add(csr);
                yCoord.add(csr.m_93694_() + 2);
            }
            int n = yCoord.intValue();
            Objects.requireNonNull(this.f_96547_);
            if (n <= this.f_97736_ + 200 - 9) continue;
            break;
        }
    }

    private ItemStack lookupResource(ResourceLocation rLoc) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(rLoc);
        if (item != null && item != Items.f_41852_) {
            return new ItemStack((ItemLike)item);
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(rLoc);
        if (block != null && block != Blocks.f_50016_) {
            return new ItemStack((ItemLike)block);
        }
        return ItemStack.f_41583_;
    }

    private ISpellComponent lookupSpell(ResourceLocation rLoc) {
        ISpellComponent output = null;
        output = (ISpellComponent)Registries.Shape.get().getValue(rLoc);
        if (output != null) {
            return output;
        }
        output = (ISpellComponent)Registries.SpellEffect.get().getValue(rLoc);
        if (output != null) {
            return output;
        }
        output = (ISpellComponent)Registries.Modifier.get().getValue(rLoc);
        return output;
    }

    private void fixFocus(String identifier, String data) {
        this.searchBox.m_93692_(true);
        this.m_7522_((GuiEventListener)this.searchBox);
    }

    private void displayRecipe(RelatedRecipe rr, boolean pushBreadcrumb) {
        if (pushBreadcrumb) {
            this.pushBreadcrumb(CodexBreadcrumb.Type.ENTRY, this.currentEntry.getName(), new String[0]);
        }
        this.clearDisplayedRecipe(true);
        this.currentRecipe = rr.constructRenderer(this.f_97735_ + (this.f_97726_ - 218) / 2, this.f_97736_ + (this.f_97727_ - 256) / 2, this::setTooltip);
        if (this.currentRecipe != null) {
            for (Renderable widget : this.f_169369_) {
                if (!(widget instanceof AbstractWidget) || this.relatedTabs.contains(widget)) continue;
                ((AbstractWidget)widget).f_93623_ = false;
            }
            for (Renderable widget : (Collection)this.pageWidgets.getOrDefault(this.page, new ArrayList())) {
                if (!(widget instanceof AbstractWidget) || this.relatedTabs.contains(widget)) continue;
                widget.f_93623_ = false;
                widget.f_93624_ = false;
            }
            for (Renderable widget : (Collection)this.pageWidgets.getOrDefault(this.page + 1, new ArrayList())) {
                if (!(widget instanceof AbstractWidget) || this.relatedTabs.contains(widget)) continue;
                widget.f_93623_ = false;
                widget.f_93624_ = false;
            }
            this.m_142416_((GuiEventListener)this.currentRecipe);
            this.m_142416_((GuiEventListener)this.closeRecipe);
            this.m_142416_((GuiEventListener)this.pinRecipe);
        }
    }

    private void clearDisplayedRecipe(boolean pushBreadcrumb) {
        if (this.currentRecipe == null) {
            return;
        }
        if (pushBreadcrumb) {
            CodexBreadcrumb lastBreadcrumb = this.progression.peekCodexBreadcrumb();
            if (lastBreadcrumb.Type == CodexBreadcrumb.Type.RECIPE) {
                this.progression.popCodexBreadcrumb();
            }
            this.pushBreadcrumb(CodexBreadcrumb.Type.RECIPE, this.currentRecipe.getRegistryName().toString(), Arrays.asList(this.currentRecipe.getRecipeIds()).stream().map(rLoc -> rLoc.toString()).collect(Collectors.toList()).toArray(new String[0]));
        }
        this.m_169411_((GuiEventListener)this.currentRecipe);
        this.m_169411_((GuiEventListener)this.closeRecipe);
        this.m_169411_((GuiEventListener)this.pinRecipe);
        for (Renderable widget : this.f_169369_) {
            if (!(widget instanceof AbstractWidget)) continue;
            ((AbstractWidget)widget).f_93623_ = true;
        }
        for (Renderable widget : (Collection)this.pageWidgets.getOrDefault(this.page, new ArrayList())) {
            if (!(widget instanceof AbstractWidget) || this.relatedTabs.contains(widget)) continue;
            widget.f_93623_ = true;
            widget.f_93624_ = true;
        }
        for (Renderable widget : (Collection)this.pageWidgets.getOrDefault(this.page + 1, new ArrayList())) {
            if (!(widget instanceof AbstractWidget) || this.relatedTabs.contains(widget)) continue;
            widget.f_93623_ = true;
            widget.f_93624_ = true;
        }
        this.currentRecipe = null;
    }

    private void lookupAndShowRecipe(String recipeId, boolean pushBreadcrumb) {
        ResourceLocation search = new ResourceLocation(recipeId);
        for (Map.Entry<String, GuidebookEntry> e : GuideBookEntries.INSTANCE.getAllEntries()) {
            for (RelatedRecipe rr : e.getValue().getRelatedRecipes()) {
                for (ResourceLocation s : rr.getResourceLocations()) {
                    if (!s.equals((Object)search)) continue;
                    this.displayRecipe(rr, pushBreadcrumb);
                    return;
                }
            }
        }
    }

    private void decrementPage() {
        if (this.hasOverlay()) {
            return;
        }
        this.page -= 2;
        if (this.max_pages > 1) {
            this.nextPage.f_93624_ = true;
            this.nextPage.f_93623_ = true;
        }
        if (this.page <= 0) {
            this.page = 0;
            this.prevPage.f_93624_ = false;
            this.prevPage.f_93623_ = false;
        }
    }

    private void incrementPage() {
        if (this.hasOverlay()) {
            return;
        }
        this.page += 2;
        if (this.max_pages > 1) {
            this.prevPage.f_93624_ = true;
            this.prevPage.f_93623_ = true;
        }
        if (this.page >= this.max_pages - 1) {
            this.page = this.max_pages - 1;
            if (this.page % 2 == 1) {
                ++this.page;
            }
            this.nextPage.f_93624_ = false;
            this.nextPage.f_93623_ = false;
        }
    }

    private void pushCategoryBreadcrumb() {
        if (this.currentCategory != null && this.currentRecipe == null && !this.isSearching) {
            String key = this.currentCategory.getId();
            this.pushBreadcrumb(CodexBreadcrumb.Type.CATEGORY, key, new String[0]);
        }
    }

    private void pushBreadcrumb(CodexBreadcrumb.Type type, String key, String ... metadata) {
        this.progression.pushCodexBreadcrumb(type, key, this.page, metadata);
    }

    private void displayBreadcrumb(boolean peek) {
        CodexBreadcrumb breadcrumb;
        CodexBreadcrumb codexBreadcrumb = breadcrumb = peek ? this.progression.peekCodexBreadcrumb() : this.progression.popCodexBreadcrumb();
        if (breadcrumb == null) {
            this.setupIndexView(false, 0);
            return;
        }
        this.clearDisplayedRecipe(false);
        this.clearSearch(false);
        switch (breadcrumb.Type) {
            case ENTRY: {
                this.setCurrentEntry(breadcrumb.Key, false);
                break;
            }
            case RECIPE: {
                this.lookupAndShowRecipe(breadcrumb.Key, false);
                break;
            }
            case SEARCH: {
                this.showSearch(false);
                this.searchBox.m_94144_(breadcrumb.Key);
                break;
            }
            case CATEGORY: {
                try {
                    this.setupCategoryView(EntryCategory.valueOf(breadcrumb.Key), breadcrumb.Page, false);
                    this.setupIndexView(false, breadcrumb.Page);
                }
                catch (Throwable t) {
                    this.setupIndexView(false, 0);
                }
                break;
            }
            case INDEX: {
                this.setupIndexView(false, breadcrumb.Page);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void setupIndexView(boolean pushBreadcrumb, int page) {
        if (pushBreadcrumb) {
            this.pushCategoryBreadcrumb();
        }
        this.currentEntry = null;
        this.clearRelatedTabs();
        this.setupCategorySelectionButtons();
        this.setupCategoryItemButtons();
        this.setupCategoryView(this.currentCategory, page, false);
        this.pageWidgets.clear();
    }

    private void setupCategoryView(EntryCategory value, boolean pushBreadcrumb) {
        this.setupCategoryView(value, 0, pushBreadcrumb);
    }

    private void setupCategoryView(EntryCategory value, int page, boolean pushBreadcrumb) {
        if (pushBreadcrumb) {
            this.pushCategoryBreadcrumb();
        }
        int playerTier = this.progression.getTier();
        this.max_pages = 1;
        this.categoryButtons.forEach(c -> {
            c.f_93624_ = c.f_93623_ = c.category == value && c.tier <= playerTier;
            if (c.f_93623_) {
                this.max_pages = Math.max(this.max_pages, c.page);
            }
        });
        this.prevPage.f_93623_ = page > 0;
        this.prevPage.f_93624_ = this.prevPage.f_93623_;
        this.page = Mth.m_14045_((int)page, (int)0, (int)this.max_pages);
        if (this.max_pages > 1) {
            this.nextPage.f_93624_ = true;
            this.nextPage.f_93623_ = true;
        } else {
            this.nextPage.f_93624_ = false;
            this.nextPage.f_93623_ = false;
        }
        this.back.f_93624_ = false;
        this.back.f_93623_ = false;
        this.currentCategory = value;
    }

    private void setCurrentEntry(String id, boolean pushBreadcrumb) {
        if (pushBreadcrumb) {
            this.pushCategoryBreadcrumb();
        }
        this.hideCategoryView();
        this.clearRelatedTabs();
        this.currentEntry = GuideBookEntries.INSTANCE.getEntry(id);
        this.currentEntry.setRead();
        this.setupEntryRelatedButtons();
        this.setupEntryPages();
        this.page = 0;
    }

    private void hideCategoryView() {
        this.categoryButtons.forEach(c -> {
            c.f_93624_ = false;
            c.f_93623_ = false;
        });
        this.back.f_93624_ = true;
        this.back.f_93623_ = true;
    }

    private void setupCategoryItemButtons() {
        for (CategoryItemButton catBtn : this.categoryButtons) {
            this.m_169411_((GuiEventListener)catBtn);
        }
        this.categoryButtons.clear();
        for (EntryCategory value : EntryCategory.values()) {
            int x = this.f_97735_ + 15;
            int y = this.f_97736_ + 10 + 20;
            int y_max = this.f_97736_ + 168;
            int render_page = 0;
            int entryCount = 1;
            String entryPrefix = "* ";
            List entries = GuideBookEntries.INSTANCE.getEntries(value).stream().collect(Collectors.toList());
            Collections.sort(entries, new Comparator<GuidebookEntry>(){

                @Override
                public int compare(GuidebookEntry o1, GuidebookEntry o2) {
                    Integer index2;
                    Integer index1 = o1.getIndex();
                    if (index1 == (index2 = Integer.valueOf(o2.getIndex()))) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return index1.compareTo(index2);
                }
            });
            for (GuidebookEntry e : entries) {
                if (e.getTier() > this.progression.getTier()) continue;
                Object disp = I18n.m_118938_((String)e.getFirstTitle(), (Object[])new Object[0]);
                if (!e.isRead()) {
                    disp = entryPrefix + (String)disp;
                }
                int countWidth = this.f_96547_.m_92895_(" " + entryCount);
                List split_lines = this.f_96547_.m_92865_().m_92432_((String)disp, 108 - countWidth, Style.f_131099_);
                disp = ((FormattedText)split_lines.get(split_lines.size() - 1)).getString();
                char spacer = '.';
                int width = this.f_96547_.m_92895_((String)disp);
                int padding = 15 - countWidth;
                int spacerWidth = this.f_96547_.m_92895_("" + spacer);
                int nonPaddedWidth = 108 - countWidth - padding;
                int requiredPaddingWidth = nonPaddedWidth - width;
                int numSpacers = 0;
                if (nonPaddedWidth > 0 && requiredPaddingWidth > spacerWidth) {
                    numSpacers = requiredPaddingWidth / spacerWidth;
                }
                if (numSpacers > 0) {
                    char[] spacers = new char[numSpacers];
                    Arrays.fill(spacers, spacer);
                    disp = (String)disp + String.copyValueOf(spacers);
                }
                split_lines.set(split_lines.size() - 1, Component.m_237113_((String)disp));
                ArrayList<Component> split_lines_cast = new ArrayList<Component>();
                for (FormattedText split : split_lines) {
                    String s = split.getString();
                    if (s.startsWith(entryPrefix)) {
                        split_lines_cast.add((Component)Component.m_237113_((String)entryPrefix).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)s.substring(2)).m_130940_(ChatFormatting.BLACK)));
                        continue;
                    }
                    split_lines_cast.add((Component)Component.m_237113_((String)s));
                }
                CategoryItemButton btn = new CategoryItemButton(value, render_page, entryCount, x, y, e, split_lines_cast, button -> {
                    this.hideCategoryView();
                    this.setCurrentEntry(e.getName(), true);
                });
                if (y + btn.m_93694_() > y_max) {
                    y = this.f_97736_ + 10 + 20;
                    x = ++render_page % 2 == 1 ? this.f_97735_ + 133 : this.f_97735_ + 15;
                    btn.m_252865_(x);
                    btn.m_253211_(y);
                    btn.page = render_page;
                }
                this.m_142416_((GuiEventListener)btn);
                this.categoryButtons.add(btn);
                y += btn.m_93694_();
                ++entryCount;
            }
        }
    }

    private void clearRelatedTabs() {
        for (ImageButton btn : this.relatedTabs) {
            this.m_169411_((GuiEventListener)btn);
        }
    }

    private void setupEntryPages() {
        this.max_pages = 1;
        this.pageWidgets.entrySet().forEach(e -> ((Collection)e.getValue()).forEach(widget -> this.m_169411_((GuiEventListener)widget)));
        this.pageWidgets.clear();
        if (this.currentEntry != null) {
            int x = 15;
            int y = 10;
            int page = -1;
            for (IEntrySection section : this.currentEntry.getSections().stream().sorted((a, b) -> b.getPage() - a.getPage()).collect(Collectors.toList())) {
                if (section.getPage() > this.max_pages) {
                    this.max_pages = section.getPage();
                }
                if (page != section.getPage()) {
                    page = section.getPage();
                    y = this.f_97736_ + 10;
                    x = this.f_97735_ + (page % 2 == 0 ? 15 : 133);
                }
                ArrayList<AbstractWidget> curPageWidgets = this.pageWidgets.getOrDefault(section.getPage(), new ArrayList());
                curPageWidgets.addAll(section.getWidgets(this, x, y, 108, 168, this::setTooltip, this::lookupAndShowRecipe, this::setCurrentEntry));
                this.pageWidgets.put(section.getPage(), curPageWidgets);
                y += section.getHeight(168);
            }
        }
        this.prevPage.f_93624_ = false;
        this.prevPage.f_93623_ = false;
        if (this.max_pages > 1) {
            this.nextPage.f_93624_ = true;
            this.nextPage.f_93623_ = true;
        } else {
            this.nextPage.f_93624_ = false;
            this.nextPage.f_93623_ = false;
        }
    }

    private void setupCategorySelectionButtons() {
        int step = 19;
        int x = this.f_97735_ + this.f_97726_ - 7;
        int y = this.f_97736_ + 4;
        int x_custom = this.f_97735_ + this.f_97726_ - step - 7;
        int y_custom = this.f_97736_ + this.f_97727_ - 4;
        for (EntryCategory value : EntryCategory.values()) {
            ItemStack stack;
            boolean entryShown = false;
            List entries = GuideBookEntries.INSTANCE.getEntries(value).stream().collect(Collectors.toList());
            for (GuidebookEntry e : entries) {
                if (e.getTier() > this.progression.getTier()) continue;
                entryShown = true;
                break;
            }
            if (!entryShown || (stack = value.getDisplayStack()).m_41619_()) continue;
            int width = value.isCustom() ? 18 : 28;
            int height = value.isCustom() ? 28 : 18;
            int u = value.isCustom() ? 208 : 28;
            int v = value.isCustom() ? 0 : 54;
            int hoverOffset = height;
            ImageItemStackButton btn = new ImageItemStackButton(value.isCustom() ? x_custom : x, value.isCustom() ? y_custom : y, width, height, u, v, hoverOffset, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> this.setupCategoryView(value, true), this::setTooltip, stack, false);
            this.m_142416_((GuiEventListener)btn);
            this.relatedTabs.add(btn);
            if (value.isCustom()) {
                x_custom -= step;
                continue;
            }
            y += step;
        }
    }

    private void setupEntryRelatedButtons() {
        if (this.currentEntry == null) {
            return;
        }
        int i = this.f_97735_;
        int j = this.f_97736_;
        int x = i + this.f_97726_ - 7;
        int y = j + 5;
        int y_step = 19;
        if (this.currentEntry.getRelatedRecipes().size() > 0) {
            y_step = Math.min(20, 170 / this.currentEntry.getRelatedRecipes().size());
        }
        int playerTier = this.progression.getTier();
        for (RelatedRecipe rr : this.currentEntry.getRelatedRecipes()) {
            if (rr.getTier() > playerTier) continue;
            if (rr.getType().equals("spell_part")) {
                ISpellComponent part = this.lookupSpell(rr.getResourceLocations()[0]);
                if (part == null) continue;
                btn = new ImageSpellPartButton(x, y, 28, 18, 56, 0, 18, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> this.displayRecipe(rr, true), part.getGuiIcon(), part.getRegistryName());
                this.m_142416_((GuiEventListener)btn);
                this.relatedTabs.add(btn);
            } else {
                Optional pattern;
                ItemStack stack = this.lookupResource(rr.getResourceLocations()[0]);
                if (stack.m_41619_() && (pattern = this.f_96541_.f_91073_.m_7465_().m_44043_(rr.getResourceLocations()[0])).isPresent()) {
                    stack = pattern.get() instanceof AMRecipeBase ? ((AMRecipeBase)pattern.get()).getGuiRepresentationStack() : ((Recipe)pattern.get()).m_8043_(this.f_96541_.f_91073_.m_9598_());
                }
                if (!stack.m_41619_()) {
                    btn = new ImageItemStackButton(x, y, 28, 18, 56, 0, 18, GuiTextures.Items.GUIDE_BOOK_WIDGETS, 256, 256, button -> this.displayRecipe(rr, true), this::setTooltip, stack);
                    this.m_142416_((GuiEventListener)btn);
                    this.relatedTabs.add(btn);
                }
            }
            y += y_step;
        }
    }

    private boolean hasOverlay() {
        return this.isSearching || this.currentRecipe != null;
    }

    public void m_7379_() {
        if (this.isSearching) {
            this.pushBreadcrumb(CodexBreadcrumb.Type.SEARCH, this.searchBox.m_94155_(), new String[0]);
        } else if (this.currentRecipe != null) {
            this.pushBreadcrumb(CodexBreadcrumb.Type.RECIPE, this.currentRecipe.getRegistryName().toString(), new String[0]);
        } else if (this.currentEntry != null) {
            this.pushBreadcrumb(CodexBreadcrumb.Type.ENTRY, this.currentEntry.getName(), new String[0]);
        } else if (this.currentCategory != null) {
            this.pushBreadcrumb(CodexBreadcrumb.Type.CATEGORY, this.currentCategory.name(), new String[0]);
        }
        ManaAndArtifice.instance.proxy.playSingleSound(SFX.Gui.BOOK_CLOSE);
        super.m_7379_();
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTick) {
        currentTooltip.clear();
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTick);
        if (this.isSearching) {
            this.fixFocus("focus", "focus");
        }
        ((Collection)this.pageWidgets.getOrDefault(this.page, new ArrayList())).forEach(w -> w.m_88315_(pGuiGraphics, mouseX, mouseY, partialTick));
        ((Collection)this.pageWidgets.getOrDefault(this.page + 1, new ArrayList())).forEach(w -> w.m_88315_(pGuiGraphics, mouseX, mouseY, partialTick));
        if (!currentTooltip.isEmpty()) {
            pGuiGraphics.m_280245_(this.f_96547_, Lists.transform(currentTooltip, Component::m_7532_), mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(pGuiGraphics);
        int i = this.f_97735_;
        int j = this.f_97736_;
        pGuiGraphics.m_280218_(GuiTextures.Items.GUIDE_BOOK, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        if (this.currentRecipe != null || this.isSearching) {
            return;
        }
        if (this.currentEntry == null) {
            this.renderIndex(pGuiGraphics);
        }
    }

    private void renderIndex(GuiGraphics pGuiGraphics) {
        String str = this.currentCategory.getDisplayStack().m_41786_().getString();
        int padding = (108 - this.f_96541_.f_91062_.m_92895_(str)) / 2;
        pGuiGraphics.m_280056_(this.f_96547_, str, 15 + padding, 15, 0x404040, false);
    }

    private void setTooltip(List<Component> tooltip) {
        currentTooltip.clear();
        currentTooltip.addAll(tooltip);
    }

    public class PaperImageButton
    extends ImageButton {
        private Component tooltip;

        public PaperImageButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, Button.OnPress onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, onPressIn);
        }

        public PaperImageButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, int p_i51136_9_, int p_i51136_10_, Button.OnPress onPressIn, Component textIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, p_i51136_9_, p_i51136_10_, onPressIn, textIn);
        }

        public PaperImageButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, int p_i51135_9_, int p_i51135_10_, Button.OnPress onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, p_i51135_9_, p_i51135_10_, onPressIn);
        }

        public PaperImageButton setTooltip(Component tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public void m_87963_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.m_87963_(pGuiGraphics, mouseX, mouseY, partialTicks);
            if (this.f_93623_ && this.f_93624_ && this.m_198029_() && this.tooltip != null) {
                currentTooltip.add(this.tooltip);
            }
        }

        public void m_7435_(SoundManager soundHandler) {
            soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }
    }

    public class CodexSearchResult
    extends Button {
        private List<FormattedText> split_lines;

        public CodexSearchResult(int x, int y, String text, Button.OnPress pressedAction) {
            Objects.requireNonNull(GuiGuideBook.this.f_96547_);
            super(x, y, 205, 9 * GuiGuideBook.this.f_96547_.m_92865_().m_92414_((FormattedText)Component.m_237113_((String)text), 200, Style.f_131099_).size(), (Component)Component.m_237113_((String)text), pressedAction, f_252438_);
            this.split_lines = GuiGuideBook.this.f_96547_.m_92865_().m_92414_((FormattedText)Component.m_237113_((String)text), 200, Style.f_131099_);
        }

        public void m_87963_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontrenderer = minecraft.f_91062_;
            int renderY = this.m_252907_();
            for (FormattedText props : this.split_lines) {
                pGuiGraphics.m_280056_(fontrenderer, props.getString(), this.m_252754_(), renderY, this.getFGColor(), false);
                Objects.requireNonNull(minecraft.f_91062_);
                renderY += 9;
            }
        }

        public int getFGColor() {
            return this.m_198029_() ? 0xB300B3 : 0x444444;
        }
    }

    public class CategoryItemButton
    extends Button {
        public int page;
        public final EntryCategory category;
        private final String count;
        private final int tier;
        private final int overrideColor;
        private final List<Component> tooltipLines;
        private final List<Component> textLines;

        public CategoryItemButton(EntryCategory category, int page, int count, int x, int y, GuidebookEntry entry, List<Component> text, Button.OnPress onPress) {
            Objects.requireNonNull(((GuiGuideBook)GuiGuideBook.this).f_96541_.f_91062_);
            super(x, y, 108, 9 * text.size() + 5, text.get(0), onPress, f_252438_);
            this.page = page;
            this.category = category;
            this.count = "" + count;
            this.textLines = text;
            this.tier = entry.getTier();
            this.overrideColor = entry.getOverrideColor();
            this.tooltipLines = entry.getTooltip();
        }

        public void setPage(int page) {
            this.page = page;
        }

        public void m_7435_(SoundManager soundHandler) {
            soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }

        public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (GuiGuideBook.this.page == this.page || GuiGuideBook.this.page == this.page - 1) {
                super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
            }
        }

        protected boolean m_93680_(double mouseX, double mouseY) {
            return (this.page == GuiGuideBook.this.page || this.page - 1 == GuiGuideBook.this.page) && this.f_93623_ && this.f_93624_ && mouseX >= (double)this.m_252754_() && mouseY >= (double)this.m_252907_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY < (double)(this.m_252907_() + this.f_93619_);
        }

        public void m_87963_(GuiGraphics pGuiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontrenderer = minecraft.f_91062_;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            int j = this.getFGColor();
            int renderY = this.m_252907_();
            for (FormattedText formattedText : this.textLines) {
                int color = j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24;
                int xOffset = 0;
                if (formattedText instanceof MutableComponent) {
                    MutableComponent mutableComponent = (MutableComponent)formattedText;
                    for (Component c : mutableComponent.m_240407_()) {
                        if (c.m_7383_().m_131135_() != null) {
                            color = c.m_7383_().m_131135_().m_131265_();
                        }
                        if (color == 0) {
                            pGuiGraphics.m_280056_(fontrenderer, c.getString(), this.m_252754_() + xOffset, renderY, j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24, false);
                            continue;
                        }
                        pGuiGraphics.m_280614_(fontrenderer, c, this.m_252754_() + xOffset, renderY, color | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24, false);
                        xOffset += fontrenderer.m_92852_((FormattedText)c);
                    }
                } else {
                    pGuiGraphics.m_280056_(fontrenderer, formattedText.getString(), this.m_252754_(), renderY, color, false);
                }
                Objects.requireNonNull(minecraft.f_91062_);
                renderY += 9;
            }
            Objects.requireNonNull(minecraft.f_91062_);
            pGuiGraphics.m_280056_(fontrenderer, this.count, this.m_252754_() + this.f_93618_ - fontrenderer.m_92895_(this.count), renderY -= 9, j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24, false);
            if (this.tooltipLines != null && this.f_93622_) {
                GuiGuideBook.this.setTooltip(this.tooltipLines);
            }
        }

        public int getFGColor() {
            if (this.f_93622_ && this.f_93623_) {
                return 0xB300B3;
            }
            return this.overrideColor == -1 ? 0x444444 : this.overrideColor;
        }
    }

    public class ImageSpellPartButton
    extends ImageButton {
        final ResourceLocation spellTexture;
        final String translateKey;

        public ImageSpellPartButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int hoverOffset, ResourceLocation textureFile, int texWidth, int texHeight, Button.OnPress clickHandler, ResourceLocation spellTexture, ResourceLocation spellName) {
            super(x, y, width, height, xTexStart, yTexStart, hoverOffset, textureFile, texWidth, texHeight, clickHandler, (Component)Component.m_237113_((String)""));
            this.spellTexture = spellTexture;
            this.translateKey = spellName.toString();
        }

        public void m_87963_(GuiGraphics pGuiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            super.m_87963_(pGuiGraphics, p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
            RenderSystem.disableDepthTest();
            pGuiGraphics.m_280163_(this.spellTexture, this.m_252754_() + 3, this.m_252907_() + 1, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.enableDepthTest();
            if (this.f_93623_ && this.f_93622_) {
                ArrayList<Component> tt = new ArrayList<Component>();
                tt.add((Component)Component.m_237115_((String)this.translateKey));
                currentTooltip = tt;
            }
        }

        public void m_7435_(SoundManager soundHandler) {
            soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }
    }
}

