/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.containers.slots;

import com.mna.gui.containers.slots.BaseSlot;
import com.mna.items.filters.ItemFilter;
import com.mna.items.filters.ItemFilterGroup;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

public class ItemFilterSlot
extends BaseSlot {
    private ItemFilterGroup itemType;
    private int maxStackSize = -1;
    private Consumer<Integer> changedCallback;
    private boolean active = true;

    public ItemFilterSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, ItemFilter validItems) {
        super(itemHandler, index, xPosition, yPosition);
        this.itemType = new ItemFilterGroup(validItems);
    }

    public ItemFilterSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, ItemFilterGroup validItems) {
        super(itemHandler, index, xPosition, yPosition);
        this.itemType = validItems;
    }

    public ItemFilterSlot setMaxStackSize(int stackSize) {
        this.maxStackSize = stackSize;
        return this;
    }

    public int m_6641_() {
        return this.maxStackSize > 0 ? this.maxStackSize : super.m_6641_();
    }

    public int m_5866_(ItemStack stack) {
        return this.maxStackSize > 0 ? this.maxStackSize : super.m_5866_(stack);
    }

    @Override
    public boolean m_5857_(ItemStack stack) {
        boolean valid = this.itemType.anyMatchesFilter(stack);
        return valid;
    }

    public void addChangeListener(Consumer<Integer> callback) {
        this.changedCallback = callback;
    }

    public void m_6654_() {
        super.m_6654_();
        if (this.changedCallback != null) {
            this.changedCallback.accept(this.getSlotIndex());
        }
    }

    public ItemStack m_6201_(int amount) {
        if (this.changedCallback != null) {
            this.changedCallback.accept(this.getSlotIndex());
        }
        return super.m_6201_(amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6659_() {
        return this.active;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setActive(boolean active) {
        this.active = active;
    }
}

