/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.containers.block;

import com.mna.blocks.tileentities.wizard_lab.MagiciansWorkbenchTile;
import com.mna.gui.containers.ContainerInit;
import com.mna.gui.containers.slots.SlotMagiciansWorkbenchOutput;
import com.mna.network.ClientMessageDispatcher;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class ContainerMagiciansWorkbench
extends RecipeBookMenu<CraftingContainer> {
    private final MagiciansWorkbenchTile table;
    public static int SIZE = 18;
    public static int INVENTORY_STORAGE_START = 0;
    public static int INVENTORY_STORAGE_END = 17;
    public static int FIRST_CRAFT_GRID_START = 18;
    public static int FIRST_OUTPUT_SLOT = 27;
    public static int SECOND_CRAFT_GRID_START = 28;
    public static int SECOND_OUTPUT_SLOT = 37;
    public static int PLAYER_INVENTORY_START = 38;
    public static int PLAYER_ACTION_BAR_START = 65;
    public static int PLAYER_ACTION_BAR_END = 73;
    public CraftingContainer firstCraftMatrix;
    public CraftingContainer secondCraftMatrix;
    private Inventory playerInv;
    private boolean initializing;

    public ContainerMagiciansWorkbench(int i, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(i, playerInventory, ((MagiciansWorkbenchTile)playerInventory.f_35978_.m_9236_().m_7702_(packetBuffer.m_130135_())).readFrom(packetBuffer));
    }

    public ContainerMagiciansWorkbench(int windowId, Inventory playerInventory, MagiciansWorkbenchTile inventory) {
        super((MenuType)ContainerInit.MAGICIANS_WORKBENCH.get(), windowId);
        int j;
        int i;
        int ypos;
        int xpos;
        this.table = inventory;
        this.playerInv = playerInventory;
        inventory.m_5856_(playerInventory.f_35978_);
        this.firstCraftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
        this.secondCraftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
        this.updateCraftingMatrices();
        int slotIndex = 0;
        for (xpos = 0; xpos < 3; ++xpos) {
            for (ypos = 0; ypos < 6; ++ypos) {
                this.m_38897_(new Slot((Container)this.table, slotIndex++, 196 + xpos * 18, 8 + ypos * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.firstCraftMatrix, j + i * 3, 67 + j * 20, 11 + i * 20));
            }
        }
        this.m_38897_(new SlotMagiciansWorkbenchOutput(playerInventory.f_35978_, (Container)this.firstCraftMatrix, (Container)this.table.firstResultInv, this, 0, 87, 91));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.secondCraftMatrix, j + i * 3, 133 + j * 20, 11 + i * 20));
            }
        }
        this.m_38897_(new SlotMagiciansWorkbenchOutput(playerInventory.f_35978_, (Container)this.secondCraftMatrix, (Container)this.table.secondResultInv, this, 0, 153, 91));
        for (xpos = 0; xpos < 9; ++xpos) {
            for (ypos = 0; ypos < 3; ++ypos) {
                this.m_38897_(new Slot((Container)playerInventory, xpos + ypos * 9 + 9, 48 + xpos * 18, 121 + ypos * 18));
            }
        }
        for (xpos = 0; xpos < 9; ++xpos) {
            this.m_38897_(new Slot((Container)playerInventory, xpos, 48 + xpos * 18, 179));
        }
    }

    public void updateCraftingMatrices() {
        this.initializing = true;
        for (int i = 0; i < 9; ++i) {
            this.firstCraftMatrix.m_6836_(i, this.table.m_8020_(i + FIRST_CRAFT_GRID_START));
            this.secondCraftMatrix.m_6836_(i, this.table.m_8020_(i + SECOND_CRAFT_GRID_START));
        }
        this.initializing = false;
    }

    public boolean m_6875_(Player playerIn) {
        return this.table.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == FIRST_OUTPUT_SLOT || index == SECOND_OUTPUT_SLOT) {
                itemstack1.m_41720_().m_7836_(itemstack1, this.table.m_58904_(), playerIn);
                if (!this.m_38903_(itemstack1, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_END, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index >= PLAYER_INVENTORY_START && index < PLAYER_ACTION_BAR_END ? !this.m_38903_(itemstack1, INVENTORY_STORAGE_START, FIRST_CRAFT_GRID_START, false) && (index < PLAYER_ACTION_BAR_START ? !this.m_38903_(itemstack1, PLAYER_ACTION_BAR_START, PLAYER_ACTION_BAR_END, false) : !this.m_38903_(itemstack1, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_START, false)) : (index >= FIRST_CRAFT_GRID_START && index < FIRST_OUTPUT_SLOT ? !this.m_38903_(itemstack1, INVENTORY_STORAGE_START, FIRST_CRAFT_GRID_START, false) && !this.m_38903_(itemstack1, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_END, false) : (index >= SECOND_CRAFT_GRID_START && index < SECOND_OUTPUT_SLOT ? !this.m_38903_(itemstack1, INVENTORY_STORAGE_START, FIRST_CRAFT_GRID_START, false) && !this.m_38903_(itemstack1, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_END, false) : !this.m_38903_(itemstack1, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_END, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
            if (index == 0) {
                playerIn.m_36176_(itemstack1, false);
            }
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.table.m_5785_(playerIn);
    }

    public void m_6199_(Container p_75130_1_) {
        this.updateCraftingResult(this.f_38840_, this.table.m_58904_(), this.playerInv.f_35978_, this.firstCraftMatrix, this.table.firstResultInv, FIRST_OUTPUT_SLOT);
        this.updateCraftingResult(this.f_38840_, this.table.m_58904_(), this.playerInv.f_35978_, this.secondCraftMatrix, this.table.secondResultInv, SECOND_OUTPUT_SLOT);
        if (!this.initializing) {
            for (int i = 0; i < 9; ++i) {
                this.table.m_6836_(i + FIRST_CRAFT_GRID_START, this.firstCraftMatrix.m_8020_(i));
                this.table.m_6836_(i + SECOND_CRAFT_GRID_START, this.secondCraftMatrix.m_8020_(i));
            }
        }
        this.m_38946_();
    }

    protected boolean m_38903_(ItemStack stack, int source, int dest, boolean loop) {
        return super.m_38903_(stack, source, dest, loop);
    }

    protected void updateCraftingResult(int id, Level world, Player player, CraftingContainer inventory, ResultContainer inventoryResult, int syncSlot) {
        if (!world.f_46443_) {
            CraftingRecipe icraftingrecipe;
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.f_41583_;
            Optional optional = world.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)inventory, world);
            if (optional.isPresent() && inventoryResult.m_40135_(world, serverplayerentity, (Recipe)(icraftingrecipe = (CraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.m_5874_((Container)inventory, world.m_9598_());
            }
            inventoryResult.m_6836_(0, itemstack);
            serverplayerentity.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(id, this.m_182425_(), syncSlot, itemstack));
        }
    }

    public MagiciansWorkbenchTile getWorkbench() {
        return this.table;
    }

    private StackedContents getStackedContents() {
        StackedContents stackedContents = new StackedContents();
        for (int i = INVENTORY_STORAGE_START; i <= INVENTORY_STORAGE_END; ++i) {
            stackedContents.m_36466_(this.table.m_8020_(i));
        }
        return stackedContents;
    }

    public boolean hasComponents(int recipeIndex) {
        MagiciansWorkbenchTile.RememberedRecipe remembered = this.table.getRememberedRecipeItems().get(recipeIndex);
        StackedContents contents = this.getStackedContents();
        return contents.m_36475_((Recipe)remembered.getRecipe(this.table.m_58904_()), (IntList)null);
    }

    private void setRecipeItemsToGrid(int recipeIndex) {
        MagiciansWorkbenchTile.RememberedRecipe recipe = this.table.getRememberedRecipeItems().get(recipeIndex);
        int count = 0;
        int startSlot = -1;
        if (this.craftingGridIsEmpty(true)) {
            startSlot = SECOND_CRAFT_GRID_START;
        } else if (this.craftingGridIsEmpty(false)) {
            startSlot = FIRST_CRAFT_GRID_START;
        }
        if (startSlot == -1) {
            return;
        }
        CraftingRecipe craftingRecipe = recipe.getRecipe(this.table.m_58904_());
        if (craftingRecipe == null) {
            return;
        }
        if (craftingRecipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)craftingRecipe;
            Ingredient[] ingreds = recipe.getComponents(this.table.m_58904_());
            block0: for (int j = 0; j < shapedRecipe.m_44221_(); ++j) {
                for (int i = 0; i < shapedRecipe.m_44220_(); ++i) {
                    int idx = i + j * shapedRecipe.m_44220_();
                    int slotIdx = i + j * this.m_6635_();
                    Slot slot = this.m_38853_(startSlot + slotIdx);
                    Ingredient ingredient = ingreds[idx];
                    if (!ingredient.m_43947_()) {
                        int ingredSlot = this.getSlotForIngredient(ingredient);
                        if (ingredSlot == -1) continue block0;
                        ItemStack existing = this.m_38853_(ingredSlot).m_7993_();
                        ItemStack copyStack = existing.m_41777_();
                        existing.m_41774_(1);
                        copyStack.m_41764_(1);
                        slot.m_5852_(copyStack);
                        continue;
                    }
                    slot.m_5852_(ItemStack.f_41583_);
                }
            }
        } else {
            for (Ingredient ingred : recipe.getComponents(this.table.m_58904_())) {
                Slot slot = this.m_38853_(startSlot + count);
                if (!ingred.m_43947_()) {
                    int ingredSlot = this.getSlotForIngredient(ingred);
                    if (ingredSlot == -1) break;
                    ItemStack existing = this.m_38853_(ingredSlot).m_7993_();
                    ItemStack copyStack = existing.m_41777_();
                    existing.m_41774_(1);
                    copyStack.m_41764_(1);
                    slot.m_5852_(copyStack);
                } else {
                    slot.m_5852_(ItemStack.f_41583_);
                }
                slot.m_6654_();
                ++count;
            }
        }
    }

    private int getSlotForIngredient(Ingredient ingred) {
        for (int i = INVENTORY_STORAGE_START; i <= INVENTORY_STORAGE_END; ++i) {
            if (!ingred.test(this.m_38853_(i).m_7993_())) continue;
            return i;
        }
        return -1;
    }

    public boolean gridIsFreeFor(int recipeIndex) {
        return this.craftingGridIsEmpty(false) || this.craftingGridIsEmpty(true);
    }

    public void tryClearGrid(boolean second) {
        if (this.table.m_58904_().m_5776_()) {
            ClientMessageDispatcher.sendMagiciansWorkbenchClearMessage(second);
            return;
        }
        int startIndex = second ? SECOND_CRAFT_GRID_START : FIRST_CRAFT_GRID_START;
        for (int i = 0; i < 9; ++i) {
            ItemStack gridStack = this.table.m_8020_(i + startIndex);
            if (gridStack.m_41619_() || !this.m_38903_(gridStack, INVENTORY_STORAGE_START, INVENTORY_STORAGE_END, true) && !this.m_38903_(gridStack, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_END, false)) continue;
            this.table.m_6836_(i + startIndex, ItemStack.f_41583_);
        }
        this.updateCraftingMatrices();
        this.m_6199_(this.table);
        this.m_38946_();
    }

    public boolean craftingGridIsEmpty(boolean second) {
        int startSlot = second ? SECOND_CRAFT_GRID_START : FIRST_CRAFT_GRID_START;
        for (int i = 0; i < 9; ++i) {
            if (this.getWorkbench().m_8020_(startSlot + i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void moveRecipeToCraftingGrid(int recipeIndex) {
        if (this.table.getRememberedRecipeItems().size() <= recipeIndex) {
            return;
        }
        if (!this.gridIsFreeFor(recipeIndex) || this.isRecipeAlreadyInGrid(recipeIndex)) {
            return;
        }
        if (this.table.m_58904_().m_5776_()) {
            ClientMessageDispatcher.sendMagiciansWorkbenchRecipeSetMessage(recipeIndex);
            return;
        }
        if (this.hasComponents(recipeIndex)) {
            this.setRecipeItemsToGrid(recipeIndex);
            this.updateCraftingMatrices();
            this.m_6199_(this.table);
            this.m_38946_();
        }
    }

    public boolean isRecipeAlreadyInGrid(int recipeIndex) {
        if (this.table.getRememberedRecipeItems().size() <= recipeIndex) {
            return false;
        }
        MagiciansWorkbenchTile.RememberedRecipe recipe = this.table.getRememberedRecipeItems().get(recipeIndex);
        if (ItemStack.m_150942_((ItemStack)this.getWorkbench().firstResultInv.m_8020_(0), (ItemStack)recipe.getOutput(this.table.m_58904_()))) {
            return true;
        }
        return ItemStack.m_150942_((ItemStack)this.getWorkbench().secondResultInv.m_8020_(0), (ItemStack)recipe.getOutput(this.table.m_58904_()));
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return this.firstCraftMatrix.m_39347_();
    }

    public int m_6656_() {
        return this.firstCraftMatrix.m_39346_();
    }

    public int m_6653_() {
        return 5;
    }

    public CraftingContainer getCraftSlots() {
        return this.firstCraftMatrix;
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int p_150591_) {
        return p_150591_ != this.m_6636_();
    }

    public void m_5816_(StackedContents p_39714_) {
        this.firstCraftMatrix.m_5809_(p_39714_);
    }

    public void m_6650_() {
        this.table.firstResultInv.m_6211_();
        this.firstCraftMatrix.m_6211_();
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> p_39719_) {
        return p_39719_.m_5818_((Container)this.firstCraftMatrix, this.playerInv.f_35978_.m_9236_());
    }

    public boolean m_6366_(Player player, int buttonIndex) {
        return this.table.toggleRecipeLock(buttonIndex);
    }
}

