/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.containers;

import com.mna.gui.containers.slots.BaseSlot;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.base.IBagItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public abstract class HeldContainerBase
extends AbstractContainerMenu {
    public ItemInventoryBase inventory;
    public int bagHash;
    protected int mySlot;
    private int myPlayerIndex;

    public abstract BaseSlot slot(IItemHandler var1, int var2, int var3, int var4);

    public HeldContainerBase(@Nullable MenuType<?> type, int id, Inventory playerInv, ItemInventoryBase basebag) {
        super(type, id);
        this.inventory = basebag;
        this.bagHash = basebag.getStack().hashCode();
        this.myPlayerIndex = playerInv.f_35977_;
        this.initializeSlots(playerInv);
    }

    protected abstract int slotsPerRow();

    protected abstract int numRows();

    protected void initializeSlots(Inventory playerInv) {
        int slotIndex = 0;
        for (int j = 0; j < this.numRows(); ++j) {
            for (int k = 0; k < this.slotsPerRow(); ++k) {
                this.m_38897_((Slot)this.slot((IItemHandler)this.inventory, k + j * this.slotsPerRow(), 8 + k * 18, 8 + j * 18));
                ++slotIndex;
            }
        }
        int i = (this.numRows() - 4) * 18;
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)playerInv, j1 + l * 9 + 9, 8 + j1 * 18, 94 + l * 18 + i));
                ++slotIndex;
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            if (i1 == playerInv.f_35977_) {
                this.mySlot = slotIndex;
            }
            this.m_38897_(new Slot((Container)playerInv, i1, 8 + i1 * 18, 152 + i));
            ++slotIndex;
        }
    }

    public int size() {
        return this.numRows() * this.slotsPerRow();
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId == this.mySlot || clickTypeIn == ClickType.SWAP && dragType == this.myPlayerIndex) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public void m_38946_() {
        super.m_38946_();
        this.inventory.writeItemStack();
    }

    public boolean m_6875_(@Nonnull Player player) {
        ItemStack held = player.m_21205_();
        return held == this.inventory.getStack() && !this.inventory.getStack().m_41619_() && held.hashCode() == this.bagHash && held.m_41720_() instanceof IBagItem;
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.numRows() * this.slotsPerRow() ? !this.m_38903_(itemstack1, this.numRows() * this.slotsPerRow(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.numRows() * this.slotsPerRow(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

