/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.block;

import com.google.common.collect.Lists;
import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.capabilities.IWellspringNodeRegistry;
import com.mna.api.entities.construct.ItemConstructPart;
import com.mna.api.faction.IFaction;
import com.mna.api.sound.SFX;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.blocks.BlockInit;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.gui.GuiTextures;
import com.mna.gui.base.GuiJEIDisable;
import com.mna.gui.containers.block.ContainerOcculus;
import com.mna.items.ItemInit;
import com.mna.network.ClientMessageDispatcher;
import com.mna.recipes.AMRecipeBase;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.recipes.progression.ProgressionCondition;
import com.mna.recipes.spells.ISpellComponentRecipe;
import com.mna.tools.render.GuiRenderUtils;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GuiOcculus
extends GuiJEIDisable<ContainerOcculus> {
    private static final int ICON_WIDTH = 50;
    private static final int ICON_HEIGHT = 40;
    private static final int ICON_SPACING = 10;
    private static final int ICON_SHEET_SIZE = 256;
    float backgroundPositionX = 0.0f;
    float backgroundPositionY = 0.0f;
    int backgroundWidth = 1024;
    int backgroundHeight = 1024;
    int categoryButtonOffset = 0;
    int startTooltipY = 52;
    int tooltipYPos = 52;
    int minTooltipY = this.startTooltipY;
    float backgroundPositionXMax = 1000.0f;
    HashMap<IconTypes, OcculusEntryList> lists;
    OcculusEntryList currentList;
    List<Component> currentTooltip = new ArrayList<Component>();
    ArrayList<TextFormatData> currentProgressionTooltip = new ArrayList();
    IPlayerProgression progression;
    IPlayerMagic magic;
    IPlayerRoteSpells rote;
    TextFormatData tierConditions = null;

    public GuiOcculus(ContainerOcculus screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.f_97726_ = 256;
        this.f_97727_ = 256;
        this.lists = new HashMap();
    }

    protected void m_7856_() {
        super.m_7856_();
        ClientMessageDispatcher.sendRequestWellspringNetworkSyncMessage(false);
        this.m_169413_();
        this.categoryButtonOffset = 0;
        Minecraft mc = Minecraft.m_91087_();
        RecipeManager recipeManager = mc.f_91073_.m_7465_();
        ArrayList<ListEntry<AMRecipeBase>> spell_parts = new ArrayList<ListEntry<AMRecipeBase>>();
        this.getRecipes(recipeManager, IconTypes.SHAPE, (RecipeType)RecipeInit.SHAPE_TYPE.get(), spell_parts, null);
        this.getRecipes(recipeManager, IconTypes.COMPONENT, (RecipeType)RecipeInit.COMPONENT_TYPE.get(), spell_parts, null);
        this.getRecipes(recipeManager, IconTypes.MODIFIER, (RecipeType)RecipeInit.MODIFIER_TYPE.get(), spell_parts, null);
        this.setupTierBadges(IconTypes.PROGRESSION, new ArrayList<ListEntry<AMRecipeBase>>(), new ItemStack((ItemLike)ItemInit.GUIDE_BOOK.get()).m_41714_((Component)Component.m_237115_((String)"mechanic.mna:progression")));
        this.setupTierBadges(IconTypes.FACTION_AFFINITY, new ArrayList<ListEntry<AMRecipeBase>>(), new ItemStack((ItemLike)ItemInit.MOTE_ARCANE.get()).m_41714_((Component)Component.m_237115_((String)"mechanic.mna:faction_affinity")));
        this.setupTierBadges(IconTypes.SHAPE, spell_parts, new ItemStack((ItemLike)ItemInit.VELLUM.get()).m_41714_((Component)Component.m_237115_((String)"mechanic.mna:sorcery")));
        this.setupTierBadges(IconTypes.RITUAL, this.getRecipes(recipeManager, IconTypes.RITUAL, (RecipeType)RecipeInit.RITUAL_TYPE.get(), null), new ItemStack((ItemLike)ItemInit.WIZARD_CHALK.get()).m_41714_((Component)Component.m_237115_((String)"mechanic.mna:rituals")));
        this.setupTierBadges(IconTypes.MANAWEAVE_PATTERN, this.getRecipes(recipeManager, IconTypes.MANAWEAVE_PATTERN, (RecipeType)RecipeInit.MANAWEAVING_PATTERN_TYPE.get(), null), new ItemStack((ItemLike)ItemInit.MANAWEAVER_WAND.get()).m_41714_((Component)Component.m_237115_((String)"mechanic.mna:manaweave_patterns")));
        this.setupTierBadges(IconTypes.MANAWEAVE_ALTAR, this.getRecipes(recipeManager, IconTypes.MANAWEAVE_ALTAR, (RecipeType)RecipeInit.MANAWEAVING_RECIPE_TYPE.get(), r -> !r.isEnchantment() && !(r.getResultItem().m_41720_() instanceof ItemConstructPart)), new ItemStack((ItemLike)BlockInit.MANAWEAVING_ALTAR.get()).m_41714_((Component)Component.m_237115_((String)"mechanic.mna:manaweave_crafting")));
        this.setupTierBadges(IconTypes.ELDRIN_ALTAR, this.getRecipes(recipeManager, IconTypes.ELDRIN_ALTAR, (RecipeType)RecipeInit.ELDRIN_ALTAR_TYPE.get(), r -> !(r.getResultItem().m_41720_() instanceof ItemConstructPart)), new ItemStack((ItemLike)BlockInit.ELDRIN_ALTAR.get()).m_41714_((Component)Component.m_237115_((String)"mechanic.mna:eldrin_altar")));
        this.setupTierBadges(IconTypes.RUNESCRIBING, this.getRecipes(recipeManager, IconTypes.RUNESCRIBING, (RecipeType)RecipeInit.RUNESCRIBING_TYPE.get(), null), new ItemStack((ItemLike)BlockInit.RUNESCRIBING_TABLE.get()).m_41714_((Component)Component.m_237115_((String)"mechanic.mna:runescribing")));
        this.setupTierBadges(IconTypes.RUNIC_ANVIL, this.getRecipes(recipeManager, IconTypes.RUNIC_ANVIL, (RecipeType)RecipeInit.RUNEFORGING_TYPE.get(), null), new ItemStack((ItemLike)BlockInit.RUNIC_ANVIL.get()).m_41714_((Component)Component.m_237115_((String)"mechanic.mna:runesmithing")));
        List<ListEntry<AMRecipeBase>> construct_recipes = this.getRecipes(recipeManager, IconTypes.CONSTRUCTS, (RecipeType)RecipeInit.MANAWEAVING_RECIPE_TYPE.get(), r -> !r.isEnchantment() && r.getResultItem().m_41720_() instanceof ItemConstructPart);
        construct_recipes.addAll(this.getRecipes(recipeManager, IconTypes.CONSTRUCTS, (RecipeType)RecipeInit.ELDRIN_ALTAR_TYPE.get(), r -> r.getResultItem().m_41720_() instanceof ItemConstructPart));
        this.setupTierBadges(IconTypes.CONSTRUCTS, construct_recipes, new ItemStack((ItemLike)ItemInit.CONSTRUCT_BASIC_HEAD_OBSIDIAN.get()).m_41714_((Component)Component.m_237115_((String)"mechanic.mna:constructs")));
        this.setupTierBadges(IconTypes.ENCHANTMENT, this.getRecipes(recipeManager, IconTypes.ENCHANTMENT, (RecipeType)RecipeInit.MANAWEAVING_RECIPE_TYPE.get(), r -> r.isEnchantment()), new ItemStack((ItemLike)Items.f_42690_).m_41714_((Component)Component.m_237115_((String)"mechanic.mna:enchantments")));
        this.finalizeLists();
        this.setActiveList(IconTypes.PROGRESSION);
        this.setActiveButton((Button)this.m_6702_().stream().filter(e -> e instanceof ImageItemStackButton).map(e -> (ImageItemStackButton)((Object)e)).findFirst().get());
        this.progression = (IPlayerProgression)this.f_96541_.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        this.magic = (IPlayerMagic)this.f_96541_.f_91074_.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        this.rote = (IPlayerRoteSpells)this.f_96541_.f_91074_.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
        this.currentProgressionTooltip.clear();
        if (this.progression != null) {
            List<ProgressionCondition> conditions = ProgressionCondition.get((Level)this.f_96541_.f_91073_, this.progression.getTier(), new ArrayList<ResourceLocation>());
            Collections.sort(conditions, new Comparator<ProgressionCondition>(){

                @Override
                public int compare(ProgressionCondition o1, ProgressionCondition o2) {
                    MutableComponent ttc1 = Component.m_237115_((String)o1.m_6423_().toString());
                    MutableComponent ttc2 = Component.m_237115_((String)o2.m_6423_().toString());
                    return ttc1.getString().compareTo(ttc2.getString());
                }
            });
            List<ResourceLocation> completedConditions = this.progression.getCompletedProgressionSteps();
            this.tierConditions = this.progression.getTier() < 5 ? new TextFormatData((Component)Component.m_237110_((String)"gui.mna.tier_progress", (Object[])new Object[]{ProgressionCondition.getCompletionRequirementForTier((Level)this.f_96541_.f_91073_, this.progression.getTier()), conditions.size()}), ChatFormatting.WHITE.m_126665_()) : null;
            for (ProgressionCondition cond : conditions) {
                if (completedConditions.contains(cond.m_6423_())) {
                    this.currentProgressionTooltip.add(new TextFormatData(cond.getDescription(), ChatFormatting.GREEN.m_126665_()));
                    continue;
                }
                this.currentProgressionTooltip.add(new TextFormatData(cond.getDescription(), ChatFormatting.RED.m_126665_()));
            }
            if (this.progression.getTierProgress((Level)this.f_96541_.f_91073_) >= 1.0f) {
                int advancementColor = ChatFormatting.YELLOW.m_126665_();
                this.currentProgressionTooltip.add(new TextFormatData((Component)Component.m_237113_((String)""), ChatFormatting.WHITE.m_126665_()));
                int tier = this.progression.getTier();
                if (tier == 1) {
                    this.currentProgressionTooltip.add(new TextFormatData((Component)Component.m_237115_((String)"mna:progresscondition.t1_complete"), advancementColor));
                } else if (tier == 2) {
                    this.currentProgressionTooltip.add(new TextFormatData((Component)Component.m_237115_((String)"mna:progresscondition.t2_complete"), advancementColor));
                    Registries.Factions.get().forEach(f -> this.currentProgressionTooltip.add(new TextFormatData(f.getOcculusTaskPrompt(tier), advancementColor)));
                } else {
                    this.currentProgressionTooltip.add(new TextFormatData((Component)Component.m_237115_((String)"mna:progresscondition.t3+_complete"), advancementColor));
                    this.currentProgressionTooltip.add(new TextFormatData(this.progression.getAlliedFaction().getOcculusTaskPrompt(tier), advancementColor));
                }
            }
        }
    }

    private <T extends AMRecipeBase> List<ListEntry<AMRecipeBase>> getRecipes(RecipeManager recipeManager, IconTypes iconType, RecipeType<T> recipeType, Function<T, Boolean> predicate) {
        return this.getRecipes(recipeManager, iconType, recipeType, null, predicate);
    }

    private <T extends AMRecipeBase> List<ListEntry<AMRecipeBase>> getRecipes(RecipeManager recipeManager, IconTypes iconType, RecipeType<T> recipeType, @Nullable List<ListEntry<AMRecipeBase>> appendTo, @Nullable Function<T, Boolean> predicate) {
        List recipes = recipeManager.m_44013_(recipeType);
        if (appendTo == null) {
            appendTo = new ArrayList<ListEntry<AMRecipeBase>>();
        }
        for (AMRecipeBase recipe : recipes) {
            if (predicate != null && !predicate.apply(recipe).booleanValue()) continue;
            appendTo.add(new ListEntry(this, recipe, iconType));
        }
        return appendTo;
    }

    private void setupViewButton(IconTypes iconType, ItemStack displayStack) {
        this.m_142416_((GuiEventListener)new ImageItemStackButton(this.f_97735_ - 22, this.f_97736_ + this.categoryButtonOffset, 22, 22, 51, 232, -22, GuiTextures.Blocks.OCCULUS_BORDER, 256, 256, button -> {
            this.setActiveList(iconType);
            this.setActiveButton(button);
        }, displayStack, this.f_96541_.m_91291_(), false));
        this.categoryButtonOffset += 25;
    }

    private void setupTierBadges(IconTypes iconType, List<ListEntry<AMRecipeBase>> recipes, ItemStack displayStack) {
        OcculusEntryList oel = new OcculusEntryList(this.f_96541_, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        this.lists.put(iconType, oel);
        Collections.sort(recipes, new Comparator<ListEntry<AMRecipeBase>>(){

            @Override
            public int compare(ListEntry<AMRecipeBase> o1, ListEntry<AMRecipeBase> o2) {
                Integer tier2;
                Integer tier1 = o1.getTier();
                int tierComp = tier1.compareTo(tier2 = Integer.valueOf(o2.getTier()));
                if (tierComp != 0) {
                    return tierComp;
                }
                String name1 = o1.getRecipe().getGuiRepresentationStack().m_41786_().getString();
                String name2 = o2.getRecipe().getGuiRepresentationStack().m_41786_().getString();
                return name1.compareTo(name2);
            }
        });
        for (ListEntry<AMRecipeBase> entry : recipes) {
            oel.addIcon(entry.getRecipe(), entry.getIcon());
        }
        this.m_7787_((GuiEventListener)oel);
        this.setupViewButton(iconType, displayStack);
    }

    private void finalizeLists() {
        for (OcculusEntryList list : this.lists.values()) {
            list.finalize();
        }
    }

    private void setActiveList(IconTypes type) {
        this.currentList = this.lists.get((Object)type);
        this.currentList.m_93410_(0.0);
    }

    private void setActiveButton(Button btn) {
        this.m_6702_().stream().forEach(l -> {
            if (l instanceof ImageItemStackButton) {
                ((ImageItemStackButton)((Object)l)).setCurrent(l == btn);
            }
        });
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return mouseX < (double)guiLeftIn || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.f_97726_) || mouseY >= (double)(guiTopIn + this.f_97727_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.f_97735_) {
            for (GuiEventListener b : this.m_6702_()) {
                if (!(b instanceof ImageItemStackButton) || !b.m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTick, int pMouseX, int pMouseY) {
        this.m_280273_(pGuiGraphics);
        int i = this.f_97735_;
        int j = this.f_97736_;
        if (this.progression != null && (this.currentList == this.lists.get((Object)IconTypes.PROGRESSION) || this.currentList == this.lists.get((Object)IconTypes.FACTION_AFFINITY))) {
            pGuiGraphics.m_280024_(i + 2, j + 2, i + this.f_97726_, j + this.f_97727_, FastColor.ARGB32.m_13660_((int)255, (int)34, (int)0, (int)61), FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0));
        } else {
            pGuiGraphics.m_280163_(GuiTextures.Blocks.OCCULUS_BACKGROUND, i + 2, j + 2, this.backgroundPositionX, this.backgroundPositionY, this.f_97726_ - 4, this.f_97727_ - 4, 100, 100);
            this.backgroundPositionX = (float)((double)this.backgroundPositionX + Math.cos((float)this.f_96541_.f_91073_.m_46467_() / 200.0f) * (double)0.2f * (double)partialTick);
            this.backgroundPositionY = (float)((double)this.backgroundPositionY - Math.sin((float)this.f_96541_.f_91073_.m_46467_() / 200.0f) * (double)0.2f * (double)partialTick);
        }
        if (this.currentList != null) {
            this.currentList.m_88315_(pGuiGraphics, pMouseX, pMouseY, partialTick);
        }
        if (this.progression != null) {
            int height = 210;
            pGuiGraphics.m_280163_(GuiTextures.Blocks.OCCULUS_BORDER, i + this.f_97726_, j, 232.0f, 0.0f, 11, height, 256, 256);
            float fillPct = this.progression.getTierProgress(ManaAndArtifice.instance.proxy.getClientWorld());
            pGuiGraphics.m_280163_(GuiTextures.Blocks.OCCULUS_BORDER, i + this.f_97726_, (int)((float)j + (float)height * (1.0f - fillPct)), 221.0f, 0.0f, 11, (int)((float)height * fillPct), 256, 256);
            pGuiGraphics.m_280163_(GuiTextures.Blocks.OCCULUS_BORDER, i + this.f_97726_, j, 210.0f, 0.0f, 11, this.f_97727_, 256, 256);
            if (pMouseX >= i + this.f_97726_ && pMouseX <= i + this.f_97726_ + 11 && pMouseY >= j && pMouseY <= j + this.f_97727_) {
                if (this.progression.getTier() < 5) {
                    MutableComponent progressSummary = Component.m_237110_((String)"gui.mna.your_tier_progress", (Object[])new Object[]{this.progression.getCompletedProgressionSteps().size()});
                    pGuiGraphics.m_280557_(this.f_96547_, (Component)progressSummary, pMouseX, pMouseY);
                } else {
                    pGuiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.mna.your_tier_max"), pMouseX, pMouseY);
                }
            }
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int i = 0;
        int j = 0;
        int tooltipYStart = 30;
        int tooltipX = 10;
        int tooltipY = this.tooltipYPos;
        int maxWidth = this.f_97726_ - 20;
        int totalTooltipHeight = 0;
        if (this.progression != null && this.currentList == this.lists.get((Object)IconTypes.PROGRESSION)) {
            List split_lines;
            String gui_player_tier = I18n.m_118938_((String)"gui.mna.your_tier", (Object[])new Object[]{this.progression.getTier()});
            pGuiGraphics.m_280056_(this.f_96547_, gui_player_tier, 10, 10, 0xFFFFFF, false);
            if (this.tierConditions != null) {
                split_lines = this.f_96547_.m_92865_().m_92432_(this.tierConditions.itc.getString(), maxWidth, Style.f_131099_);
                for (FormattedText line : split_lines) {
                    pGuiGraphics.m_280056_(this.f_96547_, line.getString(), tooltipX, tooltipYStart, this.tierConditions.color, false);
                    Objects.requireNonNull(this.f_96547_);
                    tooltipYStart += 9;
                }
            } else {
                Objects.requireNonNull(this.f_96547_);
                tooltipYStart += 9 * 2;
            }
            pGuiGraphics.m_280163_(GuiTextures.Blocks.OCCULUS_BORDER, i, j + tooltipYStart, 0.0f, 0.0f, this.f_97726_, 2, 310, 312);
            if (this.progression.getTier() >= 5) {
                pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.mna.your_tier_max").getString(), tooltipX, tooltipY, ChatFormatting.WHITE.m_126665_().intValue(), false);
            } else {
                for (TextFormatData tfd : this.currentProgressionTooltip) {
                    split_lines = this.f_96547_.m_92865_().m_92432_(tfd.itc.getString(), maxWidth, Style.f_131099_);
                    for (FormattedText line : split_lines) {
                        if (tooltipY >= tooltipYStart) {
                            Objects.requireNonNull(this.f_96547_);
                            if (tooltipY <= this.f_97727_ - 9) {
                                pGuiGraphics.m_280056_(this.f_96547_, line.getString(), tooltipX, tooltipY, tfd.color, false);
                            }
                        }
                        Objects.requireNonNull(this.f_96547_);
                        tooltipY += 9;
                        Objects.requireNonNull(this.f_96547_);
                        totalTooltipHeight += 9;
                    }
                    tooltipY += 2;
                    totalTooltipHeight += 2;
                }
            }
        } else if (this.progression != null && this.currentList == this.lists.get((Object)IconTypes.FACTION_AFFINITY)) {
            int y = 10;
            int x = 10;
            String gui_player_faction = I18n.m_118938_((String)"gui.mna.your_faction", (Object[])new Object[0]);
            pGuiGraphics.m_280056_(this.f_96547_, gui_player_faction, x, y, 0xFFFFFF, false);
            x += this.f_96547_.m_92895_(gui_player_faction) + 3;
            if (this.progression.hasAlliedFaction()) {
                IFaction faction = this.progression.getAlliedFaction();
                pGuiGraphics.m_280163_(faction.getFactionIcon(), x, y, 0.0f, 0.0f, faction.getFactionIconTextureSize(), faction.getFactionIconTextureSize(), faction.getFactionIconTextureSize(), faction.getFactionIconTextureSize());
            } else {
                gui_player_faction = I18n.m_118938_((String)"gui.mna.your_faction.none", (Object[])new Object[0]);
                pGuiGraphics.m_280056_(this.f_96547_, gui_player_faction, x, y, 0xFFFFFF, false);
            }
            y = 30;
            x = 10;
            String gui_player_affinity = I18n.m_118938_((String)"gui.mna.affinity", (Object[])new Object[0]);
            pGuiGraphics.m_280056_(this.f_96547_, gui_player_affinity, x, y, 0xFFFFFF, false);
            Objects.requireNonNull(this.f_96547_);
            y += 9;
            for (Affinity aff : Affinity.values()) {
                ItemStack affStack = GuiTextures.affinityIcons.get((Object)aff);
                if (affStack.m_41619_()) continue;
                pGuiGraphics.m_280480_(affStack, x, y);
                pGuiGraphics.m_280056_(this.f_96547_, String.format("%.1f%%", Float.valueOf(this.magic.getAffinityDepth(aff))), x += 20, y + 5, 0xFFFFFF, false);
                x = 10;
                y += 20;
            }
            this.f_96541_.f_91073_.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                int posY = 30;
                int posX = this.getXSize() - 30;
                String gui_power_network = I18n.m_118938_((String)"gui.mna.power_network", (Object[])new Object[0]);
                pGuiGraphics.m_280056_(this.f_96547_, gui_power_network, posX - this.f_96547_.m_92895_(gui_power_network) + 16, posY, 0xFFFFFF, false);
                Objects.requireNonNull(this.f_96547_);
                posY += 9;
                if (ManaAndArtifice.instance.proxy.getGameTicks() % 20L == 0L) {
                    ClientMessageDispatcher.sendRequestWellspringNetworkSyncMessage(false);
                }
                IWellspringNodeRegistry wsRegistry = m.getWellspringRegistry();
                HashMap<Affinity, Float> nodeAmounts = wsRegistry.getNodeNetworkAmountFor((Player)this.f_96541_.f_91074_);
                for (Affinity aff : Affinity.values()) {
                    ItemStack affStack = GuiTextures.affinityIcons.get((Object)aff);
                    if (affStack.m_41619_() || !nodeAmounts.containsKey((Object)aff)) continue;
                    pGuiGraphics.m_280480_(affStack, posX, posY);
                    float textScale = 0.75f;
                    pGuiGraphics.m_280168_().m_85836_();
                    pGuiGraphics.m_280168_().m_85841_(textScale, textScale, textScale);
                    float amt = nodeAmounts.get((Object)aff).floatValue();
                    amt = (float)(Math.floor(amt * 10.0f) / 10.0);
                    MutableComponent line = Component.m_237110_((String)"gui.mna.power_network.stored", (Object[])new Object[]{Float.valueOf(amt)});
                    float mult = wsRegistry.getEldrinGenerationMultiplierFor((Player)this.f_96541_.f_91074_, aff);
                    mult = (float)(Math.floor(mult * 10.0f) / 10.0);
                    MutableComponent genBonus = Component.m_237110_((String)"gui.mna.power_network.gen_bonus", (Object[])new Object[]{Float.valueOf(mult)});
                    int valueWidth = this.f_96547_.m_92852_((FormattedText)line);
                    pGuiGraphics.m_280614_(this.f_96547_, (Component)line, (int)((float)(posX - 5) / textScale) - valueWidth, (int)((float)(posY + 2) / textScale), 0xFFFFFF, false);
                    float f = posY;
                    Objects.requireNonNull(this.f_96547_);
                    posY = (int)(f + (float)(9 + 1) * textScale);
                    valueWidth = this.f_96547_.m_92852_((FormattedText)genBonus);
                    pGuiGraphics.m_280614_(this.f_96547_, (Component)genBonus, (int)((float)(posX - 5) / textScale) - valueWidth, (int)((float)(posY + 2) / textScale), 0xFFFFFF, false);
                    pGuiGraphics.m_280168_().m_85849_();
                    posY += 20;
                }
            });
        }
        pGuiGraphics.m_280163_(GuiTextures.Blocks.OCCULUS_BORDER, i, j, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 310, 312);
        this.minTooltipY = totalTooltipHeight <= this.tooltipYPos - tooltipY + this.f_97727_ - tooltipYStart + 20 ? 52 : this.tooltipYPos - tooltipY + this.f_97727_ - tooltipYStart + 20;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.currentTooltip.clear();
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (!this.currentTooltip.isEmpty()) {
            pGuiGraphics.m_280245_(this.f_96547_, Lists.transform(this.currentTooltip, Component::m_7532_), pMouseX, pMouseY);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.backgroundPositionX = (float)((double)this.backgroundPositionX - deltaX);
        this.backgroundPositionY = (float)((double)this.backgroundPositionY - deltaY);
        for (OcculusEntryList list : this.lists.values()) {
            list.m_6050_(mouseX, mouseY, deltaY / 20.0);
        }
        if (this.currentList == this.lists.get((Object)IconTypes.PROGRESSION)) {
            this.tooltipYPos += (int)Math.ceil(deltaY);
            if (this.tooltipYPos > 52) {
                this.tooltipYPos = 52;
            }
            if (this.tooltipYPos < this.minTooltipY) {
                this.tooltipYPos = this.minTooltipY;
            }
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        for (OcculusEntryList list : this.lists.values()) {
            list.m_6050_(mouseX, mouseY, delta);
        }
        if (this.currentList == this.lists.get((Object)IconTypes.PROGRESSION)) {
            this.tooltipYPos += (int)Math.ceil(delta) * 10;
            if (this.tooltipYPos > 52) {
                this.tooltipYPos = 52;
            }
            if (this.tooltipYPos < this.minTooltipY) {
                this.tooltipYPos = this.minTooltipY;
            }
        }
        return true;
    }

    class TextFormatData {
        public Component itc;
        public int color;

        public TextFormatData(Component itc, int color) {
            this.itc = itc;
            this.color = color;
        }
    }

    static enum IconTypes {
        PROGRESSION(0, 0),
        FACTION_AFFINITY(0, 0),
        MANAWEAVE_PATTERN(0, 0),
        MANAWEAVE_ALTAR(50, 0),
        ELDRIN_ALTAR(50, 0),
        SHAPE(100, 0),
        COMPONENT(150, 0),
        MODIFIER(200, 0),
        RUNESCRIBING(0, 80),
        RUNIC_ANVIL(50, 80),
        ENCHANTMENT(100, 80),
        RITUAL(150, 80),
        CONSTRUCTS(200, 80);

        private int texStartX;
        private int texStartY;

        private IconTypes(int texStartX, int texStartY) {
            this.texStartX = texStartX;
            this.texStartY = texStartY;
        }

        public int getTexX() {
            return this.texStartX;
        }

        public int getTexY() {
            return this.texStartY;
        }
    }

    static class ListEntry<T extends AMRecipeBase> {
        private T recipe;
        private IconTypes iconType;
        final /* synthetic */ GuiOcculus this$0;

        public ListEntry(T recipe, IconTypes icon) {
            this.this$0 = this$0;
            this.recipe = recipe;
            this.iconType = icon;
        }

        public int getTier() {
            return ((AMRecipeBase)this.recipe).getTier();
        }

        public IconTypes getIcon() {
            return this.iconType;
        }

        public T getRecipe() {
            return this.recipe;
        }
    }

    public class ImageItemStackButton
    extends ImageButton {
        final ItemStack iconStack;
        final ItemRenderer itemRenderer;
        final boolean includeTooltip;
        private boolean current;

        public ImageItemStackButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int hoverOffset, ResourceLocation textureFile, int texWidth, int texHeight, Button.OnPress clickHandler, ItemStack displayStack, ItemRenderer itemRenderer) {
            this(x, y, width, height, xTexStart, yTexStart, hoverOffset, textureFile, texWidth, texHeight, clickHandler, displayStack, itemRenderer, true);
        }

        public ImageItemStackButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int hoverOffset, ResourceLocation textureFile, int texWidth, int texHeight, Button.OnPress clickHandler, ItemStack displayStack, ItemRenderer itemRenderer, boolean displayFullTooltip) {
            super(x, y, width, height, xTexStart, yTexStart, hoverOffset, textureFile, texWidth, texHeight, clickHandler, displayStack.m_41786_());
            this.iconStack = displayStack;
            this.itemRenderer = itemRenderer;
            this.includeTooltip = displayFullTooltip;
        }

        public boolean m_198029_() {
            return this.current;
        }

        public void setCurrent(boolean current) {
            this.current = current;
        }

        protected boolean m_93680_(double mouseX, double mouseY) {
            return super.m_93680_(mouseX, mouseY);
        }

        public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            pGuiGraphics.m_280480_(this.iconStack, this.m_252754_() + 3, this.m_252907_() + 3);
            if (this.f_93623_ && this.f_93622_) {
                List lines;
                if (this.includeTooltip) {
                    lines = this.iconStack.m_41651_((Player)((GuiOcculus)GuiOcculus.this).f_96541_.f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_);
                } else {
                    lines = new ArrayList<Component>();
                    lines.add(this.iconStack.m_41786_());
                }
                ArrayList<Component> tt = new ArrayList<Component>();
                for (Component comp : lines) {
                    if (!this.includeTooltip) {
                        String unformatted = ChatFormatting.m_126649_((String)comp.getString());
                        MutableComponent stc = Component.m_237113_((String)unformatted);
                        stc.m_130940_(ChatFormatting.ITALIC);
                        tt.add((Component)stc);
                        continue;
                    }
                    tt.add(comp);
                }
                GuiOcculus.this.currentTooltip = tt;
            }
        }

        public void m_7435_(SoundManager soundHandler) {
            soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }
    }

    class OcculusEntryList
    extends ObjectSelectionList<OcculusEntry> {
        private int x;
        private OcculusEntry current;

        public <T extends AMRecipeBase> OcculusEntryList(Minecraft mcIn, int x, int y, int widthIn, int heightIn) {
            super(mcIn, widthIn, heightIn, y, y + heightIn, 50);
            this.x = x;
            this.m_93471_(false);
            this.m_93473_(false, 50);
        }

        public <T extends AMRecipeBase> void addIcon(T recipe, IconTypes type) {
            if (this.current == null || this.current.countIcons() == 4 || recipe.getTier() > this.current.getTier()) {
                this.current = recipe instanceof ISpellComponentRecipe ? new OcculusSpellEntry(recipe.getTier()) : (recipe instanceof ManaweavingPattern ? new OcculusManaweaveEntry(recipe.getTier()) : new OcculusEntry(recipe.getTier()));
                this.m_7085_((AbstractSelectionList.Entry)this.current);
            }
            if (this.current.getTier() > recipe.getTier()) {
                throw new InvalidParameterException("Cannot add a recipe for a lower tier.  Sort recipes ascending by tier for this to work.");
            }
            this.current.addOutputItem(recipe, type);
        }

        public void finalize() {
            for (OcculusEntry e : this.m_6702_()) {
                e.finalize();
            }
        }

        public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            int xPos = this.m_5747_();
            int yPos = this.f_93390_ - (int)this.m_93517_();
            this.m_239227_(pGuiGraphics, xPos, yPos, pPartialTick);
            int lastTier = 0;
            int tierItemCount = 0;
            for (OcculusEntry entry : this.m_6702_()) {
                while (lastTier < entry.getTier()) {
                    ++lastTier;
                    if (yPos + 15 > this.f_93390_) {
                        Objects.requireNonNull(this.f_93386_.f_91062_);
                        if (yPos + 15 + 9 < this.f_93391_) {
                            Object tierStr = String.format("Tier %d", lastTier);
                            if (tierItemCount == 0 && lastTier < entry.getTier()) {
                                tierStr = (String)tierStr + " (No Items)";
                            }
                            pGuiGraphics.m_280056_(this.f_93386_.f_91062_, (String)tierStr, xPos, yPos + 15, 0xFFFFFF, false);
                        }
                    }
                    tierItemCount = 0;
                    yPos += 10;
                }
                ++tierItemCount;
                yPos += 50;
            }
        }

        protected void m_239227_(GuiGraphics pGuiGraphics, int p_238478_4_, int p_238478_5_, float partialTicks) {
            int count = this.m_5773_();
            for (int i = 0; i < count; ++i) {
                int top = this.m_7610_(i);
                int bottom = top + this.f_93387_;
                if (top < this.f_93390_ || bottom > this.f_93391_) continue;
                int j1 = this.f_93387_ - 4;
                OcculusEntry e = (OcculusEntry)this.m_93500_(i);
                e.m_6311_(pGuiGraphics, i, top, this.m_5747_(), this.m_5759_(), j1, p_238478_4_, p_238478_5_, false, partialTicks);
            }
        }

        public int m_5759_() {
            return this.f_93388_ - 40;
        }

        public int m_5747_() {
            return this.x + 12;
        }

        protected int m_7610_(int p_230962_1_) {
            OcculusEntry oe = (OcculusEntry)((Object)this.m_6702_().get(p_230962_1_));
            return this.f_93390_ + 15 - (int)this.m_93517_() + p_230962_1_ * this.f_93387_ + oe.getTier() * 10;
        }

        protected int m_5775_() {
            return (this.m_5773_() + 1) * this.f_93387_ + 50;
        }

        public class OcculusEntry
        extends ObjectSelectionList.Entry<OcculusEntry> {
            private static final int MAX_ITEMS = 4;
            private ArrayList<ItemStack> outputItems;
            private ArrayList<AMRecipeBase> outputRecipes;
            private ArrayList<IconTypes> iconTypes;
            protected ItemRenderer itemRenderer;
            protected Font fontRenderer;
            protected int tier;

            public OcculusEntry(int tier) {
                this.itemRenderer = OcculusEntryList.this.f_93386_.m_91291_();
                this.fontRenderer = ((OcculusEntryList)OcculusEntryList.this).f_93386_.f_91062_;
                this.outputItems = new ArrayList();
                this.outputRecipes = new ArrayList();
                this.iconTypes = new ArrayList();
                this.tier = tier;
            }

            public void addOutputItem(AMRecipeBase recipe, IconTypes type) {
                if (this.outputItems.size() == 4) {
                    return;
                }
                if (recipe.getGuiRepresentationStack().m_41619_()) {
                    return;
                }
                this.outputItems.add(recipe.getGuiRepresentationStack());
                this.outputRecipes.add(recipe);
                this.iconTypes.add(type);
            }

            public void finalize() {
                while (this.outputItems.size() < 4) {
                    this.outputItems.add(ItemStack.f_41583_);
                }
            }

            public int countIcons() {
                return this.outputItems.size();
            }

            public int getTier() {
                return this.tier;
            }

            protected IFaction getFaction(int index) {
                return index >= this.outputRecipes.size() || this.outputRecipes.get(index) == null ? null : this.outputRecipes.get(index).getFactionRequirement();
            }

            public void m_6311_(GuiGraphics pGuiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
                for (int i = 0; i < 4 && !this.outputItems.get(i).m_41619_(); ++i) {
                    boolean tierMet;
                    if (GuiOcculus.this.progression == null) {
                        return;
                    }
                    boolean bl = tierMet = this.tier <= GuiOcculus.this.progression.getTier();
                    if (!tierMet) {
                        pGuiGraphics.m_280246_(0.5f, 0.0f, 0.0f, 1.0f);
                    } else {
                        pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                    }
                    this.renderBackground(pGuiGraphics, left + i * 58, top, this.iconTypes.get(i), i, tierMet);
                    this.renderForeground(pGuiGraphics, left + i * 58, top, partialTicks, this.outputItems.get(i), i);
                }
            }

            protected void renderBackground(GuiGraphics pGuiGraphics, int x, int y, IconTypes type, int index, boolean tierMet) {
                pGuiGraphics.m_280163_(GuiTextures.Blocks.OCCULUS_ICONS, x + 2, y + 2, (float)type.getTexX(), (float)type.getTexY(), 50, 40, 256, 256);
                IFaction faction = this.getFaction(index);
                if (faction != null) {
                    pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                    pGuiGraphics.m_280163_(faction.getFactionIcon(), x + 50 - faction.getFactionIconTextureSize(), y + 40 - faction.getFactionIconTextureSize(), 0.0f, 0.0f, faction.getFactionIconTextureSize(), faction.getFactionIconTextureSize(), faction.getFactionIconTextureSize(), faction.getFactionIconTextureSize());
                    if (!tierMet) {
                        pGuiGraphics.m_280246_(0.5f, 0.0f, 0.0f, 1.0f);
                    }
                }
            }

            public void renderForeground(GuiGraphics pGuiGraphics, int x, int y, float partialTick, ItemStack stack, int index) {
                pGuiGraphics.m_280480_(stack, x + 19, y + 3);
                this.renderTextLines(pGuiGraphics, stack, x, y);
            }

            protected void renderTextLines(GuiGraphics pGuiGraphics, ItemStack stack, int x, int y) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                tooltip.add(stack.m_41786_());
                if (GuiOcculus.this.progression == null) {
                    return;
                }
                float scale = 0.7f;
                pGuiGraphics.m_280168_().m_85836_();
                pGuiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
                int yCoord = y + 22;
                for (Component tc : tooltip) {
                    List lines = this.fontRenderer.m_92865_().m_92414_((FormattedText)tc, (int)(47.0f / scale), Style.f_131099_);
                    for (FormattedText line : lines) {
                        int len = (int)((float)this.fontRenderer.m_92895_(line.getString()) * scale);
                        int xCoord = x + 2 + 25 - len / 2;
                        pGuiGraphics.m_280056_(((OcculusEntryList)OcculusEntryList.this).f_93386_.f_91062_, line.getString(), (int)((float)xCoord / scale), (int)((float)yCoord / scale), 0xFFFFFF, false);
                        float f = yCoord;
                        Objects.requireNonNull(this.fontRenderer);
                        yCoord = (int)(f + 9.0f * scale);
                    }
                }
                pGuiGraphics.m_280168_().m_85849_();
            }

            public Component m_142172_() {
                return Component.m_237115_((String)"gui.mna.occulus.select");
            }
        }

        public class OcculusSpellEntry
        extends OcculusEntry {
            ArrayList<ISpellComponent> spellParts;

            public OcculusSpellEntry(int tier) {
                super(tier);
                this.spellParts = new ArrayList();
            }

            @Override
            public void addOutputItem(AMRecipeBase recipe, IconTypes type) {
                super.addOutputItem(recipe, type);
                if (recipe instanceof ISpellComponentRecipe) {
                    ResourceLocation spellRLoc;
                    ISpellComponent comp = ((ISpellComponentRecipe)((Object)recipe)).getComponent();
                    ResourceLocation resourceLocation = spellRLoc = comp != null ? comp.getRegistryName() : new ResourceLocation("");
                    if (Registries.Shape.get().containsKey(spellRLoc)) {
                        this.spellParts.add((ISpellComponent)Registries.Shape.get().getValue(spellRLoc));
                    } else if (Registries.SpellEffect.get().containsKey(spellRLoc)) {
                        this.spellParts.add((ISpellComponent)Registries.SpellEffect.get().getValue(spellRLoc));
                    } else if (Registries.Modifier.get().containsKey(spellRLoc)) {
                        this.spellParts.add((ISpellComponent)Registries.Modifier.get().getValue(spellRLoc));
                    }
                }
            }

            @Override
            protected void renderBackground(GuiGraphics pGuiGraphics, int x, int y, IconTypes type, int index, boolean tierMet) {
                ISpellComponent comp;
                super.renderBackground(pGuiGraphics, x, y, type, index, tierMet);
                if (index < this.spellParts.size() && (comp = this.spellParts.get(index)) != null && GuiOcculus.this.rote != null) {
                    int color = GuiOcculus.this.rote.isRote(comp) ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)255, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)237, (int)230, (int)9);
                    float prog = GuiOcculus.this.rote.getRoteProgression(comp);
                    if (prog > 0.0f && prog < 0.02f) {
                        prog = 0.02f;
                    }
                    int width = (int)(prog * 50.0f);
                    pGuiGraphics.m_280509_(x + 2, y + 40, x + 2 + width, y + 40 + 2, color);
                }
            }

            @Override
            public void renderForeground(GuiGraphics pGuiGraphics, int x, int y, float partialTick, ItemStack stack, int index) {
                ISpellComponent part;
                if (index >= 0 && index < this.spellParts.size() && (part = this.spellParts.get(index)) != null) {
                    pGuiGraphics.m_280163_(part.getGuiIcon(), x + 19, y + 3, 0.0f, 0.0f, 16, 16, 16, 16);
                    if (part.isSilverSpell()) {
                        GuiRenderUtils.renderSilverSpellBorder(pGuiGraphics, x + 19, y + 3, 16, 16);
                    }
                }
                this.renderTextLines(pGuiGraphics, stack, x, y);
            }

            @Override
            protected IFaction getFaction(int index) {
                return index >= this.spellParts.size() || this.spellParts.get(index) == null ? null : this.spellParts.get(index).getFactionRequirement();
            }
        }

        public class OcculusManaweaveEntry
        extends OcculusEntry {
            private ArrayList<ManaweavingPattern> patterns;

            public OcculusManaweaveEntry(int tier) {
                super(tier);
                this.patterns = new ArrayList();
            }

            @Override
            public void addOutputItem(AMRecipeBase recipe, IconTypes type) {
                super.addOutputItem(recipe, type);
                if (recipe instanceof ManaweavingPattern) {
                    this.patterns.add((ManaweavingPattern)recipe);
                }
            }

            @Override
            public void renderForeground(GuiGraphics pGuiGraphics, int x, int y, float partialTick, ItemStack stack, int index) {
                float scale = 0.1f;
                GuiRenderUtils.renderManaweavePattern(pGuiGraphics, (int)((float)(x + 33) / scale), (int)((float)(y + 4) / scale), scale, this.patterns.get(index));
                ArrayList<Component> tooltip = new ArrayList<Component>();
                tooltip.add(stack.m_41786_());
                if (GuiOcculus.this.progression == null) {
                    return;
                }
                scale = 0.7f;
                pGuiGraphics.m_280168_().m_85836_();
                pGuiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
                int yCoord = y + 22;
                for (Component tc : tooltip) {
                    List lines = this.fontRenderer.m_92865_().m_92414_((FormattedText)tc, (int)(47.0f / scale), Style.f_131099_);
                    for (FormattedText line : lines) {
                        int len = (int)((float)this.fontRenderer.m_92895_(line.getString()) * scale);
                        int xCoord = x + 2 + 25 - len / 2;
                        pGuiGraphics.m_280056_(this.fontRenderer, line.getString(), (int)((float)xCoord / scale), (int)((float)yCoord / scale), 0xFFFFFF, false);
                        float f = yCoord;
                        Objects.requireNonNull(this.fontRenderer);
                        yCoord = (int)(f + 9.0f * scale);
                    }
                }
                pGuiGraphics.m_280168_().m_85849_();
            }

            @Override
            public Component m_142172_() {
                return Component.m_237115_((String)"gui.mna.occulus.select");
            }
        }
    }
}

