/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.block;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.entities.construct.ai.ConstructTask;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskIntegerParameter;
import com.mna.gui.GuiTextures;
import com.mna.gui.base.GuiJEIDisable;
import com.mna.gui.containers.block.ContainerLodestar;
import com.mna.gui.widgets.lodestar.AreaParameterInput;
import com.mna.gui.widgets.lodestar.BooleanParameterInput;
import com.mna.gui.widgets.lodestar.FilterParameterInput;
import com.mna.gui.widgets.lodestar.IntegerParameterInput;
import com.mna.gui.widgets.lodestar.ItemStackParameterInput;
import com.mna.gui.widgets.lodestar.LodestarGroup;
import com.mna.gui.widgets.lodestar.LodestarNode;
import com.mna.gui.widgets.lodestar.LodestarParameter;
import com.mna.gui.widgets.lodestar.PointParameterInput;
import com.mna.tools.math.MathUtils;
import com.mna.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;

public class GuiLodestarV2
extends GuiJEIDisable<ContainerLodestar> {
    public static final int MAIN_WIDTH = 256;
    public static final int MAIN_HEIGHT = 165;
    public static final int BACKGROUND_SIZE = 512;
    public static final int BACKGROUND_OFFSET = 10;
    public static final int COMMANDS_WIDTH = 56;
    public static final int COMMANDS_HEIGHT = 164;
    public static final int PARAMS_WIDTH = 68;
    public static final int PARAMS_HEIGHT = 164;
    public static final int PARAMS_START_X = 5;
    public static final int PARAMS_START_Y = 21;
    public static final int PARAMS_INCREMENT_Y = 22;
    public static final int START_BUTTON_X = 4;
    public static final int START_BUTTON_Y = 10;
    public static final int START_BUTTON_SIZE = 8;
    private CommandScrollList actionsList;
    private EditBox groupBox;
    private EditBox filterBox;
    private Component currentGroupBoxInput;
    private Component currentFilterBoxInput;
    private Component currentTooltip;
    public static float Zoom = 1.0f;
    private int scroll_pos_x = 0;
    private int scroll_pos_y = 0;
    private double scroll_accum_x = 0.0;
    private double scroll_accum_y = 0.0;
    private boolean canBackgroundScroll = false;
    private List<LodestarNode> nodes;
    private List<LodestarGroup> nodeGroups;
    private LodestarNode selectedNode;
    private boolean drawingGroup = false;
    private List<LodestarParameter<?>> parameterWidgets;
    private LodestarNode lineConnectionOrigin;
    private int lineConnectionOriginNodeIndex = -1;
    private boolean draggingStartNode = false;
    private ImageButton startNodeButton = null;
    private LodestarNode draggingNode;
    private LodestarGroup draggingGroup;
    private List<LodestarNode> draggingGroupNodes;
    private LodestarGroup creatingGroup;
    private LodestarGroup selectedGroup;
    private ConstructTask draggingOutTask;
    private boolean isDownloadingLogic = false;

    public GuiLodestarV2(ContainerLodestar screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.f_97726_ = 256;
        this.f_97727_ = 256;
        this.nodes = new ArrayList<LodestarNode>();
        this.draggingGroupNodes = new ArrayList<LodestarNode>();
        this.nodeGroups = new ArrayList<LodestarGroup>();
        this.parameterWidgets = new ArrayList();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.nodes.clear();
        this.nodeGroups.clear();
        this.selectedNode = null;
        this.draggingNode = null;
        this.draggingOutTask = null;
        this.parameterWidgets.clear();
        this.m_169413_();
        this.actionsList = new CommandScrollList(((ContainerLodestar)this.f_97732_).isLowTier());
        this.m_142416_((GuiEventListener)this.actionsList);
        this.groupBox = new EditBox(this.f_96541_.f_91062_, this.f_97735_ + 4, this.f_97736_ - 12, this.getXSize() - 8, 12, this.currentGroupBoxInput);
        this.groupBox.m_94199_(100);
        this.groupBox.m_94151_(this::onGroupTextChanged);
        this.groupBox.f_93623_ = false;
        this.groupBox.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.groupBox);
        this.filterBox = new EditBox(this.f_96541_.f_91062_, this.f_97735_ - 51, this.f_97736_ - (((ContainerLodestar)this.f_97732_).isLowTier() ? 7 : 5), 50, 12, this.currentFilterBoxInput);
        this.filterBox.m_94199_(20);
        this.filterBox.m_94151_(this::onFilterTextChanged);
        this.filterBox.f_93623_ = true;
        this.filterBox.f_93624_ = true;
        this.m_142416_((GuiEventListener)this.filterBox);
        this.startNodeButton = new ImageButton(this.f_97735_ + 4, this.f_97736_ + 10, 8, 8, 0, 216, 0, this.getMainTexture(), 256, 256, b -> {
            this.draggingStartNode = true;
        });
        this.m_142416_((GuiEventListener)this.startNodeButton);
        ImageButton recenterButton = new ImageButton(this.f_97735_ + 14, this.f_97736_ + 165, 14, 14, 140, 242, 0, this.getMainTexture(), 256, 256, b -> this.recenterView());
        recenterButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.mna.lodestar.recenter")));
        this.m_142416_((GuiEventListener)recenterButton);
        ImageButton drawGroupButton = new ImageButton(this.f_97735_ + this.getXSize() - 28, this.f_97736_ + 165, 14, 14, 140, 228, 0, this.getMainTexture(), 256, 256, b -> {
            this.drawingGroup = !this.drawingGroup;
        });
        drawGroupButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.mna.lodestar.draw_group_toggle")));
        this.m_142416_((GuiEventListener)drawGroupButton);
        this.isDownloadingLogic = true;
    }

    private void onGroupTextChanged(String newText) {
        if (this.selectedGroup != null) {
            this.selectedGroup.setLabel(newText);
        }
    }

    private void onFilterTextChanged(String newText) {
        this.actionsList.setFilter(newText);
    }

    private void addParameter(LodestarParameter<?> btn) {
        this.parameterWidgets.add(btn);
        this.m_142416_((GuiEventListener)btn);
    }

    private void addNode(int x, int y, ConstructTask task) {
        LodestarNode added = new LodestarNode(this.f_97735_ + x, this.f_97736_ + y, ((ContainerLodestar)this.f_97732_).isLowTier(), task, b -> this.nodeSubClick((LodestarNode)b), this::getNodeById);
        this.insertNode(added);
    }

    private void insertNode(LodestarNode node) {
        this.nodes.add(node);
        this.m_7787_((GuiEventListener)node);
    }

    private void deleteNode(LodestarNode node) {
        if (this.selectedNode == node) {
            this.deselectNode();
        }
        this.nodes.remove((Object)node);
        this.m_169411_((GuiEventListener)node);
    }

    private void groupClicked(LodestarGroup group, boolean forDelete) {
        double clickY;
        if (forDelete) {
            this.nodeGroups.remove((Object)group);
            return;
        }
        double clickX = group.getClickX();
        if (!this.isMouseWithinStage(clickX * (double)Zoom, (clickY = group.getClickY()) * (double)Zoom)) {
            return;
        }
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        this.draggingGroup = group;
        this.draggingGroupNodes = this.getNodesInGroup(group);
        this.selectedGroup = group;
        this.groupBox.f_93623_ = true;
        this.groupBox.f_93624_ = true;
        this.groupBox.m_94144_(group.getLabel());
    }

    private void nodeSubClick(LodestarNode node) {
        double clickY;
        double clickX = node.getClickX();
        if (!this.isMouseWithinStage(clickX * (double)Zoom, (clickY = node.getClickY()) * (double)Zoom)) {
            return;
        }
        int widgetIndex = node.getSubClickIndex();
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        switch (widgetIndex) {
            case 97: {
                this.deleteNode(node);
                ((ContainerLodestar)this.f_97732_).setTileLogic(this.saveLogic());
                return;
            }
            case 98: {
                this.nodes.forEach(n -> n.disconnectFromNode(node));
                ((ContainerLodestar)this.f_97732_).setTileLogic(this.saveLogic());
                return;
            }
            case 99: {
                this.draggingNode = node;
                this.selectNode(node);
                return;
            }
        }
        this.lineConnectionOrigin = node;
        this.lineConnectionOriginNodeIndex = widgetIndex;
    }

    private void deselectNode() {
        if (this.selectedNode == null) {
            return;
        }
        this.selectedNode.saveParameters(this.parameterWidgets);
        this.parameterWidgets.forEach(w -> this.m_169411_((GuiEventListener)w));
        this.parameterWidgets.clear();
        this.selectedNode.deselect();
        this.selectedNode = null;
    }

    private void selectNode(LodestarNode node) {
        if (this.selectedNode != null) {
            this.deselectNode();
        }
        MutableInt paramIndex = new MutableInt(0);
        node.getParameters().forEach(param -> {
            switch (param.getTypeID()) {
                case AREA: {
                    this.addParameter(new AreaParameterInput(((ContainerLodestar)this.f_97732_).isLowTier(), this.getParameterX(), this.getParameterY(paramIndex.getValue()), b -> {}, param.getTooltip()));
                    break;
                }
                case BOOLEAN: {
                    this.addParameter(new BooleanParameterInput(((ContainerLodestar)this.f_97732_).isLowTier(), this.getParameterX(), this.getParameterY(paramIndex.getValue()), b -> {}, param.getTooltip()));
                    break;
                }
                case FILTER: {
                    this.addParameter(new FilterParameterInput(((ContainerLodestar)this.f_97732_).isLowTier(), this.getParameterX(), this.getParameterY(paramIndex.getValue()), b -> {}, param.getTooltip()));
                    break;
                }
                case INTEGER: {
                    this.addParameter(new IntegerParameterInput(((ContainerLodestar)this.f_97732_).isLowTier(), this.getParameterX(), this.getParameterY(paramIndex.getValue()), ((ConstructTaskIntegerParameter)param).getMinimum(), ((ConstructTaskIntegerParameter)param).getMinimum(), ((ConstructTaskIntegerParameter)param).getMaximum(), b -> {}, param.getTooltip()));
                    break;
                }
                case POINT: {
                    this.addParameter(new PointParameterInput(((ContainerLodestar)this.f_97732_).isLowTier(), this.getParameterX(), this.getParameterY(paramIndex.getValue()), b -> {}, param.getTooltip()));
                    break;
                }
                case ITEMSTACK: {
                    this.addParameter(new ItemStackParameterInput(((ContainerLodestar)this.f_97732_).isLowTier(), this.getParameterX(), this.getParameterY(paramIndex.getValue()), b -> {}, param.getTooltip()));
                    break;
                }
                default: {
                    ManaAndArtifice.LOGGER.error("Unknown parameter type for construct task!  No known parameter widget.  Skipping.");
                }
            }
            paramIndex.increment();
        });
        this.selectedNode = node;
        this.selectedNode.select();
        this.selectedNode.loadParameters(this.parameterWidgets);
    }

    private void panBackground(double deltaX, double deltaY) {
        if (!this.canBackgroundScroll) {
            return;
        }
        this.scroll_accum_x += deltaX / (double)Zoom;
        this.scroll_accum_y += deltaY / (double)Zoom;
        if (Math.abs(this.scroll_accum_x) > 1.0 || Math.abs(this.scroll_accum_y) > 1.0) {
            Object node;
            int i;
            int dX = (int)(Math.floor(Math.abs(this.scroll_accum_x)) * Math.signum(this.scroll_accum_x));
            int dY = (int)(Math.floor(Math.abs(this.scroll_accum_y)) * Math.signum(this.scroll_accum_y));
            this.scroll_accum_x -= (double)dX;
            this.scroll_accum_y -= (double)dY;
            int scroll_pos_x_o = this.scroll_pos_x;
            int scroll_pos_y_o = this.scroll_pos_y;
            this.scroll_pos_x -= dX;
            this.scroll_pos_y -= dY;
            int adX = scroll_pos_x_o - this.scroll_pos_x;
            int adY = scroll_pos_y_o - this.scroll_pos_y;
            for (i = 0; i < this.nodes.size(); ++i) {
                node = this.nodes.get(i);
                node.m_252865_(node.m_252754_() + adX);
                node.m_253211_(node.m_252907_() + adY);
            }
            for (i = 0; i < this.nodeGroups.size(); ++i) {
                node = this.nodeGroups.get(i);
                node.m_252865_(node.m_252754_() + adX);
                node.m_253211_(node.m_252907_() + adY);
            }
        }
    }

    private void startDraggingCommandFromList(ConstructTask action) {
        this.draggingOutTask = action;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int leftPos, int topPos, int button) {
        if (mouseX >= (double)(this.f_97735_ - 56) && mouseX < (double)(this.f_97735_ + 256 + 68) && mouseY >= (double)this.f_97736_ && mouseY <= (double)(this.f_97736_ + 165)) {
            return false;
        }
        int halfPlayerInvWidth = 88;
        return !(mouseX >= (double)(this.f_97735_ + this.f_97726_ / 2 - halfPlayerInvWidth)) || !(mouseX <= (double)(this.f_97735_ + this.f_97726_ / 2 + halfPlayerInvWidth)) || !(mouseY >= (double)(this.f_97736_ + 165)) || !(mouseY <= (double)(this.f_97736_ + this.f_97727_));
    }

    private ResourceLocation getMainTexture() {
        return ((ContainerLodestar)this.f_97732_).isLowTier() ? GuiTextures.Blocks.LODESTAR_LESSER_MAIN : GuiTextures.Blocks.LODESTAR_MAIN;
    }

    private ResourceLocation getBackgroundTexture() {
        return ((ContainerLodestar)this.f_97732_).isLowTier() ? GuiTextures.Blocks.LODESTAR_LESSER_BACKGROUND : GuiTextures.Blocks.LODESTAR_BACKGROUND;
    }

    private ResourceLocation getExtensionTexture() {
        return ((ContainerLodestar)this.f_97732_).isLowTier() ? GuiTextures.Blocks.LODESTAR_LESSER_EXTENSION : GuiTextures.Blocks.LODESTAR_EXTENSION;
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(pGuiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        pGuiGraphics.m_280218_(this.getMainTexture(), this.f_97735_ - 45, this.f_97736_ - 45, 166, 166, 90, 90);
        pGuiGraphics.m_280218_(this.getMainTexture(), this.f_97735_ + 211, this.f_97736_ + 121, 166, 166, 90, 90);
        this.renderNodes(pGuiGraphics, partialTick, mouseX, mouseY);
        pGuiGraphics.m_280218_(this.getMainTexture(), this.f_97735_, this.f_97736_, 0, 0, 256, 165);
        pGuiGraphics.m_280218_(this.getMainTexture(), this.f_97735_, this.f_97736_ + 7, 0, 187, 8, 14);
        pGuiGraphics.m_280218_(this.getExtensionTexture(), this.f_97735_ - 56 + 2, this.f_97736_ - 2, 0, 0, 56, 164);
        pGuiGraphics.m_280218_(this.getExtensionTexture(), this.f_97735_ + 256 - 2, this.f_97736_ - 2, 56, 0, 68, 164);
        GuiRenderUtils.renderStandardPlayerInventory(pGuiGraphics, this.f_97735_ + this.f_97726_ / 2, this.f_97736_ + 165 + 45);
        if (this.draggingOutTask != null) {
            pGuiGraphics.m_280398_(this.draggingOutTask.getIconTexture(), mouseX - 8, mouseY - 8, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (this.selectedNode != null) {
            pGuiGraphics.m_280163_(this.selectedNode.getTask().getIconTexture(), this.f_97735_ + 256 + 24, this.f_97736_, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    private void renderNodes(GuiGraphics pGuiGraphics, float partialTick, int mouseX, int mouseY) {
        Pair<Integer, Integer> mouseScaled = this.getScaledMouseCoordinates(mouseX, mouseY);
        pGuiGraphics.m_280588_(this.f_97735_, this.f_97736_, this.f_97735_ + 256, this.f_97736_ + 165);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85841_(Zoom, Zoom, Zoom);
        pGuiGraphics.m_280163_(this.getBackgroundTexture(), (int)((float)(this.f_97735_ + 5) / Zoom), (int)((float)(this.f_97736_ + 5) / Zoom), (float)Math.round(this.scroll_pos_x), (float)Math.round(this.scroll_pos_y), (int)(246.0f / Zoom), (int)(155.0f / Zoom), 512, 512);
        this.nodeGroups.forEach(group -> group.m_88315_(pGuiGraphics, mouseX, mouseY, partialTick));
        this.nodes.forEach(node -> node.renderConnections(pGuiGraphics, this.f_97735_, this.f_97736_, partialTick));
        this.nodes.forEach(node -> {
            node.m_88315_(pGuiGraphics, (Integer)mouseScaled.getFirst(), (Integer)mouseScaled.getSecond(), partialTick);
            node.renderErrors(pGuiGraphics, ((ContainerLodestar)this.f_97732_).getNodeErrors());
        });
        if (this.lineConnectionOrigin != null || this.draggingStartNode) {
            int idx;
            Optional node2;
            int lineColor = LodestarNode.COLOR_RED;
            if (this.isMouseWithinStage(mouseX, mouseY) && (node2 = this.m_94729_(mouseX, mouseY)).isPresent() && node2.get() instanceof LodestarNode && (idx = ((LodestarNode)((Object)node2.get())).getSubWidgetAt(mouseX, mouseY)) == 98) {
                int n = lineColor = this.draggingStartNode ? LodestarNode.COLOR_BLUE : LodestarNode.COLOR_GREEN;
            }
            if (this.lineConnectionOrigin != null) {
                this.lineConnectionOrigin.renderConnectingLine(pGuiGraphics, this.lineConnectionOriginNodeIndex, ((Integer)mouseScaled.getFirst()).intValue(), ((Integer)mouseScaled.getSecond()).intValue(), lineColor);
            } else {
                GuiRenderUtils.bezierLineBetween(pGuiGraphics, (int)((float)(this.f_97735_ + 4 + 4 + 3) / Zoom), (int)(((float)(this.f_97736_ + 10 + 4) + 0.5f) / Zoom), ((Integer)mouseScaled.getFirst()).intValue(), ((Integer)mouseScaled.getSecond()).intValue(), 50.0f, 3.0f, lineColor, lineColor);
            }
        }
        pGuiGraphics.m_280168_().m_85849_();
        pGuiGraphics.m_280618_();
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.currentTooltip = null;
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.currentTooltip != null) {
            pGuiGraphics.m_280557_(this.f_96547_, this.currentTooltip, mouseX, mouseY);
        } else {
            this.m_280072_(pGuiGraphics, mouseX, mouseY);
        }
        if (this.isDownloadingLogic && ((ContainerLodestar)this.f_97732_).isLogicDownloaded()) {
            this.isDownloadingLogic = false;
            this.onLogicDownloaded();
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int mouse_x, int mouse_y) {
        String text = "";
        List<Component> tooltipLines = null;
        if (this.drawingGroup) {
            pGuiGraphics.m_280218_(this.getMainTexture(), 40, -14, 154, 220, 12, 12);
            text = Component.m_237115_((String)"gui.mna.lodestar.draw_group_toggle.prompt").getString();
            pGuiGraphics.m_280056_(this.f_96547_, text, 56, -12, 0xFFFFFF, false);
        } else {
            int y = -14;
            if (this.selectedGroup != null) {
                y = -26;
            }
            if (((ContainerLodestar)this.f_97732_).getErrors().size() > 0) {
                pGuiGraphics.m_280218_(this.getMainTexture(), 40, y, 154, 244, 12, 12);
                text = Component.m_237115_((String)"gui.mna.lodestar.error").getString();
                pGuiGraphics.m_280056_(this.f_96547_, text, 56, y + 2, 0xFFFFFF, false);
                if (this.isMousedOverWarnings(mouse_x, mouse_y, text)) {
                    tooltipLines = ((ContainerLodestar)this.f_97732_).getErrors();
                }
            } else if (((ContainerLodestar)this.f_97732_).getWarnings().size() > 0) {
                pGuiGraphics.m_280218_(this.getMainTexture(), 40, y, 154, 232, 12, 12);
                text = Component.m_237115_((String)"gui.mna.lodestar.warning").getString();
                pGuiGraphics.m_280056_(this.f_96547_, text, 56, y + 2, 0xFFFFFF, false);
                if (this.isMousedOverWarnings(mouse_x, mouse_y, text)) {
                    tooltipLines = ((ContainerLodestar)this.f_97732_).getWarnings();
                }
            }
            if (tooltipLines != null) {
                ArrayList split = new ArrayList();
                tooltipLines.forEach(c -> split.addAll(this.f_96547_.m_92923_((FormattedText)c, this.f_96541_.f_91080_.f_96543_ / 4)));
                pGuiGraphics.m_280245_(this.f_96547_, split, mouse_x - this.f_97735_, mouse_y - this.f_97736_);
            }
        }
    }

    private boolean isMousedOverWarnings(int mouse_x, int mouse_y, String promptText) {
        if (mouse_x >= this.f_97735_ + 40 && mouse_x <= this.f_97735_ + 40 + this.f_96547_.m_92895_(promptText)) {
            return mouse_y >= this.f_97736_ - (this.selectedGroup != null ? 34 : 14) && mouse_y <= this.f_97736_ - (this.selectedGroup != null ? 20 : 0);
        }
        return false;
    }

    public void onLogicDownloaded() {
        this.loadLogic(((ContainerLodestar)this.f_97732_).getLogic());
        this.recenterView();
    }

    public boolean m_6375_(double x, double y, int button) {
        if (button == 1) {
            if (this.groupBox.m_5953_(x, y)) {
                this.groupBox.m_94144_("");
            }
            if (this.filterBox.m_5953_(x, y)) {
                this.filterBox.m_94144_("");
            }
            return true;
        }
        this.canBackgroundScroll = this.isMouseWithinStage(x, y);
        if (this.groupBox.m_6375_(x, y, button)) {
            this.groupBox.m_93692_(true);
            return true;
        }
        this.selectedGroup = null;
        this.groupBox.m_93692_(false);
        this.groupBox.f_93623_ = false;
        this.groupBox.f_93624_ = false;
        if (this.filterBox.m_6375_(x, y, button)) {
            this.filterBox.m_93692_(true);
            return true;
        }
        this.filterBox.m_93692_(false);
        if (this.drawingGroup && this.canBackgroundScroll) {
            Pair<Integer, Integer> scaled = this.getScaledMouseCoordinates(x, y);
            this.creatingGroup = new LodestarGroup((Integer)scaled.getFirst(), (Integer)scaled.getSecond(), 50, 50, ((ContainerLodestar)this.f_97732_).isLowTier(), this::groupClicked);
            this.nodeGroups.add(this.creatingGroup);
            return true;
        }
        for (LodestarParameter<?> lodestarParameter : this.parameterWidgets) {
            if (!lodestarParameter.m_6375_(x, y, button)) continue;
            if (this.selectedNode != null) {
                this.selectedNode.saveParameters(this.parameterWidgets);
                ((ContainerLodestar)this.f_97732_).setTileLogic(this.saveLogic());
            }
            this.m_7522_((GuiEventListener)lodestarParameter);
            return true;
        }
        if (this.canBackgroundScroll) {
            Iterator<Object> mouseScaled = this.getScaledMouseCoordinates(x, y);
            for (LodestarNode lodestarNode : this.nodes) {
                if (!lodestarNode.m_6375_(((Integer)mouseScaled.getFirst()).intValue(), ((Integer)mouseScaled.getSecond()).intValue(), button)) continue;
                return true;
            }
            for (LodestarGroup lodestarGroup : this.nodeGroups) {
                if (!lodestarGroup.m_6375_(((Integer)mouseScaled.getFirst()).intValue(), ((Integer)mouseScaled.getSecond()).intValue(), button)) continue;
                return true;
            }
        }
        for (LodestarNode lodestarNode : this.nodes) {
            lodestarNode.f_93623_ = false;
        }
        for (LodestarGroup lodestarGroup : this.nodeGroups) {
            lodestarGroup.f_93623_ = false;
        }
        boolean superClick = super.m_6375_(x, y, button);
        for (LodestarNode lodestarNode : this.nodes) {
            lodestarNode.f_93623_ = true;
        }
        for (LodestarGroup lodestarGroup : this.nodeGroups) {
            lodestarGroup.f_93623_ = true;
        }
        return superClick;
    }

    public boolean m_6348_(double mouse_x, double mouse_y, int button) {
        this.canBackgroundScroll = false;
        if (this.drawingGroup) {
            if (this.creatingGroup != null) {
                this.creatingGroup = null;
                this.drawingGroup = false;
            }
            return true;
        }
        this.m_7522_(null);
        if (this.draggingNode != null) {
            this.draggingNode = null;
        }
        if (this.draggingGroup != null) {
            this.draggingGroup.scaling = false;
            this.draggingGroup = null;
            this.draggingGroupNodes.clear();
        }
        Pair<Integer, Integer> mouseScaled = this.getScaledMouseCoordinates(mouse_x, mouse_y);
        if (this.lineConnectionOrigin != null || this.draggingStartNode) {
            this.getNodeAt(((Integer)mouseScaled.getFirst()).intValue(), ((Integer)mouseScaled.getSecond()).intValue()).ifPresent(g -> {
                int idx;
                if (g instanceof LodestarNode && (idx = ((LodestarNode)((Object)g)).getSubWidgetAt(((Integer)mouseScaled.getFirst()).intValue(), ((Integer)mouseScaled.getSecond()).intValue())) == 98) {
                    if (this.draggingStartNode) {
                        this.nodes.forEach(node -> node.setStart(false));
                        ((LodestarNode)((Object)g)).setStart(true);
                        ((ContainerLodestar)this.f_97732_).setTileLogic(this.saveLogic());
                    } else {
                        this.lineConnectionOrigin.connectToNode((LodestarNode)((Object)g), this.lineConnectionOriginNodeIndex);
                        ((ContainerLodestar)this.f_97732_).setTileLogic(this.saveLogic());
                    }
                }
            });
            this.lineConnectionOrigin = null;
            this.draggingStartNode = false;
        }
        if (this.draggingOutTask != null) {
            if (this.isMouseWithinStage(mouse_x, mouse_y)) {
                this.addNode((Integer)mouseScaled.getFirst() - this.f_97735_ - 24, (Integer)mouseScaled.getSecond() - this.f_97736_ - 20, this.draggingOutTask);
                ((ContainerLodestar)this.f_97732_).setTileLogic(this.saveLogic());
            }
            this.draggingOutTask = null;
        }
        return super.m_6348_(mouse_x, mouse_y, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.actionsList._scrolling) {
            return this.actionsList.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.drawingGroup) {
            if (this.creatingGroup != null) {
                Pair<Integer, Integer> mouseScaled = this.getScaledMouseCoordinates(mouseX, mouseY);
                int width = (Integer)mouseScaled.getFirst() - this.creatingGroup.m_252754_();
                int height = (Integer)mouseScaled.getSecond() - this.creatingGroup.m_252907_();
                this.creatingGroup.resize(Math.abs(width), Math.abs(height));
            }
            return true;
        }
        if (this.draggingGroup != null) {
            Pair<Integer, Integer> mouseScaled = this.getScaledMouseCoordinates(mouseX, mouseY);
            if (this.draggingGroup.scaling) {
                int width = (Integer)mouseScaled.getFirst() - this.draggingGroup.m_252754_();
                int height = (Integer)mouseScaled.getSecond() - this.draggingGroup.m_252907_();
                this.draggingGroup.resize(Math.abs(width), Math.abs(height));
            } else {
                int newX = (int)((double)((Integer)mouseScaled.getFirst()).intValue() - this.draggingGroup.getClickXOffset());
                int newY = (int)((double)((Integer)mouseScaled.getSecond()).intValue() - this.draggingGroup.getClickYOffset());
                int scaledDeltaX = this.draggingGroup.m_252754_() - newX;
                int scaledDeltaY = this.draggingGroup.m_252907_() - newY;
                this.draggingGroupNodes.forEach(node -> {
                    node.m_252865_(node.m_252754_() - scaledDeltaX);
                    node.m_253211_(node.m_252907_() - scaledDeltaY);
                });
                this.draggingGroup.m_252865_(newX);
                this.draggingGroup.m_253211_(newY);
            }
            return true;
        }
        if (this.draggingNode != null) {
            Pair<Integer, Integer> mouseScaled = this.getScaledMouseCoordinates(mouseX, mouseY);
            int newX = (int)((double)((Integer)mouseScaled.getFirst()).intValue() - this.draggingNode.getClickXOffset());
            int newY = (int)((double)((Integer)mouseScaled.getSecond()).intValue() - this.draggingNode.getClickYOffset());
            this.draggingNode.m_252865_(newX);
            this.draggingNode.m_253211_(newY);
            return true;
        }
        if (this.lineConnectionOrigin != null || this.draggingOutTask != null || this.draggingStartNode) {
            return true;
        }
        this.panBackground(deltaX, deltaY);
        if (this.m_7222_() != null && button == 0 && this.m_7222_().m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.actionsList.m_5953_(mouseX, mouseY)) {
            return this.actionsList.m_6050_(mouseX, mouseY, delta);
        }
        if (this.isMouseWithinStage(mouseX, mouseY)) {
            Object node;
            int i;
            Pair<Integer, Integer> scaledMousePre = this.getScaledMouseCoordinates(mouseX, mouseY);
            float zoomAmt = (float)(0.2 * Math.signum(delta));
            Zoom += zoomAmt;
            Zoom = MathUtils.clamp(Zoom, 0.2f, 1.2f);
            Pair<Integer, Integer> scaledMousePost = this.getScaledMouseCoordinates(mouseX, mouseY);
            int adX = (Integer)scaledMousePost.getFirst() - (Integer)scaledMousePre.getFirst();
            int adY = (Integer)scaledMousePost.getSecond() - (Integer)scaledMousePre.getSecond();
            this.scroll_pos_x -= adX / 2;
            this.scroll_pos_y -= adY / 2;
            for (i = 0; i < this.nodes.size(); ++i) {
                node = this.nodes.get(i);
                node.m_252865_(node.m_252754_() + adX);
                node.m_253211_(node.m_252907_() + adY);
            }
            for (i = 0; i < this.nodeGroups.size(); ++i) {
                node = this.nodeGroups.get(i);
                node.m_252865_(node.m_252754_() + adX);
                node.m_253211_(node.m_252907_() + adY);
            }
        }
        return true;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode != 256) {
            if (this.selectedGroup != null && this.groupBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
                return true;
            }
            if (this.filterBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
                return true;
            }
            if (this.groupBox.m_93696_() && this.groupBox.m_94213_()) {
                return true;
            }
            if (this.filterBox.m_93696_() && this.filterBox.m_94213_()) {
                return true;
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode != 256) {
            if (this.selectedGroup != null && this.groupBox.m_7920_(pKeyCode, pScanCode, pModifiers)) {
                return true;
            }
            if (this.filterBox.m_7920_(pKeyCode, pScanCode, pModifiers)) {
                return true;
            }
            if (this.groupBox.m_93696_() && this.groupBox.m_94213_()) {
                return true;
            }
            if (this.filterBox.m_93696_() && this.filterBox.m_94213_()) {
                return true;
            }
        }
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.selectedGroup != null && this.groupBox.m_94213_() && this.groupBox.m_93696_()) {
            return this.groupBox.m_5534_(pCodePoint, pModifiers);
        }
        if (this.filterBox.m_94213_() && this.filterBox.m_93696_()) {
            return this.filterBox.m_5534_(pCodePoint, pModifiers);
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    public void m_7379_() {
        if (this.selectedNode != null) {
            this.deselectNode();
        }
        ((ContainerLodestar)this.f_97732_).setTileLogic(this.saveLogic());
        super.m_7379_();
    }

    private void recenterView() {
        if (this.nodes.size() == 0 && this.nodeGroups.size() == 0) {
            return;
        }
        int minX = Math.min(this.nodes.size() > 0 ? this.nodes.stream().flatMapToInt(n -> IntStream.of(n.m_252754_())).min().getAsInt() : Integer.MAX_VALUE, this.nodeGroups.size() > 0 ? this.nodeGroups.stream().flatMapToInt(n -> IntStream.of(n.m_252754_())).min().getAsInt() : Integer.MAX_VALUE);
        int maxX = Math.max(this.nodes.size() > 0 ? this.nodes.stream().flatMapToInt(n -> IntStream.of(n.m_252754_() + n.m_5711_())).max().getAsInt() : Integer.MIN_VALUE, this.nodeGroups.size() > 0 ? this.nodeGroups.stream().flatMapToInt(n -> IntStream.of(n.m_252754_() + n.m_5711_())).max().getAsInt() : Integer.MIN_VALUE);
        int minY = Math.min(this.nodes.size() > 0 ? this.nodes.stream().flatMapToInt(n -> IntStream.of(n.m_252907_())).min().getAsInt() : Integer.MAX_VALUE, this.nodeGroups.size() > 0 ? this.nodeGroups.stream().flatMapToInt(n -> IntStream.of(n.m_252907_())).min().getAsInt() : Integer.MAX_VALUE);
        int maxY = Math.max(this.nodes.size() > 0 ? this.nodes.stream().flatMapToInt(n -> IntStream.of(n.m_252907_() + n.m_93694_())).max().getAsInt() : Integer.MIN_VALUE, this.nodeGroups.size() > 0 ? this.nodeGroups.stream().flatMapToInt(n -> IntStream.of(n.m_252907_() + n.m_93694_())).max().getAsInt() : Integer.MIN_VALUE);
        int cX = (minX + maxX) / 2;
        int cY = (minY + maxY) / 2;
        int vpCx = (int)(256.0f / Zoom);
        int vpCy = (int)(165.0f / Zoom);
        int deltaX = vpCx - cX + 24;
        int deltaY = vpCy - cY + 20;
        for (LodestarNode lodestarNode : this.nodes) {
            lodestarNode.m_252865_(lodestarNode.m_252754_() + deltaX);
            lodestarNode.m_253211_(lodestarNode.m_252907_() + deltaY);
        }
        for (LodestarGroup lodestarGroup : this.nodeGroups) {
            lodestarGroup.m_252865_(lodestarGroup.m_252754_() + deltaX);
            lodestarGroup.m_253211_(lodestarGroup.m_252907_() + deltaY);
        }
    }

    private CompoundTag saveLogic() {
        ListTag data = new ListTag();
        this.nodes.forEach(node -> data.add((Object)node.toCompoundTag(this.f_97736_ - this.scroll_pos_y, this.f_97735_ - this.scroll_pos_x)));
        ListTag groups = new ListTag();
        this.nodeGroups.forEach(group -> groups.add((Object)group.toCompoundTag(this.f_97736_ - this.scroll_pos_y, this.f_97735_ - this.scroll_pos_x)));
        CompoundTag output = new CompoundTag();
        output.m_128365_("commands", (Tag)data);
        output.m_128365_("groups", (Tag)groups);
        return output;
    }

    private void loadLogic(CompoundTag input) {
        if (input == null || !input.m_128441_("commands")) {
            return;
        }
        ListTag data = input.m_128437_("commands", 10);
        data.forEach(tag -> {
            LodestarNode node = LodestarNode.fromCompoundTag((CompoundTag)tag, this.f_97736_, this.f_97735_, ((ContainerLodestar)this.f_97732_).isLowTier(), b -> this.nodeSubClick((LodestarNode)b), this::getNodeById);
            if (node != null) {
                this.insertNode(node);
            }
        });
        if (input.m_128441_("groups")) {
            ListTag groupData = input.m_128437_("groups", 10);
            groupData.forEach(tag -> {
                LodestarGroup group = LodestarGroup.fromCompound((CompoundTag)tag, this.f_97736_, this.f_97735_, ((ContainerLodestar)this.f_97732_).isLowTier(), this::groupClicked);
                if (group != null) {
                    this.nodeGroups.add(group);
                }
            });
        }
    }

    private boolean isMouseWithinStage(double mouse_x, double mouse_y) {
        return mouse_x >= (double)this.f_97735_ && mouse_x <= (double)(this.f_97735_ + 256) && mouse_y >= (double)this.f_97736_ && mouse_y <= (double)(this.f_97736_ + 165);
    }

    private Pair<Integer, Integer> getScaledMouseCoordinates(double mouse_x, double mouse_y) {
        return new Pair((Object)((int)(mouse_x / (double)Zoom)), (Object)((int)(mouse_y / (double)Zoom)));
    }

    public LodestarNode getNodeById(String id) {
        Optional<LodestarNode> found = this.nodes.stream().filter(n -> n.getId().equals(id)).findFirst();
        if (!found.isPresent()) {
            return null;
        }
        return found.get();
    }

    Optional<GuiEventListener> getNodeAt(double pMouseX, double pMouseY) {
        for (LodestarNode node : this.nodes) {
            if (!node.m_5953_(pMouseX, pMouseY)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    private List<LodestarNode> getNodesInGroup(LodestarGroup group) {
        ScreenRectangle groupRect = group.m_264198_();
        return this.nodes.stream().filter(n -> groupRect.m_264295_(n.m_264198_())).collect(Collectors.toList());
    }

    private int getParameterX() {
        return this.f_97735_ + this.f_97726_ + 5;
    }

    private int getParameterY(int index) {
        return this.f_97736_ + 21 + index * 22;
    }

    @OnlyIn(value=Dist.CLIENT)
    class CommandScrollList
    extends ObjectSelectionList<Command> {
        private boolean _scrolling;
        private String _filter;
        private boolean low_tier;

        public CommandScrollList(boolean low_tier) {
            super(GuiLodestarV2.this.f_96541_, 46, 135, GuiLodestarV2.this.f_97736_ + 10, GuiLodestarV2.this.f_97736_ + 153, 18);
            this._scrolling = false;
            this._filter = "";
            this.m_93471_(false);
            this.m_93473_(false, 24);
            this.f_93393_ = GuiLodestarV2.this.f_97735_ - 56 + 1;
            this.f_93392_ = this.f_93393_ + 46;
            this.low_tier = low_tier;
            this.setFilter("");
        }

        public void clear() {
            this.m_93516_();
        }

        private void addIconsForAll(Collection<ConstructTask> parts, Consumer<ConstructTask> clickHandler) {
            ArrayList<ConstructTask> segment = new ArrayList<ConstructTask>();
            for (ConstructTask part : parts) {
                segment.add(part);
                if (segment.size() != 2) continue;
                this.m_7085_((AbstractSelectionList.Entry)new Command(segment, clickHandler, this.f_93390_, this.f_93391_));
                segment.clear();
            }
            if (segment.size() > 0) {
                this.m_7085_((AbstractSelectionList.Entry)new Command(segment, clickHandler, this.f_93390_, this.f_93391_));
            }
        }

        public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
            int scrollBarStartX = this.m_5756_();
            pGuiGraphics.m_280588_(this.f_93393_, this.f_93390_, this.f_93392_, this.f_93391_);
            this.m_239227_(pGuiGraphics, mouseX, mouseY, partialTicks);
            pGuiGraphics.m_280618_();
            if (this.m_93518_() > 0) {
                int scrollBarTop = this.f_93390_ + 2;
                int scrollBarBottom = this.f_93391_;
                int top = (int)this.m_93517_() * (scrollBarBottom - scrollBarTop) / this.m_93518_() + this.f_93390_;
                if (top < scrollBarTop) {
                    top = scrollBarTop;
                }
                pGuiGraphics.m_280163_(GuiLodestarV2.this.getExtensionTexture(), scrollBarStartX, top, 250.0f, 244.0f, 6, 6, 256, 256);
            }
        }

        @Nullable
        protected final Command getEntryAtPos(double mouseX, double mouseY) {
            int lowerXBound = this.m_5747_();
            int upperXBound = lowerXBound + this.m_5759_();
            int adjustedY = Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) + (int)this.m_93517_();
            int index = adjustedY / this.f_93387_;
            if (index >= 0 && adjustedY >= 0 && index < this.m_5773_() && mouseX < (double)this.m_5756_() && mouseX >= (double)lowerXBound && mouseX <= (double)upperXBound) {
                return (Command)((Object)this.m_6702_().get(index));
            }
            return null;
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            this.m_93410_(this.m_93517_() - delta * (double)this.f_93387_);
            return true;
        }

        public void setFilter(String filter) {
            this._filter = filter.trim().toLowerCase();
            this.clear();
            this.addIconsForAll(Registries.ConstructTasks.get().getValues().stream().filter(c -> this._filter == null || this._filter == "" ? true : Component.m_237115_((String)("construct." + Registries.ConstructTasks.get().getKey(c).toString())).getString().toLowerCase().contains(this._filter)).filter(c -> c.isLodestarAssignable() && (c.isLowTierAssignable() || !this.low_tier)).collect(Collectors.toList()), action -> GuiLodestarV2.this.startDraggingCommandFromList((ConstructTask)action));
        }

        public int m_5747_() {
            return this.f_93393_ + 2;
        }

        protected int m_5756_() {
            return this.m_5747_() + this.m_5759_() + 6;
        }

        protected int m_7610_(int p_getRowTop_1_) {
            return this.f_93390_ - (int)this.m_93517_() + p_getRowTop_1_ * this.f_93387_ - 2;
        }

        public int m_5759_() {
            return 36;
        }

        protected void m_93481_(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
            super.m_93481_(p_updateScrollingState_1_, p_updateScrollingState_3_, p_updateScrollingState_5_);
            this._scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.m_5756_() && p_updateScrollingState_1_ < (double)(this.m_5756_() + 6);
        }

        public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.m_93481_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
            if (!this.m_5953_(p_mouseClicked_1_, p_mouseClicked_3_)) {
                return false;
            }
            Command e = this.getEntryAtPos(p_mouseClicked_1_, p_mouseClicked_3_);
            if (e != null) {
                if (e.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                    e.m_93692_(true);
                    return true;
                }
            } else if (p_mouseClicked_5_ == 0) {
                this.m_7897_(true);
                return true;
            }
            return this._scrolling;
        }

        public int m_93518_() {
            return Math.max(0, this.m_5775_() - (this.f_93391_ - this.f_93390_ + this.f_93387_ / 2)) + 6;
        }

        @OnlyIn(value=Dist.CLIENT)
        public class Command
        extends ObjectSelectionList.Entry<Command> {
            private Collection<ConstructTask> parts;
            private int spacing = 18;
            private ConstructTask _hoveredComponent;
            private Consumer<ConstructTask> _clickHandler;
            private final int y0;
            private final int y1;

            public Command(Collection<ConstructTask> parts, Consumer<ConstructTask> clickHandler, int y0, int y1) {
                this.parts = new ArrayList<ConstructTask>(parts);
                this._hoveredComponent = null;
                this._clickHandler = clickHandler;
                this.y0 = y0;
                this.y1 = y1;
            }

            public boolean m_5953_(double x, double y) {
                if (y >= (double)this.y0 && y <= (double)this.y1) {
                    return super.m_5953_(x, y);
                }
                return false;
            }

            public void m_6311_(GuiGraphics pGuiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float p_render_9_) {
                int i = 0;
                for (ConstructTask action : this.parts) {
                    if (action == null) continue;
                    int x = 6 + left + i++ * this.spacing;
                    int y = top + 4;
                    pGuiGraphics.m_280398_(action.getIconTexture(), x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                    if (!this.m_5953_(mouseX, mouseY) || mouseX < x || mouseX > x + this.spacing) continue;
                    GuiLodestarV2.this.currentTooltip = action.getAIClass() == null ? Component.m_237115_((String)"gui.mna.command.coming-soon").m_130940_(ChatFormatting.GOLD) : Component.m_237115_((String)("construct." + Registries.ConstructTasks.get().getKey((Object)action).toString()));
                    this._hoveredComponent = action;
                }
            }

            public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                if (this._clickHandler != null && this._hoveredComponent != null) {
                    this._clickHandler.accept(this._hoveredComponent);
                }
                return true;
            }

            public Component m_142172_() {
                return Component.m_237115_((String)"gui.mna.lodestar.component");
            }
        }
    }
}

