/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.block;

import com.mna.ManaAndArtifice;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.spells.SpellValidityResult;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiable;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.api.spells.parts.Modifier;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.GuiTextures;
import com.mna.gui.base.SearchableGui;
import com.mna.gui.containers.block.ContainerInscriptionTable;
import com.mna.gui.widgets.AttributeButton;
import com.mna.gui.widgets.BorderedImageButton;
import com.mna.gui.widgets.ReagentList;
import com.mna.gui.widgets.SpellPartList;
import com.mna.network.messages.to_client.ShowDidYouKnow;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class GuiInscriptionTable
extends SearchableGui<ContainerInscriptionTable> {
    ImageButton buildButton;
    ImageButton[] pieceWidgets;
    ImageButton activeShapeButton;
    ImageButton activeComponentButton;
    ImageButton[] activeModifierButtons;
    ArrayList<ImageButton> shapeAttributeButtons;
    ArrayList<ImageButton> componentAttributeButtons;
    private SpellPartList spellPartList;
    private ReagentList reagentList;
    final float textScaleFactor = 0.5f;
    final int textColor = 4467972;
    final int colWidth = 38;
    final int rowHeight = 13;
    final int texSize = 32;
    final List<Component> currentTooltip;
    MutableComponent craftMessage = null;
    SpellValidityResult lastResult;
    IPlayerProgression playerProgression;
    private static long lastModifierClickTime = -1L;
    private static long clickCount = 0L;

    public GuiInscriptionTable(ContainerInscriptionTable screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.f_97726_ = 256;
        this.f_97727_ = 256;
        this.activeModifierButtons = new ImageButton[3];
        this.currentTooltip = new ArrayList<Component>();
    }

    public void addTooltipLine(Component comp) {
        this.currentTooltip.add(comp);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (this.spellPartList.m_5953_(p_mouseScrolled_1_, p_mouseScrolled_3_)) {
            return this.spellPartList.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
        }
        if (this.reagentList.m_5953_(p_mouseScrolled_1_, p_mouseScrolled_3_)) {
            return this.reagentList.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
        }
        return true;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.playerProgression = (IPlayerProgression)this.f_96541_.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        this.spellPartList = new SpellPartList(true, false, this.f_97735_, this.f_97736_, 4, 53, 64, 111, s -> this.OnShapeClicked((Shape)s), c -> this.OnComponentClicked((SpellEffect)c), m -> this.OnModifierClicked((Modifier)m), tt -> this.currentTooltip.add((Component)tt)).enableTierChecks();
        this.m_142416_((GuiEventListener)this.spellPartList);
        this.reagentList = new ReagentList(this.f_97735_, this.f_97736_, 196, 111, 51, 53, this::addTooltipLine);
        this.m_142416_((GuiEventListener)this.reagentList);
        int tbWidth = 66;
        int x = this.f_97735_ + 6;
        int y = this.f_97736_ + 30;
        this.shapeAttributeButtons = new ArrayList();
        this.componentAttributeButtons = new ArrayList();
        this.setupBuildButton();
        if (((ContainerInscriptionTable)this.f_97732_).getCurrentShape() != null) {
            this.setupShapeWidgetsFor(((ContainerInscriptionTable)this.f_97732_).getCurrentShape().getPart());
        }
        if (((ContainerInscriptionTable)this.f_97732_).getCurrentComponent() != null) {
            this.setupComponentWidgetsFor(((ContainerInscriptionTable)this.f_97732_).getCurrentComponent().getPart());
        }
        for (int i = 0; i < 3; ++i) {
            if (((ContainerInscriptionTable)this.f_97732_).getCurrentModifier(i) == null) continue;
            this.setupModifierWidgetsFor(((ContainerInscriptionTable)this.f_97732_).getCurrentModifier(i), i);
        }
        this.reagentList.reInit(((ContainerInscriptionTable)this.f_97732_).getCurrentReagents());
        this.initSearch(x, y, tbWidth, 16);
    }

    @Override
    protected void searchTermChanged(String newTerm) {
        this.currentSearchTerm = newTerm.toLowerCase();
        this.spellPartList.clear();
        this.spellPartList.reInit(this.currentSearchTerm);
        this.spellPartList.m_93410_(0.0);
    }

    private void setupShapeAttributeButtons(Shape shape) {
        this.clearAttributeButtons(this.shapeAttributeButtons);
        if (shape == null) {
            return;
        }
        this.setupAttributeButtons(115, 34, this.shapeAttributeButtons, shape);
    }

    private void setupComponentAttributeButtons(SpellEffect component) {
        this.clearAttributeButtons(this.componentAttributeButtons);
        if (component == null) {
            return;
        }
        this.setupAttributeButtons(115, 81, this.componentAttributeButtons, component);
    }

    private void setupAttributeButtons(int xStart, int yStart, ArrayList<ImageButton> addTo, IModifiable<? extends ISpellComponent> modifiable) {
        int count = 0;
        for (AttributeValuePair attribute : modifiable.getModifiableAttributes()) {
            boolean attributeModifiable = false;
            for (int i = 0; i < 3; ++i) {
                Modifier modifier = ((ContainerInscriptionTable)this.f_97732_).getCurrentModifier(i);
                if (modifier == null || !modifier.modifiesType(attribute.getAttribute())) continue;
                attributeModifiable = true;
                break;
            }
            int row = (int)Math.floor(count / 2);
            int col = count % 2;
            int xOffset = xStart + 38 * col;
            int yOffset = yStart + 13 * row;
            if (attributeModifiable) {
                ImageButton upButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + xOffset + 16, this.f_97736_ + yOffset + 1, 6, 3, 1, 49, 0, GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerInscriptionTable)this.f_97732_).increaseAttribute((Player)this.f_96541_.f_91074_, modifiable, attribute.getAttribute(), (Level)this.f_96541_.f_91073_, Screen.m_96638_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                ImageButton downButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + xOffset + 16, this.f_97736_ + yOffset + 6, 6, 3, 1, 54, 0, GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerInscriptionTable)this.f_97732_).decreaseAttribute((Player)this.f_96541_.f_91074_, modifiable, attribute.getAttribute(), (Level)this.f_96541_.f_91073_, Screen.m_96638_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                addTo.add(upButton);
                addTo.add(downButton);
            }
            Point texCoord = GuiTextures.Attribute_Icon_Mappings.get((Object)attribute.getAttribute());
            int blitSize = 8;
            float scaleFactor = (float)blitSize / 52.0f;
            ImageButton iconButton = (ImageButton)this.m_142416_((GuiEventListener)new AttributeButton(this.f_97735_ + xOffset + 6, this.f_97736_ + yOffset + 1, blitSize, blitSize, (int)((float)texCoord.x * scaleFactor), (int)((float)texCoord.y * scaleFactor), 0, GuiTextures.Widgets.ATTRIBUTE_ICONS, (int)(208.0f * scaleFactor), (int)(208.0f * scaleFactor), button -> {}, new String[]{attribute.getAttribute().getLocaleKey(), ((ISpellComponent)((Object)modifiable)).getDescriptionTooltip(attribute.getAttribute())}, this::addTooltipLine));
            addTo.add(iconButton);
            ++count;
        }
    }

    public static void checkAndShowShiftTooltip() {
        Minecraft mc = Minecraft.m_91087_();
        if (!Screen.m_96638_()) {
            if (mc.f_91073_.m_46467_() - lastModifierClickTime < 200L) {
                if (++clickCount >= 4L) {
                    ManaAndArtifice.instance.proxy.showDidYouKnow((Player)mc.f_91074_, ShowDidYouKnow.Messages.MODIFIER_SHIFT);
                }
            } else {
                clickCount = 0L;
            }
            lastModifierClickTime = mc.f_91073_.m_46467_();
        }
    }

    private void clearAttributeButtons(ArrayList<ImageButton> attributeButtons) {
        for (ImageButton button : attributeButtons) {
            this.m_169411_((GuiEventListener)button);
        }
        attributeButtons.clear();
    }

    private void setupBuildButton() {
        this.buildButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 81, this.f_97736_ + 9, 25, 14, 0, 20, 0, GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> ((ContainerInscriptionTable)this.f_97732_).sendStartBuild()));
        this.buildButton.f_93624_ = false;
        this.buildButton.f_93623_ = false;
    }

    private void setupShapeWidgetsFor(Shape shape) {
        int texSize = 32;
        if (shape != null) {
            if (this.activeShapeButton != null) {
                this.m_169411_((GuiEventListener)this.activeShapeButton);
            }
            this.activeShapeButton = (ImageButton)this.m_142416_((GuiEventListener)new BorderedImageButton(this.f_97735_ + 82, this.f_97736_ + 36, texSize, texSize, 0, 0, 0, shape.getGuiIcon(), texSize, texSize, button -> {
                if (!((ContainerInscriptionTable)this.f_97732_).setCurrentShape(null, (Level)this.f_96541_.f_91073_)) {
                    return;
                }
                this.m_169411_((GuiEventListener)button);
                this.setupShapeWidgetsFor(null);
                this.reagentList.reInit(((ContainerInscriptionTable)this.f_97732_).getCurrentReagents());
            }).setBorder(shape.isSilverSpell()));
        }
        this.setupShapeAttributeButtons(shape);
    }

    private void OnShapeClicked(Shape shape) {
        if (!((ContainerInscriptionTable)this.f_97732_).setCurrentShape(shape, (Level)this.f_96541_.f_91073_)) {
            return;
        }
        this.setupShapeWidgetsFor(shape);
        if (this.searchBox != null) {
            this.searchBox.m_94208_(0);
        }
        this.reagentList.reInit(((ContainerInscriptionTable)this.f_97732_).getCurrentReagents());
    }

    private void setupComponentWidgetsFor(SpellEffect component) {
        int texSize = 32;
        if (component != null) {
            if (this.activeComponentButton != null) {
                this.m_169411_((GuiEventListener)this.activeComponentButton);
            }
            this.activeComponentButton = (ImageButton)this.m_142416_((GuiEventListener)new BorderedImageButton(this.f_97735_ + 82, this.f_97736_ + 83, 32, 32, 0, 0, 0, component.getGuiIcon(), 32, 32, button -> {
                if (!((ContainerInscriptionTable)this.f_97732_).setCurrentComponent(null, (Level)this.f_96541_.f_91073_)) {
                    return;
                }
                this.m_169411_((GuiEventListener)button);
                this.setupComponentWidgetsFor(null);
                this.reagentList.reInit(((ContainerInscriptionTable)this.f_97732_).getCurrentReagents());
            }).setBorder(component.isSilverSpell()));
        }
        this.setupComponentAttributeButtons(component);
    }

    private void OnComponentClicked(SpellEffect component) {
        if (!((ContainerInscriptionTable)this.f_97732_).setCurrentComponent(component, (Level)this.f_96541_.f_91073_)) {
            return;
        }
        this.setupComponentWidgetsFor(component);
        if (this.searchBox != null) {
            this.searchBox.m_94208_(0);
        }
        this.reagentList.reInit(((ContainerInscriptionTable)this.f_97732_).getCurrentReagents());
    }

    private void setupModifierWidgetsFor(Modifier modifier, int index) {
        ModifiedSpellPart<SpellEffect> curComp;
        ModifiedSpellPart<Shape> curShape;
        if (modifier != null) {
            this.activeModifierButtons[index] = (ImageButton)this.m_142416_((GuiEventListener)new BorderedImageButton(this.f_97735_ + 82 + 37 * index, this.f_97736_ + 130, 32, 32, 0, 0, 0, modifier.getGuiIcon(), 32, 32, button -> {
                if (!((ContainerInscriptionTable)this.f_97732_).setCurrentModifier(index, null, (Level)this.f_96541_.f_91073_)) {
                    return;
                }
                this.m_169411_((GuiEventListener)button);
                this.setupModifierWidgetsFor(null, index);
                this.activeModifierButtons[index] = null;
                this.reagentList.reInit(((ContainerInscriptionTable)this.f_97732_).getCurrentReagents());
            }).setBorder(modifier.isSilverSpell()));
        }
        if ((curShape = ((ContainerInscriptionTable)this.f_97732_).getCurrentShape()) != null) {
            this.setupShapeAttributeButtons(curShape.getPart());
        }
        if ((curComp = ((ContainerInscriptionTable)this.f_97732_).getCurrentComponent()) != null) {
            this.setupComponentAttributeButtons(curComp.getPart());
        }
    }

    private void OnModifierClicked(Modifier modifier) {
        int i;
        if (this.searchBox != null) {
            this.searchBox.m_94208_(0);
        }
        for (i = 0; i < 3; ++i) {
            if (((ContainerInscriptionTable)this.f_97732_).getCurrentModifier(i) != modifier) continue;
            return;
        }
        for (i = 0; i < 3; ++i) {
            if (this.activeModifierButtons[i] != null) continue;
            if (!((ContainerInscriptionTable)this.f_97732_).setCurrentModifier(i, modifier, (Level)this.f_96541_.f_91073_)) {
                return;
            }
            this.setupModifierWidgetsFor(modifier, i);
            break;
        }
        this.reagentList.reInit(((ContainerInscriptionTable)this.f_97732_).getCurrentReagents());
    }

    @Override
    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.currentTooltip.clear();
        this.lastResult = ((ContainerInscriptionTable)this.f_97732_).isReadyToBuild(this.playerProgression);
        if (this.lastResult == SpellValidityResult.READY) {
            this.buildButton.f_93624_ = true;
            this.buildButton.f_93623_ = true;
            this.craftMessage = null;
        } else {
            this.buildButton.f_93624_ = false;
            this.buildButton.f_93623_ = false;
            if (!this.lastResult.getTranslationKey().isEmpty()) {
                this.craftMessage = Component.m_237115_((String)this.lastResult.getTranslationKey()).m_130940_(ChatFormatting.RED);
            }
        }
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.currentTooltip.size() > 0) {
            pGuiGraphics.m_280677_(this.f_96547_, this.currentTooltip, Optional.empty(), mouseX, mouseY);
        } else {
            this.m_280072_(pGuiGraphics, mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        float pct;
        int col;
        int row;
        int xPos = 140;
        int yPos = 37;
        int count = 0;
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        if (((ContainerInscriptionTable)this.f_97732_).getCurrentShape() != null) {
            for (Attribute attribute : ((ContainerInscriptionTable)this.f_97732_).getCurrentShape().getContainedAttributes()) {
                row = (int)Math.floor(count / 2);
                col = count % 2;
                this.drawAttributeValue(pGuiGraphics, xPos + col * 38, yPos + row * 13, ((ContainerInscriptionTable)this.f_97732_).getCurrentShape().getValueWithoutMultipliers(attribute));
                ++count;
            }
        }
        xPos = 140;
        count = 0;
        yPos = 84;
        if (((ContainerInscriptionTable)this.f_97732_).getCurrentComponent() != null) {
            for (Attribute attribute : ((ContainerInscriptionTable)this.f_97732_).getCurrentComponent().getContainedAttributes()) {
                row = (int)Math.floor(count / 2);
                col = count % 2;
                this.drawAttributeValue(pGuiGraphics, xPos + col * 38, yPos + row * 13, ((ContainerInscriptionTable)this.f_97732_).getCurrentComponent().getValueWithoutMultipliers(attribute));
                ++count;
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (((ContainerInscriptionTable)this.f_97732_).getCurrentModifier(i) == null) continue;
            String s = I18n.m_118938_((String)((ContainerInscriptionTable)this.f_97732_).getCurrentModifier(i).getRegistryName().toString(), (Object[])new Object[0]);
            pGuiGraphics.m_280056_(this.f_96547_, s, (int)((float)(81 + i * 37) / 0.5f), 244, 4467972, false);
        }
        float summaryXPos = 202.0f;
        float summaryYPos = 33.0f;
        pGuiGraphics.m_280056_(this.f_96547_, I18n.m_118938_((String)"gui.mna.complexity", (Object[])new Object[0]) + ":", (int)(summaryXPos / 0.5f), (int)(summaryYPos / 0.5f), 4467972, false);
        if (((ContainerInscriptionTable)this.f_97732_).getComplexity() <= (float)this.playerProgression.getTierMaxComplexity()) {
            pGuiGraphics.m_280056_(this.f_96547_, String.format("%.1f / %d", Float.valueOf(((ContainerInscriptionTable)this.f_97732_).getComplexity()), this.playerProgression.getTierMaxComplexity()), (int)(summaryXPos / 0.5f), (int)((summaryYPos + 5.0f) / 0.5f), 4467972, false);
        } else {
            pGuiGraphics.m_280056_(this.f_96547_, String.format("%.1f / %d", Float.valueOf(((ContainerInscriptionTable)this.f_97732_).getComplexity()), this.playerProgression.getTierMaxComplexity()), (int)(summaryXPos / 0.5f), (int)((summaryYPos + 5.0f) / 0.5f), ChatFormatting.DARK_RED.m_126665_().intValue(), false);
        }
        pGuiGraphics.m_280056_(this.f_96547_, I18n.m_118938_((String)"gui.mna.mana_cost", (Object[])new Object[0]) + ":", (int)(summaryXPos / 0.5f), (int)((summaryYPos + 13.0f) / 0.5f), 4467972, false);
        pGuiGraphics.m_280056_(this.f_96547_, String.format("%.1f", Float.valueOf(((ContainerInscriptionTable)this.f_97732_).getManaCost((Player)this.f_96541_.f_91074_))), (int)(summaryXPos / 0.5f), (int)((summaryYPos + 18.0f) / 0.5f), 4467972, false);
        if (((ContainerInscriptionTable)this.f_97732_).getCraftTicks() <= 0) {
            RenderSystem.enableBlend();
            pGuiGraphics.m_280163_(GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, (int)((summaryXPos + 3.0f) / 0.5f), (int)((summaryYPos + 25.0f) / 0.5f), 29.0f, 20.0f, 16, 16, 128, 128);
            pGuiGraphics.m_280163_(GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, (int)((summaryXPos + 18.0f) / 0.5f), (int)((summaryYPos + 25.0f) / 0.5f), 45.0f, 20.0f, 16, 16, 128, 128);
            pGuiGraphics.m_280163_(GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, (int)((summaryXPos + 33.0f) / 0.5f), (int)((summaryYPos + 25.0f) / 0.5f), 61.0f, 20.0f, 16, 16, 128, 128);
            pGuiGraphics.m_280056_(this.f_96547_, String.format("x%d", ((ContainerInscriptionTable)this.f_97732_).getRequiredInk()), (int)((summaryXPos + 4.0f) / 0.5f), (int)((summaryYPos + 35.0f) / 0.5f), 4467972, false);
            pGuiGraphics.m_280056_(this.f_96547_, String.format("x%d", ((ContainerInscriptionTable)this.f_97732_).getRequiredPaper()), (int)((summaryXPos + 19.0f) / 0.5f), (int)((summaryYPos + 35.0f) / 0.5f), 4467972, false);
            pGuiGraphics.m_280056_(this.f_96547_, String.format("x%d", ((ContainerInscriptionTable)this.f_97732_).getRequiredAsh()), (int)((summaryXPos + 34.0f) / 0.5f), (int)((summaryYPos + 35.0f) / 0.5f), 4467972, false);
            int offsetY = 44;
            if (this.craftMessage != null) {
                List split_string = this.f_96547_.m_92865_().m_92432_(this.craftMessage.getString(), 95, Style.f_131099_);
                for (FormattedText prop : split_string) {
                    pGuiGraphics.m_280056_(this.f_96547_, prop.getString(), (int)(summaryXPos / 0.5f), (int)((summaryYPos + (float)offsetY) / 0.5f), ChatFormatting.DARK_PURPLE.m_126665_().intValue(), false);
                    offsetY += 5;
                }
                offsetY += 5;
            }
            offsetY = 50;
            pGuiGraphics.m_280056_(this.f_96547_, I18n.m_118938_((String)"gui.mna.spell_reagents", (Object[])new Object[0]), (int)((summaryXPos - 2.0f) / 0.5f), (int)((summaryYPos + (float)offsetY + 22.0f) / 0.5f), 4467972, false);
        }
        pGuiGraphics.m_280168_().m_85849_();
        if (((ContainerInscriptionTable)this.f_97732_).getCraftTicks() > 0 && (pct = (float)((ContainerInscriptionTable)this.f_97732_).getCraftTicksConsumed() / (float)((ContainerInscriptionTable)this.f_97732_).getCraftTicks()) > 0.0f) {
            pGuiGraphics.m_280163_(GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, 110, 6, 0.0f, 0.0f, (int)(115.0f * pct), 20, 128, 128);
        }
    }

    private void drawAttributeValue(GuiGraphics pGuiGraphics, int x, int y, float value) {
        String valueString = String.format("%.1f", Float.valueOf(value));
        pGuiGraphics.m_280056_(this.f_96547_, valueString, (int)((float)x / 0.5f), (int)((float)y / 0.5f), 4467972, false);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(pGuiGraphics);
        int i = this.f_97735_;
        int j = this.f_97736_;
        pGuiGraphics.m_280218_(GuiTextures.WizardLab.INSCRIPTION_TABLE, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.spellPartList.isScrolling()) {
            return this.spellPartList.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }
        if (this.reagentList.isScrolling()) {
            return this.reagentList.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }
        return super.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }
}

