/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.block;

import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IWellspringNodeRegistry;
import com.mna.api.capabilities.IWorldMagic;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.gui.GuiTextures;
import com.mna.gui.block.SimpleWizardLabDeskGui;
import com.mna.gui.containers.block.ContainerEldrinFume;
import com.mna.network.ClientMessageDispatcher;
import com.mojang.datafixers.util.Pair;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GuiEldrinFume
extends SimpleWizardLabDeskGui<ContainerEldrinFume> {
    public GuiEldrinFume(ContainerEldrinFume container, Inventory inv, Component comp) {
        super(container, inv, (Component)Component.m_237113_((String)""));
        this.f_97726_ = 176;
        this.f_97727_ = 158;
    }

    @Override
    public ResourceLocation texture() {
        return GuiTextures.WizardLab.ELDRIN_FUME;
    }

    @Override
    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(pGuiGraphics);
        if (ManaAndArtifice.instance.proxy.getGameTicks() % 20L == 0L) {
            ClientMessageDispatcher.sendRequestWellspringNetworkSyncMessage(false);
        }
        IWorldMagic magic = (IWorldMagic)this.f_96541_.f_91073_.getCapability(WorldMagicProvider.MAGIC).orElse(null);
        IWellspringNodeRegistry wsRegistry = null;
        if (magic != null) {
            wsRegistry = magic.getWellspringRegistry();
        }
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(this.texture(), i, j, 0, 0, this.f_97726_, this.f_97727_);
        float motePct = ((ContainerEldrinFume)this.f_97732_).getMotePctRemaining();
        pGuiGraphics.m_280218_(this.texture(), this.f_97735_ + 58, this.f_97736_ + 8, 196, 0, (int)(60.0f * motePct), 2);
        if (((ContainerEldrinFume)this.f_97732_).isActive()) {
            float pct = ((ContainerEldrinFume)this.f_97732_).getFuelPctRemaining();
            int progressHeight = 16 - (int)(16.0f * pct);
            pGuiGraphics.m_280218_(this.texture(), this.f_97735_ + 79, this.f_97736_ + 33 + 16 - progressHeight, 238, 18 - progressHeight, 20, progressHeight);
        }
        Affinity[] affinities = ((ContainerEldrinFume)this.f_97732_).getGeneratingAffinities();
        int count = 0;
        for (Affinity toGenerate : affinities) {
            float x;
            ItemStack affStack = GuiTextures.affinityIcons.get((Object)toGenerate);
            if (affStack.m_41619_()) continue;
            float scale = count > 0 ? 0.75f : 1.0f;
            float f = x = count == 0 ? 102.0f : 104.0f;
            float y = count == 0 ? 33.0f : (count == 1 ? 17.0f : 54.0f);
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_85841_(scale, scale, scale);
            pGuiGraphics.m_280480_(affStack, (int)(((float)this.f_97735_ + x) / scale), (int)(((float)this.f_97736_ + y) / scale));
            pGuiGraphics.m_280168_().m_85849_();
            int size = (int)(18.0f * scale);
            if ((float)mouseX >= (float)this.f_97735_ + x && (float)mouseX <= (float)this.f_97735_ + x + (float)size && (float)mouseY >= (float)this.f_97736_ + y && (float)mouseY <= (float)this.f_97736_ + y + (float)size) {
                float mult = wsRegistry == null ? 1.0f : wsRegistry.getEldrinGenerationMultiplierFor((Player)this.f_96541_.f_91074_, toGenerate);
                float powerPerSecond = ((ContainerEldrinFume)this.f_97732_).getPowerPerSecond(toGenerate) * mult;
                float generationRate = (float)(Math.floor(powerPerSecond * 10.0f) / 10.0);
                pGuiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237110_((String)"gui.mna.fume.power_gen", (Object[])new Object[]{Float.valueOf(generationRate), toGenerate.toString()}), mouseX, mouseY);
            }
            ++count;
        }
        if (((ContainerEldrinFume)this.f_97732_).isPowerFull((Level)this.f_96541_.f_91073_) && mouseX >= this.f_97735_ + (Integer)this.goButtonPos().getFirst() && mouseX <= this.f_97735_ + (Integer)this.goButtonPos().getFirst() + (Integer)this.goButtonSize().getFirst() && mouseY >= this.f_97736_ + (Integer)this.goButtonPos().getSecond() && mouseY <= this.f_97736_ + (Integer)this.goButtonPos().getSecond() + (Integer)this.goButtonSize().getSecond()) {
            Object affinityNames = "";
            if (affinities.length == 1) {
                affinityNames = affinities[0].toString();
            } else {
                for (Affinity toGenerate : affinities) {
                    affinityNames = (String)affinityNames + toGenerate.toString() + ", ";
                }
                affinityNames = ((String)affinityNames).substring(0, ((String)affinityNames).length() - 2);
            }
            pGuiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237110_((String)"gui.mna.fume.power_full", (Object[])new Object[]{affinityNames}), mouseX, mouseY);
        }
    }

    @Override
    protected Pair<Integer, Integer> goButtonPos() {
        return new Pair((Object)63, (Object)36);
    }

    @Override
    protected Pair<Integer, Integer> goButtonUV() {
        return new Pair((Object)246, (Object)18);
    }

    @Override
    protected Pair<Integer, Integer> goButtonSize() {
        return new Pair((Object)10, (Object)10);
    }

    @Override
    protected int goButtonHoverOffset() {
        return 0;
    }
}

